/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ImageLocationEffect
extends LocationEffect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public boolean invert = false;
    public int stepX = 10;
    public int stepY = 10;
    public float size = 0.025f;
    protected BufferedImage image = null;

    public ImageLocationEffect(EffectManager effectManager, Location location, File file) throws IOException {
        super(effectManager, location);
        this.image = ImageIO.read(file);
        this.type = EffectType.REPEATING;
        this.period = 10;
        this.iterations = 60;
    }

    @Override
    public void onRun() {
        for (int y = 0; y < this.image.getHeight(); y += this.stepY) {
            for (int x = 0; x < this.image.getWidth(); x += this.stepX) {
                int clr = this.image.getRGB(x, y);
                if (!this.invert && Color.black.getRGB() != clr || this.invert && Color.black.getRGB() == clr) continue;
                Vector v = new Vector((float)this.image.getWidth() / 2.0f - (float)x, (float)this.image.getHeight() / 2.0f - (float)y, 0.0f).multiply(this.size);
                VectorUtils.rotateAroundAxisY(v, -this.location.getYaw() * ((float)Math.PI / 180));
                this.particle.display(this.location.add(v), this.visibleRange);
                this.location.subtract(v);
            }
        }
    }
}

