/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import java.lang.ref.WeakReference;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public abstract class Effect
implements Runnable {
    public EffectType type = EffectType.INSTANT;
    public Color color = null;
    public float speed = 1.0f;
    public int delay = 0;
    public int period = 1;
    public int iterations = 0;
    public Runnable callback = null;
    public float visibleRange = 32.0f;
    public boolean autoOrient = true;
    public Vector offset = null;
    public Vector targetOffset = null;
    public boolean asynchronous = true;
    private Location location = null;
    private WeakReference<Entity> entity = new WeakReference<Object>(null);
    private Location target = null;
    private WeakReference<Entity> targetEntity = new WeakReference<Object>(null);
    private Vector locationEntityOffset = null;
    private Vector targetEntityOffset = null;
    private boolean done = false;
    protected final EffectManager effectManager;
    protected Runnable asyncRunnableTask;

    public Effect(EffectManager effectManager) {
        if (effectManager == null) {
            throw new IllegalArgumentException("EffectManager cannot be null!");
        }
        this.effectManager = effectManager;
    }

    public final void cancel() {
        this.cancel(true);
    }

    public final void cancel(boolean callback) {
        if (callback) {
            this.done();
        } else {
            this.done = true;
        }
    }

    private void done() {
        this.done = true;
        this.effectManager.done(this);
        this.onDone();
    }

    public final boolean isDone() {
        return this.done;
    }

    public abstract void onRun();

    public void onDone() {
    }

    @Override
    public final void run() {
        if (!this.validate()) {
            this.cancel();
            return;
        }
        if (this.done) {
            return;
        }
        if (this.asynchronous) {
            if (this.asyncRunnableTask == null) {
                final Effect effect = this;
                this.asyncRunnableTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            effect.onRun();
                        }
                        catch (Exception ex) {
                            Effect.this.effectManager.onError(ex);
                            Bukkit.getScheduler().runTask(Effect.this.effectManager.getOwningPlugin(), new Runnable(){

                                @Override
                                public void run() {
                                    effect.done();
                                }
                            });
                        }
                    }
                };
            }
            Bukkit.getScheduler().runTaskAsynchronously(this.effectManager.getOwningPlugin(), this.asyncRunnableTask);
        } else {
            try {
                this.onRun();
            }
            catch (Exception ex) {
                this.done();
                this.effectManager.onError(ex);
            }
        }
        if (this.type == EffectType.REPEATING) {
            if (this.iterations == -1) {
                return;
            }
            --this.iterations;
            if (this.iterations < 1) {
                this.done();
            }
        } else {
            this.done();
        }
    }

    protected final boolean validate() {
        this.updateLocation();
        this.updateTarget();
        if (this.location == null) {
            return false;
        }
        if (this.autoOrient && this.target != null) {
            Vector direction = this.target.toVector().subtract(this.location.toVector());
            this.location.setDirection(direction);
            this.target.setDirection(direction.multiply(-1));
        }
        return true;
    }

    public final void start() {
        this.effectManager.start(this);
    }

    public final void infinite() {
        this.type = EffectType.REPEATING;
        this.iterations = -1;
    }

    public Entity getEntity() {
        return (Entity)this.entity.get();
    }

    public Entity getTargetEntity() {
        return (Entity)this.targetEntity.get();
    }

    protected void updateLocation() {
        Entity entityReference = (Entity)this.entity.get();
        if (entityReference != null) {
            Location currentLocation = null;
            currentLocation = entityReference instanceof LivingEntity ? ((LivingEntity)entityReference).getEyeLocation() : entityReference.getLocation();
            if (this.locationEntityOffset != null) {
                currentLocation.add(this.locationEntityOffset);
            } else if (this.location != null) {
                this.locationEntityOffset = this.location.toVector().subtract(currentLocation.toVector());
                currentLocation = this.location;
            }
            this.setLocation(currentLocation);
        }
    }

    public final Location getLocation() {
        return this.location;
    }

    protected void updateTarget() {
        Entity entityReference = (Entity)this.targetEntity.get();
        if (entityReference != null) {
            Location currentLocation = null;
            currentLocation = entityReference instanceof LivingEntity ? ((LivingEntity)entityReference).getEyeLocation() : entityReference.getLocation();
            if (this.targetEntityOffset != null) {
                currentLocation.add(this.targetEntityOffset);
            } else if (this.target != null) {
                this.targetEntityOffset = this.target.toVector().subtract(currentLocation.toVector());
                currentLocation = this.target;
            }
            this.setTarget(currentLocation);
        }
    }

    public final Location getTarget() {
        return this.target;
    }

    public void setEntity(Entity entity) {
        this.entity = new WeakReference<Entity>(entity);
    }

    public void setTargetEntity(Entity entity) {
        this.targetEntity = new WeakReference<Entity>(entity);
    }

    public void setLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        Location location2 = this.location = location == null ? null : location.clone();
        if (this.offset != null && this.location != null) {
            this.location = this.location.add(this.offset);
        }
    }

    public void setTarget(Location location) {
        Location location2 = this.target = location == null ? null : location.clone();
        if (this.targetOffset != null && this.target != null) {
            this.target = this.target.add(this.targetOffset);
        }
    }

    protected void display(ParticleEffect effect, Location location) {
        this.display(effect, location, this.color);
    }

    protected void display(ParticleEffect particle, Location location, Color color) {
        this.display(particle, location, color, 0.0f, 1);
    }

    protected void display(ParticleEffect particle, Location location, float speed, int amount) {
        this.display(particle, location, this.color, speed, amount);
    }

    protected void display(ParticleEffect particle, Location location, Color color, float speed, int amount) {
        particle.display(null, location, color, (double)this.visibleRange, 0.0f, 0.0f, 0.0f, speed, amount);
    }
}

