/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.UndoList;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public abstract class UndoableBatch
implements Batch {
    protected final MageController controller;
    protected final UndoList undoList;
    protected final Mage mage;
    protected boolean finished = false;

    public UndoableBatch(Mage mage) {
        this(mage, null);
    }

    public UndoableBatch(Mage mage, UndoList undoList) {
        this.controller = mage.getController();
        this.mage = mage;
        this.undoList = undoList == null ? new UndoList(mage, "Undo") : undoList;
        undoList.setBatch(this);
        mage.registerForUndo(this.undoList);
    }

    public void registerForUndo(Block block) {
        this.undoList.add(block);
    }

    public void registerForUndo(Entity entity) {
        this.undoList.add(entity);
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.finished = true;
            this.controller.update(this.undoList);
            this.undoList.setBatch(null);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

