/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;

public class TileEntitiesAction
extends CompoundAction {
    private boolean targetAllWorlds;
    private List<BlockState> tiles = new ArrayList<BlockState>();
    private int currentTile = 0;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetAllWorlds = parameters.getBoolean("target_all_worlds", false);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context);
        this.currentTile = 0;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Location sourceLocation = context.getLocation();
        if (sourceLocation == null && !this.targetAllWorlds) {
            return SpellResult.LOCATION_REQUIRED;
        }
        if (this.currentTile == 0) {
            this.tiles.clear();
            this.addTiles(context, this.tiles);
        }
        SpellResult result = SpellResult.NO_TARGET;
        while (this.currentTile < this.tiles.size()) {
            BlockState tile = this.tiles.get(this.currentTile);
            this.actionContext.setTargetLocation(tile.getLocation());
            SpellResult entityResult = super.perform(this.actionContext);
            result = result.min(entityResult);
            if (entityResult.isStop()) break;
            ++this.currentTile;
            if (this.currentTile >= this.tiles.size()) continue;
            super.reset(context);
        }
        return result;
    }

    public void addTiles(CastContext context, List<BlockState> tiles) {
        ArrayList<World> worlds;
        Location sourceLocation = context.getLocation();
        if (sourceLocation == null && !this.targetAllWorlds) {
            return;
        }
        if (this.targetAllWorlds) {
            worlds = Bukkit.getWorlds();
        } else {
            worlds = new ArrayList<World>();
            worlds.add(sourceLocation.getWorld());
        }
        for (World world : worlds) {
            Chunk[] chunks;
            for (Chunk chunk : chunks = world.getLoadedChunks()) {
                tiles.addAll(Arrays.asList(chunk.getTileEntities()));
            }
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("target_all_worlds");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("target_all_worlds")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

