/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.batch.ConstructBatch;
import com.elmakers.mine.bukkit.block.ConstructionType;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class ConstructSpell
extends BrushSpell {
    public static final String[] CONSTRUCT_PARAMETERS = new String[]{"radius", "falling", "speed", "max_dimension", "replace", "type", "thickness", "orient_dimension_max", "orient_dimension_min", "power", "breakable", "backfire", "select_self", "use_brush_size", "falling_direction"};
    private static final ConstructionType DEFAULT_CONSTRUCTION_TYPE = ConstructionType.SPHERE;
    private static final int DEFAULT_RADIUS = 2;
    private static final int DEFAULT_MAX_DIMENSION = 16;
    private Block targetBlock = null;
    private boolean powered = false;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean hasPermission;
        boolean finalCast;
        Block target = null;
        boolean isSelect = this.getTargetType() == TargetType.SELECT;
        boolean bl = finalCast = !isSelect || this.targetBlock != null;
        if (isSelect) {
            this.setTargetType(TargetType.BLOCK);
        }
        if (finalCast && parameters.getBoolean("select_self", true) && this.isLookingDown()) {
            target = this.mage.getLocation().getBlock().getRelative(BlockFace.DOWN);
        } else {
            Target t = this.getTarget();
            target = t.getBlock();
        }
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        MaterialBrush buildWith = this.getBrush();
        boolean bl2 = hasPermission = buildWith != null && buildWith.isErase() ? this.hasBreakPermission(target) : this.hasBuildPermission(target);
        if (!hasPermission) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", 2);
        radius = parameters.getInt("r", radius);
        radius = parameters.getInt("size", radius);
        boolean falling = parameters.getBoolean("falling", false);
        boolean physics = parameters.getBoolean("physics", false);
        boolean commit = parameters.getBoolean("commit", false);
        int breakable = parameters.getInt("breakable", 0);
        double backfireChance = parameters.getDouble("reflect_chance", 0.0);
        Vector orientTo = null;
        Vector bounds = null;
        if (parameters.getBoolean("use_brush_size", false)) {
            if (!buildWith.isReady()) {
                long timeout = System.currentTimeMillis() + 10000L;
                while (System.currentTimeMillis() < timeout) {
                    try {
                        Thread.sleep(500L);
                        if (!buildWith.isReady()) continue;
                        break;
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (!buildWith.isReady()) {
                    return SpellResult.NO_ACTION;
                }
            }
            bounds = buildWith.getSize();
            radius = (int)Math.max(Math.max(bounds.getX() / 2.0, bounds.getZ() / 2.0), bounds.getY());
        } else if (isSelect) {
            if (this.targetLocation2 != null) {
                this.targetBlock = this.targetLocation2.getBlock();
            }
            if (this.targetBlock == null || !this.targetBlock.getWorld().equals(target.getWorld())) {
                this.targetBlock = target;
                this.activate();
                return SpellResult.TARGET_SELECTED;
            }
            radius = (int)this.targetBlock.getLocation().distance(target.getLocation());
            orientTo = target.getLocation().toVector().subtract(this.targetBlock.getLocation().toVector());
            orientTo.setX(Math.abs(orientTo.getX()));
            orientTo.setY(Math.abs(orientTo.getY()));
            orientTo.setZ(Math.abs(orientTo.getZ()));
            orientTo = orientTo.getX() < orientTo.getZ() && orientTo.getX() < orientTo.getY() ? new Vector(1, 0, 0) : (orientTo.getZ() < orientTo.getX() && orientTo.getZ() < orientTo.getY() ? new Vector(0, 0, 1) : new Vector(0, 1, 0));
            target = this.targetBlock;
            this.targetBlock = null;
        } else if (parameters.getBoolean("orient")) {
            orientTo = this.mage.getLocation().toVector().subtract(target.getLocation().toVector());
            orientTo.setX(Math.abs(orientTo.getX()));
            orientTo.setY(Math.abs(orientTo.getY()));
            orientTo.setZ(Math.abs(orientTo.getZ()));
            orientTo = orientTo.getX() > orientTo.getZ() && orientTo.getX() > orientTo.getY() ? new Vector(1, 0, 0) : (orientTo.getZ() > orientTo.getX() && orientTo.getZ() > orientTo.getY() ? new Vector(0, 0, 1) : new Vector(0, 1, 0));
        }
        if (!parameters.contains("radius")) {
            int maxDimension = parameters.getInt("max_dimension", 16);
            maxDimension = parameters.getInt("md", maxDimension);
            int diameter = radius * 2;
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (diameter > maxDimension) {
                return SpellResult.FAIL;
            }
        }
        if (parameters.contains("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        buildWith.setTarget(target.getLocation());
        ConstructionType conType = DEFAULT_CONSTRUCTION_TYPE;
        int thickness = parameters.getInt("thickness", 0);
        String typeString = parameters.getString("type", "");
        ConstructionType testType = ConstructionType.parseString(typeString, ConstructionType.UNKNOWN);
        if (testType != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        ConstructBatch batch = new ConstructBatch(this, target.getLocation(), conType, radius, thickness, falling, orientTo);
        batch.setCommit(commit);
        if (parameters.getBoolean("replace", false)) {
            Material targetMaterial;
            ArrayList<MaterialAndData> replaceMaterials = new ArrayList<MaterialAndData>();
            com.elmakers.mine.bukkit.block.MaterialAndData wildReplace = new com.elmakers.mine.bukkit.block.MaterialAndData(target);
            if (!parameters.getBoolean("match_data", true)) {
                wildReplace.setData(null);
            }
            if ((targetMaterial = target.getType()) == Material.STATIONARY_WATER || targetMaterial == Material.WATER || targetMaterial == Material.STATIONARY_LAVA || targetMaterial == Material.LAVA) {
                wildReplace.setData(null);
            }
            replaceMaterials.add(wildReplace);
            batch.setReplace(replaceMaterials);
        }
        if (parameters.contains("commands")) {
            ConfigurationSection commandMap = parameters.getConfigurationSection("commands");
            Set keys = commandMap.getKeys(false);
            for (String key : keys) {
                batch.addCommandMapping(key, commandMap.getString(key));
            }
        }
        if (falling) {
            float force = (float)parameters.getDouble("speed", 0.0);
            batch.setFallingDirection(ConfigurationUtils.getVector(parameters, "falling_direction"));
            batch.setFallingBlockSpeed(force);
        }
        batch.setApplyPhysics(physics);
        if (breakable > 0) {
            batch.setBreakable(breakable);
        }
        if (backfireChance > 0.0) {
            batch.setBackfireChance(backfireChance);
        }
        if (parameters.contains("orient_dimension_max")) {
            batch.setOrientDimensionMax(parameters.getInt("orient_dimension_max"));
        } else if (parameters.contains("odmax")) {
            batch.setOrientDimensionMax(parameters.getInt("odmax"));
        }
        if (parameters.contains("orient_dimension_min")) {
            batch.setOrientDimensionMin(parameters.getInt("orient_dimension_min"));
        } else if (parameters.contains("odmin")) {
            batch.setOrientDimensionMin(parameters.getInt("odmin"));
        }
        if (parameters.getBoolean("power", false)) {
            batch.setPower(true);
        }
        if (bounds != null) {
            batch.setBounds(bounds);
            batch.setOrientDimensionMin(0);
        }
        boolean success = this.mage.addBatch(batch);
        this.deactivate();
        return success ? SpellResult.CAST : SpellResult.FAIL;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
    }

    @Override
    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.deactivate();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBrushOverride() {
        return this.powered || super.hasBrushOverride();
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        this.powered = this.parameters.getBoolean("power", false);
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(CONSTRUCT_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("radius") || parameterKey.equals("max_dimension") || parameterKey.equals("orient_dimension_max") || parameterKey.equals("orient_dimension_min") || parameterKey.equals("thickness") || parameterKey.equals("speed")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("type")) {
            ConstructionType[] constructionTypes;
            for (ConstructionType constructionType : constructionTypes = ConstructionType.values()) {
                examples.add(constructionType.name().toLowerCase());
            }
        } else if (parameterKey.equals("power") || parameterKey.equals("replace") || parameterKey.equals("falling")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        }
    }
}

