/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class EnchantingController
implements Listener {
    private final MagicController controller;
    private boolean enchantingEnabled = false;

    public EnchantingController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection properties) {
        WandUpgradePath.loadPaths(this.controller, properties);
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (this.enchantingEnabled && Wand.isWand(event.getItem())) {
            Player player = event.getEnchanter();
            if (player == null || !this.controller.hasPermission(player, "Magic.wand.enchant")) {
                event.setCancelled(true);
                return;
            }
            event.getEnchantsToAdd().clear();
            int level = event.getExpLevelCost();
            Wand wand = new Wand(this.controller, event.getItem());
            if (wand.enchant(level, this.controller.getMage(event.getEnchanter())) <= 0) {
                event.setCancelled(true);
            } else {
                event.setCancelled(false);
                event.getEnchantsToAdd().put(null, 0);
            }
            wand.makeEnchantable(true);
        }
    }

    @EventHandler
    public void onPrepareEnchantItem(PrepareItemEnchantEvent event) {
        if (Wand.isWand(event.getItem())) {
            if (!this.enchantingEnabled) {
                event.setCancelled(true);
                return;
            }
            Player player = event.getEnchanter();
            if (player == null || !this.controller.hasPermission(player, "Magic.wand.enchant")) {
                event.setCancelled(true);
                return;
            }
            Wand wandItem = new Wand(this.controller, event.getItem());
            if (!wandItem.isModifiable() && wandItem.getPath() == null) {
                event.setCancelled(true);
                return;
            }
            if (!wandItem.canUse(player)) {
                event.setCancelled(true);
                return;
            }
            wandItem.makeEnchantable(true);
            WandUpgradePath path = (WandUpgradePath)wandItem.getPath();
            if (path == null) {
                event.setCancelled(true);
                return;
            }
            int minLevel = path.getMinLevel();
            int maxLevel = path.getMaxLevel();
            int levelRange = maxLevel - minLevel;
            Set<Integer> levelSet = path.getLevels();
            ArrayList<Integer> levels = new ArrayList<Integer>();
            levels.addAll(levelSet);
            int[] offered = event.getExpLevelCostsOffered();
            float bonusLevelMultiplier = path.getBonusLevelMultiplier();
            int bonusLevels = event.getEnchantmentBonus();
            for (int i = 0; i < offered.length; ++i) {
                int level = minLevel + (int)((float)i * (float)levelRange / (float)offered.length);
                if (bonusLevels > 0 && bonusLevelMultiplier > 0.0f) {
                    level = (int)((float)level + (float)bonusLevels * bonusLevelMultiplier);
                }
                offered[i] = level;
            }
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        if (this.enchantingEnabled && inventoryType == InventoryType.ENCHANTING && slotType == InventoryType.SlotType.CRAFTING) {
            Wand wand;
            Player player;
            HumanEntity clicker = event.getWhoClicked();
            Player player2 = player = clicker instanceof Player ? (Player)clicker : null;
            if (player == null || !this.controller.hasPermission(player, "Magic.wand.enchant")) {
                return;
            }
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if (Wand.isWand(cursor) && (wand = new Wand(this.controller, cursor)).isModifiable()) {
                wand.makeEnchantable(true);
            }
            if (Wand.isWand(current) && (wand = new Wand(this.controller, current)).isModifiable()) {
                wand.makeEnchantable(false);
            }
        }
    }

    public boolean isEnabled() {
        return this.enchantingEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.enchantingEnabled = enabled;
    }

    public int getCount() {
        return WandUpgradePath.getPathKeys().size();
    }
}

