/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class LibsDisguiseManager {
    private final Plugin plugin;
    private Method isDisguisedMethod = null;

    public LibsDisguiseManager(Plugin owningPlugin, Plugin disguisePlugin) {
        this.plugin = owningPlugin;
    }

    public boolean initialize() {
        try {
            Class<?> disguiseAPI = Class.forName("me.libraryaddict.disguise.DisguiseAPI");
            if (disguiseAPI == null) {
                this.plugin.getLogger().log(Level.WARNING, "LibsDisguise plugin found, but DisguiseAPI could not be loaded");
                return false;
            }
            this.isDisguisedMethod = disguiseAPI.getMethod("isDisguised", Entity.class);
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.WARNING, "LibsDisguise integration failed", ex);
            this.isDisguisedMethod = null;
            return false;
        }
        if (this.isDisguisedMethod == null) {
            this.plugin.getLogger().log(Level.WARNING, "Something went wrong with LibsDisguise integration");
            return false;
        }
        return true;
    }

    public boolean isDisguised(Entity entity) {
        if (this.isDisguisedMethod == null) {
            return false;
        }
        boolean disguised = false;
        try {
            disguised = (Boolean)this.isDisguisedMethod.invoke(null, entity);
        }
        catch (Exception ex) {
            disguised = false;
        }
        return disguised;
    }
}

