/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.TriggeredCompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class ThrowBlockAction
extends TriggeredCompoundAction {
    private double speedMin;
    private double speedMax;
    private boolean setTarget;
    private float fallDamage;
    private int maxDamage;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        double itemSpeed = parameters.getDouble("speed", (double)0.6f);
        this.speedMin = parameters.getDouble("speed_min", itemSpeed);
        this.speedMax = parameters.getDouble("speed_max", itemSpeed);
        this.setTarget = parameters.getBoolean("set_target", false);
        int damage = parameters.getInt("damage", 0);
        this.fallDamage = (float)parameters.getDouble("fall_damage", (double)damage);
        this.maxDamage = parameters.getInt("max_damage", damage);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Location location = context.getLocation();
        if (!context.hasBuildPermission(location.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        location.setY(location.getY() - 1.0);
        MaterialBrush buildWith = context.getBrush();
        buildWith.setTarget(location);
        Material material = buildWith.getMaterial();
        byte data = buildWith.getBlockData();
        Vector direction = context.getDirection();
        double speed = context.getRandom().nextDouble() * (this.speedMax - this.speedMin) + this.speedMin;
        direction.normalize().multiply(speed);
        Vector up = new Vector(0, 1, 0);
        Vector perp = new Vector();
        perp.copy(direction);
        perp.crossProduct(up);
        FallingBlock block = null;
        location = context.getEyeLocation();
        block = context.getWorld().spawnFallingBlock(location, material, data);
        if (block == null) {
            return SpellResult.FAIL;
        }
        if (this.setTarget) {
            context.setTargetEntity((Entity)block);
        }
        Collection<EffectPlayer> projectileEffects = context.getEffects("projectile");
        for (EffectPlayer effectPlayer : projectileEffects) {
            effectPlayer.start(block.getLocation(), (Entity)block, null, null);
        }
        ActionHandler.setEffects((Entity)block, context, "hit");
        context.registerForUndo((Entity)block);
        block.setDropItem(false);
        block.setVelocity(direction);
        if (this.maxDamage > 0 && this.fallDamage > 0.0f) {
            CompatibilityUtils.setFallingBlockDamage(block, this.fallDamage, this.maxDamage);
        }
        ActionHandler.setActions((Entity)block, this.actions, context, this.parameters, "indirect_player_message");
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean usesBrush() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("speed");
        parameters.add("speed_min");
        parameters.add("speed_max");
        parameters.add("damage");
        parameters.add("max_damage");
        parameters.add("fall_damage");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("speed") || parameterKey.equals("speed_max") || parameterKey.equals("speed_min") || parameterKey.equals("damage") || parameterKey.equals("max_damage") || parameterKey.equals("fall_damage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

