/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_17_1;

import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.NBTUtilsBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.bukkit.inventory.ItemStack;

public class NBTUtils
extends NBTUtilsBase {
    public NBTUtils(Platform platform) {
        super(platform);
    }

    @Override
    public Object getNode(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        Object tagObject = this.platform.getItemUtils().getTag(stack);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)tagObject).get(tag);
    }

    @Override
    public Object getNode(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)nbtBase).get(tag);
    }

    @Override
    public boolean containsNode(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return false;
        }
        return ((NBTTagCompound)nbtBase).hasKey(tag);
    }

    @Override
    public Object createNode(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)nbtBase;
        NBTTagCompound meta = compoundTag.getCompound(tag);
        compoundTag.set(tag, (NBTBase)meta);
        return meta;
    }

    @Override
    public Object createNode(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        Object outputObject = this.getNode(stack, tag);
        if (outputObject == null || !(outputObject instanceof NBTTagCompound)) {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return null;
            }
            NBTTagCompound tagObject = (NBTTagCompound)this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                tagObject = new NBTTagCompound();
                ((net.minecraft.world.item.ItemStack)craft).setTag(tagObject);
            }
            outputObject = new NBTTagCompound();
            tagObject.set(tag, (NBTBase)((NBTTagCompound)outputObject));
        }
        return outputObject;
    }

    @Override
    public String getMetaString(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getString(tag);
    }

    @Override
    public String getMetaString(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        String meta = null;
        Object tagObject = this.platform.getItemUtils().getTag(stack);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return null;
        }
        meta = ((NBTTagCompound)tagObject).getString(tag);
        return meta;
    }

    @Override
    public Byte getMetaByte(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getByte(tag);
    }

    @Override
    public Integer getMetaInt(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getInt(tag);
    }

    @Override
    public Double getMetaDouble(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getDouble(tag);
    }

    @Override
    public Boolean getMetaBoolean(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)node).getBoolean(tag);
    }

    @Override
    public void setMetaLong(Object node, String tag, long value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setLong(tag, value);
    }

    @Override
    public void setMetaBoolean(Object node, String tag, boolean value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setBoolean(tag, value);
    }

    @Override
    public void setMetaDouble(Object node, String tag, double value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setDouble(tag, value);
    }

    @Override
    public void setMetaInt(Object node, String tag, int value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setInt(tag, value);
    }

    @Override
    public void removeMeta(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).remove(tag);
    }

    @Override
    public void setMetaNode(Object node, String tag, Object child) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        if (child == null) {
            ((NBTTagCompound)node).remove(tag);
        } else if (child instanceof NBTBase) {
            ((NBTTagCompound)node).set(tag, (NBTBase)child);
        }
    }

    @Override
    public boolean setMetaNode(ItemStack stack, String tag, Object child) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return false;
        }
        Object craft = this.platform.getItemUtils().getHandle(stack);
        if (craft == null) {
            return false;
        }
        Object node = this.platform.getItemUtils().getTag(craft);
        if (node == null || !(node instanceof NBTTagCompound)) {
            return false;
        }
        if (child == null) {
            ((NBTTagCompound)node).remove(tag);
        } else {
            ((NBTTagCompound)node).set(tag, (NBTBase)child);
        }
        return true;
    }

    @Override
    public void setMeta(Object node, String tag, String value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).setString(tag, value);
    }

    @Override
    public void setMeta(ItemStack stack, String tag, String value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        Object craft = this.platform.getItemUtils().getHandle(stack);
        if (craft == null) {
            return;
        }
        Object tagObject = this.platform.getItemUtils().getTag(craft);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tagObject).setString(tag, value);
    }

    @Override
    public void addToList(Object listObject, Object node) {
        if (listObject == null || !(listObject instanceof NBTTagList) || !(node instanceof NBTBase)) {
            return;
        }
        NBTTagList list = (NBTTagList)listObject;
        list.add((Object)((NBTBase)node));
    }
}

