/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.EnteredStateTracker;
import com.elmakers.mine.bukkit.utility.LoadingChunk;
import com.elmakers.mine.bukkit.utility.TeleportPassengerTask;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.PaperUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Torch;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.spigotmc.event.entity.EntityDismountEvent;

public abstract class CompatibilityUtilsBase
implements CompatibilityUtils {
    protected static final int MAX_CHUNK_LOAD_TRY = 10000;
    protected static final int MAX_ENTITY_RANGE = 72;
    protected static boolean USE_MAGIC_DAMAGE = true;
    protected static int BLOCK_BREAK_RANGE = 64;
    protected final UUID emptyUUID = new UUID(0L, 0L);
    protected ItemStack dummyItem;
    protected boolean hasDumpedStack = false;
    protected boolean teleporting = false;
    protected final Map<World.Environment, Integer> maxHeights = new HashMap<World.Environment, Integer>();
    protected final Map<LoadingChunk, Integer> loadingChunks = new HashMap<LoadingChunk, Integer>();
    protected final EnteredStateTracker isDamaging = new EnteredStateTracker();
    protected final Map<World, WeakReference<ThrownPotion>> worldPotions = new WeakHashMap<World, WeakReference<ThrownPotion>>();
    public Map<Integer, Material> materialIdMap;
    protected final Platform platform;

    protected CompatibilityUtilsBase(Platform platform) {
        this.platform = platform;
    }

    @Override
    public boolean isDamaging() {
        return this.isDamaging.isInside();
    }

    @Override
    public void applyPotionEffects(LivingEntity entity, Collection<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            this.applyPotionEffect(entity, effect);
        }
    }

    @Override
    public boolean applyPotionEffect(LivingEntity entity, PotionEffect effect) {
        boolean applyEffect = true;
        Collection currentEffects = entity.getActivePotionEffects();
        for (PotionEffect currentEffect : currentEffects) {
            if (!currentEffect.getType().equals((Object)effect.getType())) continue;
            if (effect.getAmplifier() < 0) {
                applyEffect = false;
                break;
            }
            if (currentEffect.getAmplifier() <= effect.getAmplifier() && effect.getDuration() <= 0x1FFFFFFF) continue;
            applyEffect = false;
            break;
        }
        if (applyEffect) {
            entity.addPotionEffect(effect, true);
        }
        return applyEffect;
    }

    @Override
    public boolean setDisplayNameRaw(ItemStack itemStack, String displayName) {
        Object handle = this.platform.getItemUtils().getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = this.platform.getItemUtils().getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = this.platform.getNBTUtils().createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        this.platform.getNBTUtils().setMeta(displayNode, "Name", displayName);
        return true;
    }

    @Override
    public boolean setDisplayName(ItemStack itemStack, String displayName) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(displayName);
        itemStack.setItemMeta(meta);
        return true;
    }

    @Override
    public boolean setLore(ItemStack itemStack, List<String> lore) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        return true;
    }

    @Override
    public void setInvulnerable(Entity entity) {
        this.setInvulnerable(entity, true);
    }

    @Override
    public ArmorStand createArmorStand(Location location) {
        return (ArmorStand)this.createEntity(location, EntityType.ARMOR_STAND);
    }

    @Override
    public Runnable getTaskRunnable(BukkitTask task) {
        return null;
    }

    @Override
    public void damage(Damageable target, double amount, Entity source) {
        if (target == null || target.isDead()) {
            return;
        }
        while (target instanceof ComplexEntityPart) {
            target = ((ComplexEntityPart)target).getParent();
        }
        if (USE_MAGIC_DAMAGE && target.getType() == EntityType.ENDER_DRAGON) {
            this.magicDamage(target, amount, source);
            return;
        }
        try (EnteredStateTracker.Touchable damaging = this.isDamaging.enter();){
            damaging.touch();
            if (target instanceof ArmorStand) {
                double newHealth = Math.max(0.0, target.getHealth() - amount);
                if (newHealth <= 0.0) {
                    EntityDeathEvent deathEvent = new EntityDeathEvent((LivingEntity)((ArmorStand)target), new ArrayList());
                    Bukkit.getPluginManager().callEvent((Event)deathEvent);
                    target.remove();
                } else {
                    target.setHealth(newHealth);
                }
            } else {
                target.damage(amount, source);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected ThrownPotion getOrCreatePotionEntity(Location location) {
        ThrownPotion potion;
        World world = location.getWorld();
        WeakReference<ThrownPotion> ref = this.worldPotions.get(world);
        ThrownPotion thrownPotion = potion = ref == null ? null : (ThrownPotion)ref.get();
        if (potion == null) {
            potion = (ThrownPotion)world.spawnEntity(location, EntityType.SPLASH_POTION);
            potion.remove();
            ref = new WeakReference<ThrownPotion>(potion);
            this.worldPotions.put(world, ref);
        } else {
            potion.teleport(location);
        }
        return potion;
    }

    @Override
    public Location getEyeLocation(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getEyeLocation();
        }
        return entity.getLocation();
    }

    @Override
    public ConfigurationSection loadConfiguration(String fileName) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    @Override
    public ConfigurationSection loadConfiguration(File file) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable ex) {
            this.platform.getLogger().log(Level.SEVERE, "Error reading configuration file '" + file.getAbsolutePath() + "'");
            throw ex;
        }
        return configuration;
    }

    @Override
    public YamlConfiguration loadConfiguration(InputStream stream, String fileName) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        if (stream == null) {
            this.platform.getLogger().log(Level.SEVERE, "Could not find builtin configuration file '" + fileName + "'");
            return configuration;
        }
        try {
            configuration.load((Reader)new InputStreamReader(stream, "UTF-8"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    @Override
    public YamlConfiguration loadBuiltinConfiguration(String fileName) throws IOException, InvalidConfigurationException {
        Plugin plugin = this.platform.getPlugin();
        return this.loadConfiguration(plugin.getResource(fileName), fileName);
    }

    @Override
    public int getFacing(BlockFace direction) {
        int dir;
        switch (direction) {
            default: {
                dir = 0;
                break;
            }
            case WEST: {
                dir = 1;
                break;
            }
            case NORTH: {
                dir = 2;
                break;
            }
            case EAST: {
                dir = 3;
            }
        }
        return dir;
    }

    @Override
    public Map<String, Object> getMap(ConfigurationSection section) {
        return this.getTypedMap(section);
    }

    @Override
    public Vector getNormal(Block block, Location intersection) {
        double x = intersection.getX() - ((double)block.getX() + 0.5);
        double y = intersection.getY() - ((double)block.getY() + 0.5);
        double z = intersection.getZ() - ((double)block.getZ() + 0.5);
        double ax = Math.abs(x);
        double ay = Math.abs(y);
        double az = Math.abs(z);
        if (ax > ay && ax > az) {
            return new Vector(Math.signum(x), 0.0, 0.0);
        }
        if (ay > ax && ay > az) {
            return new Vector(0.0, Math.signum(y), 0.0);
        }
        return new Vector(0.0, 0.0, Math.signum(z));
    }

    @Override
    public void configureMaxHeights(ConfigurationSection config) {
        this.maxHeights.clear();
        if (config == null) {
            return;
        }
        Set keys = config.getKeys(false);
        for (String key : keys) {
            try {
                World.Environment worldType = World.Environment.valueOf((String)key.toUpperCase());
                this.maxHeights.put(worldType, config.getInt(key));
            }
            catch (Exception ex) {
                this.platform.getLogger().log(Level.WARNING, "Invalid environment type: " + key, ex);
            }
        }
    }

    @Override
    public int getMinHeight(World world) {
        if (!this.platform.isCurrentVersion()) {
            return 0;
        }
        return -64;
    }

    @Override
    public int getMaxHeight(World world) {
        Integer maxHeight = this.maxHeights.get(world.getEnvironment());
        if (maxHeight == null) {
            maxHeight = world.getMaxHeight();
        }
        return maxHeight;
    }

    @Override
    public int getMaxEntityRange() {
        return 72;
    }

    @Override
    public void load(ConfigurationSection properties) {
        USE_MAGIC_DAMAGE = properties.getBoolean("use_magic_damage", USE_MAGIC_DAMAGE);
    }

    protected String toMinecraftAttribute(Attribute attribute) {
        String bukkit = attribute.name();
        int first = bukkit.indexOf(95);
        int second = bukkit.indexOf(95, first + 1);
        StringBuilder sb = new StringBuilder(bukkit.toLowerCase(Locale.ENGLISH));
        sb.setCharAt(first, '.');
        if (second != -1) {
            sb.deleteCharAt(second);
            sb.setCharAt(second, bukkit.charAt(second + 1));
        }
        return sb.toString();
    }

    @Override
    public boolean setItemAttribute(ItemStack item, Attribute attribute, double value, String slot, int attributeOperation) {
        return this.setItemAttribute(item, attribute, value, slot, attributeOperation, UUID.randomUUID());
    }

    @Override
    public void applyItemData(ItemStack item, Block block) {
        try {
            Object entityDataTag = this.platform.getNBTUtils().getNode(item, "BlockEntityTag");
            if (entityDataTag == null) {
                return;
            }
            this.setTileEntityData(block.getLocation(), entityDataTag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int getBlockEntityId(Block block) {
        return (block.getX() & 0xFFF) << 20 | (block.getZ() & 0xFFF) << 8 | block.getY() & 0xFF;
    }

    @Override
    public void clearBreaking(Block block) {
        this.setBreaking(block, 10, BLOCK_BREAK_RANGE);
    }

    @Override
    public void setBreaking(Block block, double percentage) {
        int breakState = (int)Math.ceil(9.0 * percentage);
        this.setBreaking(block, breakState, BLOCK_BREAK_RANGE);
    }

    @Override
    public void setBreaking(Block block, int breakAmount) {
        this.setBreaking(block, breakAmount, BLOCK_BREAK_RANGE);
    }

    @Override
    public void setBreaking(Block block, int breakAmount, int range) {
        String worldName = block.getWorld().getName();
        Location location = block.getLocation();
        int rangeSquared = range * range;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().getName().equals(worldName) || player.getLocation().distanceSquared(location) > (double)rangeSquared) continue;
            this.sendBreaking(player, this.getBlockEntityId(block), location, breakAmount);
        }
    }

    @Override
    public boolean setBlockFast(Block block, Material material, int data) {
        return this.setBlockFast(block.getChunk(), block.getX(), block.getY(), block.getZ(), material, data);
    }

    @Override
    public Material getMaterial(int id, byte data) {
        Material material = this.getMaterial(id);
        if (material != null) {
            material = this.fromLegacy(new MaterialData(material, data));
        }
        if (material == null) {
            material = Material.AIR;
        }
        return material;
    }

    @Override
    public Material getMaterial(int id) {
        if (this.materialIdMap == null) {
            T[] allMaterials;
            this.materialIdMap = new HashMap<Integer, Material>();
            for (Object o : allMaterials = Material.AIR.getDeclaringClass().getEnumConstants()) {
                Material material = (Material)o;
                if (this.hasLegacyMaterials() && !this.isLegacy(material)) continue;
                this.materialIdMap.put(material.getId(), material);
            }
        }
        return this.materialIdMap.get(id);
    }

    @Override
    public Material getMaterial(String blockData) {
        String[] pieces = StringUtils.split((String)blockData, (String)"[", (int)2);
        if (pieces.length == 0) {
            return null;
        }
        if ((pieces = StringUtils.split((String)pieces[0], (String)":", (int)2)).length == 0) {
            return null;
        }
        String materialKey = "";
        if (pieces.length == 2) {
            if (!pieces[0].equals("minecraft")) {
                return null;
            }
            materialKey = pieces[1];
        } else {
            materialKey = pieces[0];
        }
        try {
            return Material.valueOf((String)materialKey.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Material migrateMaterial(Material material, byte data) {
        return this.fromLegacy(new MaterialData(material, data));
    }

    @Override
    public String migrateMaterial(String materialKey) {
        MaterialData materialData;
        Material legacyMaterial;
        String materialName;
        Material material;
        if (materialKey == null || materialKey.isEmpty()) {
            return materialKey;
        }
        byte data = 0;
        String[] pieces = StringUtils.split((String)materialKey, (char)':');
        String textData = "";
        if (pieces.length > 1) {
            textData = pieces[1];
            try {
                data = Byte.parseByte(pieces[1]);
                textData = "";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((material = Material.getMaterial((String)(materialName = pieces[0].toUpperCase()))) != null && data == 0) {
            return material.name().toLowerCase();
        }
        Material material2 = legacyMaterial = data == 0 ? this.getLegacyMaterial(materialName) : Material.getMaterial((String)("LEGACY_" + materialName));
        if (legacyMaterial != null && (legacyMaterial = this.fromLegacy(materialData = new MaterialData(legacyMaterial, data))) != null) {
            material = legacyMaterial;
        }
        if (material != null) {
            materialKey = material.name().toLowerCase();
            if (!textData.isEmpty()) {
                materialKey = materialKey + ":" + textData;
            }
        }
        return materialKey;
    }

    @Override
    public boolean isChunkLoaded(Block block) {
        return this.isChunkLoaded(block.getLocation());
    }

    @Override
    public boolean isChunkLoaded(Location location) {
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        World world = location.getWorld();
        return world.isChunkLoaded(chunkX, chunkZ);
    }

    @Override
    public boolean checkChunk(Location location) {
        return this.checkChunk(location, true);
    }

    @Override
    public boolean checkChunk(Location location, boolean generate) {
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        World world = location.getWorld();
        return this.checkChunk(world, chunkX, chunkZ, generate);
    }

    @Override
    public boolean checkChunk(World world, int chunkX, int chunkZ) {
        return this.checkChunk(world, chunkX, chunkZ, true);
    }

    @Override
    public boolean checkChunk(World world, int chunkX, int chunkZ, boolean generate) {
        if (!world.isChunkLoaded(chunkX, chunkZ)) {
            this.loadChunk(world, chunkX, chunkZ, generate);
            return false;
        }
        return this.isReady(world.getChunkAt(chunkX, chunkZ));
    }

    @Override
    public boolean isTopBlock(Block block) {
        String blockData = this.getBlockData(block);
        return blockData != null && blockData.contains("type=top");
    }

    @Override
    public ItemStack getKnowledgeBook() {
        ItemStack book = null;
        try {
            Material bookMaterial = Material.valueOf((String)"KNOWLEDGE_BOOK");
            book = new ItemStack(bookMaterial);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return book;
    }

    @Override
    public Entity getSource(Entity entity) {
        ProjectileSource source;
        if (entity instanceof Projectile && (source = ((Projectile)entity).getShooter()) instanceof Entity) {
            entity = (Entity)source;
        }
        return entity;
    }

    @Override
    public BlockFace getCCW(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + face);
    }

    @Override
    public void loadChunk(Location location, boolean generate, Consumer<Chunk> consumer) {
        this.loadChunk(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, generate, consumer);
    }

    @Override
    public void loadChunk(World world, int x, int z, boolean generate) {
        this.loadChunk(world, x, z, generate, null);
    }

    @Override
    public void loadChunk(World world, int x, int z, boolean generate, Consumer<Chunk> consumer) {
        PaperUtils paperUtils = this.platform.getPaperUtils();
        if (paperUtils == null) {
            Chunk chunk2 = world.getChunkAt(x, z);
            chunk2.load();
            if (consumer != null) {
                consumer.accept(chunk2);
            }
            return;
        }
        LoadingChunk loading = new LoadingChunk(world, x, z);
        Integer requestCount = this.loadingChunks.get(loading);
        if (requestCount != null) {
            Integer n = requestCount;
            requestCount = requestCount + 1;
            if (requestCount > 10000) {
                this.platform.getLogger().warning("Exceeded retry count for asynchronous chunk load, loading synchronously");
                if (!this.hasDumpedStack) {
                    this.hasDumpedStack = true;
                    Thread.dumpStack();
                }
                Chunk chunk3 = world.getChunkAt(x, z);
                chunk3.load();
                if (consumer != null) {
                    consumer.accept(chunk3);
                }
                this.loadingChunks.remove(loading);
                return;
            }
            this.loadingChunks.put(loading, requestCount);
            return;
        }
        this.loadingChunks.put(loading, 1);
        paperUtils.loadChunk(world, x, z, generate, chunk -> {
            this.loadingChunks.remove(loading);
            if (consumer != null) {
                consumer.accept((Chunk)chunk);
            }
        });
    }

    @Override
    public Entity getRootVehicle(Entity entity) {
        if (entity == null) {
            return null;
        }
        Entity vehicle = entity.getVehicle();
        while (vehicle != null) {
            entity = vehicle;
            vehicle = entity.getVehicle();
        }
        return entity;
    }

    protected void teleportPassengers(Entity vehicle, Location location, Collection<Entity> passengers) {
        for (Entity passenger : passengers) {
            if (passenger instanceof Player) {
                TeleportPassengerTask task = new TeleportPassengerTask(this, vehicle, passenger, location);
                Plugin plugin = this.platform.getPlugin();
                plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)task, 2L);
                continue;
            }
            this.teleportVehicle(passenger, location);
            this.addPassenger(vehicle, passenger);
        }
    }

    @Override
    public void teleportVehicle(Entity vehicle, Location location) {
        List<Entity> passengers = this.getPassengers(vehicle);
        vehicle.eject();
        vehicle.teleport(location);
        List<Entity> newPassengers = this.getPassengers(vehicle);
        if (newPassengers.isEmpty()) {
            this.teleportPassengers(vehicle, location, passengers);
        } else {
            this.platform.getLogger().warning("Entity.eject failed!");
        }
    }

    @Override
    public void teleportWithVehicle(Entity entity, Location location) {
        this.teleporting = true;
        if (entity != null && entity.isValid()) {
            Entity vehicle = this.getRootVehicle(entity);
            this.teleportVehicle(vehicle, location);
        }
        this.teleporting = false;
    }

    @Override
    public boolean isTeleporting() {
        return this.teleporting;
    }

    @Override
    public void playRecord(Location location, Material record) {
        if (this.platform.isLegacy()) {
            location.getWorld().playEffect(location, Effect.RECORD_PLAY, this.platform.getDeprecatedUtils().getId(record));
        } else {
            location.getWorld().playEffect(location, Effect.RECORD_PLAY, (Object)record);
        }
    }

    @Override
    public void cancelDismount(EntityDismountEvent event) {
    }

    @Override
    public String translateColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @Override
    public String getEnchantmentKey(Enchantment enchantment) {
        return enchantment.getName().toLowerCase();
    }

    @Override
    public Enchantment getEnchantmentByKey(String key) {
        return Enchantment.getByName((String)key.toUpperCase());
    }

    @Override
    public boolean setTorchFacingDirection(Block block, BlockFace facing) {
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Torch) {
            Torch torchData = (Torch)data;
            torchData.setFacingDirection(facing);
            state.setData((MaterialData)torchData);
            state.update();
            return true;
        }
        return false;
    }

    @Override
    public boolean tame(Entity entity, Player tamer) {
        if (!(entity instanceof Tameable)) {
            return false;
        }
        Tameable tameable = (Tameable)entity;
        if (tameable.isTamed()) {
            return false;
        }
        tameable.setTamed(true);
        if (tamer != null) {
            tameable.setOwner((AnimalTamer)tamer);
        }
        return true;
    }

    @Override
    public boolean isArrow(Entity projectile) {
        return projectile instanceof Arrow || projectile instanceof TippedArrow || projectile instanceof SpectralArrow;
    }

    @Override
    public void setMaterialCooldown(Player player, Material material, int duration) {
    }

    @Override
    public FurnaceRecipe createFurnaceRecipe(String key, ItemStack item, ItemStack source, boolean ignoreDamage, float experience, int cookingTime) {
        return null;
    }

    @Override
    public Recipe createBlastingRecipe(String key, ItemStack item, ItemStack source, boolean ignoreDamage, float experience, int cookingTime) {
        return null;
    }

    @Override
    public Recipe createCampfireRecipe(String key, ItemStack item, ItemStack source, boolean ignoreDamage, float experience, int cookingTime) {
        return null;
    }

    @Override
    public Recipe createSmokingRecipe(String key, ItemStack item, ItemStack source, boolean ignoreDamage, float experience, int cookingTime) {
        return null;
    }

    @Override
    public Recipe createStonecuttingRecipe(String key, ItemStack item, ItemStack source, boolean ignoreDamage) {
        return null;
    }

    @Override
    public Recipe createSmithingRecipe(String key, ItemStack item, ItemStack source, ItemStack addition) {
        return null;
    }

    @Override
    public String convertParticle(String particle) {
        switch (particle.toLowerCase()) {
            case "dust_color_transition": {
                return "redstone";
            }
        }
        return particle;
    }
}

