/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class BridgeSpell
extends BrushSpell {
    private static final int MAX_SEARCH_DISTANCE = 16;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block attachBlock;
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(playerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockFace direction = this.getPlayerFacing();
        Block targetBlock = attachBlock = playerBlock;
        for (int distance = 0; this.isTargetable(targetBlock) && distance <= 16; ++distance) {
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(direction);
        }
        if (this.isTargetable(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getBrush();
        buildWith.setTarget(attachBlock.getLocation(), targetBlock.getLocation());
        buildWith.update(this.mage, targetBlock.getLocation());
        this.registerForUndo(targetBlock);
        buildWith.modify(targetBlock);
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

