/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.npc;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class MagicNPC
implements com.elmakers.mine.bukkit.api.npc.MagicNPC {
    private static final String DEFAULT_NPC_KEY = "base_npc";
    @Nonnull
    private final MagicController controller;
    @Nonnull
    private UUID id;
    @Nullable
    private Location location;
    @Nullable
    private String worldName;
    @Nonnull
    private EntityData entityData;
    @Nonnull
    private String mobKey;
    @Nonnull
    private String name;
    @Nonnull
    private UUID entityId;
    @Nullable
    private String templateKey;
    private long createdAt;
    private String creatorId;
    private String creatorName;
    private Integer importedId;
    @Nonnull
    private ConfigurationSection parameters;

    private MagicNPC(MagicController controller) {
        this.controller = controller;
    }

    public MagicNPC(MagicController controller, ConfigurationSection configuration) {
        this(controller);
        this.load(configuration);
    }

    public MagicNPC(MagicController controller, Mage creator, Location location, String name, EntityData template) {
        this(controller);
        this.setLocation(location);
        this.name = name;
        this.createdAt = System.currentTimeMillis();
        this.creatorId = creator.getId();
        this.creatorName = creator.getName();
        this.id = UUID.randomUUID();
        if (template != null) {
            if (this.name == null) {
                this.name = template.getName();
            }
            this.templateKey = template.getKey();
            this.mobKey = template.getKey();
        } else {
            this.templateKey = DEFAULT_NPC_KEY;
        }
        this.createEntityData();
        this.update();
    }

    public MagicNPC(MagicController controller, Mage creator, Location location, EntityData template) {
        this(controller, creator, location, null, template);
    }

    public MagicNPC(MagicController controller, Mage creator, Location location, String name) {
        this(controller, creator, location, name, null);
    }

    protected void load(ConfigurationSection configuration) {
        ConfigurationSection location;
        this.templateKey = configuration.getString("template", this.templateKey);
        if (this.templateKey == null) {
            this.templateKey = DEFAULT_NPC_KEY;
        }
        this.mobKey = configuration.getString("mob", this.mobKey);
        String idString = configuration.getString("id");
        this.id = idString != null && !idString.isEmpty() ? UUID.fromString(idString) : UUID.randomUUID();
        String uuidString = configuration.getString("entity_uuid", configuration.getString("uuid"));
        if (uuidString != null && !uuidString.isEmpty()) {
            this.entityId = UUID.fromString(uuidString);
        }
        this.name = configuration.getString("name", this.name);
        this.createdAt = configuration.getLong("created", this.createdAt);
        this.creatorId = configuration.getString("creator", this.creatorId);
        this.creatorName = configuration.getString("creator_name", this.creatorName);
        if (configuration.contains("imported_id")) {
            this.importedId = configuration.getInt("imported_id");
        }
        if ((location = ConfigurationUtils.getConfigurationSection(configuration, "location")) != null) {
            double x = location.getDouble("x");
            double y = location.getDouble("y");
            double z = location.getDouble("z");
            float yaw = (float)location.getDouble("yaw");
            float pitch = (float)location.getDouble("pitch");
            this.worldName = location.getString("world");
            if (this.worldName == null || this.worldName.isEmpty()) {
                this.worldName = "world";
                this.controller.getLogger().warning("NPC missing world name, defaulting to 'world'");
            }
            World world = Bukkit.getWorld((String)this.worldName);
            this.location = new Location(world, x, y, z, yaw, pitch);
        } else {
            this.location = null;
        }
        this.parameters = ConfigurationUtils.getConfigurationSection(configuration, "parameters");
        this.createEntityData();
    }

    protected void createEntityData() {
        EntityData entity;
        if (this.parameters == null) {
            this.parameters = ConfigurationUtils.newConfigurationSection();
        }
        boolean hasMobKey = this.mobKey != null && !this.mobKey.isEmpty();
        EntityData entityData = entity = hasMobKey ? this.controller.getMob(this.mobKey) : null;
        if (entity == null) {
            String defaultType;
            ConfigurationSection templateParameters = this.getTemplateParameters();
            String string = defaultType = templateParameters == null ? "villager" : templateParameters.getString("type", "villager");
            if (hasMobKey) {
                this.controller.getLogger().warning("NPC has unknown mob type: " + this.mobKey + ", will change to " + defaultType);
            }
            entity = this.controller.getMob(defaultType);
        }
        if (entity == null) {
            this.controller.getLogger().warning("NPC has unknown mob type: " + this.mobKey + ", and no deafult mob type was available. Defaulting to villager.");
            entity = new EntityData((MageController)this.controller, EntityType.VILLAGER);
        }
        this.setEntityData(entity);
    }

    @Nullable
    protected ConfigurationSection getTemplateParameters() {
        if (this.templateKey == null || this.templateKey.isEmpty()) {
            return null;
        }
        if (this.templateKey.equals(this.mobKey)) {
            return null;
        }
        EntityData entityData = this.controller.getMob(this.templateKey);
        return entityData == null ? null : entityData.getConfiguration();
    }

    protected boolean isLocationValid() {
        return this.location != null && this.location.getWorld() != null;
    }

    public boolean isValid() {
        return this.entityData != null && this.isLocationValid();
    }

    public long getBlockId() {
        return BlockData.getBlockId(this.getLocation());
    }

    @Override
    public boolean setType(@Nonnull String mobKey) {
        EntityData newEntityData = this.controller.getMob(mobKey);
        if (newEntityData == null) {
            return false;
        }
        this.setEntityData(newEntityData);
        this.mobKey = mobKey;
        this.remove();
        this.restore();
        return true;
    }

    @Override
    public boolean setTemplate(String templateKey) {
        EntityData newTemplate = this.controller.getMob(templateKey);
        if (newTemplate == null) {
            return false;
        }
        this.templateKey = templateKey;
        this.setType(this.mobKey);
        return true;
    }

    protected void setEntityData(EntityData templateData) {
        this.entityData = templateData.clone();
        this.configureEntityData();
    }

    protected void configureEntityData() {
        ConfigurationSection effectiveParameters = ConfigurationUtils.cloneConfiguration(this.entityData.getConfiguration());
        ConfigurationSection templateParameters = this.getTemplateParameters();
        if (templateParameters != null) {
            effectiveParameters = ConfigurationUtils.addConfigurations(effectiveParameters, templateParameters);
        }
        effectiveParameters = ConfigurationUtils.addConfigurations(effectiveParameters, this.parameters);
        effectiveParameters.set("type", (Object)this.entityData.getType().name());
        effectiveParameters.set("name", (Object)this.name);
        this.entityData.load(effectiveParameters);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.entityId == null ? null : CompatibilityLib.getCompatibilityUtils().getEntity(this.location.getWorld(), this.entityId);
    }

    @Override
    public boolean isEntity(Entity entity) {
        if (entity == null || this.entityId == null) {
            return false;
        }
        for (Entity vehicle = entity; vehicle != null; vehicle = vehicle.getVehicle()) {
            if (!vehicle.getUniqueId().equals(this.entityId)) continue;
            return true;
        }
        List<Entity> passengers = CompatibilityLib.getCompatibilityUtils().getPassengers(entity);
        while (!passengers.isEmpty()) {
            Entity passenger = passengers.get(0);
            if (passenger.getUniqueId().equals(this.entityId)) {
                return true;
            }
            passengers = CompatibilityLib.getCompatibilityUtils().getPassengers(passenger);
        }
        return false;
    }

    @Override
    public void teleport(@Nonnull Location location) {
        this.controller.unregisterNPC(this);
        this.setLocation(location);
        if (CompatibilityLib.getCompatibilityUtils().isChunkLoaded(location)) {
            this.restore();
        }
        this.controller.registerNPC(this);
    }

    public void setLocation(Location location) {
        this.location = location.clone();
        World world = this.location.getWorld();
        if (world != null) {
            this.worldName = world.getName();
        }
    }

    @Override
    @Nullable
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean isActive() {
        Entity entity = this.getEntity();
        return entity != null && entity.isValid();
    }

    @Override
    public void remove() {
        Entity entity = this.getEntity();
        if (entity != null) {
            entity.remove();
            this.entityData.onDeath(entity);
        }
    }

    @Override
    @Nullable
    public Entity respawn() {
        return this.restore();
    }

    @Nullable
    public Entity restore() {
        if (this.location == null || !CompatibilityLib.getCompatibilityUtils().isChunkLoaded(this.location)) {
            return null;
        }
        Entity entity = this.getEntity();
        if (entity == null || !entity.isValid()) {
            this.controller.setDisableSpawnReplacement(true);
            try {
                entity = this.entityData.spawn(this.location);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.SEVERE, "Unexpected error spawning NPC mob", ex);
            }
            this.controller.setDisableSpawnReplacement(false);
        } else {
            this.entityData.modify(entity);
            CompatibilityLib.getCompatibilityUtils().teleportWithVehicle(entity, this.location);
        }
        if (entity == null) {
            this.controller.getLogger().warning("Failed to restore NPC entity");
            return null;
        }
        for (Entity vehicle = entity; vehicle != null; vehicle = vehicle.getVehicle()) {
            CompatibilityLib.getEntityMetadataUtils().setString(vehicle, MagicMetaKeys.NPC_ID, this.id.toString());
        }
        if (this.entityData.useNPCName()) {
            entity.setCustomName(this.getName());
        }
        this.entityId = entity.getUniqueId();
        return entity;
    }

    public void save(ConfigurationSection configuration) {
        configuration.set("template", (Object)this.templateKey);
        configuration.set("id", (Object)this.id.toString());
        configuration.set("entity_uuid", (Object)this.entityId.toString());
        configuration.set("mob", (Object)this.mobKey);
        configuration.set("name", (Object)this.name);
        configuration.set("created", (Object)this.createdAt);
        configuration.set("creator", (Object)this.creatorId);
        configuration.set("creator_name", (Object)this.creatorName);
        configuration.set("imported_id", (Object)this.importedId);
        ConfigurationSection locationSection = configuration.createSection("location");
        locationSection.set("world", (Object)this.worldName);
        locationSection.set("x", (Object)this.location.getX());
        locationSection.set("y", (Object)this.location.getY());
        locationSection.set("z", (Object)this.location.getZ());
        locationSection.set("yaw", (Object)Float.valueOf(this.location.getYaw()));
        locationSection.set("pitch", (Object)Float.valueOf(this.location.getPitch()));
        configuration.set("parameters", (Object)this.parameters);
    }

    @Override
    @Nonnull
    public EntityData getEntityData() {
        return this.entityData;
    }

    @Override
    @Nonnull
    public String getName() {
        String name = this.name == null ? "" : this.name;
        return CompatibilityLib.getCompatibilityUtils().translateColors(name);
    }

    @Override
    public void setName(@Nonnull String name) {
        this.name = name;
        this.restore();
    }

    @Override
    @Nonnull
    public UUID getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public UUID getEntityId() {
        return this.entityId;
    }

    @Override
    @Nonnull
    @Deprecated
    public UUID getUUID() {
        return this.entityId;
    }

    @Override
    public void configure(String key, Object value) {
        value = ConfigurationUtils.convertProperty(value);
        this.parameters.set(key, value);
        if (this.entityData != null) {
            this.entityData.getConfiguration().set(key, value);
        }
        this.update();
    }

    @Override
    public void update() {
        EntityData newEntityData;
        boolean updated = false;
        if (this.mobKey != null && (newEntityData = this.controller.getMob(this.mobKey)) != null) {
            this.setEntityData(newEntityData);
            updated = true;
        }
        if (!updated) {
            this.configureEntityData();
        }
        this.restore();
    }

    @Override
    @Nonnull
    public ConfigurationSection getParameters() {
        return this.parameters;
    }

    @Override
    public void describe(CommandSender sender) {
        ConfigurationSection parameters;
        String mobTypeName = this.mobKey == null ? "Default Mob Type" : this.mobKey;
        sender.sendMessage(ChatColor.GOLD + this.name + ChatColor.DARK_GRAY + " (" + ChatColor.GRAY + mobTypeName + ChatColor.DARK_GRAY + ")");
        sender.sendMessage(ChatColor.AQUA + "Location: " + ChatColor.WHITE + TextUtils.printLocation(this.location));
        sender.sendMessage(ChatColor.AQUA + "Created By: " + ChatColor.WHITE + this.creatorName);
        ConfigurationSection templateParameters = this.getTemplateParameters();
        if (templateParameters != null) {
            parameters = ConfigurationUtils.cloneConfiguration(templateParameters);
            parameters = ConfigurationUtils.addConfigurations(parameters, this.parameters);
        } else {
            parameters = ConfigurationUtils.cloneConfiguration(this.parameters);
        }
        parameters.set("type", null);
        String interactSpell = parameters.getString("interact_spell");
        if (interactSpell != null && !interactSpell.isEmpty()) {
            SpellTemplate template = this.controller.getSpellTemplate(interactSpell);
            String spellName = template == null ? ChatColor.RED + interactSpell : ChatColor.YELLOW + template.getName();
            sender.sendMessage(ChatColor.AQUA + "Casts" + ChatColor.GRAY + ": " + spellName);
            parameters.set("interact_spell", null);
        }
        Set keys = parameters.getKeys(false);
        for (String key : keys) {
            Object value = parameters.get(key);
            if (value == null) continue;
            ChatColor propertyColor = ChatColor.GRAY;
            if (this.parameters.contains(key)) {
                propertyColor = ChatColor.DARK_AQUA;
            }
            sender.sendMessage(propertyColor.toString() + key + ChatColor.GRAY + ": " + ChatColor.WHITE + CompatibilityLib.getInventoryUtils().describeProperty(value, CompatibilityConstants.MAX_PROPERTY_DISPLAY_LENGTH));
        }
    }

    @Override
    @Nullable
    public Integer getImportedId() {
        return this.importedId;
    }

    public void setImportedId(int importedId) {
        this.importedId = importedId;
    }

    public boolean isStatic() {
        return this.entityData != null ? this.entityData.isStatic() : true;
    }
}

