/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.archyx.aureliumskills.api.AureliumAPI;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.Stats;
import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.ManaController;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class AureliumSkillsManager
implements ManaController,
AttributeProvider {
    private final MageController controller;
    private boolean useMana;
    private boolean enabled;
    private boolean useAttributes;
    private double manaScale;

    public AureliumSkillsManager(MageController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        String statusString;
        this.enabled = configuration.getBoolean("enabled", true);
        this.useMana = this.enabled && configuration.getBoolean("use_mana", true);
        this.useAttributes = this.enabled && configuration.getBoolean("use_attributes", true);
        this.manaScale = configuration.getDouble("mana_scale");
        if (this.manaScale <= 0.0) {
            this.controller.getLogger().info("Invalid mana scale in aurelium_sklls configuration: " + this.manaScale);
            this.manaScale = 1.0;
        }
        if (!this.useMana && !this.useAttributes) {
            statusString = " but integration is disabled in configs";
        } else {
            statusString = ", will integrate for ";
            if (this.useMana) {
                statusString = statusString + "mana";
                if (this.useAttributes) {
                    statusString = statusString + " and skill/stat attributes";
                }
            } else {
                statusString = statusString + "attributes";
            }
        }
        this.controller.getLogger().info("AureliumSkills found " + statusString);
    }

    public boolean useMana() {
        return this.useMana;
    }

    public boolean useAttributes() {
        return this.useAttributes;
    }

    @Override
    public int getMaxMana(Player player) {
        return (int)(this.manaScale * AureliumAPI.getMaxMana((Player)player));
    }

    @Override
    public int getManaRegen(Player player) {
        double regen = OptionL.getDouble((Option)Option.REGENERATION_BASE_MANA_REGEN) + AureliumAPI.getStatLevel((Player)player, (Stat)Stats.REGENERATION) * OptionL.getDouble((Option)Option.REGENERATION_MANA_MODIFIER);
        return (int)(this.manaScale * regen);
    }

    @Override
    public float getMana(Player player) {
        return (float)(this.manaScale * AureliumAPI.getMana((Player)player));
    }

    @Override
    public void removeMana(Player player, float amount) {
        AureliumAPI.setMana((Player)player, (double)(AureliumAPI.getMana((Player)player) - (double)amount / this.manaScale));
    }

    @Override
    public void setMana(Player player, float amount) {
        AureliumAPI.setMana((Player)player, (double)((double)amount / this.manaScale));
    }

    @Override
    public Set<String> getAllAttributes() {
        HashSet<String> stats = new HashSet<String>();
        for (Stats stats2 : Stats.values()) {
            stats.add(stats2.name());
        }
        for (Stats stats3 : Skills.values()) {
            stats.add(stats3.name());
        }
        return stats;
    }

    @Override
    @Nullable
    public Double getAttributeValue(String attribute, Player player) {
        try {
            Stats stat = Stats.valueOf((String)attribute);
            return AureliumAPI.getStatLevel((Player)player, (Stat)stat);
        }
        catch (Exception stat) {
            try {
                Skills skill = Skills.valueOf((String)attribute);
                return AureliumAPI.getSkillLevel((Player)player, (Skill)skill);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

