/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.VariableScope;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.PrerequisiteSpell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.configuration.MageParameters;
import com.elmakers.mine.bukkit.configuration.MagicConfiguration;
import com.elmakers.mine.bukkit.configuration.ParameterizedConfigurationSection;
import com.elmakers.mine.bukkit.configuration.SpellParameters;
import com.elmakers.mine.bukkit.configuration.TranslatingConfiguration;
import com.elmakers.mine.bukkit.configuration.TranslatingConfigurationSection;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ConfigurationUtils
extends ConfigUtils {
    @Nullable
    public static MaterialAndData getMaterialAndData(ConfigurationSection node, String path) {
        return ConfigurationUtils.getMaterialAndData(node, path, null);
    }

    @Nullable
    public static MaterialAndData getMaterialAndData(ConfigurationSection node, String path, MaterialAndData def) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toMaterialAndData(stringData);
    }

    @Nullable
    public static MaterialAndData getIconMaterialAndData(ConfigurationSection node, String path, boolean legacy, MaterialAndData def) {
        String stringData;
        if (legacy) {
            path = "legacy_" + path;
        }
        if ((stringData = node.getString(path)) == null) {
            return def;
        }
        return ConfigurationUtils.toMaterialAndData(stringData);
    }

    @Nullable
    public static MaterialAndData toMaterialAndData(Object o) {
        if (o instanceof MaterialAndData) {
            return (MaterialAndData)o;
        }
        if (o instanceof String) {
            String matName = (String)o;
            return new MaterialAndData(matName);
        }
        return null;
    }

    public static boolean loadAllTagsFromNBT(ConfigurationSection tags, Object tag) {
        return CompatibilityLib.getCompatibilityUtils().loadAllTagsFromNBT(tags, tag);
    }

    public static boolean loadAllTagsFromNBT(ConfigurationSection tags, ItemStack item) {
        if (item == null) {
            return false;
        }
        Object tag = CompatibilityLib.getItemUtils().getTag(item);
        if (tag == null) {
            return false;
        }
        return ConfigurationUtils.loadAllTagsFromNBT(tags, tag);
    }

    protected void combine(Map<Object, Object> to, Map<? extends Object, Object> from) {
        for (Map.Entry<? extends Object, Object> entry : from.entrySet()) {
            Object toValue;
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value instanceof Map && to.containsKey(key) && (toValue = to.get(key)) instanceof Map) {
                this.combine((Map)toValue, (Map)value);
                continue;
            }
            to.put(key, value);
        }
    }

    public static ConfigurationSection cloneEmptyConfiguration(ConfigurationSection section) {
        if (section instanceof SpellParameters) {
            return new SpellParameters((SpellParameters)section);
        }
        if (section instanceof MageParameters) {
            return new MageParameters((MageParameters)section);
        }
        if (section instanceof MagicConfiguration) {
            return new MagicConfiguration((MagicConfiguration)section);
        }
        if (section instanceof ParameterizedConfigurationSection) {
            return new ParameterizedConfigurationSection(section);
        }
        if (section instanceof TranslatingConfiguration) {
            return new TranslatingConfiguration();
        }
        if (section instanceof TranslatingConfigurationSection) {
            return new TranslatingConfigurationSection(section);
        }
        return ConfigurationUtils.newConfigurationSection();
    }

    public static ConfigurationSection cloneConfiguration(ConfigurationSection section) {
        ConfigurationSection copy = ConfigurationUtils.cloneEmptyConfiguration(section);
        return ConfigurationUtils.addConfigurations(copy, section);
    }

    private static Map<String, Object> replaceParameters(Map<String, Object> configuration, ConfigurationSection parameters) {
        if (configuration == null || configuration.isEmpty()) {
            return configuration;
        }
        HashMap<String, Object> replaced = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : configuration.entrySet()) {
            Object entryValue = entry.getValue();
            Object replacement = ConfigurationUtils.replaceParameters(entryValue, parameters);
            if (replacement == null) continue;
            replaced.put(entry.getKey(), replacement);
        }
        return replaced;
    }

    @Nullable
    private static Object replaceParameters(Object value, ConfigurationSection parameters) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            value = ConfigurationUtils.replaceParameters(map, parameters);
        } else if (value instanceof ConfigurationSection) {
            value = ConfigurationUtils.replaceParameters(value, parameters);
        } else if (value instanceof List) {
            List list = (List)value;
            value = ConfigurationUtils.replaceParameters(list, parameters);
        } else if (value instanceof String) {
            value = ConfigurationUtils.replaceParameter((String)value, parameters);
        }
        return value;
    }

    private static List<Object> replaceParameters(List<Object> configurations, ConfigurationSection parameters) {
        if (configurations == null || configurations.size() == 0) {
            return configurations;
        }
        ArrayList<Object> replaced = new ArrayList<Object>();
        for (Object value : configurations) {
            Object replacement = ConfigurationUtils.replaceParameters(value, parameters);
            if (replacement == null) continue;
            replaced.add(replacement);
        }
        return replaced;
    }

    @Nullable
    public static ConfigurationSection replaceParameters(ConfigurationSection configuration, ConfigurationSection parameters) {
        if (configuration == null) {
            return null;
        }
        ConfigurationSection replaced = ConfigurationUtils.newConfigurationSection();
        Map<String, Object> map = CompatibilityLib.getCompatibilityUtils().getMap(configuration);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object replacement;
            Object value = entry.getValue();
            if (value == null || (replacement = ConfigurationUtils.replaceParameters(value, parameters)) == null) continue;
            replaced.set(entry.getKey(), replacement);
        }
        return replaced;
    }

    private static Object replaceParameter(String value, ConfigurationSection parameters) {
        if (value.length() < 2 || value.charAt(0) != '$') {
            return value;
        }
        Object replaced = parameters.get(value.substring(1));
        return replaced == null ? value : replaced;
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second) {
        return ConfigurationUtils.addConfigurations(first, second, true);
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second, boolean override) {
        return ConfigurationUtils.addConfigurations(first, second, override, false, false);
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second, boolean override, boolean requireExisting) {
        return ConfigurationUtils.addConfigurations(first, second, override, requireExisting, false);
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second, boolean override, boolean requireExisting, boolean isUserConfig) {
        if (second == null) {
            return first;
        }
        override = override || second.getBoolean("override");
        Map<String, Object> map = CompatibilityLib.getCompatibilityUtils().getMap(second);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key;
            Object existingValue;
            Object value = entry.getValue();
            if (value == null || (existingValue = first.get(key = entry.getKey())) == null && requireExisting) continue;
            if (value instanceof Map) {
                value = ConfigurationUtils.getConfigurationSection(second, key);
            }
            if (existingValue instanceof Map) {
                existingValue = ConfigurationUtils.getConfigurationSection(first, key);
            }
            if (value instanceof ConfigurationSection && (existingValue == null || existingValue instanceof ConfigurationSection)) {
                boolean skipMerge;
                ConfigurationSection addChild = (ConfigurationSection)value;
                boolean bl = isUserConfig ? addChild.contains("inherit") : (skipMerge = addChild.isBoolean("inherit") && !addChild.getBoolean("inherit", true));
                if (existingValue == null || skipMerge) {
                    ConfigurationSection newChild = first.createSection(key);
                    ConfigurationUtils.addConfigurations(newChild, addChild, override);
                    continue;
                }
                ConfigurationUtils.addConfigurations((ConfigurationSection)existingValue, addChild, override);
                continue;
            }
            if (!override && existingValue != null) continue;
            first.set(key, value);
        }
        return first;
    }

    public static ConfigurationSection replaceConfigurations(ConfigurationSection first, ConfigurationSection second) {
        if (second == null) {
            return first;
        }
        Map<String, Object> map = CompatibilityLib.getCompatibilityUtils().getMap(second);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            first.set(entry.getKey(), entry.getValue());
        }
        return first;
    }

    public static ConfigurationSection overlayConfigurations(ConfigurationSection first, ConfigurationSection second) {
        return ConfigurationUtils.addConfigurations(first, second, false);
    }

    public static void addParameters(String[] extraParameters, ConfigurationSection parameters) {
        if (extraParameters != null) {
            for (int i = 0; i < extraParameters.length - 1; i += 2) {
                if (extraParameters[i] == null || extraParameters[i].isEmpty()) continue;
                ConfigurationUtils.set(parameters, extraParameters[i], extraParameters[i + 1]);
            }
        }
    }

    public static String getParameters(ConfigurationSection parameters) {
        ArrayList<String> parameterStrings = new ArrayList<String>();
        Map<String, Object> map = CompatibilityLib.getCompatibilityUtils().getMap(parameters);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            parameterStrings.add(entry.getKey());
            parameterStrings.add(entry.getValue().toString());
        }
        return StringUtils.join(parameterStrings, (char)' ');
    }

    public static SoundEffect toSoundEffect(String soundConfig) {
        return new SoundEffect(soundConfig);
    }

    @Nullable
    public static Particle toParticleEffect(String effectParticleName) {
        Particle effectParticle = null;
        if (effectParticleName.length() > 0) {
            String particleName = effectParticleName.toUpperCase();
            try {
                effectParticle = Particle.valueOf((String)particleName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return effectParticle;
    }

    public static Collection<String> getKeysOrList(@Nonnull ConfigurationSection node, @Nonnull String key) {
        ConfigurationSection spellSection;
        Collection<String> values = null;
        if (node.isString(key)) {
            values = ConfigurationUtils.getStringList(node, key);
        } else if (node.isConfigurationSection(key) && (spellSection = node.getConfigurationSection(key)) != null) {
            values = spellSection.getKeys(false);
        }
        if (values == null) {
            values = new ArrayList<String>(0);
        }
        return values;
    }

    public static Collection<PrerequisiteSpell> getPrerequisiteSpells(MageController controller, ConfigurationSection node, String key, String loadContext, boolean removeMissing) {
        if (node == null || key == null) {
            return new ArrayList<PrerequisiteSpell>(0);
        }
        Collection spells = null;
        if (node.isString(key)) {
            spells = ConfigurationUtils.getStringList(node, key);
        } else if (node.isConfigurationSection(key)) {
            ConfigurationSection spellSection = node.getConfigurationSection(key);
            if (spellSection != null) {
                spells = spellSection.getKeys(false);
            }
        } else {
            spells = node.getList(key);
        }
        if (spells == null) {
            spells = new ArrayList(0);
        }
        ArrayList<PrerequisiteSpell> requiredSpells = new ArrayList<PrerequisiteSpell>(spells.size());
        for (Object o : spells) {
            String spell;
            PrerequisiteSpell prerequisiteSpell = null;
            if (o instanceof String) {
                prerequisiteSpell = new PrerequisiteSpell(new SpellKey((String)o), 0L);
            } else if (o instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)o;
                spell = section.getString("spell");
                long progressLevel = section.getLong("progress_level");
                prerequisiteSpell = new PrerequisiteSpell(new SpellKey(spell), progressLevel);
            } else if (o instanceof Map) {
                String progressLevelString;
                Map map = (Map)o;
                spell = map.get("spell").toString();
                String string = progressLevelString = map.containsKey("progress_level") ? map.get("progress_level").toString() : "0";
                if (spell != null && StringUtils.isNumeric((String)progressLevelString)) {
                    long progressLevel = 0L;
                    try {
                        progressLevel = Long.parseLong(progressLevelString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    prerequisiteSpell = new PrerequisiteSpell(new SpellKey(spell), progressLevel);
                }
            }
            if (prerequisiteSpell == null) continue;
            if (controller.getSpellTemplate(prerequisiteSpell.getSpellKey().getKey()) != null) {
                requiredSpells.add(prerequisiteSpell);
                continue;
            }
            if (!removeMissing) {
                requiredSpells.add(prerequisiteSpell);
                controller.getLogger().warning("Unknown or disabled spell requirement " + prerequisiteSpell.getSpellKey().getKey() + " in " + loadContext + ", upgrade will be disabled");
                continue;
            }
            controller.info("Unknown or disabled spell prerequisite " + prerequisiteSpell.getSpellKey().getKey() + " in " + loadContext + ", ignoring", 5);
        }
        return requiredSpells;
    }

    @Nullable
    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parentConfig, String effectKey, int defaultDuration) {
        if (parentConfig.isConfigurationSection(effectKey)) {
            return ConfigurationUtils.getPotionEffects(parentConfig.getConfigurationSection(effectKey), null);
        }
        ArrayList<PotionEffect> effects = null;
        if (parentConfig.isList(effectKey)) {
            effects = new ArrayList<PotionEffect>();
            List effectList = parentConfig.getStringList(effectKey);
            for (String value : effectList) {
                String[] pieces = StringUtils.split((String)value, (String)"@");
                String key = pieces[0];
                try {
                    PotionEffectType effectType = PotionEffectType.getByName((String)key.toUpperCase());
                    int power = 1;
                    if (pieces.length > 1) {
                        power = (int)Float.parseFloat(pieces[1]);
                    }
                    PotionEffect effect = new PotionEffect(effectType, defaultDuration, power, true, true);
                    effects.add(effect);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().warning("Error parsing potion effect for " + key + ": " + value);
                }
            }
        }
        return effects;
    }

    @Nullable
    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig) {
        return ConfigurationUtils.getPotionEffects(effectConfig, null);
    }

    @Nullable
    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig, Integer duration) {
        return ConfigurationUtils.getPotionEffects(effectConfig, duration, true, true);
    }

    @Nullable
    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig, Integer duration, boolean ambient, boolean particles) {
        if (effectConfig == null) {
            return null;
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        Set keys = effectConfig.getKeys(false);
        if (keys.isEmpty()) {
            return null;
        }
        for (String key : keys) {
            String value = effectConfig.getString(key);
            try {
                PotionEffectType effectType = PotionEffectType.getByName((String)key.toUpperCase());
                int ticks = 10;
                int power = 1;
                if (value.contains(",")) {
                    String[] pieces = StringUtils.split((String)value, (char)',');
                    ticks = (int)Float.parseFloat(pieces[0]);
                    power = (int)Float.parseFloat(pieces[1]);
                } else {
                    power = (int)Float.parseFloat(value);
                    if (duration != null) {
                        ticks = duration / 50;
                    }
                }
                PotionEffect effect = new PotionEffect(effectType, ticks, power, ambient, particles);
                effects.add(effect);
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + key + ": " + value);
            }
        }
        return effects;
    }

    public static ConfigurationSection subtractConfiguration(ConfigurationSection base, ConfigurationSection subtract) {
        Set keys = subtract.getKeys(false);
        for (String key : keys) {
            Object subtractObject;
            Object baseObject = base.get(key);
            if (baseObject == null || (subtractObject = subtract.get(key)) == null) continue;
            if (subtractObject instanceof ConfigurationSection && baseObject instanceof ConfigurationSection) {
                ConfigurationSection baseConfig = (ConfigurationSection)baseObject;
                ConfigurationSection subtractConfig = (ConfigurationSection)subtractObject;
                if (!(baseConfig = ConfigurationUtils.subtractConfiguration(baseConfig, subtractConfig)).getKeys(false).isEmpty()) {
                    continue;
                }
            } else if (!subtractObject.equals(baseObject)) continue;
            base.set(key, null);
        }
        return base;
    }

    public static VariableScope parseScope(String scopeString, VariableScope defaultScope, Logger logger) {
        VariableScope scope = defaultScope;
        if (scopeString != null && !scopeString.isEmpty()) {
            try {
                scope = VariableScope.valueOf(scopeString.toUpperCase());
            }
            catch (Exception ex) {
                logger.warning("Invalid variable scope: " + scopeString);
            }
        }
        return scope;
    }

    @Nullable
    public static Object convertProperty(@Nullable Object value) {
        if (value == null) {
            return value;
        }
        Object result = value;
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            result = isTrue;
        } else {
            try {
                result = value instanceof Double ? (Double)value : (value instanceof Float ? (double)((Float)value).floatValue() : Double.parseDouble(value.toString()));
            }
            catch (Exception notADouble) {
                try {
                    result = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static String getIcon(ConfigurationSection node, boolean legacy) {
        return ConfigurationUtils.getIcon(node, legacy, "icon");
    }

    public static String getIcon(ConfigurationSection node, boolean legacy, String iconKey) {
        if (legacy) {
            return node.getString("legacy_" + iconKey, node.getString(iconKey));
        }
        return node.getString(iconKey);
    }

    public static boolean isEnabled(ConfigurationSection configuration) {
        if (configuration == null) {
            return false;
        }
        if (!configuration.getBoolean("enabled", true)) {
            return false;
        }
        String required = configuration.getString("requires");
        return required == null || required.isEmpty() || Bukkit.getPluginManager().getPlugin(required) != null;
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                ConfigurationUtils.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static ConfigurationSection newConfigurationSection() {
        return new TranslatingConfiguration();
    }

    @Nullable
    public static Set<Biome> loadBiomes(List<String> biomeNames, Logger logger, String logContext) {
        if (biomeNames == null || biomeNames.isEmpty()) {
            return null;
        }
        HashSet<Biome> set = new HashSet<Biome>();
        for (String biomeName : biomeNames) {
            try {
                Biome biome = Biome.valueOf((String)biomeName.trim().toUpperCase());
                set.add(biome);
            }
            catch (Exception ex) {
                logger.warning(" Invalid biome in " + logContext + ": " + biomeName);
            }
        }
        return set;
    }

    public static ConfigurationSection addSection(ConfigurationSection parent, String path, Map<?, ?> nodeMap) {
        ConfigurationSection newSection = ConfigurationUtils.toConfigurationSection(parent, path, nodeMap);
        parent.set(path, (Object)newSection);
        return newSection;
    }

    @Nullable
    public static Collection<Requirement> getRequirements(ConfigurationSection configuration) {
        ConfigurationSection singleConfiguration;
        ArrayList<Requirement> requirements = null;
        Collection<ConfigurationSection> requirementConfigurations = ConfigurationUtils.getNodeList(configuration, "requirements");
        if (requirementConfigurations != null) {
            requirements = new ArrayList<Requirement>();
            for (ConfigurationSection requirementConfiguration : requirementConfigurations) {
                requirements.add(new Requirement(requirementConfiguration));
            }
        }
        if ((singleConfiguration = ConfigurationUtils.getConfigurationSection(configuration, "requirement")) != null) {
            if (requirements == null) {
                requirements = new ArrayList();
            }
            requirements.add(new Requirement(singleConfiguration));
        }
        return requirements;
    }

    @Nullable
    public static Material toMaterial(Object o) {
        if (o instanceof Material) {
            return (Material)o;
        }
        if (o instanceof Integer) {
            return Material.values()[(Integer)o];
        }
        if (o instanceof String) {
            String matName = (String)o;
            try {
                int value = Integer.parseInt(matName);
                return CompatibilityLib.getCompatibilityUtils().getMaterial(value);
            }
            catch (NumberFormatException numberFormatException) {
                return Material.getMaterial((String)matName.toUpperCase());
            }
        }
        return null;
    }

    @Nullable
    public static Material getMaterial(ConfigurationSection node, String path, Material def) {
        String stringData = node.getString(path);
        if (stringData == null || stringData.isEmpty()) {
            return def;
        }
        return ConfigurationUtils.toMaterial(stringData);
    }

    @Nullable
    public static Material getMaterial(ConfigurationSection node, String path) {
        return ConfigurationUtils.getMaterial(node, path, null);
    }

    public static String fromMaterial(Material material) {
        if (material == null) {
            return "";
        }
        return material.name().toLowerCase();
    }
}

