/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.arena.AllStages;
import com.elmakers.mine.bukkit.arena.ArenaController;
import com.elmakers.mine.bukkit.arena.ArenaPlayer;
import com.elmakers.mine.bukkit.arena.ArenaPlayerComparator;
import com.elmakers.mine.bukkit.arena.ArenaStage;
import com.elmakers.mine.bukkit.arena.ArenaState;
import com.elmakers.mine.bukkit.arena.ArenaTemplate;
import com.elmakers.mine.bukkit.arena.EditingStage;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Sign;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public class Arena {
    private static final Random random = new Random();
    private static final Object saveLock = new Object();
    private ArenaTemplate template;
    private ArenaState state = ArenaState.LOBBY;
    private long started;
    private long lastTick;
    private long lastDeath;
    private Queue<ArenaPlayer> queue = new LinkedList<ArenaPlayer>();
    private Set<ArenaPlayer> players = new HashSet<ArenaPlayer>();
    private Set<ArenaPlayer> deadPlayers = new HashSet<ArenaPlayer>();
    private List<Location> spawns = new ArrayList<Location>();
    private List<ArenaStage> stages = new ArrayList<ArenaStage>();
    private final AllStages allStages;
    private int currentStage = 0;
    private int editingStage = 0;
    private boolean editAllStages = false;
    private final ArenaController controller;
    private Location center;
    private Location exit;
    private Location lose;
    private Location win;
    private Location lobby;
    private Vector randomizeSpawn;
    private int maxPlayers = 2;
    private int minPlayers = 2;
    private int requiredKills = 1;
    private int winXP = 0;
    private int loseXP = 0;
    private int drawXP = 0;
    private int winSP = 0;
    private int loseSP = 0;
    private int drawSP = 0;
    private int winMoney = 0;
    private int loseMoney = 0;
    private int drawMoney = 0;
    private int countdown = 10;
    private int countdownMax = 10;
    private int leaderboardSize = 5;
    private int leaderboardRecordSize = 30;
    private int leaderboardGamesRequired = 1;
    private int maxTeleportDistance = 64;
    private int announcerRange = 64;
    private boolean opCheck = true;
    private boolean allowInterrupt = false;
    private int duration = 0;
    private int suddenDeath = 0;
    private PotionEffect suddenDeathEffect = null;
    private String startCommands;
    private String endCommands;
    private int borderMin = 0;
    private int borderMax = 0;
    private List<ArenaPlayer> leaderboard = new ArrayList<ArenaPlayer>();
    private Location leaderboardLocation;
    private BlockFace leaderboardFacing;
    private Material signMaterial;
    private int portalDamage;
    private int portalEnterDamage;
    private String portalDeathMessage;
    private final String key;
    private String name;
    private String description;
    private boolean itemWear;
    private boolean keepInventory;
    private boolean keepLevel;
    private boolean allowConsuming = true;
    private boolean allowMelee = true;
    private boolean allowProjectiles = true;
    private BossBar respawnBar;

    public Arena(String key, ArenaTemplate template, ArenaController controller) {
        this.key = key;
        this.template = template;
        this.controller = controller;
        this.allStages = new AllStages(this);
        this.signMaterial = DefaultMaterials.getWallSignBlock();
    }

    public Arena(String name, ArenaTemplate template, ArenaController plugin, Location location) {
        this(name, template, plugin);
        this.center = location.clone();
    }

    public void loadProperties() {
        this.loadProperties(this.template.getConfiguration());
    }

    public void loadProperties(ConfigurationSection configuration) {
        this.name = configuration.getString("name", null);
        this.description = configuration.getString("description", null);
        this.setMinPlayers(configuration.getInt("min_players", 2));
        this.maxPlayers = configuration.getInt("max_players", 2);
        this.requiredKills = configuration.getInt("required_kills", 1);
        this.portalDamage = configuration.getInt("portal_damage", 0);
        this.portalEnterDamage = configuration.getInt("portal_enter_damage", 0);
        this.portalDeathMessage = configuration.getString("portal_death_message");
        this.leaderboardSize = configuration.getInt("leaderboard_size", 5);
        this.leaderboardRecordSize = configuration.getInt("leaderboard_record_size", 30);
        this.leaderboardGamesRequired = configuration.getInt("leaderboard_games_required", 1);
        this.maxTeleportDistance = configuration.getInt("max_teleport_distance", 64);
        this.announcerRange = configuration.getInt("announcer_range", 64);
        this.countdown = configuration.getInt("countdown", 10);
        this.countdownMax = configuration.getInt("countdown_max", 30);
        this.opCheck = configuration.getBoolean("op_check", true);
        this.allowInterrupt = configuration.getBoolean("allow_interrupt", false);
        this.startCommands = configuration.getString("start_commands");
        this.endCommands = configuration.getString("end_commands");
        this.borderMin = configuration.getInt("border_min");
        this.borderMax = configuration.getInt("border_max");
        this.itemWear = configuration.getBoolean("item_wear", true);
        this.keepInventory = configuration.getBoolean("keep_inventory", false);
        this.keepLevel = configuration.getBoolean("keep_level", false);
        this.allowConsuming = configuration.getBoolean("allow_consuming", true);
        this.allowMelee = configuration.getBoolean("allow_melee", true);
        this.allowProjectiles = configuration.getBoolean("allow_projectiles", true);
        this.lose = ConfigurationUtils.toLocation(configuration.getString("lose"), this.center);
        this.win = ConfigurationUtils.toLocation(configuration.getString("win"), this.center);
        this.lobby = ConfigurationUtils.toLocation(configuration.getString("lobby"), this.center);
        this.exit = ConfigurationUtils.toLocation(configuration.getString("exit"), this.center);
        String signType = configuration.getString("leaderboard_sign_type", "oak_wall_sign");
        try {
            this.signMaterial = Material.valueOf((String)signType.toUpperCase());
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Invalid sign type: " + signType);
        }
        this.winXP = configuration.getInt("win_xp", 0);
        this.loseXP = configuration.getInt("lose_xp", 0);
        this.drawXP = configuration.getInt("draw_xp", 0);
        this.winSP = configuration.getInt("win_sp", 0);
        this.loseSP = configuration.getInt("lose_sp", 0);
        this.drawSP = configuration.getInt("draw_sp", 0);
        this.winMoney = configuration.getInt("win_money", 0);
        this.loseMoney = configuration.getInt("lose_money", 0);
        this.drawMoney = configuration.getInt("draw_money", 0);
        this.duration = configuration.getInt("duration", 0);
        this.suddenDeath = configuration.getInt("sudden_death", 0);
        this.suddenDeathEffect = null;
        if (configuration.contains("sudden_death_effect")) {
            this.setSuddenDeathEffect(configuration.getString("sudden_death_effect"));
        }
        this.spawns.clear();
        for (String s : configuration.getStringList("spawns")) {
            this.spawns.add(ConfigurationUtils.toLocation(s, this.center));
        }
        if (configuration.contains("randomize.spawn")) {
            this.randomizeSpawn = ConfigurationUtils.toVector(configuration.getString("randomize.spawn"));
        }
        this.stages.clear();
        if (configuration.contains("stages")) {
            Collection<ConfigurationSection> stageConfigurations = ConfigurationUtils.getNodeList(configuration, "stages");
            for (ConfigurationSection stageConfiguration : stageConfigurations) {
                this.stages.add(new ArenaStage(this, this.stages.size(), this.controller.getMagic(), stageConfiguration));
            }
        }
        if (configuration.contains("leaderboard_sign_location") && configuration.contains("leaderboard_sign_facing")) {
            this.leaderboardLocation = ConfigurationUtils.toLocation(configuration.getString("leaderboard_sign_location"), this.center);
            this.leaderboardFacing = ConfigurationUtils.toBlockFace(configuration.getString("leaderboard_sign_facing"));
        }
    }

    public void load(ConfigurationSection configuration) {
        this.center = ConfigurationUtils.toLocation(configuration.getString("location"));
        if (configuration.contains("leaderboard")) {
            this.leaderboard.clear();
            ConfigurationSection leaders = configuration.getConfigurationSection("leaderboard");
            Set leaderboardKeys = leaders.getKeys(false);
            for (String key : leaderboardKeys) {
                ConfigurationSection leaderConfig = leaders.getConfigurationSection(key);
                ArenaPlayer loadedPlayer = new ArenaPlayer(this, leaderConfig);
                this.leaderboard.add(loadedPlayer);
            }
            Collections.sort(this.leaderboard, new ArenaPlayerComparator());
        }
        this.loadProperties();
    }

    public void reload() {
        this.template = this.controller.getTemplate(this.template.getKey());
        this.loadProperties();
    }

    public boolean setSuddenDeathEffect(String value) {
        if (value == null || value.isEmpty()) {
            this.suddenDeathEffect = null;
            return false;
        }
        int ticks = 100;
        int power = 1;
        try {
            String effectName;
            if (value.contains(":")) {
                String[] pieces = value.split(":");
                effectName = pieces[0];
                if (pieces.length > 1) {
                    power = (int)Float.parseFloat(pieces[1]);
                }
                if (pieces.length > 2) {
                    ticks = (int)Float.parseFloat(pieces[2]);
                }
            } else {
                effectName = value;
            }
            PotionEffectType effectType = PotionEffectType.getByName((String)effectName.toUpperCase());
            this.suddenDeathEffect = new PotionEffect(effectType, ticks, power, true);
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Error parsing potion effect: " + value);
            this.suddenDeathEffect = null;
        }
        return this.suddenDeathEffect != null;
    }

    public boolean saveTemplate(ConfigurationSection configuration) {
        if (!this.isValid()) {
            return false;
        }
        if (this.name != null && !this.name.isEmpty()) {
            configuration.set("name", (Object)this.name);
        }
        if (this.description != null && !this.description.isEmpty()) {
            configuration.set("description", (Object)this.description);
        }
        if (this.minPlayers != 2) {
            configuration.set("min_players", (Object)this.minPlayers);
        }
        if (this.maxPlayers != 2) {
            configuration.set("max_players", (Object)this.maxPlayers);
        }
        if (this.requiredKills != 1) {
            configuration.set("required_kills", (Object)this.requiredKills);
        }
        if (this.loseXP != 0) {
            configuration.set("lose_xp", (Object)this.loseXP);
        }
        if (this.drawXP != 0) {
            configuration.set("draw_xp", (Object)this.drawXP);
        }
        if (this.winXP != 0) {
            configuration.set("win_xp", (Object)this.winXP);
        }
        if (this.loseSP != 0) {
            configuration.set("lose_sp", (Object)this.loseSP);
        }
        if (this.drawSP != 0) {
            configuration.set("draw_sp", (Object)this.drawSP);
        }
        if (this.winSP != 0) {
            configuration.set("win_sp", (Object)this.winSP);
        }
        if (this.loseMoney != 0) {
            configuration.set("lose_money", (Object)this.loseMoney);
        }
        if (this.drawMoney != 0) {
            configuration.set("draw_money", (Object)this.drawMoney);
        }
        if (this.winMoney != 0) {
            configuration.set("win_money", (Object)this.winMoney);
        }
        if (this.duration != 0) {
            configuration.set("duration", (Object)this.duration);
        }
        if (this.suddenDeath != 0) {
            configuration.set("sudden_death", (Object)this.suddenDeath);
        }
        if (this.suddenDeathEffect != null) {
            configuration.set("sudden_death_effect", (Object)(this.suddenDeathEffect.getType().getName().toLowerCase() + ":" + this.suddenDeathEffect.getAmplifier() + ":" + this.suddenDeathEffect.getDuration()));
        }
        if (this.borderMin != 0) {
            configuration.set("border_min", (Object)this.borderMin);
        }
        if (this.borderMax != 0) {
            configuration.set("border_max", (Object)this.borderMax);
        }
        if (this.startCommands != null && !this.startCommands.isEmpty()) {
            configuration.set("start_commands", (Object)this.startCommands);
        }
        if (this.endCommands != null && !this.endCommands.isEmpty()) {
            configuration.set("end_commands", (Object)this.endCommands);
        }
        configuration.set("keep_inventory", (Object)this.keepInventory);
        configuration.set("keep_level", (Object)this.keepLevel);
        configuration.set("item_wear", (Object)this.itemWear);
        configuration.set("allow_consuming", (Object)this.allowConsuming);
        configuration.set("allow_melee", (Object)this.allowMelee);
        configuration.set("allow_projectiles", (Object)this.allowProjectiles);
        if (this.leaderboardSize != 5) {
            configuration.set("leaderboard_size", (Object)this.leaderboardSize);
        }
        if (this.leaderboardRecordSize != 30) {
            configuration.set("leaderboard_record_size", (Object)this.leaderboardRecordSize);
        }
        if (this.leaderboardGamesRequired != 1) {
            configuration.set("leaderboard_games_required", (Object)this.leaderboardGamesRequired);
        }
        configuration.set("leaderboard_sign_type", (Object)this.signMaterial.name().toLowerCase());
        if (this.portalDamage != 0) {
            configuration.set("portal_damage", (Object)this.portalDamage);
        }
        if (this.portalEnterDamage != 0) {
            configuration.set("portal_enter_damage", (Object)this.portalEnterDamage);
        }
        if (this.portalDeathMessage != null && !this.portalDeathMessage.isEmpty()) {
            configuration.set("portal_death_message", (Object)this.portalDeathMessage);
        }
        if (this.maxTeleportDistance != 64) {
            configuration.set("max_teleport_distance", (Object)this.maxTeleportDistance);
        }
        if (this.announcerRange != 64) {
            configuration.set("announcer_range", (Object)this.announcerRange);
        }
        if (this.countdown != 10) {
            configuration.set("countdown", (Object)this.countdown);
        }
        if (this.countdownMax != 30) {
            configuration.set("countdown_max", (Object)this.countdownMax);
        }
        configuration.set("op_check", (Object)this.opCheck);
        if (this.allowInterrupt) {
            configuration.set("allow_interrupt", (Object)this.allowInterrupt);
        }
        configuration.set("lobby", (Object)ConfigurationUtils.fromLocation(this.lobby, this.center));
        configuration.set("win", (Object)ConfigurationUtils.fromLocation(this.win, this.center));
        configuration.set("lose", (Object)ConfigurationUtils.fromLocation(this.lose, this.center));
        configuration.set("exit", (Object)ConfigurationUtils.fromLocation(this.exit, this.center));
        ArrayList<String> spawnList = new ArrayList<String>();
        for (Location spawn : this.spawns) {
            spawnList.add(ConfigurationUtils.fromLocation(spawn, this.center));
        }
        configuration.set("spawns", spawnList);
        if (!this.stages.isEmpty()) {
            ArrayList<MemoryConfiguration> stageConfigurations = new ArrayList<MemoryConfiguration>();
            for (ArenaStage stage : this.stages) {
                MemoryConfiguration section = new MemoryConfiguration();
                stage.save((ConfigurationSection)section);
                stageConfigurations.add(section);
            }
            configuration.set("stages", stageConfigurations);
        }
        if (this.randomizeSpawn != null) {
            configuration.set("randomize.spawn", (Object)ConfigurationUtils.fromVector(this.randomizeSpawn));
        }
        if (this.leaderboardLocation != null && this.leaderboardFacing != null) {
            configuration.set("leaderboard_sign_location", (Object)ConfigurationUtils.fromLocation(this.leaderboardLocation, this.center));
            configuration.set("leaderboard_sign_facing", (Object)ConfigurationUtils.fromBlockFace(this.leaderboardFacing));
        }
        return true;
    }

    public void saveTemplate() {
        final Plugin plugin = this.controller.getPlugin();
        final File arenaSaveFile = this.getSaveFile();
        final YamlConfiguration arenaSaves = new YamlConfiguration();
        ConfigurationSection arenaConfig = arenaSaves.createSection(this.key);
        if (!this.saveTemplate(arenaConfig)) {
            plugin.getLogger().warning("Not saving invalid arena: " + this.key);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = saveLock;
                synchronized (object) {
                    try {
                        arenaSaves.save(arenaSaveFile);
                    }
                    catch (Exception ex) {
                        plugin.getLogger().warning("Error saving arena configuration to " + arenaSaveFile.getName());
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    protected File getSaveFile() {
        return new File(this.controller.getPlugin().getDataFolder(), "arenas/" + this.key + ".yml");
    }

    public void save(ConfigurationSection configuration) {
        if (!this.isValid()) {
            return;
        }
        if (this.leaderboard.size() > 0) {
            ConfigurationSection leaders = configuration.createSection("leaderboard");
            for (ArenaPlayer player : this.leaderboard) {
                String key = player.getUUID().toString();
                ConfigurationSection playerData = leaders.createSection(key);
                player.save(playerData);
            }
        }
        configuration.set("location", (Object)ConfigurationUtils.fromLocation(this.center));
        configuration.set("template", (Object)this.template.getKey());
    }

    public void respawn() {
        this.spawnPlayers(new ArrayList<ArenaPlayer>(this.deadPlayers));
        for (ArenaPlayer dead : this.deadPlayers) {
            if (!dead.isValid() || dead.isDead()) continue;
            this.players.add(dead);
        }
        this.deadPlayers.clear();
        this.hideRespawnBossBar();
    }

    protected void runCommands(String runCommands) {
        if (runCommands != null && !runCommands.isEmpty()) {
            String[] commands = StringUtils.split((String)runCommands, (char)';');
            ConsoleCommandSender sender = Bukkit.getConsoleSender();
            for (String command : commands) {
                this.controller.getPlugin().getServer().dispatchCommand((CommandSender)sender, command);
            }
        }
    }

    public void start() {
        if (!this.isValid()) {
            return;
        }
        this.state = ArenaState.ACTIVE;
        this.lastTick = this.started = System.currentTimeMillis();
        this.currentStage = 0;
        for (ArenaStage stage : this.stages) {
            stage.reset();
        }
        this.runCommands(this.startCommands);
        if (this.borderMax > 0 && this.duration > 0) {
            World world = this.getCenter().getWorld();
            WorldBorder border = world.getWorldBorder();
            border.setSize((double)this.borderMax);
            border.setSize((double)this.borderMin, (long)(this.duration / 1000));
        }
        while (this.queue.size() > 0 && this.players.size() < this.maxPlayers) {
            ArenaPlayer queuedPlayer = this.queue.remove();
            if (!queuedPlayer.isValid() || queuedPlayer.isDead()) continue;
            this.players.add(queuedPlayer);
        }
        if (this.players.size() < this.minPlayers) {
            this.queue.addAll(this.players);
            this.players.clear();
            this.state = ArenaState.LOBBY;
            this.messagePlayers(ChatColor.RED + " the match did not have enough players to start.");
            return;
        }
        this.spawnPlayers(new ArrayList<ArenaPlayer>(this.players));
        ArenaStage currentStage = this.getCurrentStage();
        if (currentStage != null) {
            currentStage.start();
        }
        this.messageNextRoundPlayerList(ChatColor.GOLD + "You are up for the next round!");
    }

    protected List<Location> getRandomSpawns() {
        List<Location> spawns = this.getSpawns();
        Collections.shuffle(spawns);
        return spawns;
    }

    protected void spawnPlayers(Collection<ArenaPlayer> players, List<Location> spawns) {
        int num = 0;
        for (ArenaPlayer arenaPlayer : players) {
            if (!arenaPlayer.isValid() || arenaPlayer.isDead()) continue;
            arenaPlayer.heal();
            arenaPlayer.sendMessage("t:" + ChatColor.GOLD + "GO!");
            Location spawn = spawns.get(num);
            if (this.randomizeSpawn != null) {
                spawn = spawn.clone();
                spawn.add((2.0 * random.nextDouble() - 1.0) * this.randomizeSpawn.getX(), (2.0 * random.nextDouble() - 1.0) * this.randomizeSpawn.getY(), (2.0 * random.nextDouble() - 1.0) * this.randomizeSpawn.getZ());
            }
            num = (num + 1) % spawns.size();
            arenaPlayer.teleport(spawn);
        }
    }

    protected void spawnPlayers(Collection<ArenaPlayer> players) {
        this.spawnPlayers(players, this.getRandomSpawns());
    }

    protected void spawnPlayer(ArenaPlayer player) {
        ArrayList<ArenaPlayer> playerList = new ArrayList<ArenaPlayer>();
        playerList.add(player);
        this.spawnPlayers(playerList, this.getRandomSpawns());
    }

    protected void messageNextRoundPlayerList(String message) {
        Collection<ArenaPlayer> nextUpPlayers = this.getNextRoundPlayers();
        for (ArenaPlayer messagePlayer : nextUpPlayers) {
            Player player = messagePlayer.getPlayer();
            if (player == null) continue;
            String messagePlayerName = messagePlayer.getNameAndPath();
            player.sendMessage(message);
            for (ArenaPlayer otherArenaPlayer : nextUpPlayers) {
                String otherPlayerName = otherArenaPlayer.getNameAndPath();
                if (otherPlayerName.equals(messagePlayerName)) continue;
                int winCount = otherArenaPlayer.getWins();
                int lostCount = otherArenaPlayer.getLosses();
                player.sendMessage(ChatColor.YELLOW + " with " + ChatColor.DARK_AQUA + otherPlayerName + ChatColor.WHITE + " (" + ChatColor.GREEN + winCount + "W" + ChatColor.WHITE + " / " + ChatColor.RED + lostCount + "L" + ChatColor.WHITE + ")");
            }
        }
    }

    public void remove(Player player) {
        ArenaPlayer removePlayer = new ArenaPlayer(this, player);
        this.players.remove(removePlayer);
        this.deadPlayers.remove(removePlayer);
        this.queue.remove(removePlayer);
        this.controller.unregister(player);
        if (this.respawnBar != null) {
            this.respawnBar.removePlayer(player);
        }
    }

    public void remove() {
        this.messagePlayers(ChatColor.RED + "This arena has been removed");
        this.stop();
        this.clearQueue();
    }

    public void delete() {
        this.remove();
        File configFile = this.getSaveFile();
        if (!configFile.exists()) {
            this.controller.getPlugin().getLogger().warning("Can not remove arena " + this.key + ", if it exists in a combined config file you will need to remove it manually");
            return;
        }
        if (!configFile.delete()) {
            this.controller.getPlugin().getLogger().warning("Failed to delete file " + configFile.getAbsolutePath());
        }
    }

    public ArenaPlayer getWinner() {
        if (this.players.size() == 1) {
            ArenaPlayer winner = this.players.iterator().next();
            return winner;
        }
        return null;
    }

    public Location getLobby() {
        return this.lobby == null ? this.center : this.lobby;
    }

    public Location getLoseLocation() {
        return this.lose == null ? this.center : this.lose;
    }

    public Location getWinLocation() {
        return this.win == null ? this.center : this.win;
    }

    public Location getCenter() {
        return this.center;
    }

    public Location getExit() {
        return this.exit == null ? this.center : this.exit;
    }

    public boolean isReady() {
        return this.state == ArenaState.LOBBY && this.queue.size() >= this.minPlayers;
    }

    public void lobbyMessage() {
        int playerCount = this.queue.size();
        if (playerCount < this.minPlayers) {
            int playersRemaining = this.minPlayers - playerCount;
            String playerDescription = playersRemaining == 1 ? "1 more player" : playersRemaining + " more players";
            this.messageNextRoundPlayers(ChatColor.AQUA + "Waiting for " + playerDescription);
        }
    }

    public void announce(String message) {
        int rangeSquared = this.announcerRange * this.announcerRange;
        Collection players = this.controller.getPlugin().getServer().getOnlinePlayers();
        for (Player player : players) {
            Location playerLocation = player.getLocation();
            if (!playerLocation.getWorld().equals(this.center.getWorld()) || !(playerLocation.distanceSquared(this.center) < (double)rangeSquared)) continue;
            player.sendMessage(message);
        }
    }

    protected void messagePlayers(String message, Collection<ArenaPlayer> players) {
        for (ArenaPlayer arenaPlayer : players) {
            arenaPlayer.sendMessage(message);
        }
    }

    public void messagePlayers(String message) {
        this.messagePlayers(message, this.getAllPlayers());
    }

    public void messageInGamePlayers(String message) {
        this.messagePlayers(message, this.players);
    }

    public void messageDeadPlayers(String message) {
        this.messagePlayers(message, this.deadPlayers);
    }

    public void messageNextRoundPlayers(String message) {
        this.messagePlayers(message, this.getNextRoundPlayers());
    }

    public void startCountdown() {
        this.startCountdown(this.countdown);
    }

    public void startCountdown(int time) {
        if (this.state != ArenaState.LOBBY) {
            return;
        }
        this.state = ArenaState.COUNTDOWN;
        this.messageNextRoundPlayerList(ChatColor.YELLOW + "A round of " + this.getName() + " is about to start!");
        this.countdown(time);
    }

    private void countdown(final int time) {
        if (this.state != ArenaState.COUNTDOWN) {
            return;
        }
        if (time <= 0) {
            this.start();
            return;
        }
        if (time % 10 == 0) {
            this.messageNextRoundPlayers("t:" + ChatColor.DARK_AQUA + "Starting In\n " + ChatColor.AQUA + Integer.toString(time) + ChatColor.DARK_AQUA + " seconds");
        } else if (time <= 5) {
            this.messageNextRoundPlayers("t:" + ChatColor.AQUA + Integer.toString(time));
        }
        BukkitScheduler scheduler = this.controller.getPlugin().getServer().getScheduler();
        scheduler.runTaskLater(this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                Arena.this.countdown(time - 1);
            }
        }, 20L);
    }

    public boolean stop() {
        if (this.state == ArenaState.LOBBY) {
            return false;
        }
        this.messageInGamePlayers(ChatColor.DARK_RED + "This match has been cancelled!");
        this.finish();
        return true;
    }

    protected void finish() {
        ArenaStage currentStage = this.getCurrentStage();
        if (currentStage != null) {
            currentStage.finish();
        }
        this.runCommands(this.endCommands);
        this.state = ArenaState.LOBBY;
        this.exitPlayers();
        this.hideRespawnBossBar();
        this.clearPlayers();
        this.checkStart();
    }

    protected Collection<ArenaPlayer> getParticipants() {
        ArenaStage stage = this.getCurrentStage();
        if (stage == null || !stage.isRespawnEnabled() || this.deadPlayers.isEmpty()) {
            return this.players;
        }
        ArrayList<ArenaPlayer> participants = new ArrayList<ArenaPlayer>(this.players);
        participants.addAll(this.deadPlayers);
        return participants;
    }

    protected void exitPlayers() {
        for (ArenaPlayer arenaPlayer : this.getParticipants()) {
            arenaPlayer.teleport(this.getExit());
        }
    }

    protected void clearPlayers() {
        Player player;
        for (ArenaPlayer arenaPlayer : this.players) {
            player = arenaPlayer.getPlayer();
            if (player == null) continue;
            this.controller.unregister(player);
        }
        for (ArenaPlayer arenaPlayer : this.deadPlayers) {
            player = arenaPlayer.getPlayer();
            if (player == null) continue;
            this.controller.unregister(player);
        }
        this.players.clear();
        this.deadPlayers.clear();
    }

    protected void clearQueue() {
        for (ArenaPlayer arenaPlayer : this.queue) {
            Player player = arenaPlayer.getPlayer();
            if (player == null) continue;
            Location exit = this.getExit();
            if (exit != null) {
                arenaPlayer.teleport(this.getExit());
            }
            this.controller.unregister(player);
        }
        this.queue.clear();
    }

    public boolean isStarted() {
        return this.state == ArenaState.ACTIVE || this.state == ArenaState.WON;
    }

    public boolean isFull() {
        return this.queue.size() >= this.maxPlayers;
    }

    public boolean isPlayersFull() {
        return this.players.size() + this.deadPlayers.size() >= this.maxPlayers;
    }

    public ArenaPlayer add(Player player) {
        ArenaPlayer arenaPlayer = new ArenaPlayer(this, player);
        this.queue.add(arenaPlayer);
        arenaPlayer.teleport(this.getLobby());
        this.controller.register(player, arenaPlayer);
        return arenaPlayer;
    }

    public ArenaPlayer interrupt(Player player) {
        ArenaPlayer arenaPlayer = new ArenaPlayer(this, player);
        if (!arenaPlayer.isValid() || arenaPlayer.isDead()) {
            return arenaPlayer;
        }
        ArenaStage stage = this.getCurrentStage();
        if (stage != null && stage.isRespawning()) {
            this.deadPlayers.add(arenaPlayer);
            arenaPlayer.teleport(this.getLobby());
        } else {
            this.players.add(arenaPlayer);
            this.spawnPlayer(arenaPlayer);
        }
        this.controller.register(player, arenaPlayer);
        return arenaPlayer;
    }

    public void setLoseLocation(Location location) {
        this.lose = location == null ? null : location.clone();
    }

    public void setExit(Location location) {
        this.exit = location == null ? null : location.clone();
    }

    public void setCenter(Location location) {
        this.center = location.clone();
    }

    public void setLobby(Location location) {
        this.lobby = location == null ? null : location.clone();
    }

    public void setWinLocation(Location location) {
        this.win = location == null ? null : location.clone();
    }

    public void addSpawn(Location location) {
        this.spawns.add(location.clone());
    }

    public void setSpawn(Location location) {
        this.spawns.clear();
        if (location != null) {
            this.addSpawn(location);
        }
    }

    public Location removeSpawn(Location location) {
        int rangeSquared = 9;
        for (Location spawn : this.spawns) {
            if (!(spawn.distanceSquared(location) < (double)rangeSquared)) continue;
            this.spawns.remove(spawn);
            return spawn;
        }
        return null;
    }

    public List<Location> getSpawns() {
        if (this.spawns.size() == 0) {
            ArrayList<Location> centerList = new ArrayList<Location>();
            centerList.add(this.center);
            return centerList;
        }
        return this.spawns;
    }

    public ArenaStage getCurrentStage() {
        if (this.stages.isEmpty()) {
            return null;
        }
        if (this.currentStage >= this.stages.size() - 1) {
            return this.stages.get(this.stages.size() - 1);
        }
        if (this.currentStage >= 0) {
            return this.stages.get(this.currentStage);
        }
        return null;
    }

    public boolean nextStage() {
        if (this.stages.isEmpty()) {
            return false;
        }
        if (this.currentStage >= this.stages.size() - 1) {
            return false;
        }
        ++this.currentStage;
        ArenaStage currentStage = this.getCurrentStage();
        if (currentStage != null) {
            currentStage.start();
        }
        return currentStage != null;
    }

    public void addStage() {
        this.stages.add(new ArenaStage(this, this.stages.size()));
        this.editingStage = this.stages.size() - 1;
    }

    public void addStageBeforeCurrent() {
        this.stages.add(this.editingStage, new ArenaStage(this, this.stages.size()));
        this.reindexStages();
    }

    public void addStageAfterCurrent() {
        ++this.editingStage;
        this.stages.add(this.editingStage, new ArenaStage(this, this.stages.size()));
        this.reindexStages();
    }

    public void moveCurrentStage(int newIndex) {
        ArenaStage moveStage = this.stages.remove(this.editingStage);
        this.editingStage = newIndex;
        this.stages.add(this.editingStage, moveStage);
        this.reindexStages();
    }

    public void removeStage() {
        if (this.stages.size() <= 1) {
            return;
        }
        if (this.editingStage < 0 || this.editingStage >= this.stages.size()) {
            return;
        }
        this.stages.remove(this.editingStage);
        this.editingStage = 0;
        this.reindexStages();
    }

    public void reindexStages() {
        for (int i = 0; i < this.stages.size(); ++i) {
            this.stages.get(i).setIndex(i);
        }
    }

    public EditingStage getEditingStage() {
        if (this.editAllStages) {
            return this.allStages;
        }
        return this.stages.get(this.getEditingStageIndex());
    }

    public EditingStage getIfEditingStage() {
        if (this.editAllStages) {
            return this.allStages;
        }
        if (this.editingStage < 0 || this.editingStage >= this.stages.size()) {
            return null;
        }
        return this.stages.get(this.editingStage);
    }

    public void setEditingStage(int stage) {
        this.editingStage = stage;
        this.editAllStages = false;
    }

    public int getEditingStageIndex() {
        if (this.stages.isEmpty()) {
            this.stages.add(new ArenaStage(this, 0));
            this.editingStage = 0;
        }
        if (this.editingStage < 0 || this.editingStage >= this.stages.size()) {
            this.editingStage = 0;
        }
        return this.editingStage;
    }

    public int getStageCount() {
        return this.stages.size();
    }

    public void setMinPlayers(int players) {
        this.minPlayers = Math.max(1, players);
    }

    public void setMaxPlayers(int players) {
        this.maxPlayers = players;
    }

    public void setRandomizeSpawn(Vector vector) {
        this.randomizeSpawn = vector;
    }

    public void check() {
        if (this.state == ArenaState.COUNTDOWN) {
            if (!this.isReady()) {
                this.messagePlayers(ChatColor.RED + " Countdown cancelled");
                this.state = ArenaState.LOBBY;
                this.checkStart();
            }
            return;
        }
        if (this.state == ArenaState.LOBBY) {
            return;
        }
        Server server = this.controller.getPlugin().getServer();
        if (this.players.size() == 0 && this.state != ArenaState.WON) {
            if (this.isMobArena()) {
                for (ArenaPlayer loser : this.deadPlayers) {
                    loser.lost();
                    this.updateLeaderboard(loser);
                }
                this.announce(ChatColor.RED + "The " + ChatColor.YELLOW + this.getName() + ChatColor.RED + " match has ended, better luck next time!");
            } else {
                this.announce(ChatColor.RED + "The " + ChatColor.YELLOW + this.getName() + ChatColor.RED + " match ended in a default");
            }
            this.exitPlayers();
            this.finish();
            return;
        }
        if (this.state != ArenaState.WON && this.isMobArena()) {
            ArenaStage currentStage = this.getCurrentStage();
            if (currentStage == null || currentStage.isFinished()) {
                if (currentStage != null) {
                    currentStage.completed();
                }
                if (!this.nextStage()) {
                    this.state = ArenaState.WON;
                    server.getScheduler().runTaskLater(this.controller.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            for (ArenaPlayer winner : Arena.this.getParticipants()) {
                                if (winner == null) continue;
                                Arena.this.playerWon(winner);
                                winner.heal();
                            }
                            Arena.this.finish();
                        }
                    }, 100L);
                }
            }
        } else if (this.players.size() == 1 && this.state != ArenaState.WON) {
            this.state = ArenaState.WON;
            server.getScheduler().runTaskLater(this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    boolean won;
                    ArenaPlayer winner = Arena.this.getWinner();
                    boolean defaulted = Arena.this.deadPlayers.size() < Arena.this.requiredKills;
                    boolean bl = won = winner != null && winner.isValid() && !winner.isDead();
                    if (defaulted) {
                        if (winner != null) {
                            winner.teleport(Arena.this.getExit());
                        }
                        Arena.this.announce(ChatColor.RED + "The " + ChatColor.YELLOW + Arena.this.getName() + ChatColor.RED + " match ended in a default");
                    } else if (won) {
                        Arena.this.playerWon(winner);
                    } else {
                        if (winner != null) {
                            winner.draw();
                        }
                        for (ArenaPlayer loser : Arena.this.deadPlayers) {
                            loser.draw();
                        }
                        Arena.this.announce(ChatColor.GRAY + "The " + ChatColor.YELLOW + Arena.this.getName() + ChatColor.GRAY + " match ended in a draw");
                    }
                    if (winner != null) {
                        winner.heal();
                    }
                    Arena.this.finish();
                }
            }, 100L);
        }
    }

    protected void playerWon(ArenaPlayer winner) {
        winner.won();
        this.updateLeaderboard(winner);
        for (ArenaPlayer loser : this.deadPlayers) {
            loser.lost();
            this.updateLeaderboard(loser);
        }
        this.updateLeaderboard();
        winner.sendMessage("t:" + ChatColor.AQUA + "WINNER!");
        winner.sendMessage(ChatColor.AQUA + "You have won! Congratulations!");
        int winCount = winner.getWins();
        int lostCount = winner.getLosses();
        double health = winner.getHealth() / 2.0;
        int hearts = (int)Math.floor(health);
        String heartDescription = Integer.toString(hearts);
        health -= (double)hearts;
        if (health >= 0.5) {
            heartDescription = heartDescription + " 1/2";
        }
        this.announce(ChatColor.GOLD + winner.getNameAndPath() + " is the champion of " + ChatColor.YELLOW + this.getName());
        this.announce(ChatColor.GOLD + " with " + ChatColor.DARK_RED + heartDescription + ChatColor.GOLD + " hearts, and a total of " + ChatColor.GREEN + Integer.toString(winCount) + ChatColor.GOLD + " wins and " + ChatColor.RED + Integer.toString(lostCount) + ChatColor.GOLD + " losses.");
        winner.teleport(this.getWinLocation());
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getName() {
        return this.name == null ? this.key : this.name;
    }

    public String getKey() {
        return this.key;
    }

    public void join(Player player) {
        Arena currentArena = this.controller.getQueuedArena(player);
        if (currentArena != null) {
            if (currentArena == this) {
                player.sendMessage(ChatColor.RED + "You are already in " + ChatColor.AQUA + currentArena.getName());
                return;
            }
            this.controller.leave(player);
        }
        boolean queue = true;
        boolean started = this.isStarted();
        if (started && this.allowInterrupt && !this.isPlayersFull()) {
            queue = false;
            player.sendMessage(ChatColor.YELLOW + "You have entered the current round of " + ChatColor.AQUA + this.getName());
        } else if (this.isFull()) {
            player.sendMessage(ChatColor.GOLD + "You have joined the queue for " + ChatColor.AQUA + this.getName());
        } else {
            player.sendMessage(ChatColor.GOLD + "You have joined the queue for the next round of " + ChatColor.AQUA + this.getName());
        }
        if (this.description != null) {
            player.sendMessage(ChatColor.LIGHT_PURPLE + this.getDescription());
        }
        ArenaPlayer arenaPlayer = queue ? this.add(player) : this.interrupt(player);
        int winCount = arenaPlayer.getWins();
        int lostCount = arenaPlayer.getLosses();
        int joinedCount = arenaPlayer.getJoins();
        arenaPlayer.joined();
        if (winCount == 0 && lostCount == 0 && joinedCount == 0) {
            this.announce(ChatColor.AQUA + arenaPlayer.getNameAndPath() + ChatColor.DARK_AQUA + " has joined " + ChatColor.AQUA + this.getName() + ChatColor.DARK_AQUA + " for the first time");
        } else {
            this.announce(ChatColor.AQUA + arenaPlayer.getNameAndPath() + ChatColor.DARK_AQUA + " has joined " + ChatColor.AQUA + this.getName() + ChatColor.DARK_AQUA + " with " + ChatColor.GREEN + Integer.toString(winCount) + ChatColor.DARK_AQUA + " wins and " + ChatColor.RED + Integer.toString(lostCount) + ChatColor.DARK_AQUA + " losses.");
        }
        this.checkStart();
    }

    protected void checkStart() {
        if (this.isStarted()) {
            return;
        }
        if (this.isReady()) {
            if (this.isFull()) {
                this.startCountdown(this.countdown);
            } else {
                this.startCountdown(this.countdownMax);
            }
        } else {
            this.lobbyMessage();
        }
    }

    protected Collection<ArenaPlayer> getAllPlayers() {
        ArrayList<ArenaPlayer> allPlayers = new ArrayList<ArenaPlayer>(this.players);
        allPlayers.addAll(this.queue);
        allPlayers.addAll(this.deadPlayers);
        return allPlayers;
    }

    protected Collection<ArenaPlayer> getNextRoundPlayers() {
        ArrayList<ArenaPlayer> allPlayers = new ArrayList<ArenaPlayer>();
        for (ArenaPlayer queuedPlayer : this.queue) {
            if (allPlayers.size() >= this.maxPlayers) break;
            allPlayers.add(queuedPlayer);
        }
        return allPlayers;
    }

    public void describe(CommandSender sender) {
        ArenaStage currentStage;
        int spawnSize;
        if (this.name == null) {
            sender.sendMessage(ChatColor.DARK_AQUA + this.getName());
        } else {
            sender.sendMessage(ChatColor.DARK_AQUA + this.getName() + ChatColor.GRAY + " (" + this.getKey() + ")");
        }
        if (this.description != null) {
            sender.sendMessage(ChatColor.LIGHT_PURPLE + this.getDescription());
        }
        if (this.opCheck) {
            sender.sendMessage(ChatColor.RED + "OP Wand Check Enabled");
        }
        if (this.allowInterrupt) {
            sender.sendMessage(ChatColor.YELLOW + "Allows joining mid-match");
        }
        if (this.keepInventory) {
            sender.sendMessage(ChatColor.GREEN + "Players keep their inventory on death");
        }
        if (!this.itemWear) {
            sender.sendMessage(ChatColor.GREEN + "Players' items do not get worn out");
        }
        if (this.keepLevel) {
            sender.sendMessage(ChatColor.GREEN + "Players keep their XP levels on death");
        }
        if (!this.allowConsuming) {
            sender.sendMessage(ChatColor.GREEN + "Players may not eat or drink potions");
        }
        if (!this.allowMelee) {
            sender.sendMessage(ChatColor.GREEN + "Players may not use melee weapons");
        }
        if (!this.allowProjectiles) {
            sender.sendMessage(ChatColor.GREEN + "Players may not use bows or other projectile weapons");
        }
        int minPlayers = this.getMinPlayers();
        int maxPlayers = this.getMaxPlayers();
        sender.sendMessage(ChatColor.AQUA + "Min / Max Players: " + ChatColor.DARK_AQUA + minPlayers + ChatColor.WHITE + " / " + ChatColor.DARK_AQUA + maxPlayers);
        sender.sendMessage(ChatColor.AQUA + "Required Kills: " + ChatColor.DARK_AQUA + this.requiredKills);
        sender.sendMessage(ChatColor.AQUA + "Countdown: " + ChatColor.DARK_AQUA + this.countdown + ChatColor.WHITE + " / " + ChatColor.DARK_AQUA + this.countdownMax);
        if (this.duration > 0) {
            int minutes = (int)Math.ceil((double)this.duration / 60.0 / 1000.0);
            int sd = (int)Math.ceil((double)this.suddenDeath / 1000.0);
            sender.sendMessage(ChatColor.AQUA + "Duration: " + ChatColor.DARK_AQUA + minutes + ChatColor.WHITE + " minutes");
            if (this.suddenDeathEffect != null && this.suddenDeath > 0) {
                sender.sendMessage(ChatColor.DARK_RED + " Sudden death " + ChatColor.RED + sd + ChatColor.DARK_RED + " seconds before end with " + ChatColor.RED + this.suddenDeathEffect.getType().getName().toLowerCase() + "@" + this.suddenDeathEffect.getAmplifier());
            }
        }
        if (this.startCommands != null && !this.startCommands.isEmpty()) {
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "Start Commands: " + ChatColor.AQUA + this.startCommands);
        }
        if (this.endCommands != null && !this.endCommands.isEmpty()) {
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "End Commands: " + ChatColor.AQUA + this.endCommands);
        }
        if (this.borderMax > 0) {
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "Border: " + ChatColor.AQUA + this.borderMax + ChatColor.LIGHT_PURPLE + " to " + ChatColor.AQUA + this.borderMin);
        }
        if (this.winXP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: " + ChatColor.LIGHT_PURPLE + this.winXP + ChatColor.AQUA + " xp");
        }
        if (this.loseXP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Losing Reward: " + ChatColor.LIGHT_PURPLE + this.loseXP + ChatColor.AQUA + " xp");
        }
        if (this.drawXP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Draw Reward: " + ChatColor.LIGHT_PURPLE + this.drawXP + ChatColor.AQUA + " xp");
        }
        if (this.winSP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: " + ChatColor.LIGHT_PURPLE + this.winSP + ChatColor.AQUA + " sp");
        }
        if (this.loseSP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Losing Reward: " + ChatColor.LIGHT_PURPLE + this.loseSP + ChatColor.AQUA + " sp");
        }
        if (this.drawSP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Draw Reward: " + ChatColor.LIGHT_PURPLE + this.drawSP + ChatColor.AQUA + " sp");
        }
        if (this.winMoney > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: $" + ChatColor.LIGHT_PURPLE + this.winMoney + ChatColor.AQUA);
        }
        if (this.loseMoney > 0) {
            sender.sendMessage(ChatColor.AQUA + "Losing Reward: $" + ChatColor.LIGHT_PURPLE + this.loseMoney + ChatColor.AQUA);
        }
        if (this.drawMoney > 0) {
            sender.sendMessage(ChatColor.AQUA + "Draw Reward: $" + ChatColor.LIGHT_PURPLE + this.drawMoney + ChatColor.AQUA);
        }
        if ((spawnSize = this.spawns.size()) == 1) {
            sender.sendMessage(ChatColor.BLUE + "Spawn: " + this.printLocation(this.spawns.get(0)));
        } else {
            sender.sendMessage(ChatColor.BLUE + "Spawns: " + ChatColor.GRAY + spawnSize);
            for (Location spawn : this.spawns) {
                sender.sendMessage(ChatColor.GRAY + " " + this.printLocation(spawn));
            }
        }
        if (this.randomizeSpawn != null) {
            sender.sendMessage(ChatColor.DARK_BLUE + " Randomize: " + ChatColor.BLUE + this.randomizeSpawn);
        }
        sender.sendMessage(ChatColor.BLUE + "Lobby: " + this.printLocation(this.lobby));
        sender.sendMessage(ChatColor.BLUE + "Win: " + this.printLocation(this.win));
        sender.sendMessage(ChatColor.BLUE + "Lose: " + this.printLocation(this.lose));
        sender.sendMessage(ChatColor.BLUE + "Exit: " + this.printLocation(this.exit));
        sender.sendMessage(ChatColor.BLUE + "Center: " + this.printLocation(this.center));
        int numStages = this.stages.size();
        if (numStages > 0) {
            sender.sendMessage(ChatColor.BLUE + "Stages: " + ChatColor.GRAY + numStages);
        }
        if (this.state == ArenaState.ACTIVE && (currentStage = this.getCurrentStage()) != null) {
            sender.sendMessage(ChatColor.BLUE + "Active mobs: " + ChatColor.GRAY + currentStage.getActiveMobs());
        }
        if (this.portalDamage > 0 || this.portalEnterDamage > 0) {
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "Portal Entry Damage: " + ChatColor.DARK_PURPLE + this.portalEnterDamage);
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "Portal Damage: " + ChatColor.DARK_PURPLE + this.portalDamage);
            if (this.portalDeathMessage != null && !this.portalDeathMessage.isEmpty()) {
                sender.sendMessage(ChatColor.LIGHT_PURPLE + "Portal Death Message: " + ChatColor.DARK_PURPLE + this.portalDeathMessage);
            }
        }
        sender.sendMessage(ChatColor.YELLOW + "Announcer Range: " + ChatColor.GOLD + this.announcerRange);
        sender.sendMessage(ChatColor.YELLOW + "Leaderboard Size: " + ChatColor.GOLD + this.leaderboardSize + ChatColor.WHITE + "/" + ChatColor.GOLD + this.leaderboardRecordSize);
        sender.sendMessage(ChatColor.AQUA + "State: " + ChatColor.DARK_AQUA + (Object)((Object)this.state));
        int inGamePlayers = this.getInGamePlayers();
        sender.sendMessage(ChatColor.DARK_GREEN + "Active Players: " + ChatColor.GREEN + inGamePlayers);
        for (ArenaPlayer arenaPlayer : this.players) {
            sender.sendMessage(ChatColor.GOLD + " " + arenaPlayer.getDisplayName());
        }
        int deathCount = this.deadPlayers.size();
        sender.sendMessage(ChatColor.DARK_RED + "Dead Players: " + ChatColor.RED + deathCount);
        for (ArenaPlayer player : this.deadPlayers) {
            sender.sendMessage(ChatColor.RED + " " + player.getDisplayName());
        }
        int n = this.getQueuedPlayers();
        sender.sendMessage(ChatColor.YELLOW + "Queued Players: " + ChatColor.GOLD + n);
        for (ArenaPlayer player : this.queue) {
            sender.sendMessage(ChatColor.YELLOW + " " + player.getDisplayName());
        }
    }

    public void describeStages(CommandSender sender) {
        int numStages = this.stages.size();
        sender.sendMessage(ChatColor.BLUE + "Stages: " + ChatColor.GRAY + numStages);
        int stageNumber = 1;
        for (ArenaStage stage : this.stages) {
            String prefix = " ";
            prefix = this.editAllStages || stageNumber == stage.getNumber() ? ChatColor.YELLOW + "*" : " ";
            ++stageNumber;
            sender.sendMessage(prefix + ChatColor.GRAY + stage.getName() + ": " + ChatColor.AQUA + stage.getName());
        }
    }

    protected String printLocation(Location location) {
        if (location == null) {
            return ChatColor.DARK_GRAY + "(None)";
        }
        return "" + ChatColor.GRAY + location.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + location.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + location.getBlockZ() + ChatColor.DARK_GRAY + " : " + ChatColor.GRAY + location.getWorld().getName();
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getQueuedPlayers() {
        return this.queue.size();
    }

    public int getInGamePlayers() {
        return this.players.size();
    }

    public Set<ArenaPlayer> getLivingParticipants() {
        return this.players;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPortalEnterDamage(int damage) {
        this.portalEnterDamage = damage;
    }

    public int getPortalEnterDamage() {
        return this.portalEnterDamage;
    }

    public void setPortalDamage(int damage) {
        this.portalDamage = damage;
    }

    public int getPortalDamage() {
        return this.portalDamage;
    }

    public String getPortalDeathMessage() {
        return this.portalDeathMessage;
    }

    public void setPortalDeathMessage(String message) {
        this.portalDeathMessage = message;
    }

    public void mobDied(Entity entity) {
        ArenaStage currentStage = this.getCurrentStage();
        if (currentStage != null) {
            currentStage.mobDied(entity);
            if (this.isStarted()) {
                this.check();
            }
        }
    }

    public void died(Player player) {
        ArenaPlayer arenaPlayer = new ArenaPlayer(this, player);
        if (this.isStarted()) {
            if (this.players.contains(arenaPlayer)) {
                long respawnDuration;
                this.lastDeath = System.currentTimeMillis();
                this.deadPlayers.add(arenaPlayer);
                this.players.remove(arenaPlayer);
                ArenaStage currentStage = this.getCurrentStage();
                long l = respawnDuration = currentStage != null ? currentStage.getRespawnDuration() : 0L;
                if (respawnDuration > 0L) {
                    Location lobby = this.getLobby();
                    player.setMetadata("respawnLocation", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)lobby));
                    long seconds = respawnDuration / 1000L;
                    player.sendMessage(ChatColor.AQUA + "You have died, but you can get back in the fight in " + ChatColor.YELLOW + seconds + ChatColor.AQUA + " seconds!");
                } else {
                    Location specroom = this.getLoseLocation();
                    player.setMetadata("respawnLocation", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)specroom));
                    player.sendMessage(ChatColor.AQUA + "You have lost - Better luck next time!");
                }
            }
        } else {
            if (this.queue.contains(arenaPlayer)) {
                player.sendMessage(ChatColor.RED + "You died before the match even started!");
            }
            this.queue.remove(arenaPlayer);
        }
        this.check();
    }

    public ArenaController getController() {
        return this.controller;
    }

    public void removeFromLeaderboard(ArenaPlayer removePlayer) {
        this.leaderboard.remove(removePlayer);
    }

    public void updateLeaderboard(ArenaPlayer changedPlayer) {
        int wins = changedPlayer.getWins();
        int losses = changedPlayer.getLosses();
        this.leaderboard.remove(changedPlayer);
        if (wins + losses < this.leaderboardGamesRequired) {
            return;
        }
        this.leaderboard.add(changedPlayer);
        Collections.sort(this.leaderboard, new ArenaPlayerComparator());
        this.setLeaderboardSize(this.leaderboardSize);
    }

    public void updateLeaderboard() {
        MaterialAndData skullMaterial = DefaultMaterials.getPlayerSkullWallBlock();
        Block leaderboardBlock = this.getLeaderboardBlock();
        if (leaderboardBlock != null && this.leaderboardFacing != null) {
            BlockFace rightDirection = Arena.goLeft(this.leaderboardFacing);
            leaderboardBlock = leaderboardBlock.getRelative(BlockFace.UP);
            int size = Math.min(this.leaderboard.size(), this.leaderboardSize);
            BlockFace skullFace = this.leaderboardFacing;
            for (int i = size - 1; i >= 0; --i) {
                Block neighborBlock;
                ArenaPlayer player = this.leaderboard.get(i);
                if (this.canReplace(leaderboardBlock)) {
                    skullMaterial.modify(leaderboardBlock);
                    BlockState blockState = leaderboardBlock.getState();
                    if (blockState instanceof Skull) {
                        Skull skullBlock = (Skull)blockState;
                        skullBlock.setRotation(skullFace);
                        this.controller.getMagic().setSkullOwner(skullBlock, player.getUUID());
                    }
                }
                if (this.canReplace(neighborBlock = leaderboardBlock.getRelative(rightDirection))) {
                    neighborBlock.setType(this.signMaterial);
                    BlockState blockState = neighborBlock.getState();
                    MaterialData data = blockState.getData();
                    if (data instanceof Sign) {
                        Sign signData = (Sign)data;
                        signData.setFacingDirection(this.leaderboardFacing);
                        blockState.setData((MaterialData)signData);
                    }
                    if (blockState instanceof org.bukkit.block.Sign) {
                        org.bukkit.block.Sign signBlock = (org.bukkit.block.Sign)blockState;
                        String playerName = ChatColor.DARK_PURPLE + player.getDisplayName();
                        signBlock.setLine(0, playerName);
                        signBlock.setLine(1, ChatColor.LIGHT_PURPLE + "#" + Integer.toString(i + 1) + " " + ChatColor.WHITE + " : " + ChatColor.BLACK + Integer.toString((int)(player.getWinRatio() * 100.0f)) + "% " + String.format("(%.2f)", player.getWinConfidence()));
                        signBlock.setLine(2, ChatColor.GREEN + "Wins   : " + ChatColor.DARK_GREEN + player.getWins());
                        signBlock.setLine(3, ChatColor.RED + "Losses : " + ChatColor.DARK_RED + player.getLosses());
                    }
                    blockState.update();
                }
                leaderboardBlock = leaderboardBlock.getRelative(BlockFace.UP);
            }
        }
    }

    protected void clearLeaderboardBlock(Block block) {
        MaterialAndData skullMaterial;
        Material blockType = block.getType();
        if (blockType == (skullMaterial = DefaultMaterials.getPlayerSkullWallBlock()).getMaterial() || DefaultMaterials.isSign(blockType)) {
            block.setType(Material.AIR);
        }
    }

    protected boolean canReplace(Block block) {
        Material blockType = block.getType();
        if (this.controller.getMagic().getMaterialSetManager().getMaterialSet("all_air").testBlock(block)) {
            return true;
        }
        MaterialAndData skullMaterial = DefaultMaterials.getPlayerSkullWallBlock();
        return DefaultMaterials.isSign(blockType) || blockType == skullMaterial.getMaterial();
    }

    protected Block getLeaderboardBlock() {
        Block block = null;
        if (this.leaderboardLocation != null) {
            Block testBlock = this.leaderboardLocation.getBlock();
            if (DefaultMaterials.isSign(testBlock.getType())) {
                block = testBlock;
            } else {
                this.leaderboardLocation = null;
                this.leaderboardFacing = null;
            }
        }
        return block;
    }

    public static BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public static BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public void removeLeaderboard() {
        Block leaderboardBlock = this.getLeaderboardBlock();
        if (leaderboardBlock != null && this.leaderboardFacing != null) {
            BlockFace rightDirection = Arena.goLeft(this.leaderboardFacing);
            for (int y = 0; y <= this.leaderboardSize; ++y) {
                Block neighborBlock = leaderboardBlock.getRelative(rightDirection);
                this.clearLeaderboardBlock(neighborBlock);
                if (y != 0) {
                    this.clearLeaderboardBlock(leaderboardBlock);
                }
                leaderboardBlock = leaderboardBlock.getRelative(BlockFace.UP);
            }
        }
    }

    protected void trimLeaderboard() {
        this.removeLeaderboard();
        while (this.leaderboard.size() > this.leaderboardRecordSize) {
            this.leaderboard.remove(this.leaderboard.size() - 1);
        }
        this.updateLeaderboard();
    }

    public void setLeaderboardRecordSize(int size) {
        this.leaderboardRecordSize = size;
        if (this.leaderboardSize > this.leaderboardRecordSize) {
            this.leaderboardSize = this.leaderboardRecordSize;
        }
        this.trimLeaderboard();
    }

    public void setLeaderboardSize(int size) {
        this.leaderboardSize = size;
        if (this.leaderboardSize > this.leaderboardRecordSize) {
            this.leaderboardRecordSize = this.leaderboardSize;
        }
        this.trimLeaderboard();
    }

    public void setLeaderboardGamesRequired(int required) {
        this.leaderboardGamesRequired = required;
        ArrayList<ArenaPlayer> currentLeaderboard = new ArrayList<ArenaPlayer>(this.leaderboard);
        this.leaderboard.clear();
        for (ArenaPlayer player : currentLeaderboard) {
            this.updateLeaderboard(player);
        }
        this.updateLeaderboard();
    }

    public void describeStats(CommandSender sender, Player player) {
        ArenaPlayer arenaPlayer = new ArenaPlayer(this, player);
        int wins = arenaPlayer.getWins();
        int losses = arenaPlayer.getLosses();
        int draws = arenaPlayer.getDraws();
        int quits = arenaPlayer.getQuits();
        float ratio = arenaPlayer.getWinRatio();
        double confidence = arenaPlayer.getWinConfidence();
        Integer rank = null;
        int ranking = 1;
        for (ArenaPlayer testPlayer : this.leaderboard) {
            if (testPlayer.equals(arenaPlayer)) {
                rank = ranking;
                break;
            }
            ++ranking;
        }
        if (rank != null) {
            sender.sendMessage(ChatColor.DARK_PURPLE + player.getDisplayName() + ChatColor.DARK_PURPLE + " is ranked " + ChatColor.AQUA + "#" + Integer.toString(rank) + ChatColor.DARK_PURPLE + " for " + ChatColor.GOLD + this.getName());
        } else {
            sender.sendMessage(ChatColor.DARK_PURPLE + player.getDisplayName() + ChatColor.DARK_RED + " is not on the leaderboard for " + ChatColor.GOLD + this.getName());
        }
        Arena currentArena = this.controller.getQueuedArena(player);
        if (currentArena != null) {
            sender.sendMessage(ChatColor.DARK_PURPLE + player.getDisplayName() + ChatColor.LIGHT_PURPLE + " is currently in " + ChatColor.GOLD + currentArena.getName());
        }
        sender.sendMessage(ChatColor.GREEN + "Wins: " + ChatColor.WHITE + Integer.toString(wins));
        sender.sendMessage(ChatColor.RED + "Losses: " + ChatColor.WHITE + Integer.toString(losses));
        sender.sendMessage(ChatColor.GOLD + "Win Ratio: " + ChatColor.WHITE + Integer.toString((int)(ratio * 100.0f)) + "% " + String.format("(%.2f)", confidence));
        sender.sendMessage(ChatColor.YELLOW + "Draws: " + ChatColor.WHITE + Integer.toString(draws));
        sender.sendMessage(ChatColor.GRAY + "Defaults: " + ChatColor.WHITE + Integer.toString(quits));
    }

    public void describeLeaderboard(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + this.getName() + ChatColor.YELLOW + " Leaderboard: ");
        sender.sendMessage(ChatColor.AQUA + Integer.toString(this.leaderboard.size()) + ChatColor.DARK_AQUA + " players with at least " + ChatColor.AQUA + Integer.toString(this.leaderboardGamesRequired) + ChatColor.DARK_AQUA + " games:");
        int position = 1;
        for (ArenaPlayer arenaPlayer : this.leaderboard) {
            int wins = arenaPlayer.getWins();
            int losses = arenaPlayer.getLosses();
            float ratio = arenaPlayer.getWinRatio();
            sender.sendMessage(ChatColor.LIGHT_PURPLE + Integer.toString(position) + ": " + ChatColor.WHITE + ChatColor.DARK_PURPLE + arenaPlayer.getDisplayName() + ChatColor.WHITE + ": " + ChatColor.GREEN + Integer.toString(wins) + "W" + ChatColor.WHITE + " / " + ChatColor.RED + Integer.toString(losses) + "L" + ChatColor.WHITE + " = " + ChatColor.GOLD + Integer.toString((int)(ratio * 100.0f)) + "%");
            ++position;
        }
    }

    public boolean placeLeaderboard(Block leaderboardBlock) {
        if (!DefaultMaterials.isSign(leaderboardBlock.getType())) {
            return false;
        }
        BlockFace signDirection = CompatibilityLib.getCompatibilityUtils().getSignFacing(leaderboardBlock);
        if (signDirection == null) {
            this.controller.getPlugin().getLogger().warning("Block at " + leaderboardBlock.getLocation() + " has no sign data");
            return false;
        }
        BlockFace rightDirection = Arena.goLeft(signDirection);
        Block checkBlock = leaderboardBlock;
        for (int y = 0; y <= this.leaderboardSize; ++y) {
            Block neighborBlock = checkBlock.getRelative(rightDirection);
            if (!this.canReplace(neighborBlock)) {
                return false;
            }
            if (y != 0 && !this.canReplace(checkBlock)) {
                return false;
            }
            checkBlock = checkBlock.getRelative(BlockFace.UP);
        }
        this.removeLeaderboard();
        this.leaderboardLocation = leaderboardBlock.getLocation();
        this.leaderboardFacing = signDirection;
        this.updateLeaderboard();
        this.saveTemplate();
        return true;
    }

    public int getLeaderboardSize() {
        return this.leaderboardSize;
    }

    public void reset(Player player) {
        this.remove(player);
        ArenaPlayer arenaPlayer = new ArenaPlayer(this, player);
        this.removeFromLeaderboard(arenaPlayer);
        arenaPlayer.reset();
    }

    public void reset() {
        this.leaderboard.clear();
    }

    public void setWinXP(int xp) {
        this.winXP = Math.max(xp, 0);
    }

    public void setLoseXP(int xp) {
        this.loseXP = Math.max(xp, 0);
    }

    public void setDrawXP(int xp) {
        this.drawXP = Math.max(xp, 0);
    }

    public int getWinXP() {
        return this.winXP;
    }

    public int getLoseXP() {
        return this.loseXP;
    }

    public int getDrawXP() {
        return this.drawXP;
    }

    public void setWinSP(int sp) {
        this.winSP = Math.max(sp, 0);
    }

    public void setLoseSP(int sp) {
        this.loseSP = Math.max(sp, 0);
    }

    public void setDrawSP(int sp) {
        this.drawSP = Math.max(sp, 0);
    }

    public int getWinSP() {
        return this.winSP;
    }

    public int getLoseSP() {
        return this.loseSP;
    }

    public int getDrawSP() {
        return this.drawSP;
    }

    public void setWinMoney(int money) {
        this.winMoney = Math.max(money, 0);
    }

    public void setLoseMoney(int money) {
        this.loseMoney = Math.max(money, 0);
    }

    public void setDrawMoney(int money) {
        this.drawMoney = Math.max(money, 0);
    }

    public int getWinMoney() {
        return this.winMoney;
    }

    public int getLoseMoney() {
        return this.loseMoney;
    }

    public int getDrawMoney() {
        return this.drawMoney;
    }

    public void setMaxTeleportDistance(int distance) {
        this.maxTeleportDistance = distance;
    }

    public int getMaxTeleportDistance() {
        return this.maxTeleportDistance;
    }

    public void showLeaderboard(Player player) {
        int inventorySize = this.leaderboard.size() + 1;
        int leaderboardRows = (int)Math.ceil((float)inventorySize / 9.0f);
        leaderboardRows = Math.min(8, leaderboardRows);
        inventorySize = leaderboardRows * 9;
        boolean shownPlayer = false;
        String arenaName = ChatColor.DARK_AQUA + "Leaderboard: " + ChatColor.GOLD + this.getName();
        if (arenaName.length() > 32) {
            arenaName = arenaName.substring(0, 31);
        }
        final Inventory leaderboardInventory = Bukkit.createInventory(null, (int)inventorySize, (String)arenaName);
        final int leaderboardSize = Math.min(this.leaderboard.size(), inventorySize);
        for (int i = 0; i < leaderboardSize; ++i) {
            ArenaPlayer arenaPlayer = this.leaderboard.get(i);
            final int slot = i;
            this.createLeaderboardIcon(i + 1, arenaPlayer, new ItemUpdatedCallback(){

                @Override
                public void updated(ItemStack itemStack) {
                    leaderboardInventory.setItem(slot, itemStack);
                }
            });
            if (!player.getUniqueId().equals(arenaPlayer.getUUID())) continue;
            shownPlayer = true;
        }
        if (!shownPlayer && leaderboardSize > 0) {
            ArenaPlayer arenaPlayer = new ArenaPlayer(this, player);
            this.createLeaderboardIcon(null, arenaPlayer, new ItemUpdatedCallback(){

                @Override
                public void updated(ItemStack itemStack) {
                    leaderboardInventory.setItem(leaderboardSize - 1, itemStack);
                }
            });
        }
        player.openInventory(leaderboardInventory);
    }

    protected void createLeaderboardIcon(final Integer rank, final ArenaPlayer player, final ItemUpdatedCallback callback) {
        ItemStack playerItem = this.controller.getMagic().getSkull(player.getUUID(), ChatColor.GOLD + player.getDisplayName(), new ItemUpdatedCallback(){

            @Override
            public void updated(ItemStack itemStack) {
                ItemMeta meta = itemStack.getItemMeta();
                ArrayList<String> lore = new ArrayList<String>();
                if (rank != null) {
                    lore.add(ChatColor.DARK_PURPLE + "Ranked " + ChatColor.AQUA + "#" + Integer.toString(rank) + ChatColor.DARK_PURPLE + " for " + ChatColor.GOLD + Arena.this.getName());
                } else {
                    lore.add(ChatColor.DARK_PURPLE + "Not ranked for " + ChatColor.GOLD + Arena.this.getName());
                }
                lore.add(ChatColor.GREEN + "Wins: " + ChatColor.WHITE + Integer.toString(player.getWins()));
                lore.add(ChatColor.RED + "Losses: " + ChatColor.WHITE + Integer.toString(player.getLosses()));
                lore.add(ChatColor.GOLD + "Win Ratio: " + ChatColor.WHITE + Integer.toString((int)(player.getWinRatio() * 100.0f)) + "% " + String.format("(%.2f)", player.getWinConfidence()));
                lore.add(ChatColor.YELLOW + "Draws: " + ChatColor.WHITE + Integer.toString(player.getDraws()));
                lore.add(ChatColor.GRAY + "Defaults: " + ChatColor.WHITE + Integer.toString(player.getQuits()));
                meta.setLore(lore);
                itemStack.setItemMeta(meta);
                callback.updated(itemStack);
            }
        });
    }

    public void setCountdown(int countdown) {
        this.countdown = countdown;
    }

    public void setCountdownMax(int countdownMax) {
        this.countdownMax = countdownMax;
    }

    public boolean hasOpCheck() {
        return this.opCheck;
    }

    public void setOpCheck(boolean check) {
        this.opCheck = check;
    }

    public boolean getAllowInterrupt() {
        return this.allowInterrupt;
    }

    public void setAllowInterrupt(boolean interrupt) {
        this.allowInterrupt = interrupt;
    }

    public void setKeepInventory(boolean keep) {
        this.keepInventory = keep;
    }

    public void setItemWear(boolean wear) {
        this.itemWear = wear;
    }

    public void setAllowConsuming(boolean consume) {
        this.allowConsuming = consume;
    }

    public void setAllowMelee(boolean allow) {
        this.allowMelee = allow;
    }

    public void setAllowProjectiles(boolean allow) {
        this.allowProjectiles = allow;
    }

    public void setKeepLevel(boolean keep) {
        this.keepLevel = keep;
    }

    public void setAnnouncerRange(int range) {
        this.announcerRange = range;
    }

    public int getAnnouncerRange() {
        return this.announcerRange;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setSuddenDeath(int suddenDeath) {
        this.suddenDeath = suddenDeath;
    }

    public void setStartCommands(String commands) {
        this.startCommands = commands;
    }

    public void setEndCommands(String commands) {
        this.endCommands = commands;
    }

    public void setBorder(int min, int max) {
        this.borderMin = min;
        this.borderMax = max;
    }

    public void draw() {
        this.messageInGamePlayers("t:" + ChatColor.RED + "Out of Time!");
        this.announce(ChatColor.GRAY + "The " + ChatColor.YELLOW + this.getName() + ChatColor.GRAY + " match timed out in a draw");
        for (ArenaPlayer player : this.players) {
            player.draw();
        }
        for (ArenaPlayer loser : this.deadPlayers) {
            loser.draw();
        }
        this.finish();
    }

    public void tick() {
        long suddenDeathDuration;
        boolean hasSuddenDeath;
        ArenaStage currentStage = this.getCurrentStage();
        if (currentStage != null) {
            currentStage.tick();
        }
        if (this.duration <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        long previousTime = this.lastTick - this.started;
        long currentTime = now - this.started;
        this.lastTick = now;
        if (currentTime > (long)this.duration) {
            this.draw();
            return;
        }
        boolean bl = hasSuddenDeath = this.suddenDeath > 0 && this.suddenDeathEffect != null && this.suddenDeath < this.duration;
        if (currentTime >= (long)(this.duration - 120000) && previousTime < (long)(this.duration - 1200000)) {
            this.announce(ChatColor.GOLD + "The " + ChatColor.YELLOW + this.getName() + ChatColor.GOLD + " match will " + ChatColor.RED + "END" + ChatColor.GOLD + " in " + ChatColor.RED + "two minutes!");
        }
        if (currentTime >= (long)(this.duration - 60000) && previousTime < (long)(this.duration - 60000)) {
            this.announce(ChatColor.GOLD + "The " + ChatColor.YELLOW + this.getName() + ChatColor.GOLD + " match will " + ChatColor.RED + "END" + ChatColor.GOLD + " in " + ChatColor.RED + "one minute!");
        }
        if (currentTime >= (long)(this.duration - 30000) && previousTime < (long)(this.duration - 30000)) {
            this.announce(ChatColor.GOLD + "The " + ChatColor.YELLOW + this.getName() + ChatColor.GOLD + " match will " + ChatColor.RED + "END" + ChatColor.GOLD + " in " + ChatColor.RED + "thirty seconds!");
        }
        if (currentTime >= (long)(this.duration - 10000) && previousTime < (long)(this.duration - 10000)) {
            this.announce(ChatColor.GOLD + "The " + ChatColor.YELLOW + this.getName() + ChatColor.GOLD + " match will " + ChatColor.RED + "END" + ChatColor.GOLD + " in " + ChatColor.RED + "ten seconds!");
        }
        if (currentTime >= (long)(this.duration - 5000) && previousTime < (long)(this.duration - 5000)) {
            this.announce(ChatColor.GOLD + "The " + ChatColor.YELLOW + this.getName() + ChatColor.GOLD + " match will " + ChatColor.RED + "END" + ChatColor.GOLD + " in " + ChatColor.RED + "five seconds!");
        }
        if (hasSuddenDeath && currentTime >= (suddenDeathDuration = (long)(this.duration - this.suddenDeath))) {
            if (previousTime < suddenDeathDuration) {
                this.announce(ChatColor.RED + "SUDDEN DEATH!");
            }
            for (ArenaPlayer player : this.players) {
                player.getPlayer().addPotionEffect(this.suddenDeathEffect, true);
            }
        }
    }

    public boolean isValid() {
        return this.center != null && this.center.getWorld() != null;
    }

    public boolean isKeepInventory() {
        return this.keepInventory;
    }

    public boolean isKeepLevel() {
        return this.keepLevel;
    }

    public boolean isItemWear() {
        return this.itemWear;
    }

    public boolean isAllowConsuming() {
        return this.allowConsuming;
    }

    public boolean isAllowMelee() {
        return this.allowMelee;
    }

    public boolean isAllowProjectiles() {
        return this.allowProjectiles;
    }

    public boolean isMobArena() {
        ArenaStage currentStage = this.getCurrentStage();
        if (currentStage == null) {
            return false;
        }
        return currentStage.hasMobs();
    }

    public Mage getMage() {
        return this.controller.getMagic().getMage("ARENA: " + this.getKey(), this.getName());
    }

    public void setLeaderboardSignType(Material material) {
        this.signMaterial = material;
    }

    public boolean isBattling(ArenaPlayer player) {
        return this.players.contains(player);
    }

    public Collection<ArenaStage> getStages() {
        return this.stages;
    }

    public void setEditAllStages(boolean all) {
        this.editAllStages = all;
    }

    public long getLastDeathTime() {
        return this.lastDeath;
    }

    public void showRespawnBossBar(double progress) {
        if (this.respawnBar == null) {
            this.respawnBar = this.controller.getPlugin().getServer().createBossBar(ChatColor.GREEN + "Respawning", BarColor.GREEN, BarStyle.SOLID, new BarFlag[0]);
        }
        for (ArenaPlayer dead : this.deadPlayers) {
            this.respawnBar.addPlayer(dead.getPlayer());
        }
        this.respawnBar.setProgress(progress);
    }

    public void hideRespawnBossBar() {
        if (this.respawnBar != null) {
            this.respawnBar.removeAll();
        }
    }

    public boolean hasDeadPlayers() {
        return !this.deadPlayers.isEmpty();
    }
}

