/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.integration.ModelEngine;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class ModelEngineAction
extends BaseSpellAction {
    private ActionType actionType;
    private String state;
    private String model;
    private boolean ignoreLerp;
    private int lerpIn;
    private int lerpOut;
    private double lerpSpeed;
    private String partId;
    private String subModelId;
    private String subPartId;
    private String customId;
    private Color color;
    private boolean exactMatch;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.model = parameters.getString("model_id");
        this.state = parameters.getString("model_state");
        this.ignoreLerp = parameters.getBoolean("ignore_lerp", false);
        this.lerpIn = parameters.getInt("lerp_in", 0);
        this.lerpOut = parameters.getInt("lerp_out", 1);
        this.lerpSpeed = parameters.getDouble("lerp_speed", 1.0);
        this.partId = parameters.getString("part_id");
        this.subModelId = parameters.getString("sub_model_id");
        this.subPartId = parameters.getString("sub_part_id");
        this.customId = parameters.getString("custom_id");
        String actionTypeString = parameters.getString("model_action", "add_state");
        if (actionTypeString != null && !actionTypeString.isEmpty()) {
            try {
                this.actionType = ActionType.valueOf(actionTypeString.toUpperCase());
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid model_action in ModelEngine action: " + actionTypeString);
            }
        } else {
            context.getLogger().warning("Missing required model_action in ModelEngine action");
        }
        switch (this.actionType) {
            case TINT: {
                this.exactMatch = parameters.getBoolean("exact_match");
                this.color = ConfigurationUtils.getColor(parameters, "color", Color.WHITE);
                break;
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        MageController controller = context.getController();
        ModelEngine modelEngine = controller.getModelEngine();
        if (modelEngine == null) {
            context.getMage().sendMessage("This spell requires ModelEngine");
            return SpellResult.FAIL;
        }
        Entity target = context.getTargetEntity();
        boolean result = false;
        switch (this.actionType) {
            case ADD_STATE: {
                result = modelEngine.addModelState(target, this.model, this.state, this.lerpIn, this.lerpOut, this.lerpSpeed);
                break;
            }
            case REMOVE_STATE: {
                result = modelEngine.removeModelState(target, this.model, this.state, this.ignoreLerp);
                break;
            }
            case ADD_SUB_MODEL: {
                result = modelEngine.addSubModel(target, this.model, this.partId, this.subModelId, this.subPartId, this.customId);
                break;
            }
            case REMOVE_SUB_MODEL: {
                result = modelEngine.removeSubModel(target, this.model, this.subPartId, this.customId);
                break;
            }
            case TINT: {
                result = modelEngine.tintModel(target, this.model, this.subPartId, this.color, this.exactMatch);
                break;
            }
        }
        return result ? SpellResult.CAST : SpellResult.NO_TARGET;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    private static enum ActionType {
        ADD_STATE,
        REMOVE_STATE,
        ADD_SUB_MODEL,
        REMOVE_SUB_MODEL,
        TINT;

    }
}

