/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class ExplosionAction
extends BaseSpellAction {
    protected int size;
    protected boolean useFire;
    protected boolean breakBlocks;

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        if (this.breakBlocks && !context.hasBreakPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.useFire && !context.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Entity entity = context.getEntity();
        Location location = block.getLocation();
        UndoList currentList = com.elmakers.mine.bukkit.block.UndoList.getUndoList(entity);
        com.elmakers.mine.bukkit.block.UndoList.setUndoList(entity, context.getUndoList());
        CompatibilityLib.getCompatibilityUtils().createExplosion(entity, location.getWorld(), location.getX(), location.getY(), location.getZ(), this.size, this.useFire, this.breakBlocks);
        com.elmakers.mine.bukkit.block.UndoList.setUndoList(entity, currentList);
        return SpellResult.CAST;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        Mage mage = context.getMage();
        this.size = parameters.getInt("size", 1);
        this.useFire = parameters.getBoolean("fire", false);
        this.breakBlocks = parameters.getBoolean("break_blocks", true);
        this.size = (int)(mage.getRadiusMultiplier() * (float)this.size);
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresBreakPermission() {
        return true;
    }
}

