/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.magic.SourceLocation;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class CheckBlockAction
extends CheckAction {
    private MaterialSet allowed;
    private boolean useTarget;
    private BlockFace direction;
    private int directionCount;
    private boolean setTarget;
    private boolean allowBrush;
    private SourceLocation sourceLocation;
    private Set<Biome> allowedBiomes;
    private Set<Biome> notBiomes;
    private Map<Biome, String> biomeActions;
    private Map<Material, String> blockActions;
    private boolean checkPermissions;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        ConfigurationSection blockActionConfig;
        this.allowed = spell.getController().getMaterialSetManager().fromConfig(parameters.getString("allowed"));
        this.allowedBiomes = ConfigurationUtils.loadBiomes(ConfigurationUtils.getStringList(parameters, "biomes"), spell.getController().getLogger(), "spell " + spell.getKey());
        this.notBiomes = ConfigurationUtils.loadBiomes(ConfigurationUtils.getStringList(parameters, "not_biomes"), spell.getController().getLogger(), "spell " + spell.getKey());
        ConfigurationSection biomeActionConfig = ConfigurationUtils.getConfigurationSection(parameters, "biome_actions");
        if (biomeActionConfig != null) {
            this.biomeActions = new HashMap<Biome, String>();
            for (String biomeKey : biomeActionConfig.getKeys(false)) {
                try {
                    Biome biome = Biome.valueOf((String)biomeKey.trim().toUpperCase());
                    this.biomeActions.put(biome, biomeActionConfig.getString(biomeKey));
                }
                catch (Exception ex) {
                    spell.getController().getLogger().warning("Invalid biome in biome_actions config: " + biomeKey);
                }
            }
        }
        if ((blockActionConfig = ConfigurationUtils.getConfigurationSection(parameters, "block_actions")) != null) {
            this.blockActions = new HashMap<Material, String>();
            for (String blockKey : blockActionConfig.getKeys(false)) {
                try {
                    Material blockType = Material.valueOf((String)blockKey.trim().toUpperCase());
                    this.blockActions.put(blockType, blockActionConfig.getString(blockKey));
                }
                catch (Exception ex) {
                    spell.getController().getLogger().warning("Invalid block type in block_actions config: " + blockKey);
                }
            }
        }
        super.initialize(spell, parameters);
    }

    @Override
    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
        super.addHandlers(spell, parameters);
        if (this.blockActions != null) {
            for (String handler : this.blockActions.values()) {
                this.addHandler(spell, handler);
            }
        }
        if (this.biomeActions != null) {
            for (String handler : this.biomeActions.values()) {
                this.addHandler(spell, handler);
            }
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.useTarget = parameters.getBoolean("use_target", true);
        this.setTarget = parameters.getBoolean("set_target", false);
        this.allowBrush = parameters.getBoolean("allow_brush", false);
        this.sourceLocation = new SourceLocation(parameters.getString("source_location", "BLOCK"), !this.useTarget);
        this.directionCount = parameters.getInt("direction_count", 1);
        this.checkPermissions = this.notBiomes == null && this.allowedBiomes == null && !this.allowBrush && this.allowed == null;
        this.checkPermissions = parameters.getBoolean("check_permission", this.checkPermissions);
        String directionString = parameters.getString("direction");
        if (directionString != null && !directionString.isEmpty()) {
            try {
                this.direction = BlockFace.valueOf((String)directionString.toUpperCase());
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid BlockFace direction: " + directionString);
            }
        }
    }

    @Override
    public SpellResult step(CastContext context) {
        String actionHandler = null;
        if (this.blockActions != null || this.biomeActions != null) {
            Block block = this.getTargetBlock(context);
            if (block == null) {
                return SpellResult.NO_TARGET;
            }
            if (this.blockActions != null) {
                actionHandler = this.blockActions.get(block.getType());
            }
            if (this.biomeActions != null && actionHandler == null) {
                actionHandler = this.biomeActions.get(block.getBiome());
            }
        }
        if (actionHandler != null) {
            return this.startActions(actionHandler);
        }
        return super.step(context);
    }

    private Block getTargetBlock(CastContext context) {
        Block block = this.sourceLocation.getBlock(context);
        if (block != null && this.direction != null) {
            for (int i = 0; i < this.directionCount; ++i) {
                block = block.getRelative(this.direction);
            }
        }
        return block;
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        MaterialBrush brush = context.getBrush();
        Block block = this.getTargetBlock(context);
        if (block == null) {
            return false;
        }
        boolean isAllowed = true;
        if (this.allowed != null && !this.allowed.testBlock(block)) {
            isAllowed = false;
        }
        if (!isAllowed && this.checkPermissions) {
            isAllowed = true;
            if (brush != null && brush.isErase()) {
                if (!context.hasBreakPermission(block)) {
                    isAllowed = false;
                }
            } else if (!context.hasBuildPermission(block)) {
                isAllowed = false;
            }
            if (!context.isDestructible(block)) {
                isAllowed = false;
            }
        }
        if (isAllowed && this.allowedBiomes != null && !this.allowedBiomes.contains(block.getBiome())) {
            isAllowed = false;
        }
        if (!isAllowed && this.allowBrush && brush != null && !brush.isDifferent(block)) {
            isAllowed = true;
        }
        if (isAllowed && this.notBiomes != null && this.notBiomes.contains(block.getBiome())) {
            isAllowed = false;
        }
        if (this.setTarget && isAllowed) {
            this.createActionContext(context, context.getEntity(), null, context.getTargetEntity(), block.getLocation());
        }
        return isAllowed;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

