/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.populator.MagicChunkPopulator;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public abstract class BaseBlockPopulator
extends MagicChunkPopulator {
    private int maxY = 255;
    private int minY = 0;
    private int maxAirY = 255;

    @Override
    public boolean load(ConfigurationSection config, MagicController controller) {
        if (!super.load(config, controller)) {
            return false;
        }
        this.maxY = config.getInt("max_y", this.maxY);
        this.minY = config.getInt("min_y", this.minY);
        this.maxAirY = config.getInt("max_air_y", this.maxAirY);
        return true;
    }

    public void populate(World world, Random random, Chunk chunk) {
        for (int x = 0; x <= 15; ++x) {
            block1: for (int z = 0; z <= 15; ++z) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    Block block = chunk.getBlock(x, y, z);
                    if (y > this.maxAirY && block.getType() == Material.AIR) continue block1;
                    this.populate(block, random);
                }
            }
        }
    }

    public abstract BlockResult populate(Block var1, Random var2);
}

