/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.legacy;

import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.SkinUtilsBase;
import com.elmakers.mine.bukkit.utility.platform.legacy.NMSUtils;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class SkinUtils
extends SkinUtilsBase {
    public SkinUtils(Platform platform) {
        super(platform);
    }

    @Override
    public String getProfileURL(Object profile) {
        String url = null;
        if (profile == null) {
            return null;
        }
        try {
            Multimap properties = (Multimap)NMSUtils.class_GameProfile_properties.get(profile);
            Collection textures = properties.get((Object)"textures");
            if (textures != null && textures.size() > 0) {
                Object textureProperty = textures.iterator().next();
                String texture = (String)NMSUtils.class_GameProfileProperty_value.get(textureProperty);
                String decoded = Base64Coder.decodeString(texture);
                url = this.getTextureURL(decoded);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return url;
    }

    @Override
    public Object getProfile(Player player) {
        if (NMSUtils.class_CraftPlayer_getProfileMethod == null) {
            return null;
        }
        try {
            return NMSUtils.class_CraftPlayer_getProfileMethod.invoke((Object)player, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public JsonElement getProfileJson(Object gameProfile) throws IllegalAccessException {
        JsonElement profileJson = this.getGson().toJsonTree(gameProfile);
        if (profileJson.isJsonObject()) {
            JsonObject profileObject = (JsonObject)profileJson;
            Multimap properties = (Multimap)NMSUtils.class_GameProfile_properties.get(gameProfile);
            JsonArray propertiesArray = new JsonArray();
            for (Map.Entry entry : properties.entries()) {
                JsonObject newObject = new JsonObject();
                newObject.addProperty("name", (String)entry.getKey());
                String value = (String)NMSUtils.class_GameProfileProperty_value.get(entry.getValue());
                newObject.addProperty("value", value);
                String signature = (String)NMSUtils.class_GameProfileProperty_signature.get(entry.getValue());
                newObject.addProperty("signature", signature);
                propertiesArray.add((JsonElement)newObject);
            }
            profileObject.add("properties", (JsonElement)propertiesArray);
        }
        return profileJson;
    }

    @Override
    public Object getGameProfile(UUID uuid, String playerName, String profileJSON) {
        Object gameProfile = null;
        try {
            JsonObject profile;
            gameProfile = NMSUtils.class_GameProfile_constructor.newInstance(uuid, playerName);
            Multimap properties = (Multimap)NMSUtils.class_GameProfile_properties.get(gameProfile);
            JsonElement json = new JsonParser().parse(profileJSON);
            if (json != null && json.isJsonObject() && (profile = json.getAsJsonObject()).has("properties")) {
                JsonArray propertiesJson = profile.getAsJsonArray("properties");
                for (int i = 0; i < propertiesJson.size(); ++i) {
                    JsonObject property = propertiesJson.get(i).getAsJsonObject();
                    if (property == null || !property.has("name") || !property.has("value")) continue;
                    String name = property.get("name").getAsString();
                    String value = property.get("value").getAsString();
                    String signature = property.has("signature") ? property.get("signature").getAsString() : null;
                    Object newProperty = NMSUtils.class_GameProfileProperty_constructor.newInstance(name, value, signature);
                    properties.put((Object)name, newProperty);
                }
            }
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error creating GameProfile", ex);
        }
        if (CompatibilityConstants.DEBUG) {
            this.platform.getLogger().info("Got profile: " + gameProfile);
            this.platform.getLogger().info(this.platform.getSkinUtils().getProfileURL(gameProfile));
        }
        return gameProfile;
    }
}

