/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.legacy;

import com.elmakers.mine.bukkit.utility.MetaKey;
import com.elmakers.mine.bukkit.utility.platform.EntityMetadataUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class LegacyEntityMetadataUtils
extends EntityMetadataUtils {
    private final Map<String, Map<String, Object>> metadata = new HashMap<String, Map<String, Object>>();

    public LegacyEntityMetadataUtils(Plugin plugin) {
        super(plugin);
        plugin.getLogger().info("Persistent metadata is not available, will rely on custom names to restore persistent magic mobs");
    }

    protected <T> T getRawValue(Entity entity, MetaKey<T> key) {
        Map<String, Object> data = this.metadata.get(entity.getUniqueId().toString());
        Object v = data == null ? null : data.get(key.getName());
        return key.getType().isInstance(v) ? (T)key.getType().cast(v) : null;
    }

    @Override
    public boolean getBoolean(Entity entity, MetaKey<Boolean> key) {
        Boolean value = this.getRawValue(entity, key);
        return value != null && value != false;
    }

    @Override
    public Double getDouble(Entity entity, MetaKey<Double> key) {
        return this.getRawValue(entity, key);
    }

    @Override
    public Long getLong(Entity entity, MetaKey<Long> key) {
        return this.getRawValue(entity, key);
    }

    @Override
    public String getString(Entity entity, MetaKey<String> key) {
        return this.getRawValue(entity, key);
    }

    protected <T> void setRawValue(Entity entity, MetaKey<T> key, T value) {
        Map<String, Object> values = this.metadata.get(entity.getUniqueId().toString());
        if (values == null) {
            values = new HashMap<String, Object>();
            this.metadata.put(entity.getUniqueId().toString(), values);
        }
        values.put(key.getName(), value);
    }

    @Override
    public void setBoolean(Entity entity, MetaKey<Boolean> key, boolean value) {
        this.setRawValue(entity, key, value);
    }

    @Override
    public void setDouble(Entity entity, MetaKey<Double> key, double value) {
        this.setRawValue(entity, key, value);
    }

    @Override
    public void setLong(Entity entity, MetaKey<Long> key, long value) {
        this.setRawValue(entity, key, value);
    }

    @Override
    public void setString(Entity entity, MetaKey<String> key, String value) {
        this.setRawValue(entity, key, value);
    }

    @Override
    public void remove(Entity entity, MetaKey<?> key) {
        Map<String, Object> values = this.metadata.get(entity.getUniqueId().toString());
        if (values != null) {
            values.remove(key);
        }
    }
}

