/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.base.entity.EntityAbstractHorseData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;

public class EntityHorseData
extends EntityAbstractHorseData {
    public Horse.Color color;
    public Horse.Style style;
    public ItemData armor;

    public EntityHorseData() {
    }

    public EntityHorseData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        String styleString;
        Logger log = controller.getLogger();
        String horseColorKey = parameters.getString("horse_color");
        if (horseColorKey != null && !horseColorKey.isEmpty()) {
            try {
                this.color = Horse.Color.valueOf((String)horseColorKey.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid horse_color: " + horseColorKey);
            }
        }
        if ((styleString = parameters.getString("horse_style")) != null && !styleString.isEmpty()) {
            try {
                this.style = Horse.Style.valueOf((String)styleString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid horse_style: " + parameters.getString("horse_style"));
            }
        }
        if (parameters.contains("horse_jump_strength")) {
            this.jumpStrength = parameters.getDouble("horse_jump_strength");
        }
        this.armor = controller.getOrCreateItem(parameters.getString("armor"));
    }

    public EntityHorseData(Horse horse, MageController controller) {
        super((Entity)horse);
        this.color = horse.getColor();
        this.style = horse.getStyle();
        this.armor = this.getItem(horse.getInventory().getArmor(), controller);
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (!(entity instanceof Horse)) {
            return;
        }
        Horse horse = (Horse)entity;
        if (this.armor != null) {
            horse.getInventory().setArmor(this.armor.getItemStack(1));
        }
        if (this.color != null) {
            horse.setColor(this.color);
        }
        if (this.style != null) {
            horse.setStyle(this.style);
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Horse horse = (Horse)entity;
        Horse.Color color = horse.getColor();
        Horse.Color[] colorValues = Horse.Color.values();
        color = colorValues[(color.ordinal() + 1) % colorValues.length];
        Horse.Style horseStyle = horse.getStyle();
        Horse.Style[] styleValues = Horse.Style.values();
        horseStyle = styleValues[(horseStyle.ordinal() + 1) % styleValues.length];
        horse.setStyle(horseStyle);
        horse.setColor(color);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Horse;
    }
}

