/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.kit;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.kit.Kit;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.item.InventorySlot;
import com.elmakers.mine.bukkit.kit.MageKit;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MagicKit
implements Kit,
Comparable<MagicKit> {
    private final MagicController controller;
    private Collection<Requirement> requirements;
    private final String key;
    private final boolean isStarter;
    private final boolean isKeep;
    private final boolean isRemove;
    private final boolean isPartial;
    private final boolean isWelcomeWand;
    private final int cooldown;
    private final int priority;
    private final String icon;
    private final String iconDisabled;
    private final String name;
    private final String description;
    private final Double worth;
    private final Set<String> worlds;
    private final boolean allWorlds;
    private Map<Integer, ItemData> slotItems;
    private Collection<ItemData> items;

    public MagicKit(MagicController controller, String key, ConfigurationSection configuration) {
        block11: {
            block12: {
                block10: {
                    this.controller = controller;
                    this.key = key;
                    this.isStarter = configuration.getBoolean("starter");
                    this.isKeep = configuration.getBoolean("keep");
                    this.isRemove = configuration.getBoolean("remove");
                    this.isPartial = configuration.getBoolean("partial");
                    this.isWelcomeWand = configuration.getBoolean("welcome_wand");
                    this.cooldown = configuration.getInt("cooldown");
                    this.priority = configuration.getInt("priority");
                    this.icon = configuration.getString("icon");
                    this.iconDisabled = configuration.getString("icon_disabled");
                    this.requirements = ConfigurationUtils.getRequirements(configuration);
                    this.worth = configuration.contains("worth") ? Double.valueOf(configuration.getDouble("worth")) : null;
                    this.name = configuration.getString("name", "");
                    this.description = configuration.getString("description", "");
                    List<String> worldKeys = ConfigurationUtils.getStringList(configuration, "worlds");
                    if (worldKeys != null && !worldKeys.isEmpty()) {
                        this.worlds = new HashSet<String>(worldKeys);
                        this.allWorlds = this.worlds.contains("*");
                    } else {
                        this.worlds = null;
                        this.allWorlds = false;
                    }
                    List itemList = configuration.getList("items");
                    if (itemList == null) break block10;
                    for (Object itemObject : itemList) {
                        if (itemObject instanceof String) {
                            this.addItemFromString((String)itemObject);
                            continue;
                        }
                        if (!(itemObject instanceof ConfigurationSection) && !(itemObject instanceof Map)) continue;
                        ConfigurationSection itemConfig = itemObject instanceof Map ? ConfigurationUtils.toConfigurationSection(configuration, (Map)itemObject) : (ConfigurationSection)itemObject;
                        String itemKey = itemConfig.getString("item");
                        if (itemKey == null || itemKey.isEmpty()) {
                            controller.getLogger().warning("Skipping empty item in kit " + key);
                            continue;
                        }
                        Integer slot = null;
                        if (itemConfig.contains("slot")) {
                            slot = itemConfig.isInt("slot") ? Integer.valueOf(itemConfig.getInt("slot")) : InventorySlot.parseSlot(itemConfig.getString("slot"));
                        }
                        if (itemConfig.contains("amount")) {
                            itemKey = itemKey + "@" + itemConfig.getInt("amount");
                        }
                        this.addItemFromString(itemKey, slot);
                    }
                    break block11;
                }
                ConfigurationSection itemsWithCounts = configuration.getConfigurationSection("items");
                if (itemsWithCounts == null) break block12;
                for (String itemKey : itemsWithCounts.getKeys(false)) {
                    int amount = itemsWithCounts.getInt(itemKey);
                    if (amount > 1) {
                        itemKey = itemKey + "@" + amount;
                    }
                    this.addItemFromString(itemKey, null);
                }
                break block11;
            }
            List<String> itemStringList = ConfigurationUtils.getStringList(configuration, "items");
            if (itemStringList == null) break block11;
            for (String itemKey : itemStringList) {
                this.addItemFromString(itemKey, null);
            }
        }
    }

    private void addItemFromString(String itemKey) {
        this.addItemFromString(itemKey, null);
    }

    private void addItemFromString(String itemKey, Integer slot) {
        ItemData item = this.controller.getOrCreateItem(itemKey);
        if (item == null) {
            this.controller.getLogger().warning("Invalid item key in key " + this.key + ": " + itemKey);
        } else if (slot == null) {
            if (this.items == null) {
                this.items = new ArrayList<ItemData>();
            }
            this.items.add(item);
        } else {
            if (this.slotItems == null) {
                this.slotItems = new HashMap<Integer, ItemData>();
            }
            this.slotItems.put(slot, item);
        }
    }

    public boolean isStarter() {
        return this.isStarter;
    }

    public boolean isKeep() {
        return this.isKeep;
    }

    public boolean isRemove() {
        return this.isRemove;
    }

    @Override
    public long getRemainingCooldown(com.elmakers.mine.bukkit.api.magic.Mage apiMage) {
        Mage mage = (Mage)apiMage;
        if (this.cooldown == 0) {
            return 0L;
        }
        if (this.bypasses(mage, "Magic.bypass_kit_cooldown")) {
            return 0L;
        }
        MageKit kit = mage.getKit(this.key);
        if (kit == null) {
            return 0L;
        }
        long lastGive = kit.getLastGiveTime();
        lastGive = System.currentTimeMillis() - lastGive;
        return lastGive >= (long)this.cooldown ? 0L : (long)this.cooldown - lastGive;
    }

    private boolean bypasses(Mage mage, String node) {
        if (mage.isBypassEnabled()) {
            return true;
        }
        Player player = mage.getPlayer();
        return player != null && (player.hasPermission(node) || player.hasPermission("Magic.bypass"));
    }

    @Override
    public boolean isAllowed(com.elmakers.mine.bukkit.api.magic.Mage apiMage) {
        Location location;
        Mage mage = (Mage)apiMage;
        if (!this.bypasses(mage, "Magic.bypass_kit_requirements") && this.controller.checkRequirements(mage.getContext(), this.requirements) != null) {
            return false;
        }
        if (this.isWelcomeWand && mage.hasGivenWelcomeWand()) {
            return false;
        }
        if (this.getRemainingCooldown(mage) > 0L) {
            return false;
        }
        return !this.isWorldSpecific() || (location = apiMage.getLocation()) != null && this.isWorld(location.getWorld());
    }

    public void checkGive(Mage mage) {
        MageKit kit = mage.getKit(this.key);
        if (kit != null && !this.isPartial) {
            return;
        }
        this.give(mage, true, true, kit);
    }

    public void giveMissing(Mage mage) {
        this.give(mage, true, false, null);
    }

    @Override
    public void give(com.elmakers.mine.bukkit.api.magic.Mage apiMage) {
        Mage mage = (Mage)apiMage;
        this.give(mage, false, false, null);
    }

    private void give(Mage mage, boolean onlyIfMissing, boolean useKit, MageKit givenKit) {
        if (!this.isAllowed(mage)) {
            return;
        }
        boolean gave = false;
        ArrayList<ItemStack> giveItems = new ArrayList<ItemStack>();
        if (this.slotItems != null) {
            for (Map.Entry<Integer, ItemData> slotItem : this.slotItems.entrySet()) {
                int slot = slotItem.getKey();
                ItemData itemData = slotItem.getValue();
                ItemStack itemStack = itemData.getItemStack();
                if (CompatibilityLib.getItemUtils().isEmpty(itemStack) || onlyIfMissing && (itemStack = this.checkGiveIfMissing(itemData.getBaseKey(), itemStack, mage, useKit, givenKit)) == null) continue;
                ItemStack existingSlot = mage.getItem(slot);
                mage.gaveItemFromKit(this.key, itemData.getBaseKey(), itemStack.getAmount());
                if (CompatibilityLib.getItemUtils().isEmpty(existingSlot)) {
                    mage.setItem(slot, itemStack);
                    gave = true;
                    continue;
                }
                if (giveItems == null) {
                    giveItems = new ArrayList();
                }
                giveItems.add(itemStack);
            }
        }
        if (giveItems != null) {
            for (ItemStack giveItem : giveItems) {
                mage.giveItem(giveItem);
                gave = true;
            }
        }
        if (this.items != null) {
            for (ItemData itemData : this.items) {
                ItemStack itemStack = itemData.getItemStack();
                if (CompatibilityLib.getItemUtils().isEmpty(itemStack) || onlyIfMissing && (itemStack = this.checkGiveIfMissing(itemData.getBaseKey(), itemStack, mage, useKit, givenKit)) == null) continue;
                mage.gaveItemFromKit(this.key, itemData.getBaseKey(), itemStack.getAmount());
                mage.giveItem(itemStack);
                gave = true;
            }
        }
        if (gave) {
            mage.sendMessage(this.controller.getMessages().get("kits." + this.key + ".give", ""));
        }
    }

    @Nullable
    private ItemStack checkGiveIfMissing(String itemKey, ItemStack itemStack, Mage mage, boolean useKit, MageKit givenKit) {
        if (useKit) {
            int givenAmount;
            int n = givenAmount = givenKit == null ? 0 : givenKit.getGivenAmount(itemKey);
            if (givenAmount >= itemStack.getAmount()) {
                return null;
            }
            if (givenAmount > 0) {
                if (!this.isPartial) {
                    return null;
                }
                itemStack.setAmount(itemStack.getAmount() - givenAmount);
            }
        } else if (mage.hasItem(itemStack)) {
            return null;
        }
        return itemStack;
    }

    private void removeFrom(Mage mage) {
        ArrayList<ItemData> removeItems = new ArrayList<ItemData>();
        if (this.slotItems != null) {
            removeItems.addAll(this.slotItems.values());
        }
        if (this.items != null) {
            removeItems.addAll(this.items);
        }
        for (ItemData itemData : removeItems) {
            ItemStack itemStack = itemData.getItemStack();
            if (!mage.hasItem(itemStack)) continue;
            mage.tookItemFromKit(this.key, itemData.getBaseKey());
            mage.removeItem(itemStack);
        }
    }

    public void checkRemoveFrom(Mage mage) {
        if (this.isAllowed(mage)) {
            return;
        }
        this.removeFrom(mage);
    }

    @Override
    public String getName() {
        return this.controller.getMessages().get("kits." + this.key + ".name", this.name);
    }

    @Override
    public String getDescription() {
        return this.controller.getMessages().get("kits." + this.key + ".description", this.description);
    }

    @Override
    @Nullable
    public String getIconKey() {
        return this.icon;
    }

    @Override
    @Nullable
    public String getIconDisabledKey() {
        return this.iconDisabled;
    }

    @Override
    public double getWorth() {
        if (this.worth != null) {
            return this.worth;
        }
        double computed = 0.0;
        if (this.items != null) {
            for (ItemData item : this.items) {
                computed += item.getWorth();
            }
        }
        if (this.slotItems != null) {
            for (ItemData item : this.slotItems.values()) {
                computed += item.getWorth();
            }
        }
        return computed;
    }

    public boolean isWorld(World world) {
        if (this.allWorlds) {
            return true;
        }
        if (world == null || !this.isWorldSpecific()) {
            return false;
        }
        return this.worlds.contains(world.getName());
    }

    public boolean isWorldSpecific() {
        return this.worlds != null;
    }

    @Override
    public int compareTo(@NotNull MagicKit o) {
        return Integer.compare(o.priority, this.priority);
    }
}

