/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.item.Cost;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MageModifier;
import com.elmakers.mine.bukkit.boss.BossBarConfiguration;
import com.elmakers.mine.bukkit.boss.BossBarTracker;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.entity.EntityMageData;
import com.elmakers.mine.bukkit.entity.SpawnedEntityExtraData;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.tasks.DisguiseTask;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class EntityData
implements com.elmakers.mine.bukkit.api.entity.EntityData {
    protected static Map<UUID, WeakReference<Entity>> respawned = new HashMap<UUID, WeakReference<Entity>>();
    public static boolean isSpawning = false;
    private static int mobStackSize = 0;
    private static final int maxMobStackSize = 255;
    @Nonnull
    private final MageController controller;
    protected String key;
    protected WeakReference<Entity> entity = null;
    protected UUID uuid = null;
    protected EntityType type;
    protected EntityExtraData extraData;
    protected Location location;
    protected Vector relativeLocation;
    protected boolean hasMoved = false;
    protected boolean hasChangedHealth = false;
    protected boolean isTemporary = false;
    protected boolean cancelExplosion = false;
    protected boolean magicSpawned = false;
    private boolean respawn = true;
    protected String name = null;
    protected Double maxHealth;
    protected Double health;
    protected Integer airLevel;
    protected boolean isBaby;
    protected boolean isSilent;
    protected boolean isTamed;
    protected boolean isSitting;
    protected boolean isInvulnerable;
    protected boolean isAware = true;
    protected boolean hasAI = true;
    protected boolean hasGravity = true;
    protected boolean isDocile;
    protected boolean transformable = true;
    protected boolean combustible = true;
    protected boolean isStatic = false;
    protected boolean preventProjectiles;
    protected boolean preventMelee;
    protected boolean nameVisible;
    protected boolean isNPC;
    protected boolean isHidden;
    protected boolean useNPCName;
    protected boolean preventDismount;
    protected boolean preventTeleport;
    protected boolean equipOnRespawn = true;
    protected Boolean invisible = null;
    protected Boolean persistentInvisible = null;
    protected Boolean persist = null;
    protected Boolean removeWhenFarAway = null;
    protected int fireTicks;
    protected Set<String> permissions;
    protected Collection<PotionEffect> potionEffects = null;
    protected Collection<PotionEffectType> removeEffects = null;
    protected Map<String, ConfigurationSection> modifiers = null;
    protected Collection<String> removeModifiers = null;
    protected Map<Attribute, Double> attributes = null;
    protected Vector velocity = null;
    protected boolean hasPotionEffects = false;
    protected boolean hasVelocity = false;
    protected boolean isLiving = false;
    protected boolean isProjectile = false;
    protected boolean canPickupItems = false;
    protected boolean isSuperProtected = false;
    protected boolean registerByName = false;
    protected ItemData itemInHand;
    protected ItemData itemInOffhand;
    protected ItemData helmet;
    protected ItemData chestplate;
    protected ItemData leggings;
    protected ItemData boots;
    protected Integer xp;
    protected Integer dropXp;
    protected boolean defaultDrops;
    protected boolean dropsRequirePlayerKiller;
    protected List<Deque<WeightedPair<String>>> drops;
    protected Set<String> tags;
    protected Set<String> removeMounts;
    protected String interactSpell;
    protected String interactPermission;
    protected boolean interactRequiresOwner;
    protected List<Cost> interactCosts;
    protected ConfigurationSection interactSpellParameters;
    protected EntityData.SourceType interactSpellSource;
    protected EntityData.TargetType interactSpellTarget;
    protected EntityData.SourceType interactCommandSource;
    protected List<String> interactCommands;
    protected boolean cancelInteract;
    protected ConfigurationSection disguise;
    protected ConfigurationSection model;
    protected BossBarConfiguration bossBar;
    protected EntityMageData mageData;
    protected EntityData mount;
    protected String mountType;
    protected ConfigurationSection configuration;

    public EntityData(MageController controller, Entity entity) {
        this.controller = controller;
        this.setEntity(entity);
        this.location = CompatibilityLib.getCompatibilityUtils().getHangingLocation(entity);
        this.magicSpawned = CompatibilityLib.getEntityMetadataUtils().getBoolean(entity, MagicMetaKeys.MAGIC_SPAWNED);
        this.cancelExplosion = CompatibilityLib.getEntityMetadataUtils().getBoolean(entity, MagicMetaKeys.CANCEL_EXPLOSION);
        this.isLiving = entity instanceof LivingEntity;
        this.isProjectile = entity instanceof Projectile;
        this.type = entity.getType();
        this.fireTicks = entity.getFireTicks();
        this.isSilent = CompatibilityLib.getCompatibilityUtils().isSilent(entity);
        this.invisible = CompatibilityLib.getCompatibilityUtils().isInvisible(entity);
        this.persistentInvisible = CompatibilityLib.getCompatibilityUtils().isPersistentInvisible(entity);
        this.canPickupItems = entity instanceof Creature ? ((Creature)entity).getCanPickupItems() : false;
        this.name = entity.getCustomName();
        this.nameVisible = entity.isCustomNameVisible();
        this.tags = CompatibilityLib.getCompatibilityUtils().getTags(entity);
        try {
            this.velocity = entity.getVelocity();
        }
        catch (Exception ex) {
            this.velocity = null;
        }
        this.isAware = CompatibilityLib.getCompatibilityUtils().isAware(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            this.health = li.getHealth();
            this.potionEffects = li.getActivePotionEffects();
            this.airLevel = li.getRemainingAir();
            this.maxHealth = CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)li);
            this.hasAI = li.hasAI();
            this.itemInHand = this.getItem(li.getEquipment().getItemInMainHand());
            this.itemInOffhand = this.getItem(li.getEquipment().getItemInOffHand());
            this.helmet = this.getItem(li.getEquipment().getHelmet());
            this.chestplate = this.getItem(li.getEquipment().getChestplate());
            this.leggings = this.getItem(li.getEquipment().getLeggings());
            this.boots = this.getItem(li.getEquipment().getBoots());
        }
        if (entity instanceof Tameable) {
            this.isTamed = ((Tameable)entity).isTamed();
        }
        this.isSitting = CompatibilityLib.getCompatibilityUtils().isSitting(entity);
        this.isInvulnerable = CompatibilityLib.getCompatibilityUtils().isInvulnerable(entity);
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            boolean bl = this.isBaby = !ageable.isAdult();
        }
        if (entity instanceof ExperienceOrb) {
            this.xp = ((ExperienceOrb)entity).getExperience();
        }
        this.extraData = CompatibilityLib.getEntityUtils().getExtraData(controller, entity);
    }

    public EntityData(MageController controller, EntityType type) {
        this.controller = controller;
        this.type = type;
    }

    public EntityData(@Nonnull MageController controller, @Nonnull String key, ConfigurationSection parameters) {
        this.controller = controller;
        this.key = key;
        this.load(parameters);
    }

    public EntityData(@Nonnull MageController controller, ConfigurationSection parameters) {
        this.controller = controller;
        this.load(parameters);
    }

    @Nullable
    private ItemData getItem(ItemStack item) {
        return item == null ? null : this.controller.createItemData(item);
    }

    @Override
    @Deprecated
    public ItemStack getItem() {
        return null;
    }

    @Override
    @Deprecated
    public void load(@Nonnull MageController controller, ConfigurationSection parameters) {
        this.load(parameters);
    }

    @Override
    public void load(ConfigurationSection parameters) {
        String modelId;
        ConfigurationSection mountConfig;
        String entityName;
        this.configuration = parameters;
        this.hasChangedHealth = true;
        this.name = parameters.getString("name");
        if (this.name == null && this.key != null) {
            this.name = this.controller.getMessages().getIfSet("mobs." + this.key + ".name");
        }
        if (this.name != null) {
            this.name = CompatibilityLib.getCompatibilityUtils().translateColors(this.name);
        }
        this.registerByName = true;
        if (this.name != null && (this.name.equals("Grumm") || this.name.equals("Dinnerbone") || this.name.equals("jeb_"))) {
            this.registerByName = false;
        }
        this.registerByName = parameters.getBoolean("register_by_name", this.registerByName);
        this.isNPC = parameters.getBoolean("npc");
        this.isStatic = parameters.getBoolean("static", this.isNPC);
        this.useNPCName = parameters.getBoolean("use_npc_name", false);
        this.isHidden = parameters.getBoolean("hidden");
        this.nameVisible = parameters.getBoolean("show_name");
        if (parameters.contains("health")) {
            this.maxHealth = this.health = Double.valueOf(parameters.getDouble("health", 1.0));
        }
        if (parameters.contains("max_health")) {
            this.maxHealth = parameters.getDouble("max_health", 1.0);
        }
        this.isSilent = parameters.getBoolean("silent", false);
        if (parameters.contains("persist")) {
            this.persist = parameters.getBoolean("persist");
        }
        if (parameters.contains("remove_when_far_away")) {
            this.removeWhenFarAway = parameters.getBoolean("remove_when_far_away");
        } else if (this.persist != null && this.persist.booleanValue()) {
            this.removeWhenFarAway = false;
        }
        if (parameters.contains("invisible")) {
            this.persistentInvisible = this.invisible = Boolean.valueOf(parameters.getBoolean("invisible"));
        }
        this.isDocile = parameters.getBoolean("docile");
        this.transformable = parameters.getBoolean("transformable", true);
        this.combustible = parameters.getBoolean("combustible", true);
        this.preventProjectiles = parameters.getBoolean("prevent_projectiles", false);
        this.preventMelee = parameters.getBoolean("prevent_melee", false);
        this.bossBar = BossBarConfiguration.parse(this.controller, parameters, "$pn");
        this.preventDismount = parameters.getBoolean("prevent_dismount", false);
        this.preventTeleport = parameters.getBoolean("prevent_teleport", false);
        this.cancelExplosion = parameters.getBoolean("cancel_explosion", false);
        this.equipOnRespawn = parameters.getBoolean("equip_on_respawn", true);
        List<String> permissionsList = ConfigurationUtils.getStringList(parameters, "permissions");
        if (permissionsList != null && !permissionsList.isEmpty()) {
            this.permissions = new HashSet<String>(permissionsList);
        }
        String string = entityName = parameters.contains("type") ? parameters.getString("type") : this.key;
        if (entityName != null && !entityName.isEmpty()) {
            this.type = EntityData.parseEntityType(entityName);
            if (this.type == null) {
                String message = " Invalid entity type: " + entityName + " in mob config";
                if (this.key != null) {
                    message = message + " " + this.key;
                }
                if (this.key != null && entityName.equals(this.key)) {
                    message = message + ", did you forget the 'type' parameter?";
                }
                this.controller.getLogger().log(Level.WARNING, message);
                return;
            }
        }
        if ((mountConfig = ConfigurationUtils.getConfigurationSection(parameters, "mount")) != null) {
            this.mount = new EntityData(this.controller, mountConfig);
        } else {
            this.mountType = parameters.getString("mount");
        }
        List<String> removeMountKeys = ConfigurationUtils.getStringList(parameters, "remove_mounts");
        if (removeMountKeys != null && !removeMountKeys.isEmpty()) {
            this.removeMounts = new HashSet<String>(removeMountKeys);
        }
        this.disguise = ConfigurationUtils.getConfigurationSection(parameters, "disguise");
        this.model = ConfigurationUtils.getConfigurationSection(parameters, "model");
        if (this.model == null && (modelId = parameters.getString("model")) != null && !modelId.isEmpty()) {
            this.model = ConfigurationUtils.newConfigurationSection();
            this.model.set("id", (Object)modelId);
        }
        this.isTamed = parameters.getBoolean("tamed", false);
        this.isSitting = parameters.getBoolean("sitting", false);
        this.isInvulnerable = parameters.getBoolean("invulnerable", false);
        this.isBaby = parameters.getBoolean("baby", false);
        this.hasAI = parameters.getBoolean("ai", true);
        this.isAware = parameters.getBoolean("aware", true);
        this.hasGravity = parameters.getBoolean("gravity", true);
        this.isSuperProtected = parameters.getBoolean("protected", false);
        this.potionEffects = ConfigurationUtils.getPotionEffectObjects(parameters, "potion_effects", this.controller.getLogger());
        this.hasPotionEffects = this.potionEffects != null && !this.potionEffects.isEmpty();
        ConfigurationSection modifierSection = parameters.getConfigurationSection("modifiers");
        if (modifierSection == null) {
            List<String> modifierList = ConfigurationUtils.getStringList(parameters, "modifiers");
            if (modifierList != null) {
                this.modifiers = new HashMap<String, ConfigurationSection>();
                for (String addKey : modifierList) {
                    this.modifiers.put(addKey, null);
                }
            }
        } else {
            this.modifiers = new HashMap<String, ConfigurationSection>();
            for (String addKey : modifierSection.getKeys(false)) {
                this.modifiers.put(addKey, modifierSection.getConfigurationSection(addKey));
            }
        }
        this.defaultDrops = parameters.getBoolean("default_drops", true);
        this.dropsRequirePlayerKiller = parameters.getBoolean("drops_require_player_killer", false);
        if (parameters.contains("xp")) {
            this.xp = parameters.getInt("xp");
        }
        if (parameters.contains("drop_xp")) {
            this.dropXp = parameters.getInt("drop_xp");
        }
        this.interactSpell = parameters.getString("interact_spell");
        this.interactSpellParameters = ConfigurationUtils.getConfigurationSection(parameters, "interact_spell_parameters");
        List<com.elmakers.mine.bukkit.item.Cost> interactCosts = com.elmakers.mine.bukkit.item.Cost.parseCosts(ConfigurationUtils.getConfigurationSection(parameters, "interact_costs"), this.controller);
        this.interactCosts = interactCosts == null ? null : new ArrayList<com.elmakers.mine.bukkit.item.Cost>(interactCosts);
        this.interactPermission = parameters.getString("interact_permission");
        this.interactRequiresOwner = parameters.getBoolean("interact_requires_owner", false);
        String sourceType = parameters.getString("interact_spell_source", "PLAYER");
        if (sourceType.equalsIgnoreCase("NPC")) {
            sourceType = "MOB";
        } else if (sourceType.equalsIgnoreCase("OPPED_PLAYER")) {
            this.controller.getLogger().warning("Invalid spell source type: " + sourceType);
            sourceType = "PLAYER";
        }
        try {
            this.interactSpellSource = EntityData.SourceType.valueOf(sourceType.toUpperCase());
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("Invalid mob source type: " + sourceType);
            this.interactSpellSource = EntityData.SourceType.PLAYER;
        }
        String targetType = parameters.getString("interact_spell_target", "MOB");
        if (targetType.equalsIgnoreCase("NPC")) {
            targetType = "MOB";
        }
        try {
            this.interactSpellTarget = EntityData.TargetType.valueOf(targetType.toUpperCase());
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("Invalid mob target type: " + targetType);
            this.interactSpellTarget = EntityData.TargetType.MOB;
        }
        sourceType = parameters.getString("interact_command_source", "CONSOLE");
        if (sourceType.equalsIgnoreCase("MOB") || sourceType.equalsIgnoreCase("NPC")) {
            this.controller.getLogger().warning("Invalid command source type: " + sourceType);
            sourceType = "CONSOLE";
        }
        try {
            this.interactCommandSource = EntityData.SourceType.valueOf(sourceType.toUpperCase());
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("Invalid command source type: " + sourceType);
            this.interactCommandSource = EntityData.SourceType.CONSOLE;
        }
        this.interactCommands = ConfigurationUtils.getStringList(parameters, "interact_commands", ";");
        if (parameters.isList("drops")) {
            List list = parameters.getList("drops");
            this.drops = new ArrayList<Deque<WeightedPair<String>>>();
            for (Object item : list) {
                ArrayDeque<WeightedPair<String>> dropProbability;
                if (item instanceof Map || item instanceof ConfigurationSection) {
                    ConfigurationSection table = null;
                    table = item instanceof Map ? ConfigurationUtils.toConfigurationSection(parameters, (Map)item) : (ConfigurationSection)item;
                    dropProbability = new ArrayDeque();
                    RandomUtils.populateStringProbabilityMap(dropProbability, table, 0, 0, 0.0f);
                    this.drops.add(dropProbability);
                    continue;
                }
                List<String> dropList = ConfigurationUtils.getStringList(item);
                if (dropList == null) continue;
                dropProbability = new ArrayDeque<WeightedPair<String>>();
                RandomUtils.populateStringProbabilityList(dropProbability, dropList);
                this.drops.add(dropProbability);
            }
        }
        this.cancelInteract = parameters.getBoolean("cancel_interact");
        List<String> tagList = ConfigurationUtils.getStringList(parameters, "tags");
        if (tagList != null) {
            this.tags = new HashSet<String>(tagList);
        }
        try {
            this.extraData = this.type == null ? null : CompatibilityLib.getEntityUtils().getExtraData(this.controller, this.type, parameters);
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Invalid entity type or sub-type", ex);
        }
        ConfigurationSection attributeConfiguration = ConfigurationUtils.getConfigurationSection(parameters, "entity_attributes");
        ConfigurationSection migrateAttributes = ConfigurationUtils.getConfigurationSection(parameters, "attributes");
        if (migrateAttributes != null) {
            boolean nagged = false;
            Set keys = migrateAttributes.getKeys(false);
            for (String attributeKey : keys) {
                try {
                    Attribute.valueOf((String)attributeKey.toUpperCase());
                }
                catch (IllegalArgumentException ignored) {
                    continue;
                }
                if (attributeConfiguration == null) {
                    attributeConfiguration = parameters.createSection("entity_attributes");
                }
                attributeConfiguration.set(attributeKey, migrateAttributes.get(attributeKey));
                parameters.set("attributes", null);
                if (this.key == null || nagged) continue;
                this.controller.getLogger().warning("You have vanilla entity attributes in the 'attributes' property of mob template '" + this.key + "', please rename that to entity_attributes.");
                nagged = true;
            }
        }
        if (attributeConfiguration != null) {
            Set keys = attributeConfiguration.getKeys(false);
            if (keys.size() > 0) {
                this.attributes = new HashMap<Attribute, Double>();
            }
            for (String attributeKey : keys) {
                try {
                    Attribute attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
                    this.attributes.put(attribute, attributeConfiguration.getDouble(attributeKey));
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.WARNING, "Invalid attribute type: " + attributeKey);
                }
            }
        }
        this.itemInHand = this.controller.getOrCreateItem(parameters.getString("item"));
        this.itemInOffhand = this.controller.getOrCreateItem(parameters.getString("offhand"));
        this.helmet = this.controller.getOrCreateItem(parameters.getString("helmet"));
        this.chestplate = this.controller.getOrCreateItem(parameters.getString("chestplate"));
        this.leggings = this.controller.getOrCreateItem(parameters.getString("leggings"));
        this.boots = this.controller.getOrCreateItem(parameters.getString("boots"));
        this.canPickupItems = parameters.getBoolean("can_pickup_items", false);
        EntityMageData mageData = new EntityMageData(this.controller, parameters);
        if (!mageData.isEmpty()) {
            this.mageData = mageData;
        }
    }

    public static EntityData loadPainting(MageController controller, Vector location, Art art, BlockFace direction) {
        EntityData data = new EntityData(controller, EntityType.PAINTING);
        data.extraData = CompatibilityLib.getEntityUtils().getPaintingData(art, direction);
        data.relativeLocation = location.clone();
        return data;
    }

    public static EntityData loadItemFrame(MageController controller, Vector location, ItemStack item, BlockFace direction, Rotation rotation) {
        EntityData data = new EntityData(controller, EntityType.ITEM_FRAME);
        data.extraData = CompatibilityLib.getEntityUtils().getItemFrameData(item, direction, rotation);
        data.relativeLocation = location.clone();
        return data;
    }

    public void setEntity(Entity entity) {
        this.entity = entity == null ? null : new WeakReference<Entity>(entity);
        this.uuid = entity == null ? null : entity.getUniqueId();
    }

    @Nullable
    public static EntityType parseEntityType(String typeString) {
        if (typeString == null) {
            return null;
        }
        EntityType returnType = null;
        try {
            returnType = EntityType.valueOf((String)typeString.toUpperCase());
        }
        catch (Exception ex) {
            returnType = null;
        }
        if (returnType == null) {
            returnType = EntityType.fromName((String)typeString);
        }
        return returnType;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public EntityType getType() {
        return this.type;
    }

    @Override
    @Deprecated
    public Art getArt() {
        return null;
    }

    @Override
    @Deprecated
    public BlockFace getFacing() {
        return BlockFace.SELF;
    }

    @Override
    public double getHealth() {
        return this.health == null ? 0.0 : this.health;
    }

    @Nullable
    protected Entity trySpawn(CreatureSpawnEvent.SpawnReason reason) {
        Entity spawned = null;
        boolean addedToWorld = false;
        if (this.type != null && this.type != EntityType.PLAYER) {
            try {
                SpawnedEntityExtraData spawnedEntity = null;
                if (this.extraData != null) {
                    spawnedEntity = this.extraData.spawn(this.location);
                }
                if (spawnedEntity != null) {
                    spawned = spawnedEntity.getEntity();
                    addedToWorld = spawnedEntity.isAddedToWorld();
                } else {
                    spawned = CompatibilityLib.getCompatibilityUtils().createEntity(this.location, this.type);
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error restoring entity type " + this.getType() + " at " + this.getLocation(), ex);
            }
        }
        if (spawned != null) {
            try {
                this.modifyPreSpawn(spawned, true);
                if (!addedToWorld) {
                    isSpawning = true;
                    reason = reason == null ? CreatureSpawnEvent.SpawnReason.CUSTOM : reason;
                    CompatibilityLib.getCompatibilityUtils().addToWorld(this.location.getWorld(), spawned, reason);
                    isSpawning = false;
                }
                this.modifyPostSpawn(spawned);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error restoring entity properties for] " + this.getType() + " at " + this.getLocation(), ex);
            }
        }
        return spawned;
    }

    @Override
    @Nullable
    public EntityData getRelativeTo(Location center) {
        EntityData copy = this.clone();
        if (copy != null) {
            if (this.relativeLocation != null) {
                copy.location = center.clone().add(this.relativeLocation);
            } else if (this.location != null) {
                copy.location = this.location.clone();
            }
        }
        return copy;
    }

    @Override
    @Nullable
    public Entity spawn() {
        return this.spawn((Location)null, null);
    }

    @Override
    @Nullable
    public Entity spawn(Location location) {
        return this.spawn(location, null);
    }

    @Override
    @Deprecated
    @Nullable
    public Entity spawn(MageController controller) {
        return this.spawn((Location)null, null);
    }

    @Override
    @Deprecated
    @Nullable
    public Entity spawn(MageController controller, Location location) {
        return this.spawn(location, null);
    }

    @Override
    @Deprecated
    @Nullable
    public Entity spawn(MageController controller, Location location, CreatureSpawnEvent.SpawnReason reason) {
        return this.spawn(location, reason);
    }

    @Override
    @Nullable
    public Entity spawn(Location location, CreatureSpawnEvent.SpawnReason reason) {
        com.elmakers.mine.bukkit.api.magic.Mage mage;
        if (location != null) {
            this.location = location;
        } else if (this.location == null) {
            return null;
        }
        Entity entity = this.trySpawn(reason);
        if (entity != null && this.mageData != null && (mage = this.controller.getMage(entity)) != null) {
            this.mageData.trigger(mage, "spawn");
        }
        return entity;
    }

    @Override
    @Nullable
    public Entity undo() {
        Entity entity = this.getEntity();
        if (!(!this.respawn || this.isTemporary || this.magicSpawned || this.uuid == null || entity != null && entity.isValid() && !entity.isDead() || entity instanceof Player)) {
            com.elmakers.mine.bukkit.api.magic.Mage mage;
            WeakReference<Entity> respawnedEntity = respawned.get(this.uuid);
            if (respawnedEntity != null) {
                entity = (Entity)respawnedEntity.get();
            } else {
                entity = this.trySpawn(null);
                if (entity != null) {
                    respawned.put(this.uuid, new WeakReference<Entity>(entity));
                    CompatibilityLib.getEntityMetadataUtils().setBoolean(entity, MagicMetaKeys.NO_DROPS, true);
                }
            }
            if (entity != null && this.mageData != null && (mage = this.controller.getMage(entity)) != null) {
                this.mageData.trigger(mage, "respawn");
            }
            this.setEntity(entity);
        } else if (entity != null) {
            this.modify(entity, false);
        }
        return entity;
    }

    @Override
    public boolean respawned(Entity entity) {
        com.elmakers.mine.bukkit.api.magic.Mage mage;
        boolean success = this.modify(entity, true);
        if (success && this.mageData != null && (mage = this.controller.getMage(entity)) != null) {
            this.mageData.trigger(mage, "respawn");
        }
        return success;
    }

    public Entity respawn() {
        com.elmakers.mine.bukkit.api.magic.Mage mage;
        Entity entity = this.spawn();
        if (entity != null && this.mageData != null && (mage = this.controller.getMage(entity)) != null) {
            this.mageData.trigger(mage, "respawn");
        }
        return entity;
    }

    @Override
    @Deprecated
    public boolean modify(MageController controller, Entity entity) {
        return this.modify(entity);
    }

    @Override
    public boolean modify(Entity entity) {
        return this.modify(entity, true);
    }

    private boolean modify(Entity entity, boolean register) {
        if (entity.isDead()) {
            return false;
        }
        if (register && !(entity instanceof Player)) {
            this.controller.registerMob(entity, this);
        }
        boolean modifiedPre = this.modifyPreSpawn(entity, false);
        boolean modifiedPost = this.modifyPostSpawn(entity);
        return modifiedPre || modifiedPost;
    }

    private boolean modifyPreSpawn(Entity entity, boolean isFirstSpawn) {
        Set<String> entityTags;
        if (entity == null || this.type != null && entity.getType() != this.type) {
            return false;
        }
        if (!(entity instanceof Player)) {
            this.controller.registerMob(entity, this);
        }
        boolean isPlayer = entity instanceof Player;
        if (this.extraData != null) {
            this.extraData.apply(entity);
        }
        if (this.persist != null) {
            CompatibilityLib.getCompatibilityUtils().setPersist(entity, this.persist);
        }
        if (this.invisible != null) {
            CompatibilityLib.getCompatibilityUtils().setInvisible(entity, (boolean)this.invisible);
        }
        if (this.persistentInvisible != null) {
            CompatibilityLib.getCompatibilityUtils().setPersistentInvisible(entity, this.persistentInvisible);
        }
        if (this.removeWhenFarAway != null) {
            CompatibilityLib.getCompatibilityUtils().setRemoveWhenFarAway(entity, this.removeWhenFarAway);
        }
        CompatibilityLib.getCompatibilityUtils().setSilent(entity, this.isSilent);
        entity.setFireTicks(this.fireTicks);
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            if (this.isBaby) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        }
        if (entity instanceof Tameable) {
            ((Tameable)entity).setTamed(this.isTamed);
        }
        CompatibilityLib.getCompatibilityUtils().setSitting(entity, this.isSitting);
        CompatibilityLib.getCompatibilityUtils().setInvulnerable(entity, this.isInvulnerable);
        if (this.tags != null && !this.tags.isEmpty() && (entityTags = CompatibilityLib.getCompatibilityUtils().getTags(entity)) != null) {
            entityTags.addAll(this.tags);
        }
        if (entity instanceof Creature) {
            Creature creature = (Creature)entity;
            creature.setCanPickupItems(this.canPickupItems);
        }
        if (entity instanceof ExperienceOrb && this.xp != null) {
            ((ExperienceOrb)entity).setExperience(this.xp.intValue());
        }
        if (!this.hasGravity && !(entity instanceof ArmorStand)) {
            CompatibilityLib.getCompatibilityUtils().setGravity(entity, this.hasGravity);
        }
        if (!this.isAware) {
            CompatibilityLib.getCompatibilityUtils().setAware(entity, false);
        }
        if (entity instanceof LivingEntity) {
            com.elmakers.mine.bukkit.api.magic.Mage mage;
            LivingEntity li = (LivingEntity)entity;
            if (this.hasPotionEffects && this.potionEffects != null) {
                for (PotionEffect effect : this.potionEffects) {
                    li.addPotionEffect(effect);
                }
            }
            if (this.removeEffects != null) {
                for (PotionEffectType effectType : this.removeEffects) {
                    li.removePotionEffect(effectType);
                }
            }
            if ((this.modifiers != null || this.removeModifiers != null) && (mage = this.controller.getRegisteredMage((Entity)li)) != null) {
                if (this.modifiers != null) {
                    for (Map.Entry entry : this.modifiers.entrySet()) {
                        mage.addModifier((String)entry.getKey(), (ConfigurationSection)entry.getValue());
                    }
                }
                if (this.removeModifiers != null) {
                    for (String string : this.removeModifiers) {
                        mage.removeModifier(string);
                    }
                }
            }
            try {
                if (!isPlayer) {
                    this.applyAttributes(li);
                    if (this.equipOnRespawn || isFirstSpawn) {
                        this.copyEquipmentTo(li);
                    }
                    if (this.maxHealth != null) {
                        CompatibilityLib.getCompatibilityUtils().setMaxHealth((Damageable)li, this.maxHealth);
                    }
                }
                if (this.health != null && this.hasChangedHealth) {
                    li.setHealth(Math.min(this.health, CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)li)));
                }
                if (this.airLevel != null) {
                    li.setRemainingAir(Math.min(this.airLevel, li.getRemainingAir()));
                }
                if (!this.hasAI) {
                    li.setAI(this.hasAI);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (!isPlayer && this.name != null && this.name.length() > 0) {
            entity.setCustomName(this.name);
        }
        if (!isPlayer) {
            entity.setCustomNameVisible(this.nameVisible);
        }
        this.attachToMage(entity);
        if (this.disguise != null) {
            this.tryDisguise(entity, this.disguise);
            int redisguise = this.disguise.getString("type", "").equalsIgnoreCase("player") ? 2 : 0;
            redisguise = this.disguise.getInt("redisguise", redisguise);
            if (redisguise > 0) {
                Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), (Runnable)new DisguiseTask(this.controller, entity, this.disguise), (long)redisguise);
            }
        }
        if (this.model != null && !this.controller.getModelEngine().applyModel(entity, this.model)) {
            this.controller.getLogger().warning("Invalid model config in mob " + this.getName() + " (" + this.getKey() + ")");
        }
        return true;
    }

    private void tryDisguise(Entity entity, ConfigurationSection disguise) {
        if (!this.controller.hasDisguises()) {
            return;
        }
        if (!this.controller.disguise(entity, disguise)) {
            this.controller.getLogger().warning("Invalid disguise type in mob " + this.getName() + " (" + this.getKey() + "): " + disguise.getString("type"));
        }
    }

    @Override
    @Deprecated
    public void attach(@Nonnull MageController controller, @Nonnull Entity entity) {
        this.attach(entity);
    }

    @Override
    public void attach(@Nonnull Entity entity) {
        this.attachToMage(entity);
    }

    public com.elmakers.mine.bukkit.api.magic.Mage attachToMage(@Nonnull Entity entity) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = null;
        if (this.mageData != null) {
            apiMage = this.controller.getMage(entity);
            if (apiMage.getEntityData() == this) {
                return apiMage;
            }
            if (apiMage instanceof Mage) {
                ((Mage)apiMage).setEntityData(this);
            }
            this.mageData.resetTriggers();
        }
        return apiMage;
    }

    @Nullable
    public ConfigurationSection getMageProperties() {
        return this.mageData != null ? this.mageData.mageProperties : null;
    }

    private boolean modifyPostSpawn(Entity entity) {
        if (entity == null || this.type != null && entity.getType() != this.type) {
            return false;
        }
        if (this.hasMoved && this.location != null && !this.location.equals((Object)entity.getLocation())) {
            entity.teleport(this.location);
        }
        if (this.hasVelocity && this.velocity != null) {
            SafetyUtils.setVelocity(entity, this.velocity);
        }
        if (this.mount == null && this.mountType != null) {
            this.mount = (EntityData)this.controller.getMob(this.mountType);
            if (this.mount == null) {
                this.controller.getLogger().warning("Mob " + this.key + " has invalid mount: " + this.mountType);
            }
        }
        if (this.mount != null) {
            Entity mountEntity = entity.getVehicle();
            boolean allowMount = true;
            if (++mobStackSize > 255) {
                this.controller.getLogger().warning("Mob " + this.key + " has more than " + 255 + " mounts");
                allowMount = false;
            }
            if (mountEntity == null) {
                mountEntity = this.mount.spawn(entity.getLocation());
            } else if (mountEntity.getType() == this.mount.getType()) {
                allowMount = false;
                this.mount.modify(mountEntity);
            } else {
                mountEntity.remove();
                entity.eject();
                mountEntity = this.mount.spawn(entity.getLocation());
            }
            if (allowMount && mountEntity != null) {
                CompatibilityLib.getCompatibilityUtils().addPassenger(mountEntity, entity);
            }
            --mobStackSize;
        }
        if (this.cancelExplosion) {
            CompatibilityLib.getEntityMetadataUtils().setBoolean(entity, MagicMetaKeys.CANCEL_EXPLOSION, true);
        }
        if (this.key != null) {
            CompatibilityLib.getEntityMetadataUtils().setString(entity, MagicMetaKeys.MAGIC_MOB, this.key);
        }
        if (this.invisible != null) {
            CompatibilityLib.getCompatibilityUtils().setInvisible(entity, (boolean)this.invisible);
        }
        if (this.extraData != null) {
            this.extraData.applyPostSpawn(entity);
        }
        return true;
    }

    public void applyAttributes(LivingEntity entity) {
        if (this.attributes != null) {
            for (Map.Entry<Attribute, Double> entry : this.attributes.entrySet()) {
                AttributeInstance attribute = entity.getAttribute(entry.getKey());
                if (attribute == null) continue;
                attribute.setBaseValue(entry.getValue().doubleValue());
            }
        }
    }

    public void copyEquipmentTo(LivingEntity entity) {
        if (this.itemInHand != null) {
            this.itemInHand.getItemStack(1, itemStack -> entity.getEquipment().setItemInMainHand(itemStack));
        }
        if (this.itemInOffhand != null) {
            this.itemInOffhand.getItemStack(1, itemStack -> entity.getEquipment().setItemInOffHand(itemStack));
        }
        if (this.helmet != null) {
            this.helmet.getItemStack(1, itemStack -> entity.getEquipment().setHelmet(itemStack));
        }
        if (this.chestplate != null) {
            this.chestplate.getItemStack(1, itemStack -> entity.getEquipment().setChestplate(itemStack));
        }
        if (this.leggings != null) {
            this.leggings.getItemStack(1, itemStack -> entity.getEquipment().setLeggings(itemStack));
        }
        if (this.boots != null) {
            this.boots.getItemStack(1, itemStack -> entity.getEquipment().setBoots(itemStack));
        }
    }

    @Override
    public void setHasMoved(boolean moved) {
        this.hasMoved = moved;
    }

    @Override
    public void setDamaged(boolean damaged) {
        this.hasChangedHealth = damaged;
    }

    public void setHasPotionEffects(boolean changed) {
        this.hasPotionEffects = changed;
    }

    public void addPotionEffectForRemoval(PotionEffectType potionEffectType) {
        if (this.removeEffects == null) {
            this.removeEffects = new ArrayList<PotionEffectType>();
        }
        this.removeEffects.add(potionEffectType);
    }

    public void addModifier(MageModifier modifier) {
        if (this.modifiers == null) {
            this.modifiers = new HashMap<String, ConfigurationSection>();
        }
        this.modifiers.put(modifier.getKey(), modifier.getConfiguration());
    }

    public void addModifierForRemoval(String modifierKey) {
        if (this.removeModifiers == null) {
            this.removeModifiers = new ArrayList<String>();
        }
        this.removeModifiers.add(modifierKey);
    }

    public void setHasVelocity(boolean hasVelocity) {
        this.hasVelocity = hasVelocity;
    }

    public boolean isLiving() {
        return this.isLiving;
    }

    public boolean isProjectile() {
        return this.isProjectile;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity == null ? null : (Entity)this.entity.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isRegisterByName() {
        return this.registerByName;
    }

    @Override
    public EntityData clone() {
        try {
            return (EntityData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return this;
        }
    }

    public boolean isRespawn() {
        return this.respawn;
    }

    public void setRespawn(boolean respawn) {
        this.respawn = respawn;
    }

    private void removeVehicles(Entity entity) {
        if ((entity = entity.getVehicle()) != null) {
            com.elmakers.mine.bukkit.api.entity.EntityData entityType;
            if (!(this.removeMounts.contains("*") || (entityType = this.controller.getMob(entity)) != null && this.removeMounts.contains(entityType.getKey()))) {
                return;
            }
            this.removeVehicles(entity);
            entity.remove();
        }
    }

    private void removePassengers(Entity entity) {
        List<Entity> passengers = CompatibilityLib.getCompatibilityUtils().getPassengers(entity);
        for (Entity passenger : passengers) {
            com.elmakers.mine.bukkit.api.entity.EntityData entityType;
            if (!this.removeMounts.contains("*") && ((entityType = this.controller.getMob(passenger)) == null || !this.removeMounts.contains(entityType.getKey()))) continue;
            this.removePassengers(passenger);
            passenger.remove();
        }
    }

    public void onDeath(Entity died) {
        if (this.removeMounts != null) {
            this.removeVehicles(died);
            this.removePassengers(died);
        }
    }

    public void modifyDrops(EntityDeathEvent event) {
        if (this.dropXp != null) {
            event.setDroppedExp(this.dropXp.intValue());
        }
        List dropList = event.getDrops();
        if (!this.defaultDrops) {
            dropList.clear();
        }
        if (this.dropsRequirePlayerKiller) {
            EntityDamageEvent lastDamage = event.getEntity().getLastDamageCause();
            if (!(lastDamage instanceof EntityDamageByEntityEvent)) {
                return;
            }
            Entity entity2 = ((EntityDamageByEntityEvent)lastDamage).getDamager();
            entity2 = this.controller.getDamageSource(entity2);
            if (!(entity2 instanceof Player) || entity2 == event.getEntity()) {
                return;
            }
        }
        if (this.drops != null) {
            for (Deque deque : this.drops) {
                ItemStack item;
                String key = (String)RandomUtils.weightedRandom(deque);
                if (key == null || key.equalsIgnoreCase("none") || (item = this.controller.createItem(key)) == null) continue;
                dropList.add(item);
            }
        }
    }

    @Override
    public String describe() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.type == null) {
            return "Unknown";
        }
        return this.type.name().toLowerCase();
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            return this.type.name().toLowerCase();
        }
        return this.key;
    }

    public long getTickInterval() {
        return this.mageData == null ? 0L : this.mageData.tickInterval;
    }

    public void tick(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (this.mageData != null) {
            this.mageData.tick(mage);
        }
    }

    public boolean trigger(com.elmakers.mine.bukkit.api.magic.Mage mage, String trigger) {
        if (this.mageData == null) {
            return false;
        }
        boolean result = this.mageData.trigger(mage, trigger);
        this.mageData.resetTriggers();
        return result;
    }

    @Override
    @Nullable
    public String getInteractSpell() {
        return this.interactSpell;
    }

    @Override
    @Nullable
    public ConfigurationSection getInteractSpellParameters() {
        return this.interactSpellParameters;
    }

    @Override
    public EntityData.SourceType getInteractSpellSource() {
        return this.interactSpellSource;
    }

    @Override
    public EntityData.TargetType getInteractSpellTarget() {
        return this.interactSpellTarget;
    }

    @Override
    @Nullable
    public List<String> getInteractCommands() {
        return this.interactCommands;
    }

    @Override
    public boolean hasInteract() {
        if (this.interactSpell != null && !this.interactSpell.isEmpty()) {
            return true;
        }
        if (this.interactCommands != null && !this.interactCommands.isEmpty()) {
            return true;
        }
        return this.cancelInteract;
    }

    @Override
    public EntityData.SourceType getInteractCommandSource() {
        return this.interactCommandSource;
    }

    @Override
    @Nullable
    public Collection<Cost> getInteractCosts() {
        return this.interactCosts;
    }

    public boolean shouldFocusOnDamager() {
        return this.mageData == null ? false : this.mageData.aggro;
    }

    public double getTrackRadiusSquared() {
        return this.mageData == null ? 0.0 : this.mageData.getTrackRadiusSquared();
    }

    @Override
    public void setMaterial(@Nonnull MaterialAndData material) {
        if (this.extraData != null) {
            this.extraData.setMaterialAndData(material);
        }
    }

    @Override
    @Nullable
    public MaterialAndData getMaterial() {
        if (this.extraData != null) {
            return this.extraData.getMaterialAndData();
        }
        return null;
    }

    public boolean isCancelLaunch() {
        return this.mageData != null ? this.mageData.isCancelLaunch : true;
    }

    public boolean hasAI() {
        return this.hasAI;
    }

    public void setAI(boolean hasAI) {
        this.hasAI = hasAI;
    }

    public boolean isInvulnerable() {
        return this.isInvulnerable;
    }

    public void setInvulnerable(boolean invulnerable) {
        this.isInvulnerable = invulnerable;
    }

    public boolean hasGravity() {
        return this.hasGravity;
    }

    public void setGravity(boolean hasGravity) {
        this.hasGravity = hasGravity;
    }

    public boolean isPersist() {
        return this.persist != null && this.persist != false;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    @Override
    public boolean isDocile() {
        return this.isDocile;
    }

    @Override
    public boolean hasPermission(String key) {
        return this.permissions != null && this.permissions.contains(key);
    }

    @Override
    public boolean canTarget(Entity target) {
        if (target == null || this.mageData == null) {
            return true;
        }
        return this.mageData.canTarget(target);
    }

    @Override
    public boolean isFriendly(Entity target) {
        if (target == null || this.mageData == null) {
            return false;
        }
        return this.mageData.isFriendly(target);
    }

    @Override
    public boolean isTransformable() {
        return this.transformable;
    }

    @Override
    public boolean isCombustible() {
        return this.combustible;
    }

    @Override
    @Nullable
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nullable
    public String getInteractPermission() {
        return this.interactPermission;
    }

    @Override
    public boolean getInteractRequiresOwner() {
        return this.interactRequiresOwner;
    }

    public boolean isSplittable() {
        return this.extraData == null || this.extraData.isSplittable();
    }

    @Override
    public boolean isPreventProjectiles() {
        return this.preventProjectiles;
    }

    @Override
    public boolean isPreventMelee() {
        return this.preventMelee;
    }

    @Override
    public boolean isNPC() {
        return this.isNPC;
    }

    public boolean useNPCName() {
        return this.useNPCName;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public boolean isSuperProtected() {
        return this.isSuperProtected;
    }

    @Override
    public boolean isPreventDismount() {
        return this.preventDismount;
    }

    @Override
    public boolean isPreventTeleport() {
        return this.preventTeleport;
    }

    @Nullable
    public BossBarTracker getBossBar(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        return this.bossBar == null ? null : this.bossBar.createTracker(mage);
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

