/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.Collection;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;

public class PlayEffectsAction
extends BaseSpellAction {
    private String effectKey;
    private boolean countAsCast;

    @Override
    public SpellResult perform(CastContext context) {
        if (this.effectKey == null || this.effectKey.isEmpty()) {
            return SpellResult.FAIL;
        }
        context.playEffects(this.effectKey, 1.0f, context.getTargetBlock());
        return this.countAsCast ? SpellResult.CAST : SpellResult.NO_ACTION;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.effectKey = parameters.getString("effect");
        this.effectKey = parameters.getString("effects", this.effectKey);
        this.countAsCast = parameters.getBoolean("effects_count_as_cast", false);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("particle");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("particle")) {
            for (Particle particle : Particle.values()) {
                examples.add(particle.name().toLowerCase());
            }
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

