/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class DisarmAction
extends BaseSpellAction {
    private boolean keepInInventory;
    private int minSlot;
    private int maxSlot;
    private String displayName;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.keepInInventory = parameters.getBoolean("keep_in_inventory", false);
        this.minSlot = parameters.getInt("min_slot", 9);
        this.maxSlot = parameters.getInt("max_slot", 35);
        this.displayName = parameters.getString("display_name", null);
        if (this.displayName != null) {
            this.displayName = CompatibilityLib.getCompatibilityUtils().translateColors(this.displayName);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity target = context.getTargetEntity();
        if (target == null || !(target instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity entity = (LivingEntity)target;
        EntityEquipment equipment = entity.getEquipment();
        ItemStack stack = null;
        Integer originalSlot = null;
        boolean isMainHand = false;
        if (this.displayName == null) {
            stack = equipment.getItemInMainHand();
            isMainHand = true;
        } else {
            this.keepInInventory = false;
            if (!(entity instanceof Player)) {
                return SpellResult.PLAYER_REQUIRED;
            }
            PlayerInventory playerInventory = ((Player)entity).getInventory();
            originalSlot = 0;
            while (originalSlot < playerInventory.getSize()) {
                ItemMeta meta;
                Object item = playerInventory.getItem(originalSlot.intValue());
                if (!CompatibilityLib.getItemUtils().isEmpty((ItemStack)item) && (meta = item.getItemMeta()) != null && meta.hasDisplayName() && meta.getDisplayName().equals(this.displayName)) {
                    stack = item;
                    isMainHand = originalSlot.intValue() == playerInventory.getHeldItemSlot();
                    break;
                }
                item = originalSlot;
                originalSlot = originalSlot + 1;
            }
        }
        if (CompatibilityLib.getItemUtils().isEmpty(stack)) {
            return SpellResult.NO_TARGET;
        }
        MageController controller = context.getController();
        Mage targetMage = controller.getMage((Entity)entity);
        if (Wand.isWand(stack) && controller.isMage((Entity)entity)) {
            Mage mage = context.getMage();
            if (!mage.isSuperPowered() && targetMage.isSuperProtected()) {
                return SpellResult.NO_TARGET;
            }
            com.elmakers.mine.bukkit.api.wand.Wand activeWand = targetMage.getActiveWand();
            if (activeWand != null && isMainHand) {
                targetMage.getActiveWand().deactivate();
                stack = equipment.getItemInMainHand();
            }
        }
        Integer targetSlot = null;
        PlayerInventory targetInventory = null;
        ItemStack swapItem = null;
        Random random = context.getRandom();
        if (entity instanceof Player && this.keepInInventory) {
            Player targetPlayer = (Player)entity;
            targetInventory = targetPlayer.getInventory();
            originalSlot = targetInventory.getHeldItemSlot();
            ArrayList<Integer> validSlots = new ArrayList<Integer>();
            ItemStack[] contents = targetInventory.getContents();
            for (int i = this.minSlot; i <= this.maxSlot; ++i) {
                if (contents[i] != null && contents[i].getType() != Material.AIR) continue;
                validSlots.add(i);
            }
            if (validSlots.size() == 0) {
                int swapSlot = random.nextInt(this.maxSlot - this.minSlot) + this.minSlot;
                swapItem = targetInventory.getItem(swapSlot);
                validSlots.add(swapSlot);
            }
            int chosen = random.nextInt(validSlots.size());
            targetSlot = (Integer)validSlots.get(chosen);
        }
        if (this.displayName != null) {
            ((Player)entity).getInventory().setItem(originalSlot.intValue(), null);
        } else {
            equipment.setItemInMainHand(swapItem);
        }
        if (targetSlot != null && targetInventory != null) {
            targetInventory.setItem(targetSlot.intValue(), stack);
            if (originalSlot != null) {
                DisarmUndoAction disarmUndo = new DisarmUndoAction(targetMage, originalSlot, targetSlot);
                context.registerForUndo(disarmUndo);
            }
        } else {
            Location location = entity.getLocation();
            location.setY(location.getY() + 1.0);
            Item item = entity.getWorld().dropItemNaturally(location, stack);
            Vector velocity = item.getVelocity();
            velocity.setY(velocity.getY() * 5.0);
            SafetyUtils.setVelocity((Entity)item, velocity);
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("keep_in_inventory");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("keep_in_inventory")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    private static class DisarmUndoAction
    implements Runnable {
        private final WeakReference<Mage> mage;
        private final int originalSlot;
        private final int targetSlot;

        public DisarmUndoAction(Mage mage, int originalSlot, int targetSlot) {
            this.mage = new WeakReference<Mage>(mage);
            this.originalSlot = originalSlot;
            this.targetSlot = targetSlot;
        }

        @Override
        public void run() {
            Mage mage = (Mage)this.mage.get();
            if (mage == null) {
                return;
            }
            com.elmakers.mine.bukkit.api.wand.Wand activeWand = mage.getActiveWand();
            if (activeWand != null && activeWand.isInventoryOpen()) {
                return;
            }
            Player player = mage.getPlayer();
            if (player == null) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            ItemStack targetItem = inventory.getItem(this.targetSlot);
            ItemStack swapItem = inventory.getItem(this.originalSlot);
            inventory.setItem(this.originalSlot, targetItem);
            inventory.setItem(this.targetSlot, swapItem);
            mage.checkWand();
        }
    }
}

