/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class CheckEntityAction
extends CheckAction {
    private boolean allowCaster;
    private boolean onlyCaster;
    private Boolean onFire;
    private Boolean onGround;
    private Set<EntityType> allowedTypes;
    private Set<EntityType> deniedTypes;
    private List<Class<? extends Entity>> allowedClasses;
    private List<Class<? extends Entity>> deniedClasses;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        Class<?> targetEntityType;
        Class<?> rawClass;
        EntityType entityType;
        List<String> keys;
        super.prepare(context, parameters);
        this.allowCaster = parameters.getBoolean("allow_caster", true);
        this.onlyCaster = parameters.getBoolean("only_caster", false);
        if (parameters.contains("on_fire")) {
            this.onFire = parameters.getBoolean("on_fire");
        }
        if (parameters.contains("on_ground")) {
            this.onGround = parameters.getBoolean("on_ground");
        }
        if (parameters.contains("allowed_entities")) {
            keys = ConfigurationUtils.getStringList(parameters, "allowed_entities");
            this.allowedTypes = new HashSet<EntityType>();
            for (String key : keys) {
                try {
                    entityType = EntityType.valueOf((String)key.toUpperCase());
                    this.allowedTypes.add(entityType);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid entity type in CheckEntity configuration: " + key);
                }
            }
        }
        if (parameters.contains("denied_entities")) {
            keys = ConfigurationUtils.getStringList(parameters, "denied_entities");
            this.deniedTypes = new HashSet<EntityType>();
            for (String key : keys) {
                try {
                    entityType = EntityType.valueOf((String)key.toUpperCase());
                    this.deniedTypes.add(entityType);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid entity type in CheckEntity configuration: " + key);
                }
            }
        }
        if (parameters.contains("allowed_entity_classes")) {
            keys = ConfigurationUtils.getStringList(parameters, "allowed_entity_classes");
            this.allowedClasses = new ArrayList<Class<? extends Entity>>();
            for (String key : keys) {
                try {
                    rawClass = Class.forName("org.bukkit.entity." + key);
                    if (!Entity.class.isAssignableFrom(rawClass)) {
                        context.getLogger().warning("Invalid entity class in CheckEntity configuration, does not extend from Entity: " + rawClass.getName());
                        continue;
                    }
                    targetEntityType = rawClass;
                    this.allowedClasses.add(targetEntityType);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid entity class in CheckEntity configuration: " + key);
                }
            }
        }
        if (parameters.contains("denied_entity_classes")) {
            keys = ConfigurationUtils.getStringList(parameters, "denied_entity_classes");
            this.deniedClasses = new ArrayList<Class<? extends Entity>>();
            for (String key : keys) {
                try {
                    rawClass = Class.forName("org.bukkit.entity." + key);
                    if (!Entity.class.isAssignableFrom(rawClass)) {
                        context.getLogger().warning("Invalid entity class in CheckEntity configuration, does not extend from Entity: " + rawClass.getName());
                        continue;
                    }
                    targetEntityType = rawClass;
                    this.deniedClasses.add(targetEntityType);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid entity class in CheckEntity configuration: " + key);
                }
            }
        }
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        boolean anyAllowed;
        boolean isCaster;
        Entity targetEntity = context.getTargetEntity();
        if (targetEntity == null) {
            return false;
        }
        boolean bl = isCaster = targetEntity == context.getEntity();
        if (!this.allowCaster && isCaster) {
            return false;
        }
        if (this.onlyCaster && !isCaster) {
            return false;
        }
        if (this.onGround != null && this.onGround.booleanValue() != targetEntity.isOnGround()) {
            return false;
        }
        if (this.onFire != null && this.onFire != targetEntity.getFireTicks() > 0) {
            return false;
        }
        if (this.deniedTypes != null && this.deniedTypes.contains(targetEntity.getType())) {
            return false;
        }
        if (this.deniedClasses != null) {
            for (Class<? extends Entity> entityClass : this.deniedClasses) {
                if (!entityClass.isAssignableFrom(targetEntity.getClass())) continue;
                return false;
            }
        }
        boolean bl2 = anyAllowed = this.allowedTypes == null && this.allowedClasses == null;
        if (!anyAllowed && this.allowedTypes != null) {
            anyAllowed = this.allowedTypes.contains(targetEntity.getType());
        }
        if (!anyAllowed && this.allowedClasses != null) {
            for (Class<? extends Entity> entityClass : this.allowedClasses) {
                if (!entityClass.isAssignableFrom(targetEntity.getClass())) continue;
                anyAllowed = true;
                break;
            }
        }
        return anyAllowed;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

