/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.block.BrushMode;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.event.SpellInventoryEvent;
import com.elmakers.mine.bukkit.api.event.WandPreActivateEvent;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandAction;
import com.elmakers.mine.bukkit.api.wand.WandUseMode;
import com.elmakers.mine.bukkit.boss.BossBarConfiguration;
import com.elmakers.mine.bukkit.configuration.MageParameters;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.effect.WandContext;
import com.elmakers.mine.bukkit.effect.builtin.EffectRing;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.item.InventorySlot;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.tasks.ApplyWandIconTask;
import com.elmakers.mine.bukkit.tasks.CancelEffectsContextTask;
import com.elmakers.mine.bukkit.tasks.OpenWandTask;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.CurrencyAmount;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.UnknownWandException;
import com.elmakers.mine.bukkit.wand.WandDisplayMode;
import com.elmakers.mine.bukkit.wand.WandInventory;
import com.elmakers.mine.bukkit.wand.WandManaMode;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandOrganizer;
import com.elmakers.mine.bukkit.wand.WandProperties;
import com.elmakers.mine.bukkit.wand.WandTemplate;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Wand
extends WandProperties
implements CostReducer,
com.elmakers.mine.bukkit.api.wand.Wand {
    public static final int OFFHAND_SLOT = 40;
    public static final int INVENTORY_SIZE = 27;
    public static final int PLAYER_INVENTORY_SIZE = 36;
    public static final int INVENTORY_ORGANIZE_BUFFER = 4;
    public static final int HOTBAR_SIZE = 9;
    public static final int HOTBAR_INVENTORY_SIZE = 8;
    public static boolean FILL_CREATOR = false;
    public static Vector DEFAULT_CAST_OFFSET = new Vector(0.0, 0.0, 0.5);
    public static String DEFAULT_WAND_TEMPLATE = "default";
    public static boolean CREATIVE_CHEST_MODE = false;
    private static final String[] EMPTY_PARAMETERS = new String[0];
    private static final Random random = new Random();
    @Nullable
    protected ItemStack item;
    private int hideFlags;
    @Nullable
    protected Mage mage;
    @Nullable
    protected WandContext wandContext;
    private String id = "";
    private List<WandInventory> hotbars;
    private List<WandInventory> inventories;
    private Map<String, Integer> spellInventory = new HashMap<String, Integer>();
    private Set<String> spells = new LinkedHashSet<String>();
    private Map<String, Integer> spellLevels = new HashMap<String, Integer>();
    private Map<String, Integer> brushInventory = new HashMap<String, Integer>();
    private Set<String> brushes = new LinkedHashSet<String>();
    private MaterialSet interactibleMaterials = null;
    private String activeSpell = "";
    private String[] alternateSpells = new String[7];
    private String activeBrush = "";
    protected String wandName = "";
    protected String description = "";
    private String owner = "";
    private String ownerId = "";
    private String template = "";
    private String path = "";
    private String inventoryOpenLore = "";
    private List<String> mageClassKeys = null;
    private boolean superProtected = false;
    private boolean superPowered = false;
    private boolean glow = false;
    private boolean spellGlow = false;
    private boolean bound = false;
    private boolean boundDisplayName = true;
    private boolean indestructible = false;
    private boolean undroppable = false;
    private boolean keep = false;
    private boolean worn = false;
    private WandUseMode useMode = WandUseMode.SUCCESS;
    private boolean autoOrganize = false;
    private boolean autoAlphabetize = false;
    private boolean autoFill = false;
    private boolean isUpgrade = false;
    private boolean randomizeOnActivate = true;
    private boolean rename = false;
    private boolean renameDescription = false;
    private boolean quickCast = false;
    private boolean quickCastDisabled = false;
    private boolean manualQuickCastDisabled = false;
    private boolean isInOffhand = false;
    private boolean hasId = false;
    private boolean showCycleModeLore = true;
    private boolean useActiveName = false;
    private int inventoryRows = 1;
    private Vector castLocation;
    private WandAction leftClickAction = WandAction.NONE;
    private WandAction rightClickAction = WandAction.NONE;
    private WandAction dropAction = WandAction.NONE;
    private WandAction swapAction = WandAction.NONE;
    private WandAction leftClickSneakAction = WandAction.NONE;
    private WandAction rightClickSneakAction = WandAction.NONE;
    private WandAction dropSneakAction = WandAction.NONE;
    private WandAction swapSneakAction = WandAction.NONE;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = null;
    private com.elmakers.mine.bukkit.block.MaterialAndData inactiveIcon = null;
    private int inactiveIconDelay = 0;
    private String upgradeTemplate = null;
    protected float consumeReduction = 0.0f;
    protected float cooldownReduction = 0.0f;
    protected float costReduction = 0.0f;
    protected Map<String, Double> protection;
    private float power = 0.0f;
    private float earnMultiplier = 1.0f;
    private float blockFOV = 0.0f;
    private float blockChance = 0.0f;
    private float blockReflectChance = 0.0f;
    private int blockMageCooldown = 0;
    private int blockCooldown = 0;
    private int maxEnchantCount = 0;
    private int enchantCount = 0;
    private boolean hasInventory = false;
    private boolean locked = false;
    private boolean autoAbsorb = false;
    private boolean lockedAllowUpgrades = false;
    private boolean forceUpgrade = false;
    private boolean isHeroes = false;
    private int uses = 0;
    private boolean hasUses = false;
    private boolean isSingleUse = false;
    private boolean limitSpellsToPath = false;
    private boolean levelSpells = false;
    private boolean limitBrushesToPath = false;
    private Double resetManaOnActivate = null;
    private float manaPerDamage = 0.0f;
    private Particle effectParticle = null;
    private float effectParticleData = 0.0f;
    private int effectParticleCount = 0;
    private int effectParticleInterval = 0;
    private double effectParticleMinVelocity = 0.0;
    private double effectParticleRadius = 0.0;
    private double effectParticleOffset = 0.0;
    private boolean effectBubbles = false;
    private boolean activeEffectsOnly = false;
    private EffectRing effectPlayer = null;
    private int castInterval = 0;
    private double castMinVelocity = 0.0;
    private Vector castVelocityDirection = null;
    private String castSpell = null;
    private ConfigurationSection castParameters = null;
    private SoundEffect effectSound = null;
    private int effectSoundInterval = 0;
    private int quietLevel = 0;
    private List<Wand> slotted = null;
    private ConfigurationSection slottedConfiguration = null;
    private boolean hasSpellProgression = false;
    private long lastSoundEffect;
    private long lastParticleEffect;
    private long lastSpellCast;
    private WandMode mode = null;
    private WandMode brushMode = null;
    private int openInventoryPage = 0;
    private boolean inventoryIsOpen = false;
    private boolean inventoryWasOpen = false;
    private Inventory displayInventory = null;
    private int currentHotbar = 0;
    public static WandManaMode manaMode = WandManaMode.BAR;
    public static boolean regenWhileInactive = true;
    public static Material DefaultUpgradeMaterial = Material.NETHER_STAR;
    public static Material DefaultWandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = null;
    public static boolean SpellGlow = false;
    public static boolean BrushGlow = false;
    public static boolean BrushItemGlow = true;
    public static boolean LiveHotbar = true;
    public static boolean LiveHotbarSkills = false;
    public static boolean LiveHotbarCooldown = true;
    public static boolean LiveHotbarCharges = true;
    public static boolean LiveHotbarMana = true;
    public static boolean Unbreakable = false;
    public static boolean Unstashable = true;
    public static SoundEffect inventoryOpenSound = null;
    public static SoundEffect inventoryCloseSound = null;
    public static SoundEffect inventoryCycleSound = null;
    public static SoundEffect noActionSound = null;
    public static SoundEffect itemPickupSound = null;
    public static String WAND_KEY = "wand";
    public static String UPGRADE_KEY = "wand_upgrade";
    public static String WAND_SELF_DESTRUCT_KEY = null;
    public static int HIDE_FLAGS = 127;
    public static String brushSelectSpell = "";
    private Inventory storedInventory = null;
    private int heldSlot = 0;
    private boolean isActive = false;
    protected WandDisplayMode xpBarDisplayMode = WandDisplayMode.MANA;
    protected WandDisplayMode levelDisplayMode = WandDisplayMode.SP;
    protected BossBar bossBar;
    protected BossBarConfiguration bossBarConfiguration;
    protected WandDisplayMode bossBarDisplayMode = WandDisplayMode.COOLDOWN;
    protected String actionBarMessage;
    protected int actionBarInterval;
    protected long lastActionBar;
    protected boolean actionBarMana;
    protected boolean lastActionBarFullMana;

    public Wand(MagicController controller) {
        super(controller);
        this.hotbars = new ArrayList<WandInventory>();
        this.inventories = new ArrayList<WandInventory>();
    }

    @Deprecated
    public Wand(MagicController controller, ItemStack itemStack) {
        this(controller);
        Preconditions.checkNotNull((Object)itemStack);
        if (itemStack.getType() == Material.AIR) {
            itemStack.setType(DefaultWandMaterial);
        }
        this.icon = new com.elmakers.mine.bukkit.block.MaterialAndData(itemStack);
        this.item = itemStack;
        boolean needsSave = false;
        boolean isWand = Wand.isWand(this.item);
        boolean isUpgradeItem = Wand.isUpgrade(this.item);
        if (isWand || isUpgradeItem) {
            int version;
            WandTemplate migrateTemplate;
            ConfigurationSection wandConfig = Wand.itemToConfig(this.item, ConfigurationUtils.newConfigurationSection());
            WandTemplate wandTemplate = controller.getWandTemplate(wandConfig.getString("template"));
            WandTemplate wandTemplate2 = migrateTemplate = wandTemplate == null ? null : wandTemplate.getMigrateTemplate();
            if (migrateTemplate != null) {
                wandConfig.set("template", (Object)migrateTemplate.getKey());
            }
            if ((version = wandConfig.getInt("version", 0)) < CURRENT_VERSION) {
                needsSave = true;
            }
            this.randomizeOnActivate = !wandConfig.contains("icon");
            this.load(wandConfig);
        } else {
            this.updateIcon();
            needsSave = true;
        }
        this.loadProperties();
        if ((this.isUpgrade || isUpgradeItem) && isWand) {
            needsSave = true;
            CompatibilityLib.getNBTUtils().removeMeta(this.item, WAND_KEY);
        }
        if (needsSave) {
            this.saveState();
            this.updateName();
            this.updateLore();
        }
    }

    public Wand(MagicController controller, ConfigurationSection config) {
        this(controller, DefaultWandMaterial, 0);
        this.load(config);
        this.loadProperties();
        this.updateName();
        this.updateLore();
        this.saveState();
    }

    protected Wand(MagicController controller, String templateName, Mage mage) throws UnknownWandException {
        this(controller);
        WandTemplate template;
        this.mage = mage;
        if (templateName == null || templateName.length() == 0) {
            templateName = DEFAULT_WAND_TEMPLATE;
        }
        int level = 0;
        if (templateName.contains("(")) {
            String levelString = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
            try {
                level = Integer.parseInt(levelString);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
            templateName = templateName.substring(0, templateName.indexOf(40));
        }
        if ((template = controller.getWandTemplate(templateName)) == null) {
            throw new UnknownWandException(templateName);
        }
        WandTemplate migrateTemplate = template.getMigrateTemplate();
        if (migrateTemplate != null) {
            template = migrateTemplate;
            templateName = migrateTemplate.getKey();
        }
        this.setTemplate(templateName);
        this.setProperty("version", CURRENT_VERSION);
        ConfigurationSection templateConfig = template.getConfiguration();
        if (templateConfig == null) {
            throw new UnknownWandException(templateName);
        }
        this.loadProperties();
        if (level > 0) {
            boolean wasLocked = this.locked;
            this.locked = false;
            this.randomize(level, null, true);
            this.locked = wasLocked;
        }
        if (!this.randomizeOnActivate) {
            this.randomize();
        }
        this.updateName();
        this.updateLore();
        this.saveState();
        this.mage = null;
    }

    public Wand(MagicController controller, Material icon, short iconData) {
        this(controller, CompatibilityLib.getItemUtils().makeReal(CompatibilityLib.getDeprecatedUtils().createItemStack(icon, 1, iconData)));
        this.saveState();
        this.updateName();
    }

    @Override
    protected void migrate(int version, ConfigurationSection wandConfig) {
        Object spellInventoryRaw;
        ConfigurationSection templateConfig;
        if (version <= 1 && (templateConfig = this.controller.getWandTemplateConfiguration(wandConfig.getString("template"))) != null) {
            String randomizeIcon = templateConfig.getString("randomize_icon");
            String currentIcon = wandConfig.getString("icon");
            if (randomizeIcon != null && currentIcon != null && randomizeIcon.equals(currentIcon)) {
                wandConfig.set("icon", null);
            }
            wandConfig.set("randomize", null);
            Set keys = templateConfig.getKeys(false);
            for (String key : keys) {
                Object templateData = templateConfig.get(key);
                Object wandData = wandConfig.get(key);
                if (wandData == null) continue;
                String templateString = templateData.toString();
                String wandString = wandData.toString();
                if (templateData instanceof List) {
                    templateString = templateString.substring(1, templateString.length() - 1);
                    templateString = templateString.replace(", ", ",");
                    templateData = templateString;
                }
                if (wandString.equalsIgnoreCase(templateString)) {
                    wandConfig.set(key, null);
                    continue;
                }
                try {
                    double numericValue = Double.parseDouble(wandString);
                    double numericTemplate = Double.parseDouble(templateString);
                    if (numericValue == numericTemplate) {
                        wandConfig.set(key, null);
                        continue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!wandData.equals(templateData)) continue;
                wandConfig.set(key, null);
            }
        }
        if (version <= 3) {
            String templateIcon;
            templateConfig = this.controller.getWandTemplateConfiguration(wandConfig.getString("template"));
            String string = templateIcon = templateConfig == null ? null : templateConfig.getString("icon");
            if (templateIcon != null && templateIcon.equals(wandConfig.getString("icon", ""))) {
                wandConfig.set("icon", null);
            }
        }
        if (version <= 4 && (spellInventoryRaw = wandConfig.get("spell_inventory")) != null) {
            Map<String, Object> spellInventory = null;
            HashMap<String, Integer> newSpellInventory = new HashMap<String, Integer>();
            if (spellInventoryRaw instanceof Map) {
                spellInventory = (Map<String, Object>)spellInventoryRaw;
            } else if (spellInventoryRaw instanceof ConfigurationSection) {
                spellInventory = CompatibilityLib.getCompatibilityUtils().getMap((ConfigurationSection)spellInventoryRaw);
            }
            if (spellInventory != null) {
                for (Map.Entry spellEntry : spellInventory.entrySet()) {
                    Object slot = spellEntry.getValue();
                    if (slot == null || !(slot instanceof Integer)) continue;
                    SpellKey spellKey = new SpellKey((String)spellEntry.getKey());
                    Object testSlot = spellInventory.get(spellKey.getBaseKey());
                    if (testSlot != null) {
                        slot = testSlot;
                    }
                    newSpellInventory.put(spellKey.getBaseKey(), (Integer)slot);
                }
                wandConfig.set("spell_inventory", newSpellInventory);
            }
        }
        if (version <= 5) {
            ConfigurationSection attributes = wandConfig.getConfigurationSection("attributes");
            wandConfig.set("attributes", null);
            wandConfig.set("item_attributes", (Object)attributes);
        }
        super.migrate(version, wandConfig);
    }

    @Override
    public void load(ConfigurationSection configuration) {
        if (configuration != null) {
            this.setTemplate(configuration.getString("template"));
        }
        super.load(configuration);
    }

    protected void updateHotbarCount() {
        int hotbarCount = 0;
        hotbarCount = this.hasProperty("hotbar_inventory_count") ? Math.max(1, this.getInt("hotbar_inventory_count", 1)) : this.getHotbarCount();
        if (hotbarCount != this.hotbars.size()) {
            if (this.isInventoryOpen()) {
                this.closeInventory();
            }
            this.hotbars.clear();
            while (this.hotbars.size() < hotbarCount) {
                this.hotbars.add(new WandInventory(8));
            }
            while (this.hotbars.size() > hotbarCount) {
                this.hotbars.remove(0);
            }
        }
    }

    protected void checkHotbarCount() {
        if (!this.hasInventory || this.getHotbarCount() == 0) {
            return;
        }
        int hotbarCount = Math.max(1, this.getInt("hotbar_count", 1));
        if (hotbarCount != this.hotbars.size()) {
            while (this.hotbars.size() < hotbarCount) {
                this.hotbars.add(new WandInventory(8));
            }
            while (this.hotbars.size() > hotbarCount) {
                this.hotbars.remove(0);
            }
            ArrayList<WandInventory> pages = new ArrayList<WandInventory>(this.inventories);
            int slotOffset = this.getInt("hotbar_count") * 8;
            int index = 0;
            for (WandInventory inventory : pages) {
                for (ItemStack itemStack : inventory.items) {
                    this.updateSlot(index + slotOffset, itemStack);
                    ++index;
                }
            }
            this.updateSpellInventory();
            this.updateBrushInventory();
        }
        this.setProperty("hotbar_inventory_count", hotbarCount);
    }

    @Override
    public void unenchant() {
        this.controller.cleanItem(this.item);
        this.clear();
    }

    public void updateItemIcon() {
        this.setIcon(this.icon);
    }

    protected void updateIcon() {
        if (this.icon != null && this.icon.getMaterial() != null && this.icon.getMaterial() != Material.AIR) {
            WandTemplate template;
            String templateIcon;
            String iconKey = this.icon.getKey();
            if (iconKey != null && iconKey.isEmpty()) {
                iconKey = null;
            }
            String string = templateIcon = (template = this.getTemplate()) != null && this.controller != null ? template.getIcon(this.controller.isLegacyIconsEnabled()) : null;
            if (templateIcon == null || !templateIcon.equals(iconKey)) {
                this.setProperty("icon", iconKey);
            }
        }
    }

    @Override
    public void setInactiveIcon(MaterialAndData materialData) {
        this.inactiveIcon = materialData == null ? null : (materialData instanceof com.elmakers.mine.bukkit.block.MaterialAndData ? (com.elmakers.mine.bukkit.block.MaterialAndData)materialData : new com.elmakers.mine.bukkit.block.MaterialAndData(materialData));
        String inactiveIconKey = null;
        if (this.inactiveIcon != null && this.inactiveIcon.getMaterial() != null && this.inactiveIcon.getMaterial() != Material.AIR && (inactiveIconKey = this.inactiveIcon.getKey()) != null && inactiveIconKey.isEmpty()) {
            inactiveIconKey = null;
        }
        this.setProperty("inactive_icon", inactiveIconKey);
        this.updateItemIcon();
    }

    public void setIcon(Material material, byte data) {
        this.setIcon(material == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(material, data));
        this.updateIcon();
    }

    @Override
    public void setIcon(MaterialAndData materialData) {
        if (materialData instanceof com.elmakers.mine.bukkit.block.MaterialAndData) {
            this.setIcon((com.elmakers.mine.bukkit.block.MaterialAndData)materialData);
        } else {
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(materialData));
        }
        this.updateIcon();
    }

    public void setIcon(com.elmakers.mine.bukkit.block.MaterialAndData materialData) {
        if (materialData == null || !materialData.isValid()) {
            return;
        }
        if (materialData.getMaterial() == Material.AIR || materialData.getMaterial() == null) {
            materialData.setMaterial(DefaultWandMaterial);
        }
        this.icon = materialData;
        if (this.item == null) {
            this.item = CompatibilityLib.getItemUtils().makeReal(this.icon.getItemStack(1));
        }
        if (!this.icon.isValid()) {
            return;
        }
        Short durability = null;
        if (!this.indestructible && !this.isUpgrade && this.icon.getMaterial().getMaxDurability() > 0) {
            durability = CompatibilityLib.getDeprecatedUtils().getItemDamage(this.item);
        }
        try {
            if (this.inactiveIcon == null || this.useActiveIcon()) {
                if (this.inactiveIcon != null && this.inactiveIconDelay > 0) {
                    this.inactiveIcon.applyToItem(this.item);
                    MagicPlugin plugin = this.controller.getPlugin();
                    plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new ApplyWandIconTask(this), (long)(this.inactiveIconDelay * 20 / 1000));
                } else {
                    this.icon.applyToItem(this.item);
                }
            } else {
                this.inactiveIcon.applyToItem(this.item);
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Unable to apply wand icon", ex);
            this.item.setType(DefaultWandMaterial);
        }
        if (durability != null) {
            CompatibilityLib.getDeprecatedUtils().setItemDamage(this.item, durability);
        }
        if ((this.indestructible || Unbreakable || this.isUpgrade) && !manaMode.useDurability()) {
            CompatibilityLib.getItemUtils().makeUnbreakable(this.item);
        } else {
            CompatibilityLib.getItemUtils().removeUnbreakable(this.item);
        }
        CompatibilityLib.getItemUtils().hideFlags(this.item, this.hideFlags);
    }

    private boolean useActiveIcon() {
        boolean useActiveIcon;
        boolean bl = useActiveIcon = this.mage != null;
        if (useActiveIcon && this.getMode() == WandMode.INVENTORY) {
            useActiveIcon = this.isInventoryOpen();
        }
        return useActiveIcon;
    }

    @Override
    public void makeUpgrade() {
        if (!this.isUpgrade) {
            this.isUpgrade = true;
            String oldName = this.wandName;
            String newName = this.getMessage("upgrade_name");
            newName = newName.replace("$name", oldName);
            String newDescription = this.controller.getMessages().get("wand.upgrade_default_description");
            if (this.template != null && this.template.length() > 0) {
                newDescription = this.controller.getMessages().get("wands." + this.template + ".upgrade_description", this.description);
            }
            this.setIcon(DefaultUpgradeMaterial, (byte)0);
            this.setName(newName);
            this.setDescription(newDescription);
            CompatibilityLib.getNBTUtils().removeMeta(this.item, WAND_KEY);
            this.saveState();
            this.updateName(true);
            this.updateLore();
        }
    }

    public void newId() {
        this.id = UUID.randomUUID().toString();
        this.setProperty("id", this.id);
    }

    public boolean checkId() {
        if (this.id == null || this.id.length() == 0) {
            this.newId();
            return true;
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isModifiable() {
        return !this.locked;
    }

    public boolean isAutoAbsorb() {
        return this.autoAbsorb;
    }

    @Override
    public boolean isIndestructible() {
        return this.indestructible;
    }

    @Override
    public boolean isUndroppable() {
        return this.undroppable;
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public static boolean isUpgrade(ItemStack item) {
        return item != null && CompatibilityLib.getNBTUtils().hasMeta(item, UPGRADE_KEY);
    }

    @Override
    public boolean usesMana() {
        if (this.isCostFree()) {
            return false;
        }
        return this.getManaMax() > 0 || this.isHeroes && this.mage != null;
    }

    @Override
    public void removeMana(float amount) {
        HeroesManager heroes;
        if (this.isHeroes && this.mage != null && (heroes = this.controller.getHeroes()) != null) {
            heroes.removeMana(this.mage.getPlayer(), (int)Math.ceil(amount));
        }
        super.removeMana(amount);
        this.updateMana();
    }

    @Override
    public float getCostReduction() {
        if (this.mage != null) {
            float reduction = this.mage.getCostReduction();
            return this.worn ? reduction : this.stackPassiveProperty(reduction, this.costReduction * this.controller.getMaxCostReduction());
        }
        return this.costReduction;
    }

    @Override
    public float getCooldownReduction() {
        if (this.mage != null) {
            float reduction = this.mage.getCooldownReduction();
            return this.worn ? reduction : this.stackPassiveProperty(reduction, this.cooldownReduction * this.controller.getMaxCooldownReduction());
        }
        return this.cooldownReduction;
    }

    @Override
    public float getConsumeReduction() {
        if (this.mage != null) {
            float reduction = this.mage.getConsumeReduction();
            return this.worn ? reduction : this.stackPassiveProperty(reduction, this.consumeReduction);
        }
        return this.consumeReduction;
    }

    @Override
    public float getCostScale() {
        return 1.0f;
    }

    @Override
    public boolean hasInventory() {
        return this.hasInventory;
    }

    @Override
    public float getPower() {
        return this.power;
    }

    @Override
    public boolean isSuperProtected() {
        return this.superProtected;
    }

    @Override
    public boolean isSuperPowered() {
        return this.superPowered;
    }

    @Override
    public boolean isConsumeFree() {
        return this.consumeReduction >= 1.0f;
    }

    @Override
    public boolean isCooldownFree() {
        return this.cooldownReduction > 1.0f;
    }

    @Override
    public String getName() {
        return CompatibilityLib.getCompatibilityUtils().translateColors(this.wandName);
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner == null ? "" : this.owner;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public long getWorth() {
        long worth = this.getInt("worth");
        if (worth > 0L) {
            return worth;
        }
        Collection spells = this.getSpells();
        for (String spellKey : spells) {
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell == null) continue;
            worth = (long)((double)worth + spell.getWorth());
        }
        return worth;
    }

    @Override
    public void setName(String name) {
        this.wandName = ChatColor.stripColor((String)name);
        this.setProperty("name", this.wandName);
        this.updateName();
    }

    public void setTemplate(String templateName) {
        this.template = templateName;
        WandTemplate wandTemplate = this.controller.getWandTemplate(templateName);
        if (wandTemplate != null) {
            this.setWandTemplate(wandTemplate);
        }
        this.setProperty("template", this.template);
    }

    @Override
    public String getTemplateKey() {
        return this.template;
    }

    @Override
    public boolean hasTag(String tag) {
        WandTemplate template = this.getTemplate();
        return template != null && template.hasTag(tag);
    }

    @Override
    public WandUpgradePath getPath() {
        String pathKey = this.path;
        if (pathKey == null || pathKey.length() == 0) {
            pathKey = this.controller.getDefaultWandPath();
        }
        return WandUpgradePath.getPath(pathKey);
    }

    public boolean hasPath() {
        return this.path != null && this.path.length() > 0;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.setProperty("description", description);
        this.updateLore();
    }

    public boolean tryToOwn(Player player) {
        if (this.ownerId == null || this.ownerId.length() == 0) {
            this.takeOwnership(player);
            return true;
        }
        return false;
    }

    @Override
    public void showInstructions() {
        this.showInstructions(false);
    }

    public void showInstructions(boolean forceBound) {
        if (this.mage == null) {
            return;
        }
        this.startWandInstructions();
        if (forceBound) {
            this.doShowBoundInstructions();
        } else {
            this.showBoundInstructions();
        }
        this.showSpellInstructions();
        this.showBrushInstructions();
        this.showHotbarInstructions();
        this.showPageInstructions();
        this.showManaInstructions();
        this.showPathInstructions();
        this.endWandInstructions();
    }

    private void showBoundInstructions() {
        if (this.ownerId != null) {
            this.doShowBoundInstructions();
        }
    }

    private void doShowBoundInstructions() {
        this.mage.sendMessage(this.getMessage("bound_instructions", "").replace("$wand", this.getName()));
    }

    private void showSpellInstructions() {
        int spellCount;
        SpellTemplate spellTemplate;
        String spellKey = this.getActiveSpellKey();
        SpellTemplate spellTemplate2 = spellTemplate = spellKey != null && !spellKey.isEmpty() ? this.controller.getSpellTemplate(spellKey) : null;
        if (spellTemplate != null && (spellCount = this.spells.size()) > 0) {
            String controlKey;
            if (this.leftClickAction == WandAction.CAST) {
                controlKey = this.getInventoryKey("right_click");
                controlKey = this.controller.getMessages().get("controls." + controlKey);
                String message = this.getMessage("spell_instructions", "").replace("$wand", this.getName()).replace("$toggle", controlKey).replace("$spell", spellTemplate.getName());
                this.mage.sendMessage(message);
            }
            controlKey = this.getInventoryKey();
            String inventoryMessage = this.getControlMessage();
            if (controlKey != null && inventoryMessage != null) {
                controlKey = this.controller.getMessages().get("controls." + controlKey);
                this.mage.sendMessage(this.getMessage(inventoryMessage, "").replace("$wand", this.getName()).replace("$toggle", controlKey).replace("$cycle", controlKey));
            }
        }
    }

    private void showBrushInstructions() {
        String controlKey;
        int brushCount = this.brushes.size();
        if (brushCount != 0 && (controlKey = this.getControlKey(WandAction.TOGGLE)) != null) {
            controlKey = this.controller.getMessages().get("controls." + controlKey);
            this.mage.sendMessage(this.getMessage("brush_instructions").replace("$wand", this.getName()).replace("$toggle", controlKey));
        }
    }

    private void showPageInstructions() {
        if (this.inventories.size() > 1) {
            this.mage.sendMessage(this.getMessage("page_instructions", "").replace("$wand", this.getName()));
        }
    }

    private void showHotbarInstructions() {
        String controlKey;
        if (this.getInt("hotbar_count") > 1 && (controlKey = this.getControlKey(WandAction.CYCLE_HOTBAR)) != null) {
            controlKey = this.controller.getMessages().get("controls." + controlKey);
            this.mage.sendMessage(this.getMessage("hotbar_instructions", "").replace("$wand", this.getName()).replace("$cycle_hotbar", controlKey));
        }
    }

    private void showManaInstructions() {
        SpellTemplate spellTemplate;
        String spellKey = this.getActiveSpellKey();
        SpellTemplate spellTemplate2 = spellTemplate = spellKey != null && !spellKey.isEmpty() ? this.controller.getSpellTemplate(spellKey) : null;
        if (this.usesMana() && spellTemplate != null) {
            String message = this.getMessage("mana_instructions", "").replace("$wand", this.getName()).replace("$spell", spellTemplate.getName());
            this.mage.sendMessage(message);
        }
    }

    private void showPathInstructions() {
        WandUpgradePath path = this.getPath();
        if (path != null) {
            ProgressionPath nextPath;
            if (this.usesSP()) {
                String message = this.getMessage("enchant_instructions", "").replace("$wand", this.getName());
                this.mage.sendMessage(message);
            }
            if ((nextPath = path.getNextPath()) != null && path.isAutomaticProgression()) {
                String message = this.getMessage("path_instructions", "").replace("$path", path.getName()).replace("$nextpath", nextPath.getName());
                this.mage.sendMessage(message);
            }
        }
    }

    public void takeOwnership(Player player) {
        boolean setMage = false;
        if (this.mage == null) {
            this.setMage(this.controller.getMage(player), false, null);
            setMage = true;
        }
        if ((this.ownerId == null || this.ownerId.length() == 0) && this.quietLevel < 2) {
            this.showInstructions(true);
        }
        String ownerName = this.boundDisplayName ? player.getDisplayName() : player.getName();
        this.owner = ChatColor.stripColor((String)ownerName);
        this.ownerId = this.mage.getId();
        if (setMage) {
            this.mage = null;
        }
        this.setProperty("owner", this.owner);
        this.setProperty("owner_id", this.ownerId);
        this.updateLore();
        this.saveState();
    }

    private void startWandInstructions() {
        if (this.mage == null) {
            return;
        }
        String message = this.getMessage("wand_instructions_header", "").replace("$wand", this.getName());
        this.mage.sendMessage(message);
    }

    private void endWandInstructions() {
        if (this.mage == null) {
            return;
        }
        String message = this.getMessage("wand_instructions_footer", "").replace("$wand", this.getName());
        this.mage.sendMessage(message);
    }

    @Nullable
    public String getControlKey(WandAction action) {
        String controlKey = null;
        if (this.rightClickAction == action) {
            controlKey = "right_click";
        } else if (this.dropAction == action) {
            controlKey = "drop";
        } else if (this.leftClickAction == action) {
            controlKey = "left_click";
        } else if (this.swapAction == action) {
            controlKey = "swap";
        }
        return controlKey;
    }

    @Override
    @Nullable
    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    @Override
    public MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public MaterialAndData getInactiveIcon() {
        return this.inactiveIcon;
    }

    protected List<WandInventory> getAllInventories() {
        int hotbarCount = this.getHotbarCount();
        ArrayList<WandInventory> allInventories = new ArrayList<WandInventory>(this.inventories.size() + hotbarCount);
        if (hotbarCount > 0) {
            allInventories.addAll(this.hotbars);
        }
        allInventories.addAll(this.inventories);
        return allInventories;
    }

    public Set<String> getBaseSpells() {
        return this.spells;
    }

    @Override
    @Nonnull
    protected Map<String, Integer> getSpellLevels() {
        return this.spellLevels;
    }

    @Override
    public Set<String> getSpells() {
        HashSet<String> spellSet = new HashSet<String>();
        for (String key : this.spells) {
            Integer level = this.spellLevels.get(key);
            if (level != null) {
                spellSet.add(new SpellKey(key, level).getKey());
                continue;
            }
            spellSet.add(key);
        }
        return spellSet;
    }

    @Override
    public Set<String> getBrushes() {
        return this.brushes;
    }

    @Nullable
    protected Integer parseSlot(String[] pieces) {
        Integer slot = null;
        if (pieces.length > 1) {
            try {
                slot = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                slot = null;
            }
            if (slot != null && slot < 0) {
                slot = null;
            }
        }
        return slot;
    }

    protected void addToInventory(ItemStack itemStack, Integer slot) {
        if (slot == null) {
            this.addToInventory(itemStack);
            return;
        }
        WandInventory inventory = this.getInventory(slot);
        slot = this.getInventorySlot(slot);
        ItemStack existing = inventory.getItem(slot);
        inventory.setItem(slot, itemStack);
        if (existing != null && existing.getType() != Material.AIR) {
            this.addToInventory(existing);
        }
    }

    public void addToInventory(ItemStack itemStack) {
        String brushKey;
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        if (this.getBrushMode() != WandMode.INVENTORY && Wand.isBrush(itemStack) && (!com.elmakers.mine.bukkit.block.MaterialBrush.isSpecialMaterialKey(brushKey = Wand.getBrush(itemStack)) || com.elmakers.mine.bukkit.block.MaterialBrush.isSchematic(brushKey))) {
            return;
        }
        List<WandInventory> checkInventories = this.getAllInventories();
        boolean added = false;
        int organizeBuffer = this.getOrganizeBuffer();
        WandMode mode = this.getMode();
        int fullSlot = 0;
        for (WandInventory inventory : checkInventories) {
            int inventorySize = inventory.getSize();
            Integer slot = null;
            int freeSpace = 0;
            for (int i = 0; i < inventorySize && freeSpace < organizeBuffer; ++i) {
                ItemStack existing = inventory.getItem(i);
                if (!CompatibilityLib.getItemUtils().isEmpty(existing)) continue;
                if (slot == null) {
                    slot = i;
                }
                ++freeSpace;
            }
            if (slot != null && (freeSpace >= organizeBuffer || inventorySize == 8 || mode == WandMode.CHEST)) {
                added = true;
                inventory.setItem(slot, itemStack);
                fullSlot += slot.intValue();
                break;
            }
            fullSlot += inventorySize;
        }
        if (!added) {
            fullSlot = this.getHotbarSize() + this.getInventorySize() * this.inventories.size();
            WandInventory newInventory = new WandInventory(this.getInventorySize());
            newInventory.addItem(itemStack);
            this.inventories.add(newInventory);
        }
        this.updateSlot(fullSlot, itemStack);
    }

    @Nonnull
    protected WandInventory getInventoryByIndex(int inventoryIndex) {
        while (inventoryIndex >= this.inventories.size()) {
            this.inventories.add(new WandInventory(this.getInventorySize()));
        }
        return this.inventories.get(inventoryIndex);
    }

    protected int getHotbarSize() {
        if (this.getMode() != WandMode.INVENTORY) {
            return 0;
        }
        return this.hotbars.size() * 8;
    }

    @Nonnull
    protected WandInventory getInventory(int slot) {
        int hotbarSize = this.getHotbarSize();
        if (slot < hotbarSize) {
            return this.hotbars.get(slot / 8);
        }
        int inventoryIndex = (slot - hotbarSize) / this.getInventorySize();
        return this.getInventoryByIndex(inventoryIndex);
    }

    protected int getInventorySlot(int slot) {
        int hotbarSize = this.getHotbarSize();
        if (slot < hotbarSize) {
            return slot % 8;
        }
        return (slot - hotbarSize) % this.getInventorySize();
    }

    protected void buildInventory() {
        Integer slot;
        ItemStack itemStack;
        this.displayInventory = null;
        this.updateHotbarCount();
        for (WandInventory wandInventory : this.hotbars) {
            wandInventory.clear();
        }
        this.inventories.clear();
        ArrayList<ItemStack> unsorted = new ArrayList<ItemStack>();
        for (String key : this.spells) {
            SpellTemplate spell;
            int spellLevel = this.getSpellLevel(key);
            SpellKey spellKey = new SpellKey(key, spellLevel);
            SpellTemplate spellTemplate = spell = this.mage == null ? this.controller.getSpellTemplate(spellKey.getKey()) : this.mage.getSpell(spellKey.getKey());
            itemStack = this.createSpellItem(spellKey.getKey(), "", false);
            if (itemStack == null) continue;
            slot = this.spellInventory.get(spell.getSpellKey().getBaseKey());
            if (slot == null) {
                unsorted.add(itemStack);
                continue;
            }
            this.addToInventory(itemStack, slot);
        }
        WandMode wandMode = this.getMode();
        WandMode brushMode = this.getBrushMode();
        for (String brushKey : this.brushes) {
            boolean addToInventory = brushMode == WandMode.INVENTORY || wandMode == WandMode.INVENTORY && com.elmakers.mine.bukkit.block.MaterialBrush.isSpecialMaterialKey(brushKey) && !com.elmakers.mine.bukkit.block.MaterialBrush.isSchematic(brushKey);
            if (!addToInventory) continue;
            itemStack = this.createBrushIcon(brushKey);
            if (itemStack == null) {
                this.controller.info("Unable to create brush icon for key " + brushKey, 5);
                continue;
            }
            slot = this.brushInventory.get(brushKey);
            if (this.activeBrush == null || this.activeBrush.length() == 0) {
                this.activeBrush = brushKey;
            }
            this.addToInventory(itemStack, slot);
        }
        for (ItemStack unsortedItem : unsorted) {
            this.addToInventory(unsortedItem);
        }
        this.updateHasInventory();
        if (this.openInventoryPage >= this.inventories.size() && this.openInventoryPage != 0 && this.hasInventory) {
            this.setOpenInventoryPage(0);
        }
        this.checkHotbarCount();
    }

    protected void parseSpells(String spellString) {
        spellString = spellString.replaceAll("[\\]\\[]", "");
        String[] spellNames = StringUtils.split((String)spellString, (char)',');
        this.loadSpells(Arrays.asList(spellNames));
    }

    protected void clearSpells() {
        this.spellLevels = new HashMap<String, Integer>();
        this.spells.clear();
    }

    private int getNextFreeSlot(int minSlot) {
        int hotbarCount = this.getHotbarCount();
        int pageStart = hotbarCount * 8;
        int inventorySize = this.getInventorySize();
        HashSet<Integer> used = new HashSet<Integer>();
        used.addAll(this.brushInventory.values());
        used.addAll(this.spellInventory.values());
        int slot = minSlot;
        while (true) {
            if (slot > pageStart && (slot - pageStart) % inventorySize > inventorySize - this.getOrganizeBuffer()) {
                slot = ((slot - pageStart) / inventorySize + 1) * inventorySize + pageStart;
            }
            if (!used.contains(slot)) {
                return slot;
            }
            ++slot;
        }
    }

    private int getMaxSlot() {
        int maxSlot = -1;
        for (Map.Entry<String, Integer> brush : this.brushInventory.entrySet()) {
            maxSlot = Math.max(maxSlot, brush.getValue());
        }
        for (Map.Entry<String, Integer> spell : this.spellInventory.entrySet()) {
            maxSlot = Math.max(maxSlot, spell.getValue());
        }
        return maxSlot;
    }

    protected void loadSpells(Collection<String> spellKeys) {
        this.clearSpells();
        WandUpgradePath path = this.getPath();
        int maxSlot = -1;
        int nextFreeSlot = 0;
        int hotbarCount = this.getHotbarCount();
        int pageStart = hotbarCount * 8;
        int inventorySize = this.getInventorySize();
        for (String spellName : spellKeys) {
            int maxLevel;
            if (spellName.equalsIgnoreCase("none")) {
                if (maxSlot < 0) {
                    maxSlot = this.getMaxSlot();
                }
                ++maxSlot;
                continue;
            }
            if (spellName.equalsIgnoreCase("newpage")) {
                if (maxSlot < 0) {
                    maxSlot = this.getMaxSlot();
                }
                if (maxSlot < pageStart) {
                    maxSlot = ((maxSlot + 1) / 8 + 1) * 8 - 1;
                    continue;
                }
                maxSlot = ((maxSlot + 1 - pageStart) / inventorySize + 1) * inventorySize + pageStart - 1;
                continue;
            }
            String[] pieces = StringUtils.split((String)spellName, (char)'@');
            Integer slot = this.parseSlot(pieces);
            SpellKey spellKey = new SpellKey(pieces[0].trim());
            spellKey = this.controller.unalias(spellKey);
            if (this.levelSpells && (maxLevel = this.controller.getMaxLevel(spellKey.getBaseKey())) > spellKey.getLevel()) {
                spellKey = new SpellKey(spellKey.getBaseKey(), maxLevel);
            }
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey.getKey());
            if (this.limitSpellsToPath && path != null && !path.containsSpell(spellKey.getBaseKey())) continue;
            while (spell == null && spellKey.getLevel() > 0) {
                spellKey = new SpellKey(spellKey.getBaseKey(), spellKey.getLevel() - 1);
                spell = this.controller.getSpellTemplate(spellKey.getKey());
            }
            if (spell == null) continue;
            spellKey = spell.getSpellKey();
            Integer currentLevel = this.spellLevels.get(spellKey.getBaseKey());
            if (spellKey.getLevel() > 1 && (currentLevel == null || currentLevel < spellKey.getLevel())) {
                this.setSpellLevel(spellKey.getBaseKey(), spellKey.getLevel());
            }
            if (slot == null) {
                slot = this.spellInventory.get(spellKey.getBaseKey());
            }
            if (slot == null) {
                if (maxSlot > nextFreeSlot) {
                    nextFreeSlot = maxSlot + 1;
                }
                slot = this.getNextFreeSlot(nextFreeSlot);
                nextFreeSlot = slot + 1;
            }
            this.spellInventory.put(spellKey.getBaseKey(), slot);
            this.spells.add(spellKey.getBaseKey());
            if (this.activeSpell != null && this.activeSpell.length() != 0) continue;
            this.activeSpell = spellKey.getBaseKey();
        }
    }

    private void loadSpells() {
        Object wandSpells = this.getObject("spells");
        if (wandSpells != null) {
            if (wandSpells instanceof String) {
                this.parseSpells((String)wandSpells);
            } else if (wandSpells instanceof Collection) {
                Collection spellList = (Collection)wandSpells;
                this.loadSpells(spellList);
            } else {
                this.clearSpells();
            }
        } else {
            this.clearSpells();
        }
    }

    protected void parseBrushes(String brushString) {
        brushString = brushString.replaceAll("[\\]\\[]", "");
        String[] brushNames = StringUtils.split((String)brushString, (char)',');
        this.loadBrushes(Arrays.asList(brushNames));
    }

    protected void clearBrushes() {
        this.brushes.clear();
    }

    protected void loadBrushes(Collection<String> brushKeys) {
        WandUpgradePath path = this.getPath();
        this.clearBrushes();
        for (String materialName : brushKeys) {
            String[] pieces = StringUtils.split((String)materialName, (char)'@');
            Integer slot = this.parseSlot(pieces);
            String materialKey = pieces[0].trim();
            if (this.limitBrushesToPath && path != null && !path.containsBrush(materialKey)) continue;
            if (slot != null) {
                this.brushInventory.put(materialKey, slot);
            }
            this.brushes.add(materialKey);
        }
    }

    private void loadBrushes() {
        Object wandBrushes = this.getObject("brushes", this.getObject("materials"));
        if (wandBrushes != null) {
            if (wandBrushes instanceof String) {
                this.parseBrushes((String)wandBrushes);
            } else if (wandBrushes instanceof Collection) {
                Collection brushList = (Collection)wandBrushes;
                this.loadBrushes(brushList);
            } else {
                this.clearBrushes();
            }
        } else {
            this.clearBrushes();
        }
    }

    protected void loadBrushInventory(Map<String, ? extends Object> inventory) {
        if (inventory == null) {
            return;
        }
        WandUpgradePath path = this.getPath();
        for (Map.Entry<String, ? extends Object> brushEntry : inventory.entrySet()) {
            Object slot = brushEntry.getValue();
            String brushKey = brushEntry.getKey();
            if (this.limitBrushesToPath && path != null && !path.containsBrush(brushKey) || slot == null || !(slot instanceof Integer)) continue;
            this.brushInventory.put(brushKey, (Integer)slot);
        }
    }

    protected void loadSpellInventory(Map<String, ? extends Object> inventory) {
        if (inventory == null) {
            return;
        }
        WandUpgradePath path = this.getPath();
        for (Map.Entry<String, ? extends Object> spellEntry : inventory.entrySet()) {
            Object slot;
            String spellKey = spellEntry.getKey();
            if (this.limitSpellsToPath && path != null && !path.containsSpell(spellKey) || (slot = spellEntry.getValue()) == null || !(slot instanceof Integer)) continue;
            this.spellInventory.put(spellKey, (Integer)slot);
        }
    }

    protected void loadSpellLevels(Map<String, ? extends Object> levels) {
        if (levels == null) {
            return;
        }
        for (Map.Entry<String, ? extends Object> spellEntry : levels.entrySet()) {
            Object level = spellEntry.getValue();
            if (level == null || !(level instanceof Integer)) continue;
            SpellKey spellKey = new SpellKey(spellEntry.getKey(), (Integer)level);
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey.getKey());
            while (spell == null && spellKey.getLevel() > 0) {
                spellKey = new SpellKey(spellKey.getBaseKey(), spellKey.getLevel() - 1);
                spell = this.controller.getSpellTemplate(spellKey.getKey());
            }
            this.setSpellLevel(spellKey.getBaseKey(), spellKey.getLevel());
        }
    }

    @Nullable
    public static ItemStack createSpellItem(String spellKey, MagicController controller, Wand wand, boolean isItem) {
        String[] split = spellKey.split(" ", 2);
        return Wand.createSpellItem(controller.getSpellTemplate(split[0]), split.length > 1 ? split[1] : "", controller, wand == null ? null : wand.getActiveMage(), wand, isItem);
    }

    @Nullable
    public static ItemStack createSpellItem(String spellKey, MagicController controller, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean isItem) {
        String[] split = spellKey.split(" ", 2);
        return Wand.createSpellItem(controller.getSpellTemplate(split[0]), split.length > 1 ? split[1] : "", controller, mage, wand, isItem);
    }

    @Nullable
    public ItemStack createSpellItem(String spellKey) {
        return this.createSpellItem(spellKey, "", false);
    }

    @Nullable
    public ItemStack createSpellItem(String spellKey, String args, boolean isItem) {
        SpellTemplate spell = this.mage == null ? this.controller.getSpellTemplate(spellKey) : this.mage.getSpell(spellKey);
        return Wand.createSpellItem(spell, args, this.controller, this.mage, this, isItem);
    }

    @Nullable
    public static ItemStack createSpellItem(SpellTemplate spell, String args, MagicController controller, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean isItem) {
        boolean urlIcons;
        if (spell == null) {
            return null;
        }
        String iconURL = spell.getIconURL();
        ItemStack itemStack = null;
        boolean bl = urlIcons = mage == null ? controller.isUrlIconsEnabled() : mage.isUrlIconsEnabled();
        if (iconURL != null && (urlIcons || spell.getIcon() == null || !spell.getIcon().isValid() || spell.getIcon().getMaterial() == Material.AIR)) {
            itemStack = controller.getURLSkull(iconURL);
        }
        if (itemStack == null) {
            ItemStack originalItemStack = null;
            MaterialAndData icon = spell.getIcon();
            if (icon == null) {
                controller.getLogger().warning("Unable to create spell icon for " + spell.getName() + ", missing material");
                return null;
            }
            try {
                originalItemStack = icon.getItemStack(1);
                itemStack = CompatibilityLib.getItemUtils().makeReal(originalItemStack);
            }
            catch (Exception ex) {
                itemStack = null;
            }
            if (itemStack == null) {
                if (icon.getMaterial() != Material.AIR) {
                    String iconName = icon.getName();
                    controller.getLogger().warning("Unable to create spell icon for " + spell.getKey() + " with material " + iconName);
                }
                return originalItemStack;
            }
        }
        CompatibilityLib.getItemUtils().makeUnbreakable(itemStack);
        CompatibilityLib.getItemUtils().hideFlags(itemStack, HIDE_FLAGS);
        Wand.updateSpellItem(controller.getMessages(), itemStack, spell, args, mage, wand, wand == null ? null : wand.activeBrush, isItem);
        if (wand != null && wand.getMode() == WandMode.SKILLS && !isItem) {
            String mageClassKey = wand.getMageClassKey();
            ConfigurationSection skillsConfig = wand.getConfigurationSection("skills");
            CompatibilityLib.getInventoryUtils().configureSkillItem(itemStack, mageClassKey, skillsConfig);
        }
        return itemStack;
    }

    @Nullable
    protected ItemStack createBrushIcon(String materialKey) {
        return Wand.createBrushItem(materialKey, this.controller, this, false);
    }

    @Nullable
    public static ItemStack createBrushItem(String materialKey, MageController controller, Wand wand, boolean isItem) {
        return Wand.createBrushItem(materialKey, controller, wand, isItem, true);
    }

    @Nullable
    public static ItemStack createBrushItem(String materialKey, MageController controller, Wand wand, boolean isItem, boolean useWandName) {
        ItemStack worthItem;
        Double itemWorth;
        Currency currency;
        boolean consumeFree;
        String keyMessage;
        com.elmakers.mine.bukkit.block.MaterialBrush brushData = com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey);
        if (brushData == null) {
            return null;
        }
        ItemStack itemStack = brushData.getItem(controller, isItem);
        if (BrushGlow || isItem && BrushItemGlow) {
            CompatibilityLib.getItemUtils().addGlow(itemStack);
        }
        CompatibilityLib.getItemUtils().makeUnbreakable(itemStack);
        CompatibilityLib.getItemUtils().hideFlags(itemStack, HIDE_FLAGS);
        Wand.updateBrushItem(controller.getMessages(), itemStack, brushData, wand, useWandName);
        ArrayList<String> lore = itemStack.getItemMeta().getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        String string = keyMessage = wand != null ? wand.getMessage("brush.key") : controller.getMessages().get("brush.key");
        if (keyMessage != null && !keyMessage.isEmpty()) {
            CompatibilityLib.getInventoryUtils().wrapText(keyMessage.replace("$key", materialKey), lore);
        }
        boolean bl = consumeFree = wand == null ? false : wand.isConsumeFree();
        if (brushData.getMode() == BrushMode.MATERIAL && !consumeFree && (currency = controller.getBlockExchangeCurrency()) != null && (itemWorth = controller.getWorth(worthItem = brushData.getItemStack(1), currency.getKey())) != null && itemWorth > 0.0) {
            String message;
            String string2 = message = wand != null ? wand.getMessage("brush.consumes", controller.getMessages().get("brush.consumes")) : controller.getMessages().get("brush.consumes");
            if (message != null && !message.isEmpty()) {
                lore.add(message.replace("$description", currency.formatAmount(itemWorth, controller.getMessages())));
            }
        }
        CompatibilityLib.getCompatibilityUtils().setLore(itemStack, lore);
        return itemStack;
    }

    protected boolean findItem() {
        Player player;
        if (this.mage != null && this.item != null && (player = this.mage.getPlayer()) != null) {
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand != null && !CompatibilityLib.getInventoryUtils().isSameInstance(itemInHand, this.item) && this.controller.isSameItem(itemInHand, this.item)) {
                this.item = itemInHand;
                this.isInOffhand = false;
                return true;
            }
            itemInHand = player.getInventory().getItemInOffHand();
            if (itemInHand != null && !CompatibilityLib.getInventoryUtils().isSameInstance(itemInHand, this.item) && this.controller.isSameItem(itemInHand, this.item)) {
                this.item = itemInHand;
                this.isInOffhand = true;
                return true;
            }
            itemInHand = player.getInventory().getItem(this.heldSlot);
            if (itemInHand != null && !CompatibilityLib.getInventoryUtils().isSameInstance(itemInHand, this.item) && this.controller.isSameItem(itemInHand, this.item)) {
                this.item = itemInHand;
                this.isInOffhand = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveState() {
        Object wandNode;
        if (this.findItem()) {
            this.updateItemIcon();
            this.updateName();
            this.updateLore();
        }
        if (this.item == null || this.item.getType() == Material.AIR) {
            return;
        }
        if (this.isUpgrade && Wand.isWand(this.item)) {
            CompatibilityLib.getNBTUtils().removeMeta(this.item, WAND_KEY);
        }
        if ((wandNode = CompatibilityLib.getNBTUtils().createNode(this.item, this.isUpgrade ? UPGRADE_KEY : WAND_KEY)) == null) {
            String ownerMessage = "";
            if (this.mage != null) {
                ownerMessage = " for player " + this.mage.getName();
            }
            this.controller.getLogger().warning("Failed to save wand state for wand to : " + this.item + ownerMessage);
        } else {
            CompatibilityLib.getInventoryUtils().saveTagsToNBT(this.getConfiguration(), wandNode);
        }
    }

    @Nullable
    public static ConfigurationSection itemToConfig(ItemStack item, ConfigurationSection stateNode) {
        Object wandNode = CompatibilityLib.getNBTUtils().getNode(item, WAND_KEY);
        if (wandNode == null && (wandNode = CompatibilityLib.getNBTUtils().getNode(item, UPGRADE_KEY)) == null) {
            return null;
        }
        ConfigurationUtils.loadAllTagsFromNBT(stateNode, wandNode);
        return stateNode;
    }

    public static void configToItem(ConfigurationSection itemSection, ItemStack item) {
        ConfigurationSection stateNode = itemSection.getConfigurationSection("wand");
        Object wandNode = CompatibilityLib.getNBTUtils().createNode(item, WAND_KEY);
        if (wandNode != null) {
            CompatibilityLib.getInventoryUtils().saveTagsToNBT(stateNode, wandNode);
        }
    }

    @Override
    public void save(ConfigurationSection node, boolean filtered) {
        ConfigurationUtils.addConfigurations(node, this.getConfiguration());
        if (filtered) {
            node.set("id", null);
            node.set("owner_id", null);
            node.set("owner", null);
            node.set("template", null);
            node.set("mana_timestamp", null);
            node.set("enchant_count", null);
        }
        if (this.isUpgrade) {
            node.set("upgrade", (Object)true);
        }
        if (this.template != null && !this.template.isEmpty()) {
            node.set("template", null);
            node.set("inherit", (Object)this.template);
        }
    }

    public void save() {
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public void updateBrushInventory() {
        if (this.brushInventory.isEmpty()) {
            this.setProperty("brush_inventory", null);
        } else {
            this.setProperty("brush_inventory", new HashMap<String, Integer>(this.brushInventory));
        }
    }

    @Override
    public void updateBrushInventory(Map<String, Integer> updateBrushes) {
        for (Map.Entry<String, Integer> brushEntry : this.brushInventory.entrySet()) {
            String brushKey = brushEntry.getKey();
            Integer slot = updateBrushes.get(brushKey);
            if (slot == null) continue;
            brushEntry.setValue(slot);
        }
    }

    public void updateSpellInventory() {
        if (this.spellInventory.isEmpty()) {
            this.setProperty("spell_inventory", null);
        } else {
            this.setProperty("spell_inventory", new HashMap<String, Integer>(this.spellInventory));
        }
    }

    @Override
    public void updateSpellInventory(Map<String, Integer> updateSpells) {
        for (Map.Entry<String, Integer> spellEntry : this.spellInventory.entrySet()) {
            String spellKey = spellEntry.getKey();
            Integer slot = updateSpells.get(spellKey);
            if (slot == null) continue;
            spellEntry.setValue(slot);
        }
    }

    private void migrateProtection(String legacy, String migrateTo) {
        if (this.hasProperty(legacy)) {
            double protection = this.getDouble(legacy);
            this.clearProperty(legacy);
            this.setProperty("protection." + migrateTo, protection);
        }
    }

    @Nullable
    private com.elmakers.mine.bukkit.block.MaterialAndData loadIcon(String key) {
        ItemStack bookItem;
        if (key == null || key.isEmpty()) {
            return null;
        }
        if (key.startsWith("book:") && (bookItem = this.controller.createItem(key)) != null) {
            return new com.elmakers.mine.bukkit.block.MaterialAndData(bookItem);
        }
        MaterialAndData materialData = null;
        ItemData itemData = this.controller.getItem(key);
        materialData = itemData != null ? itemData.getMaterialAndData() : new com.elmakers.mine.bukkit.block.MaterialAndData(key);
        return materialData instanceof com.elmakers.mine.bukkit.block.MaterialAndData ? (com.elmakers.mine.bukkit.block.MaterialAndData)materialData : null;
    }

    @Override
    public void loadProperties() {
        ConfigurationSection config;
        Object spellInventoryRaw;
        WandUpgradePath upgradePath;
        List<String> enchantmentList;
        String iconKey;
        int page;
        super.loadProperties();
        this.path = this.getString("path");
        this.locked = this.getBoolean("locked", this.locked);
        this.autoAbsorb = this.getBoolean("auto_absorb", false);
        this.lockedAllowUpgrades = this.getBoolean("locked_allow_upgrades", false);
        this.consumeReduction = this.getFloat("consume_reduction");
        this.cooldownReduction = this.getFloat("cooldown_reduction");
        this.costReduction = this.getFloat("cost_reduction");
        this.power = this.getFloat("power");
        this.inventoryOpenLore = this.getMessage("inventory_open", "");
        ConfigurationSection protectionConfig = this.getConfigurationSection("protection");
        if (protectionConfig == null && this.hasProperty("protection")) {
            this.migrateProtection("protection", "overall");
            this.migrateProtection("protection_physical", "physical");
            this.migrateProtection("protection_projectiles", "projectile");
            this.migrateProtection("protection_falling", "fall");
            this.migrateProtection("protection_fire", "fire");
            this.migrateProtection("protection_explosions", "explosion");
            protectionConfig = this.getConfigurationSection("protection");
        }
        if (protectionConfig != null) {
            this.protection = new HashMap<String, Double>();
            for (String protectionKey : protectionConfig.getKeys(false)) {
                this.protection.put(protectionKey, protectionConfig.getDouble(protectionKey));
            }
        }
        this.hasId = this.getBoolean("unique", false);
        this.blockChance = this.getFloat("block_chance");
        this.blockReflectChance = this.getFloat("block_reflect_chance");
        this.blockFOV = this.getFloat("block_fov");
        this.blockMageCooldown = this.getInt("block_mage_cooldown");
        this.blockCooldown = this.getInt("block_cooldown");
        this.manaPerDamage = this.getFloat("mana_per_damage");
        this.earnMultiplier = this.getFloat("earn_multiplier", this.getFloat("sp_multiplier", 1.0f));
        String interactibleMaterialKey = this.getString("interactible");
        this.interactibleMaterials = interactibleMaterialKey != null ? this.controller.getMaterialSetManager().fromConfigEmpty(interactibleMaterialKey) : null;
        String singleClass = this.getString("class");
        if (singleClass != null && !singleClass.isEmpty()) {
            this.mageClassKeys = new ArrayList<String>();
            this.mageClassKeys.add(singleClass);
        } else {
            this.mageClassKeys = this.getStringList("classes");
        }
        List<String> slottedKeys = this.getStringList("slotted");
        if (slottedKeys != null && !slottedKeys.isEmpty()) {
            this.slotted = new ArrayList<Wand>();
            for (String slottedKey : slottedKeys) {
                Wand slottedWand = this.controller.createWand(slottedKey);
                if (slottedWand == null) continue;
                this.slotted.add(slottedWand);
                this.updateSlotted(slottedWand);
            }
        }
        this.uses = this.getInt("uses");
        boolean bl = this.hasUses = this.uses > 0;
        if (this.hasUses) {
            boolean preuse = this.getBoolean("preuse", false);
            this.useMode = this.parseUseMode(this.getString("use_mode"), preuse ? WandUseMode.PRECAST : WandUseMode.SUCCESS);
        }
        if (!this.usesMana()) {
            this.removeProperty("mana_timestamp");
        } else if (!regenWhileInactive) {
            this.setProperty("mana_timestamp", System.currentTimeMillis());
        }
        this.id = this.getString("id");
        this.isUpgrade = this.getBoolean("upgrade");
        this.quietLevel = this.getInt("quiet");
        this.effectBubbles = this.getBoolean("effect_bubbles");
        this.keep = this.getBoolean("keep");
        this.worn = this.getBoolean("worn", this.getBoolean("passive"));
        this.indestructible = this.getBoolean("indestructible");
        this.superPowered = this.getBoolean("powered");
        this.superProtected = this.getBoolean("protected");
        this.glow = this.getBoolean("glow");
        this.spellGlow = this.getBoolean("spell_glow");
        this.undroppable = this.getBoolean("undroppable");
        this.isHeroes = this.getBoolean("heroes");
        this.bound = this.getBoolean("bound");
        this.boundDisplayName = this.getString("bound_name", "display").equals("display");
        this.forceUpgrade = this.getBoolean("force");
        this.autoOrganize = this.getBoolean("organize");
        this.autoAlphabetize = this.getBoolean("alphabetize");
        this.autoFill = this.getBoolean("fill");
        this.rename = this.getBoolean("rename");
        this.renameDescription = this.getBoolean("rename_description");
        this.enchantCount = this.getInt("enchant_count");
        this.maxEnchantCount = this.getInt("max_enchant_count");
        this.inventoryRows = this.getInt("inventory_rows", 5);
        this.showCycleModeLore = this.getBoolean("show_cycle_lore", true);
        this.useActiveName = this.getBoolean("use_active_name", false);
        if (this.inventoryRows <= 0) {
            this.inventoryRows = 1;
        }
        this.resetManaOnActivate = null;
        if (this.hasProperty("reset_mana_on_activate")) {
            String asString = this.getString("reset_mana_on_activate");
            if (asString.equalsIgnoreCase("true")) {
                this.resetManaOnActivate = 0.0;
            } else if (!asString.equalsIgnoreCase("false")) {
                this.resetManaOnActivate = this.getDouble("reset_mana_on_activate", 0.0);
            }
        }
        if (this.hasProperty("effect_particle")) {
            this.effectParticle = ConfigurationUtils.toParticleEffect(this.getString("effect_particle"));
            this.effectParticleData = 0.0f;
        } else {
            this.effectParticle = null;
        }
        this.effectSound = this.hasProperty("effect_sound") ? ConfigurationUtils.toSoundEffect(this.getString("effect_sound")) : null;
        this.activeEffectsOnly = this.getBoolean("active_effects");
        this.effectParticleData = this.getFloat("effect_particle_data");
        this.effectParticleCount = this.getInt("effect_particle_count");
        this.effectParticleRadius = this.getDouble("effect_particle_radius");
        this.effectParticleOffset = this.getDouble("effect_particle_offset");
        this.effectParticleInterval = this.getInt("effect_particle_interval");
        this.effectParticleMinVelocity = this.getDouble("effect_particle_min_velocity");
        this.effectSoundInterval = this.getInt("effect_sound_interval");
        this.castLocation = this.getVector("cast_location");
        this.castInterval = this.getInt("cast_interval");
        this.castMinVelocity = this.getDouble("cast_min_velocity");
        this.castVelocityDirection = this.getVector("cast_velocity_direction");
        this.castSpell = this.getString("cast_spell");
        String castParameterString = this.getString("cast_parameters", null);
        if (castParameterString != null && !castParameterString.isEmpty()) {
            this.castParameters = ConfigurationUtils.newConfigurationSection();
            ConfigurationUtils.addParameters(StringUtils.split((String)castParameterString, (char)' '), this.castParameters);
        } else {
            this.castParameters = null;
        }
        WandMode newMode = Wand.parseWandMode(this.getString("mode"), this.controller.getDefaultWandMode());
        if (newMode != this.mode) {
            if (this.isInventoryOpen()) {
                this.closeInventory();
            }
            this.mode = newMode;
        }
        this.brushMode = Wand.parseWandMode(this.getString("brush_mode"), this.controller.getDefaultBrushMode());
        if (this.getBoolean("mode_drop", false)) {
            this.dropAction = WandAction.TOGGLE;
            this.swapAction = WandAction.CYCLE_HOTBAR;
            this.rightClickAction = WandAction.NONE;
            this.quickCast = true;
            this.quickCastDisabled = true;
            this.manualQuickCastDisabled = false;
        } else if (this.mode == WandMode.CAST) {
            this.leftClickAction = WandAction.CAST;
            this.rightClickAction = WandAction.CAST;
            this.swapAction = WandAction.NONE;
            this.dropAction = WandAction.NONE;
        } else if (this.mode == WandMode.CYCLE) {
            this.leftClickAction = WandAction.CAST;
            this.rightClickAction = WandAction.NONE;
            this.swapAction = WandAction.NONE;
            this.dropAction = WandAction.CYCLE;
        } else {
            this.leftClickAction = WandAction.NONE;
            this.rightClickAction = WandAction.NONE;
            this.dropAction = WandAction.NONE;
            this.swapAction = WandAction.NONE;
            this.quickCast = false;
            this.quickCastDisabled = false;
            this.manualQuickCastDisabled = false;
        }
        String quickCastType = this.getString("quick_cast", this.getString("mode_cast"));
        if (quickCastType != null) {
            if (quickCastType.equalsIgnoreCase("true")) {
                this.quickCast = true;
                this.quickCastDisabled = true;
                this.manualQuickCastDisabled = false;
            } else if (quickCastType.equalsIgnoreCase("manual")) {
                this.quickCast = false;
                this.quickCastDisabled = true;
                this.manualQuickCastDisabled = false;
            } else if (quickCastType.equalsIgnoreCase("disable")) {
                this.quickCast = false;
                this.quickCastDisabled = true;
                this.manualQuickCastDisabled = true;
            } else {
                this.quickCast = false;
                this.quickCastDisabled = false;
                this.manualQuickCastDisabled = false;
            }
        }
        this.leftClickAction = Wand.parseWandAction(this.getString("left_click"), this.leftClickAction);
        this.rightClickAction = Wand.parseWandAction(this.getString("right_click"), this.rightClickAction);
        this.dropAction = Wand.parseWandAction(this.getString("drop"), this.dropAction);
        this.swapAction = Wand.parseWandAction(this.getString("swap"), this.swapAction);
        this.leftClickSneakAction = Wand.parseWandAction(this.getString("left_click_sneak"), this.leftClickSneakAction);
        this.rightClickSneakAction = Wand.parseWandAction(this.getString("right_click_sneak"), this.rightClickSneakAction);
        this.dropSneakAction = Wand.parseWandAction(this.getString("drop_sneak"), this.dropSneakAction);
        this.swapSneakAction = Wand.parseWandAction(this.getString("swap_sneak"), this.swapSneakAction);
        this.owner = this.getString("owner");
        this.ownerId = this.getString("owner_id");
        this.template = this.getString("template");
        this.upgradeTemplate = this.getString("upgrade_template");
        this.activeSpell = this.getString("active_spell");
        if (this.activeSpell != null && this.activeSpell.contains("|")) {
            SpellKey activeKey = new SpellKey(this.activeSpell);
            this.activeSpell = activeKey.getBaseKey();
            this.setProperty("active_spell", this.activeSpell);
        }
        for (int i = 0; i < this.alternateSpells.length; ++i) {
            String key = "alternate_spell";
            if (i > 0) {
                key = key + (i + 1);
            }
            this.alternateSpells[i] = this.getString(key);
        }
        this.activeBrush = this.getString("active_brush", this.getString("active_material"));
        if (this.hasProperty("hotbar")) {
            this.currentHotbar = this.getInt("hotbar");
        }
        if (this.hasProperty("page") && (page = this.getInt("page")) != this.openInventoryPage) {
            this.openInventoryPage = page;
        }
        this.wandName = this.controller.getMessages().get("wand.default_name");
        this.description = "";
        ConfigurationSection templateConfig = null;
        if (this.template != null && !this.template.isEmpty()) {
            templateConfig = this.controller.getWandTemplateConfiguration(this.template);
            if (templateConfig != null) {
                this.wandName = templateConfig.getString("name", this.wandName);
                this.description = templateConfig.getString("description", this.description);
                int templateUses = templateConfig.getInt("uses");
                this.isSingleUse = templateUses == 1;
                this.hasUses = this.hasUses || templateUses > 0;
            }
            this.wandName = this.controller.getMessages().get("wands." + this.template + ".name", this.wandName);
            this.description = this.controller.getMessages().get("wands." + this.template + ".description", this.description);
        }
        this.wandName = this.getString("name", this.wandName);
        this.description = this.getString("description", this.description);
        List<String> flagList = this.getStringList("item_flags");
        if (flagList != null) {
            this.hideFlags = 0;
            for (String flagKey : flagList) {
                try {
                    ItemFlag flag = ItemFlag.valueOf((String)flagKey.toUpperCase());
                    this.hideFlags |= 1 << flag.ordinal();
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Invalid ItemFlag: " + flagKey);
                }
            }
        } else {
            this.hideFlags = this.getProperty("hide_flags", HIDE_FLAGS);
        }
        WandTemplate wandTemplate = this.getTemplate();
        boolean legacyIcons = this.controller.isLegacyIconsEnabled();
        if (this.hasIcon(legacyIcons, "icon_inactive")) {
            iconKey = this.getIcon(legacyIcons, "icon_inactive");
            if (wandTemplate != null) {
                iconKey = wandTemplate.migrateIcon(iconKey);
            }
            if (iconKey != null) {
                this.inactiveIcon = this.loadIcon(iconKey);
            }
        } else {
            this.inactiveIcon = null;
        }
        if (this.inactiveIcon != null && (this.inactiveIcon.getMaterial() == null || this.inactiveIcon.getMaterial() == Material.AIR)) {
            this.inactiveIcon = null;
        }
        this.inactiveIconDelay = this.getInt("icon_inactive_delay");
        boolean bl2 = this.randomizeOnActivate = this.randomizeOnActivate && this.hasIcon(legacyIcons, "randomize_icon");
        if (this.randomizeOnActivate) {
            String randomizeIcon = this.getIcon(legacyIcons, "randomize_icon");
            this.setIcon(this.loadIcon(randomizeIcon));
            if (this.item == null) {
                this.controller.getLogger().warning("Invalid randomize_icon in wand '" + this.template + "' config: " + randomizeIcon);
                this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(DefaultWandMaterial));
            }
        } else if (this.hasIcon(legacyIcons)) {
            iconKey = this.getIcon(legacyIcons);
            if (wandTemplate != null) {
                iconKey = wandTemplate.migrateIcon(iconKey);
            }
            if (iconKey.contains(",")) {
                Random r = new Random();
                String[] keys = StringUtils.split((String)iconKey, (char)',');
                iconKey = keys[r.nextInt(keys.length)];
            }
            if (templateConfig != null && iconKey.contains("i.imgur.com")) {
                iconKey = ConfigurationUtils.getIcon(templateConfig, legacyIcons);
            }
            this.setIcon(this.loadIcon(iconKey));
            if (this.item == null) {
                this.controller.getLogger().warning("Invalid icon in wand '" + this.template + "' config: " + iconKey);
                this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(DefaultWandMaterial));
            }
            this.updateIcon();
        } else if (this.isUpgrade) {
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(DefaultUpgradeMaterial));
        } else {
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(DefaultWandMaterial));
        }
        if (this.getBoolean("unswappable")) {
            CompatibilityLib.getNBTUtils().setMetaBoolean(this.item, "unswappable", true);
        } else {
            CompatibilityLib.getNBTUtils().removeMeta(this.item, "unswappable");
        }
        if (this.getBoolean("unstashable") || this.undroppable && Unstashable) {
            CompatibilityLib.getNBTUtils().setMetaBoolean(this.item, "unstashable", true);
        } else {
            CompatibilityLib.getNBTUtils().removeMeta(this.item, "unstashable");
        }
        if (this.getBoolean("craftable")) {
            CompatibilityLib.getNBTUtils().setMetaBoolean(this.item, "craftable", true);
        } else {
            CompatibilityLib.getNBTUtils().removeMeta(this.item, "craftable");
        }
        if (this.getBoolean("unmoveable")) {
            CompatibilityLib.getNBTUtils().setMetaBoolean(this.item, "unmoveable", true);
        } else {
            CompatibilityLib.getNBTUtils().removeMeta(this.item, "unmoveable");
        }
        if (this.undroppable) {
            CompatibilityLib.getNBTUtils().setMetaBoolean(this.item, "undroppable", true);
        } else {
            CompatibilityLib.getNBTUtils().removeMeta(this.item, "undroppable");
        }
        if (this.keep) {
            CompatibilityLib.getNBTUtils().setMetaBoolean(this.item, "keep", true);
        } else {
            CompatibilityLib.getNBTUtils().removeMeta(this.item, "keep");
        }
        ConfigurationSection enchantments = this.getConfigurationSection("enchantments");
        if (enchantments == null && (enchantmentList = this.getStringList("enchantments")) != null && !enchantmentList.isEmpty()) {
            enchantments = ConfigurationUtils.newConfigurationSection();
            for (String enchantKey : enchantmentList) {
                enchantments.set(enchantKey, (Object)0);
            }
        }
        CompatibilityLib.getInventoryUtils().applyEnchantments(this.item, enchantments);
        if (enchantments == null || enchantments.getKeys(false).isEmpty()) {
            if (this.glow) {
                CompatibilityLib.getItemUtils().addGlow(this.item);
            } else {
                CompatibilityLib.getItemUtils().removeGlow(this.item);
            }
        }
        if ((upgradePath = this.getPath()) != null) {
            this.hasSpellProgression = upgradePath.getSpells().size() > 0 || upgradePath.getExtraSpells().size() > 0 || upgradePath.getRequiredSpells().size() > 0;
            upgradePath.checkMigration(this);
        } else {
            this.hasSpellProgression = false;
        }
        if (this.isHeroes) {
            this.hasSpellProgression = true;
        }
        this.brushInventory.clear();
        this.spellInventory.clear();
        this.limitSpellsToPath = this.getBoolean("limit_spells_to_path");
        this.limitBrushesToPath = this.getBoolean("limit_brushes_to_path");
        this.levelSpells = this.getBoolean("level_spells");
        Object brushInventoryRaw = this.getObject("brush_inventory");
        if (brushInventoryRaw != null) {
            if (brushInventoryRaw instanceof Map) {
                Map brushInventory = (Map)brushInventoryRaw;
                this.loadBrushInventory(brushInventory);
            } else if (brushInventoryRaw instanceof ConfigurationSection) {
                this.loadBrushInventory(CompatibilityLib.getCompatibilityUtils().getMap((ConfigurationSection)brushInventoryRaw));
            }
        }
        if ((spellInventoryRaw = this.getObject("spell_inventory")) != null) {
            if (spellInventoryRaw instanceof Map) {
                Map spellInventory = (Map)spellInventoryRaw;
                this.loadSpellInventory(spellInventory);
            } else if (spellInventoryRaw instanceof ConfigurationSection) {
                this.loadSpellInventory(CompatibilityLib.getCompatibilityUtils().getMap((ConfigurationSection)spellInventoryRaw));
            }
        }
        this.loadSpells();
        Object spellLevelsRaw = this.getObject("spell_levels");
        if (spellLevelsRaw != null) {
            if (spellLevelsRaw instanceof Map) {
                Map spellLevels = (Map)spellLevelsRaw;
                this.loadSpellLevels(spellLevels);
            } else if (spellLevelsRaw instanceof ConfigurationSection) {
                this.loadSpellLevels(CompatibilityLib.getCompatibilityUtils().getMap((ConfigurationSection)spellLevelsRaw));
            }
        }
        this.checkActiveSpell();
        this.loadBrushes();
        if (spellInventoryRaw == null) {
            this.updateSpellInventory();
        }
        if (this.effectSound == null) {
            this.effectSoundInterval = 0;
        } else {
            int n = this.effectSoundInterval = this.effectSoundInterval == 0 ? 5 : this.effectSoundInterval;
        }
        if (this.effectParticle == null) {
            this.effectParticleInterval = 0;
        }
        this.checkActiveMaterial();
        this.bossBarConfiguration = null;
        if (this.getBoolean("boss_bar", false)) {
            this.bossBarConfiguration = new BossBarConfiguration(this.controller, ConfigurationUtils.newConfigurationSection());
        } else {
            config = this.getConfigurationSection("boss_bar");
            if (config != null) {
                this.bossBarDisplayMode = this.parseDisplayMode(config, WandDisplayMode.COOLDOWN);
                if (this.bossBarDisplayMode != WandDisplayMode.NONE) {
                    this.bossBarConfiguration = new BossBarConfiguration(this.controller, config, "$wand");
                }
            } else {
                String bossBarMode = this.getString("boss_bar");
                this.bossBarDisplayMode = this.parseDisplayMode(bossBarMode, WandDisplayMode.NONE);
                if (this.bossBarDisplayMode != WandDisplayMode.NONE) {
                    this.bossBarConfiguration = new BossBarConfiguration(this.controller, ConfigurationUtils.newConfigurationSection());
                }
            }
        }
        config = this.getConfigurationSection("xp_display");
        if (config != null) {
            this.xpBarDisplayMode = this.parseDisplayMode(config, WandDisplayMode.MANA);
        } else {
            String displayMode = this.getString("xp_display");
            this.xpBarDisplayMode = this.parseDisplayMode(displayMode, WandDisplayMode.MANA);
        }
        config = this.getConfigurationSection("level_display");
        if (config != null) {
            this.levelDisplayMode = this.parseDisplayMode(config, WandDisplayMode.SP);
        } else {
            String currencyDisplay = this.getString("currency_display", "sp");
            if (!currencyDisplay.equals("sp")) {
                this.levelDisplayMode = currencyDisplay.isEmpty() ? WandDisplayMode.NONE : WandDisplayMode.getCurrency(currencyDisplay);
            } else {
                String displayMode = this.getString("level_display");
                this.levelDisplayMode = this.parseDisplayMode(displayMode, WandDisplayMode.SP);
            }
        }
        config = this.getConfigurationSection("action_bar");
        if (config != null) {
            this.actionBarMessage = config.getString("message");
            if (this.actionBarMessage.isEmpty()) {
                this.actionBarMessage = null;
            } else {
                this.actionBarInterval = config.getInt("interval", 1000);
                this.actionBarMana = config.getBoolean("uses_mana");
            }
            this.lastActionBar = 0L;
        } else {
            this.actionBarMessage = this.getString("action_bar");
        }
        if (this.actionBarMessage == null) {
            this.actionBarMana = false;
        }
    }

    private WandDisplayMode parseDisplayMode(String displayMode, WandDisplayMode defaultMode) {
        WandDisplayMode mode = null;
        try {
            mode = WandDisplayMode.parse(displayMode);
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("Invalid display mode: " + ex.getMessage());
        }
        return mode == null ? defaultMode : mode;
    }

    private WandDisplayMode parseDisplayMode(ConfigurationSection config, WandDisplayMode defaultMode) {
        WandDisplayMode mode = defaultMode;
        try {
            mode = WandDisplayMode.parse(this.controller, config, "mode");
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("Invalid display mode: " + ex.getMessage());
        }
        return mode == null ? defaultMode : mode;
    }

    private void checkBossBar() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null || this.bossBarConfiguration == null) {
            return;
        }
        if (!this.bossBarDisplayMode.isEnabled(this)) {
            return;
        }
        if (this.bossBar == null) {
            this.bossBar = this.bossBarConfiguration.createBossBar(this.mage);
            this.bossBar.addPlayer(player);
        }
        double progress = this.bossBarDisplayMode.getProgress(this);
        this.bossBar.setProgress(Math.min(1.0, Math.max(0.0, progress)));
    }

    private void removeBossBar() {
        if (this.bossBar != null) {
            this.bossBar.setVisible(false);
            this.bossBar.removeAll();
            this.bossBar = null;
        }
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        ChatColor wandColor = this.isModifiable() ? ChatColor.AQUA : ChatColor.RED;
        sender.sendMessage(wandColor + this.getName());
        if (this.isUpgrade) {
            sender.sendMessage(ChatColor.YELLOW + "(Upgrade)");
        }
        if (this.description.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + this.description);
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + "(No Description)");
        }
        if (this.owner != null && this.owner.length() > 0 && this.ownerId != null && this.ownerId.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + this.owner + " (" + ChatColor.GRAY + this.ownerId + ChatColor.WHITE + ")");
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + "(No Owner)");
        }
        super.describe(sender, ignoreProperties);
        WandTemplate template = this.getTemplate();
        if (template != null) {
            sender.sendMessage("" + ChatColor.BOLD + ChatColor.GREEN + "Template Configuration:");
            ConfigurationSection itemConfig = this.getConfiguration();
            Set ownKeys = itemConfig.getKeys(false);
            template.describe(sender, ignoreProperties, ownKeys);
        }
    }

    private static String getBrushDisplayName(com.elmakers.mine.bukkit.api.magic.Messages messages, MaterialBrush brush) {
        String materialName;
        String string = materialName = brush == null || !brush.isValid() ? null : brush.getName(messages);
        if (materialName == null) {
            materialName = "none";
        }
        String brushPrefix = CompatibilityLib.getCompatibilityUtils().translateColors(messages.get("wand.brush_prefix"));
        return brushPrefix + materialName;
    }

    private static String getSpellDisplayName(com.elmakers.mine.bukkit.api.magic.Messages messages, SpellTemplate spell, MaterialBrush brush) {
        String name = "";
        if (spell != null) {
            String spellPrefix = CompatibilityLib.getCompatibilityUtils().translateColors(messages.get("wand.spell_prefix"));
            name = brush != null && spell.usesBrush() && spell.showBrush() ? spellPrefix + spell.getName() + " " + Wand.getBrushDisplayName(messages, brush) + ChatColor.WHITE : spellPrefix + spell.getName() + ChatColor.WHITE;
        }
        return name;
    }

    private String getCustomName(String displayName, SpellTemplate spell, MaterialBrush brush) {
        String name = displayName;
        name = name.replace("$name", this.wandName);
        String pathName = this.getPathName();
        if (pathName != null) {
            name = name.replace("$path", pathName);
        }
        String spellName = spell == null ? "" : spell.getName();
        name = name.replace("$spell", spellName);
        String brushName = brush == null ? "" : brush.getName();
        name = name.replace("$brush", brushName);
        name = name.replace("$uses", Integer.toString(this.getRemainingUses()));
        return CompatibilityLib.getCompatibilityUtils().translateColors(name);
    }

    private String getActiveWandName(SpellTemplate spell, MaterialBrush brush) {
        String customName = this.getString("display_name");
        if (customName != null && !customName.isEmpty()) {
            return this.getCustomName(customName, spell, brush);
        }
        int remaining = this.getRemainingUses();
        String wandColorPrefix = this.hasUses && remaining <= 1 ? "single_use_prefix" : (this.isModifiable() ? (this.bound ? "bound_prefix" : "unbound_prefix") : (this.path != null && this.path.length() > 0 ? "has_path_prefix" : "unmodifiable_prefix"));
        String name = CompatibilityLib.getCompatibilityUtils().translateColors(this.getMessage(wandColorPrefix)) + this.getDisplayName();
        if (this.randomizeOnActivate) {
            return name;
        }
        Collection spells = this.getSpells();
        Messages messages = this.controller.getMessages();
        boolean showSpell = this.isModifiable() && this.hasSpellProgression();
        showSpell = !this.quickCast && (spells.size() > 1 || showSpell) && this.getMode() != WandMode.SKILLS;
        boolean bl = showSpell = showSpell || this.useActiveName;
        if (spell != null && showSpell) {
            name = Wand.getSpellDisplayName(messages, spell, brush) + " (" + name + ChatColor.WHITE + ")";
        }
        if (remaining > 1) {
            String message = this.getMessage("uses_remaining_brief");
            name = name + ChatColor.DARK_RED + " (" + message.replace("$count", Integer.toString(remaining)) + ChatColor.DARK_RED + ")";
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell) {
        return this.getActiveWandName(spell, this.mage == null ? com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(this.activeBrush) : this.mage.getBrush());
    }

    private String getActiveWandName(com.elmakers.mine.bukkit.block.MaterialBrush brush) {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell, brush);
    }

    private String getActiveWandName() {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell);
    }

    protected String getDisplayName() {
        return CompatibilityLib.getCompatibilityUtils().translateColors(this.randomizeOnActivate ? this.getMessage("randomized_name") : this.wandName);
    }

    public void updateName(boolean isActive) {
        this.updateName(isActive, false);
    }

    public void updateName(boolean isActive, boolean stripColors) {
        String name;
        if (isActive || this.useActiveName) {
            name = !this.isUpgrade ? this.getActiveWandName() : CompatibilityLib.getCompatibilityUtils().translateColors(this.getMessage("upgrade_prefix")) + this.getDisplayName();
        } else {
            String string = name = stripColors ? this.getDisplayName() : this.getActiveWandName(null, null);
        }
        if (stripColors) {
            name = ChatColor.stripColor((String)name);
        }
        CompatibilityLib.getCompatibilityUtils().setDisplayName(this.item, name);
        if (!stripColors) {
            CompatibilityLib.getItemUtils().hideFlags(this.item, this.hideFlags);
        } else if ((this.hideFlags & 1) == 1) {
            CompatibilityLib.getItemUtils().hideFlags(this.item, this.hideFlags & 0xFFFFFFFE);
        }
    }

    private void updateName() {
        this.updateName(this.isActive);
    }

    protected static String convertToHTML(String line) {
        int tagCount = 1;
        line = "<span style=\"color:white\">" + line;
        for (ChatColor c : ChatColor.values()) {
            tagCount += StringUtils.countMatches((String)line, (String)c.toString());
            String replaceStyle = "";
            if (c == ChatColor.ITALIC) {
                replaceStyle = "font-style: italic";
            } else if (c == ChatColor.BOLD) {
                replaceStyle = "font-weight: bold";
            } else if (c == ChatColor.UNDERLINE) {
                replaceStyle = "text-decoration: underline";
            } else {
                String color = c.name().toLowerCase().replace("_", "");
                if (c == ChatColor.LIGHT_PURPLE) {
                    color = "mediumpurple";
                }
                replaceStyle = "color:" + color;
            }
            line = line.replace(c.toString(), "<span style=\"" + replaceStyle + "\">");
        }
        for (int i = 0; i < tagCount; ++i) {
            line = line + "</span>";
        }
        return line;
    }

    public String getHTMLDescription() {
        List<String> rawLore = this.getLore();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("<h2>" + Wand.convertToHTML(this.getActiveWandName()) + "</h2>");
        for (String line : rawLore) {
            lore.add(Wand.convertToHTML(line));
        }
        return "<div style=\"background-color: black; margin: 8px; padding: 8px\">" + StringUtils.join(lore, (String)"<br/>") + "</div>";
    }

    private String getPropertyString(String templateName, float value) {
        return this.getPropertyString(templateName, value, 1.0f);
    }

    private String getPropertyString(String templateName, float value, float max) {
        String propertyTemplate;
        String string = propertyTemplate = this.getBoolean("stack") ? "property_stack" : "property_value";
        if (value < 0.0f) {
            propertyTemplate = propertyTemplate + "_negative";
        }
        return this.controller.getMessages().getPropertyString(this.getMessageKey(templateName), value, max, this.getMessageKey(propertyTemplate));
    }

    private String formatPropertyString(String message, float value, float max) {
        String propertyTemplate;
        String string = propertyTemplate = this.getBoolean("stack") ? "property_stack" : "property_value";
        if (value < 0.0f) {
            propertyTemplate = propertyTemplate + "_negative";
        }
        return this.controller.getMessages().formatPropertyString(message, value, max, this.getMessage(propertyTemplate));
    }

    private void addDamageTypeLore(String property, String propertyType, double amount, List<String> lore) {
        this.addDamageTypeLore(property, propertyType, amount, 1.0, lore);
    }

    private void addDamageTypeLore(String property, String propertyType, double amount, double max, List<String> lore) {
        this.addDamageTypeLore(property, propertyType, amount, max, lore, null);
    }

    private void addDamageTypeLore(String property, String propertyType, double amount, double max, List<String> lore, String unknownDefault) {
        if (amount != 0.0) {
            String template;
            String prefix = this.getMessageKey("prefixes." + property);
            prefix = this.controller.getMessages().get(prefix, "");
            String templateKey = this.getMessageKey(property + "." + propertyType);
            if (this.controller.getMessages().containsKey(templateKey)) {
                template = this.controller.getMessages().get(templateKey);
            } else {
                templateKey = this.getMessageKey(property + ".unknown");
                template = this.controller.getMessages().get(templateKey);
                String pretty = propertyType.substring(0, 1).toUpperCase() + propertyType.substring(1);
                template = template.replace("$type", pretty);
                if (unknownDefault != null && !unknownDefault.isEmpty()) {
                    unknownDefault = WordUtils.capitalize((String)unknownDefault.toLowerCase().replace("_", " "));
                    template = template.replace("$name", unknownDefault);
                }
            }
            template = this.formatPropertyString(prefix + template, (float)amount, (float)max);
            ConfigurationUtils.addIfNotEmpty(template, lore);
        }
    }

    public String getLevelString(String templateName, float amount) {
        return this.controller.getMessages().getLevelString(this.getMessageKey(templateName), amount);
    }

    public String getLevelString(String templateName, float amount, float max) {
        return this.controller.getMessages().getLevelString(this.getMessageKey(templateName), amount, max);
    }

    protected List<String> getCustomLore(Collection<String> loreTemplate) {
        ArrayList<String> lore = new ArrayList<String>();
        block20: for (String line : loreTemplate) {
            if (line == null) {
                line = "";
            }
            if (line.startsWith("$")) {
                switch (line) {
                    case "$description": {
                        this.addDescriptionLore(lore);
                        break;
                    }
                    case "$path": {
                        String pathTemplate = this.getMessage("path_lore", "");
                        String pathName = this.getPathName();
                        if (pathName == null || pathTemplate.isEmpty()) continue block20;
                        lore.add(pathTemplate.replace("$path", pathName));
                        break;
                    }
                    case "$owner": {
                        this.addOwnerDescription(lore);
                        break;
                    }
                    case "$spells": {
                        int spellCount = this.getSpells().size();
                        if (spellCount <= 0) continue block20;
                        ConfigurationUtils.addIfNotEmpty(this.getMessage("spell_count").replace("$count", Integer.toString(spellCount)), lore);
                        break;
                    }
                    case "$brushes": {
                        int materialCount = this.getBrushes().size();
                        if (materialCount <= 0) continue block20;
                        ConfigurationUtils.addIfNotEmpty(this.getMessage("material_count").replace("$count", Integer.toString(materialCount)), lore);
                        break;
                    }
                    case "$uses": {
                        this.addUseLore(lore);
                        break;
                    }
                    case "$mana_max": {
                        if (!this.usesMana()) continue block20;
                        float manaMax = this.getManaMax();
                        if (this.effectiveManaMax != manaMax) {
                            String fullMessage = this.getLevelString("mana_amount_boosted", manaMax, this.controller.getMaxMana());
                            ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString((int)Math.ceil(this.effectiveManaMax))), lore);
                            break;
                        }
                        ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_amount", manaMax, this.controller.getMaxMana()), lore);
                        break;
                    }
                    case "$mana_regeneration": {
                        double manaRegeneration;
                        if (!this.usesMana() || !((manaRegeneration = (double)this.getManaRegeneration()) > 0.0)) continue block20;
                        if ((double)this.effectiveManaRegeneration != manaRegeneration) {
                            String fullMessage = this.getLevelString("mana_regeneration_boosted", (int)Math.ceil(manaRegeneration), this.controller.getMaxManaRegeneration());
                            ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString((int)Math.ceil(this.effectiveManaRegeneration))), lore);
                            break;
                        }
                        ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_regeneration", (int)Math.ceil(manaRegeneration), this.controller.getMaxManaRegeneration()), lore);
                        break;
                    }
                    default: {
                        if (this.mage != null) {
                            line = this.mage.parameterize(line);
                        }
                        lore.add(CompatibilityLib.getCompatibilityUtils().translateColors(line));
                    }
                }
                continue;
            }
            if (this.mage != null) {
                line = this.mage.parameterize(line);
            }
            lore.add(CompatibilityLib.getCompatibilityUtils().translateColors(line));
        }
        return lore;
    }

    protected void addDescriptionLore(List<String> lore) {
        String description = this.getAndUpdateDescription();
        CompatibilityLib.getInventoryUtils().wrapText(description, lore);
    }

    protected String getAndUpdateDescription() {
        String newDescription;
        String updatedDescription = this.description;
        if (this.description.contains("$") && !this.description.contains("$path") && !(newDescription = this.controller.getMessages().escape(this.description)).equals(this.description)) {
            this.description = newDescription;
            this.setProperty("description", this.description);
            updatedDescription = newDescription;
        }
        String descriptionTemplate = this.controller.getMessages().get(this.getMessageKey("description_lore"), "");
        if (this.description.contains("$path") && !descriptionTemplate.isEmpty()) {
            String pathName = this.getPathName();
            updatedDescription = updatedDescription.replace("$path", pathName == null ? "Unknown" : pathName);
        } else if (this.description.contains("$")) {
            String randomDescription = this.getMessage("randomized_lore");
            String randomTemplate = this.controller.getMessages().get(this.getMessageKey("randomized_description"), "");
            if (randomDescription.length() > 0 && !randomTemplate.isEmpty()) {
                updatedDescription = randomDescription;
            }
        } else if (!descriptionTemplate.isEmpty()) {
            updatedDescription = descriptionTemplate.replace("$description", this.description);
        }
        updatedDescription = CompatibilityLib.getCompatibilityUtils().translateColors(updatedDescription);
        return updatedDescription;
    }

    @Nullable
    protected String getPathName() {
        String pathName = null;
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = this.getPath();
        if (path != null) {
            pathName = path.getName();
        } else if (this.mageClassKeys != null && !this.mageClassKeys.isEmpty()) {
            for (String classKey : this.mageClassKeys) {
                MageClassTemplate classTemplate = this.controller.getMageClassTemplate(classKey);
                if (classTemplate == null) continue;
                String pathKey = classTemplate.getProperty("path", "");
                if (!pathKey.isEmpty()) {
                    path = this.controller.getPath(pathKey);
                }
                if (path != null) {
                    pathName = path.getName();
                    break;
                }
                pathName = classTemplate.getName();
                break;
            }
        }
        return pathName;
    }

    protected void addOwnerDescription(List<String> lore) {
        if (this.owner != null && this.owner.length() > 0) {
            if (this.bound) {
                String ownerDescription = this.getMessage("bound_description", "$name").replace("$name", this.owner);
                ConfigurationUtils.addIfNotEmpty(ownerDescription, lore);
            } else {
                String ownerDescription = this.getMessage("owner_description", "$name").replace("$name", this.owner);
                ConfigurationUtils.addIfNotEmpty(ownerDescription, lore);
            }
        }
    }

    protected List<String> getLore() {
        boolean isSingleSpell;
        String slot;
        List<String> messagesLore = this.controller.getMessages().getAll(this.getMessageKey("lore"));
        if (messagesLore != null) {
            return this.getCustomLore(messagesLore);
        }
        Object customLore = this.getProperty("lore");
        if (customLore != null && customLore instanceof Collection) {
            return this.getCustomLore((Collection)customLore);
        }
        ArrayList<String> lore = new ArrayList<String>();
        int spellCount = this.getSpells().size();
        int materialCount = this.getBrushes().size();
        if (this.isUpgrade && (slot = this.getString("slot")) != null && !slot.isEmpty()) {
            String slotName = this.controller.getMessages().get("slots." + slot + ".name", slot);
            ConfigurationUtils.addIfNotEmpty(this.getMessage("upgrade_slot").replace("$slot", slotName), lore);
        }
        String pathName = this.getPathName();
        if (this.description.length() > 0) {
            if (this.randomizeOnActivate) {
                String randomDescription = this.getMessage("randomized_lore");
                String randomTemplate = this.controller.getMessages().get(this.getMessageKey("randomized_description"), "");
                if (randomDescription.length() > 0 && !randomTemplate.isEmpty()) {
                    CompatibilityLib.getInventoryUtils().wrapText(randomTemplate.replace("$description", randomDescription), lore);
                    return lore;
                }
            }
            String description = this.getAndUpdateDescription();
            CompatibilityLib.getInventoryUtils().wrapText(description, lore);
        }
        String pathTemplate = this.getMessage("path_lore", "");
        if (pathName != null && !pathTemplate.isEmpty()) {
            lore.add(pathTemplate.replace("$path", pathName));
        }
        if (!this.isUpgrade) {
            this.addOwnerDescription(lore);
        }
        SpellTemplate spell = this.mage == null ? this.controller.getSpellTemplate(this.getActiveSpellKey()) : this.mage.getSpell(this.getActiveSpellKey());
        Messages messages = this.controller.getMessages();
        boolean bl = isSingleSpell = spell != null && spellCount == 1 && !this.hasInventory && !this.isUpgrade;
        if (this.showCycleModeLore && this.getMode() == WandMode.CYCLE && spell != null) {
            isSingleSpell = true;
        }
        if (isSingleSpell) {
            Wand.addSpellLore(messages, spell, lore, this.getActiveMage(), this);
        }
        if (materialCount == 1 && this.activeBrush != null && this.activeBrush.length() > 0) {
            lore.add(Wand.getBrushDisplayName(messages, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(this.activeBrush)));
        }
        if (spellCount > 0) {
            if (this.isUpgrade) {
                ConfigurationUtils.addIfNotEmpty(this.getMessage("upgrade_spell_count").replace("$count", Integer.toString(spellCount)), lore);
            } else if (spellCount > 1) {
                ConfigurationUtils.addIfNotEmpty(this.getMessage("spell_count").replace("$count", Integer.toString(spellCount)), lore);
            }
        }
        if (materialCount > 0) {
            if (this.isUpgrade) {
                ConfigurationUtils.addIfNotEmpty(this.getMessage("upgrade_material_count").replace("$count", Integer.toString(materialCount)), lore);
            } else if (materialCount > 1) {
                ConfigurationUtils.addIfNotEmpty(this.getMessage("material_count").replace("$count", Integer.toString(materialCount)), lore);
            }
        }
        this.addUseLore(lore);
        this.addPropertyLore(lore, isSingleSpell);
        if (this.isUpgrade) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("upgrade_item_description"), lore);
        } else {
            List<String> slots = this.getStringList("slots");
            if (slots != null && !slots.isEmpty()) {
                ArrayList<Wand> remaining = new ArrayList<Wand>();
                if (this.slotted != null) {
                    remaining.addAll(this.slotted);
                }
                ConfigurationUtils.addIfNotEmpty(this.getMessage("slots_header").replace("$count", Integer.toString(slots.size())), lore);
                for (String slot2 : slots) {
                    Wand slottedWand = null;
                    Iterator it = remaining.iterator();
                    while (it.hasNext()) {
                        Wand testSlot = (Wand)it.next();
                        if (!testSlot.getSlot().equals(slot2)) continue;
                        it.remove();
                        slottedWand = testSlot;
                        break;
                    }
                    if (slottedWand == null) {
                        String slotName = this.controller.getMessages().get("slots." + slot2 + ".name", slot2);
                        ConfigurationUtils.addIfNotEmpty(this.getMessage("empty_slot").replace("$slot", slotName), lore);
                        continue;
                    }
                    ConfigurationUtils.addIfNotEmpty(this.getMessage("slotted").replace("$slotted", slottedWand.getName()), lore);
                }
            }
        }
        if (this.isInventoryOpen() && this.inventoryOpenLore != null && !this.inventoryOpenLore.isEmpty()) {
            CompatibilityLib.getInventoryUtils().wrapText(this.inventoryOpenLore, lore);
            String cycleMessage = this.getMessage("inventory_open_cycle", "");
            if (!cycleMessage.isEmpty() && this.inventories.size() > 1) {
                CompatibilityLib.getInventoryUtils().wrapText(cycleMessage, lore);
            }
            if (!(cycleMessage = this.getMessage("inventory_open_cycle_hotbar", "")).isEmpty() && this.hotbars.size() > 1) {
                CompatibilityLib.getInventoryUtils().wrapText(cycleMessage, lore);
            }
        }
        return lore;
    }

    public String getSlot() {
        return this.getString("slot");
    }

    protected void addUseLore(List<String> lore) {
        int remaining = this.getRemainingUses();
        if (!this.isSingleUse && remaining > 0) {
            if (this.isUpgrade) {
                String message = remaining == 1 ? this.getMessage("upgrade_uses_singular") : this.getMessage("upgrade_uses");
                ConfigurationUtils.addIfNotEmpty(message.replace("$count", Integer.toString(remaining)), lore);
            } else {
                String message = remaining == 1 ? this.getMessage("uses_remaining_singular") : this.getMessage("uses_remaining_brief");
                ConfigurationUtils.addIfNotEmpty(message.replace("$count", Integer.toString(remaining)), lore);
            }
        }
    }

    protected void updateLore() {
        this.findItem();
        CompatibilityLib.getCompatibilityUtils().setLore(this.item, this.getLore());
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        if (EnchantableWandMaterial == null) {
            return;
        }
        if (!enchantable) {
            this.item.setType(this.icon.getMaterial());
            CompatibilityLib.getDeprecatedUtils().setItemDamage(this.item, this.icon.getData());
        } else {
            MaterialSet enchantableMaterials = this.controller.getMaterialSetManager().getMaterialSetEmpty("enchantable");
            if (!enchantableMaterials.testItem(this.item)) {
                this.item.setType(EnchantableWandMaterial);
                CompatibilityLib.getDeprecatedUtils().setItemDamage(this.item, (short)0);
            }
        }
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack activeItem = player.getInventory().getItemInMainHand();
        return Wand.isWand(activeItem);
    }

    @Nullable
    public static Wand getActiveWand(MagicController controller, Player player) {
        ItemStack activeItem = player.getInventory().getItemInMainHand();
        if (Wand.isWand(activeItem)) {
            return controller.getWand(activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return item != null && CompatibilityLib.getNBTUtils().hasMeta(item, WAND_KEY);
    }

    public static boolean isWandOrUpgrade(ItemStack item) {
        return Wand.isWand(item) || Wand.isUpgrade(item);
    }

    public static boolean isSpecial(ItemStack item) {
        return Wand.isWand(item) || Wand.isUpgrade(item) || Wand.isSpell(item) || Wand.isBrush(item) || Wand.isSP(item) || Wand.isCurrency(item);
    }

    public static boolean isSelfDestructWand(ItemStack item) {
        return item != null && WAND_SELF_DESTRUCT_KEY != null && CompatibilityLib.getNBTUtils().hasMeta(item, WAND_SELF_DESTRUCT_KEY);
    }

    public static boolean isSP(ItemStack item) {
        return CompatibilityLib.getNBTUtils().hasMeta(item, "sp");
    }

    public static boolean isCurrency(ItemStack item) {
        return CompatibilityLib.getNBTUtils().hasMeta(item, "currency");
    }

    protected void addPropertyLore(List<String> lore, boolean isSingleSpell) {
        String template;
        ConfigurationSection attributes;
        ConfigurationSection configurationSection;
        ConfigurationSection weaknessConfig;
        Iterator<Map.Entry<String, Double>> spell;
        float manaRegenerationBoost;
        if (this.usesMana() && this.effectiveManaMax > 0.0f) {
            int manaMax = this.getManaMax();
            if (this.effectiveManaMax != (float)manaMax) {
                String fullMessage = this.getLevelString("mana_amount_boosted", manaMax, this.controller.getMaxMana());
                ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString((int)Math.ceil(this.effectiveManaMax))), lore);
            } else {
                ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_amount", manaMax, this.controller.getMaxMana()), lore);
            }
            int manaRegeneration = this.getManaRegeneration();
            if (manaRegeneration > 0 && this.effectiveManaRegeneration > 0.0f) {
                if (this.effectiveManaRegeneration != (float)manaRegeneration) {
                    String fullMessage = this.getLevelString("mana_regeneration_boosted", manaRegeneration, this.controller.getMaxManaRegeneration());
                    ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString((int)Math.ceil(this.effectiveManaRegeneration))), lore);
                } else {
                    ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_regeneration", manaRegeneration, this.controller.getMaxManaRegeneration()), lore);
                }
            }
            if (this.manaPerDamage > 0.0f) {
                ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_per_damage", this.manaPerDamage, this.controller.getMaxManaRegeneration()), lore);
            }
        }
        if (this.blockReflectChance > 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("reflect_chance", this.blockReflectChance), lore);
        } else if (this.blockChance != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("block_chance", this.blockChance), lore);
        }
        float manaMaxBoost = this.getManaMaxBoost();
        if (manaMaxBoost != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("mana_boost", manaMaxBoost), lore);
        }
        if ((manaRegenerationBoost = this.getManaRegenerationBoost()) != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("mana_regeneration_boost", manaRegenerationBoost), lore);
        }
        if (this.castSpell != null && (spell = this.controller.getSpellTemplate(this.castSpell)) != null) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("spell_aura").replace("$spell", spell.getName()), lore);
        }
        for (Map.Entry entry : this.getPotionEffects().entrySet()) {
            ConfigurationUtils.addIfNotEmpty(this.describePotionEffect((PotionEffectType)entry.getKey(), (Integer)entry.getValue()), lore);
        }
        if (this.worn) {
            isSingleSpell = false;
        }
        if (this.consumeReduction != 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("consume_reduction", this.consumeReduction), lore);
        }
        if (this.costReduction != 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("cost_reduction", this.costReduction), lore);
        }
        if (this.cooldownReduction != 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("cooldown_reduction", this.cooldownReduction), lore);
        }
        if (this.power > 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("power", this.power), lore);
        }
        if (this.superProtected) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("super_protected"), lore);
        } else if (this.protection != null) {
            for (Map.Entry<String, Double> entry : this.protection.entrySet()) {
                String protectionType = entry.getKey();
                double amount = entry.getValue();
                this.addDamageTypeLore("protection", protectionType, amount, lore);
            }
        }
        if (this.superPowered) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("super_powered"), lore);
        }
        if (this.isEnchantable()) {
            int hideFlags = this.getProperty("hide_flags", HIDE_FLAGS);
            ConfigurationSection configurationSection2 = this.getConfigurationSection("enchantments");
            if ((hideFlags & 1) == 1 && configurationSection2 != null) {
                Set enchantmentKeys = configurationSection2.getKeys(false);
                Iterator amount = enchantmentKeys.iterator();
                while (amount.hasNext()) {
                    String enchantmentKey = (String)amount.next();
                    int level = configurationSection2.getInt(enchantmentKey);
                    String[] pieces = StringUtils.split((String)enchantmentKey, (String)":");
                    enchantmentKey = pieces[pieces.length - 1];
                    this.addDamageTypeLore("enchantment", enchantmentKey, level, 0.0, lore, enchantmentKey);
                }
            }
        }
        if ((weaknessConfig = this.getConfigurationSection("weakness")) != null) {
            Set set = weaknessConfig.getKeys(false);
            for (String key : set) {
                this.addDamageTypeLore("weakness", key, weaknessConfig.getDouble(key), lore);
            }
        }
        if ((configurationSection = this.getConfigurationSection("strength")) != null) {
            Set keys = configurationSection.getKeys(false);
            for (String key : keys) {
                this.addDamageTypeLore("strength", key, configurationSection.getDouble(key), lore);
            }
        }
        if (this.earnMultiplier > 1.0f) {
            String earnDescription = this.getPropertyString("earn_multiplier", this.earnMultiplier - 1.0f);
            String earnType = this.getController().getMessages().get("currency.sp.name_short", "SP");
            earnDescription = earnDescription.replace("$type", earnType);
            ConfigurationUtils.addIfNotEmpty(earnDescription, lore);
        }
        if ((attributes = this.getConfigurationSection("attributes")) != null && !(template = this.getMessage("attributes")).isEmpty()) {
            Set keys = attributes.getKeys(false);
            for (String key : keys) {
                Double maxValue;
                String label = this.controller.getMessages().get("attributes." + key + ".name", key);
                int value = attributes.getInt(key);
                if (value == 0) continue;
                float max = 1.0f;
                MagicAttribute attribute = this.controller.getAttribute(key);
                if (attribute != null && (maxValue = attribute.getMax()) != null) {
                    max = (float)maxValue.doubleValue();
                }
                label = this.getPropertyString("attributes", value, max).replace("$attribute", label);
                lore.add(label);
            }
        }
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && CompatibilityLib.getNBTUtils().hasMeta(item, "spell");
    }

    public static boolean isSkill(ItemStack item) {
        return item != null && CompatibilityLib.getNBTUtils().hasMeta(item, "skill");
    }

    public static boolean isBrush(ItemStack item) {
        return item != null && CompatibilityLib.getNBTUtils().hasMeta(item, "brush");
    }

    @Nullable
    protected static Object getWandOrUpgradeNode(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object wandNode = CompatibilityLib.getNBTUtils().getNode(item, WAND_KEY);
        if (wandNode == null) {
            wandNode = CompatibilityLib.getNBTUtils().getNode(item, UPGRADE_KEY);
        }
        return wandNode;
    }

    @Nullable
    public static String getWandTemplate(ItemStack item) {
        Object wandNode = Wand.getWandOrUpgradeNode(item);
        if (wandNode == null) {
            return null;
        }
        return CompatibilityLib.getNBTUtils().getMetaString(wandNode, "template");
    }

    @Nullable
    public static String getWandId(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object wandNode = CompatibilityLib.getNBTUtils().getNode(item, WAND_KEY);
        if (wandNode == null) {
            return null;
        }
        return CompatibilityLib.getNBTUtils().getMetaString(wandNode, "id");
    }

    @Nullable
    public static String getArrowSpell(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object arrowNode = CompatibilityLib.getNBTUtils().getNode(item, "arrow");
        if (arrowNode == null) {
            return null;
        }
        Object spellNode = CompatibilityLib.getNBTUtils().getNode(arrowNode, "spell");
        if (spellNode == null) {
            return null;
        }
        return CompatibilityLib.getNBTUtils().getMetaString(spellNode, "key");
    }

    @Nullable
    public static String getArrowSpellClass(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object arrowNode = CompatibilityLib.getNBTUtils().getNode(item, "arrow");
        if (arrowNode == null) {
            return null;
        }
        Object spellNode = CompatibilityLib.getNBTUtils().getNode(arrowNode, "spell");
        if (spellNode == null) {
            return null;
        }
        return CompatibilityLib.getNBTUtils().getMetaString(spellNode, "class");
    }

    @Nullable
    public static String getSpell(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object spellNode = CompatibilityLib.getNBTUtils().getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return CompatibilityLib.getNBTUtils().getMetaString(spellNode, "key");
    }

    @Override
    @Nullable
    public Spell getSpell(String spellKey, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage == null) {
            return null;
        }
        if (!this.hasSpell(spellKey)) {
            return null;
        }
        SpellKey key = new SpellKey(spellKey);
        Integer level = this.spellLevels.get(spellKey = key.getBaseKey());
        if (level != null) {
            spellKey = new SpellKey(spellKey, level).getKey();
        }
        return mage.getSpell(spellKey);
    }

    @Override
    @Nullable
    public Spell getSpell(String spellKey) {
        return this.getSpell(spellKey, this.mage);
    }

    @Nullable
    public static String getSpellClass(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object spellNode = CompatibilityLib.getNBTUtils().getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return CompatibilityLib.getNBTUtils().getMetaString(spellNode, "class");
    }

    public static boolean isQuickCastSkill(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return false;
        }
        Object spellNode = CompatibilityLib.getNBTUtils().getNode(item, "spell");
        if (spellNode == null) {
            return false;
        }
        Boolean quickCast = CompatibilityLib.getNBTUtils().containsNode(spellNode, "quick_cast") ? CompatibilityLib.getNBTUtils().getMetaBoolean(spellNode, "quick_cast") : null;
        return quickCast == null ? true : quickCast;
    }

    @Nullable
    public static String getSpellArgs(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object spellNode = CompatibilityLib.getNBTUtils().getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return CompatibilityLib.getNBTUtils().getMetaString(spellNode, "args");
    }

    @Nullable
    public static String getBrush(ItemStack item) {
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object brushNode = CompatibilityLib.getNBTUtils().getNode(item, "brush");
        if (brushNode == null) {
            return null;
        }
        return CompatibilityLib.getNBTUtils().getMetaString(brushNode, "key");
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            MageSpell spell = this.mage.getSpell(Wand.getSpell(item));
            if (spell != null) {
                Wand.updateSpellName(this.controller.getMessages(), item, spell, activeName ? this : null, this.activeBrush);
            }
        } else if (Wand.isBrush(item)) {
            Wand.updateBrushName((com.elmakers.mine.bukkit.api.magic.Messages)this.controller.getMessages(), item, Wand.getBrush(item), activeName ? this : null);
        }
    }

    private boolean updateIfMatch(ItemStack itemStack, Spell spell) {
        String spellKey = Wand.getSpell(itemStack);
        if (spellKey != null && spellKey.equals(spell.getKey())) {
            Wand.updateSpellItem(this.controller.getMessages(), itemStack, spell, "", this, this.activeBrush, false);
            return true;
        }
        return false;
    }

    public void updateSpellItem(Spell spell) {
        WandInventory inventory;
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player != null) {
            ItemStack itemStack;
            ListIterator listIterator = player.getInventory().iterator();
            while (listIterator.hasNext() && !this.updateIfMatch(itemStack = (ItemStack)listIterator.next(), spell)) {
            }
        }
        if (this.inventories.size() > this.openInventoryPage) {
            inventory = this.inventories.get(this.openInventoryPage);
            for (ItemStack itemStack : inventory.getContents()) {
                if (!this.updateIfMatch(itemStack, spell)) continue;
                return;
            }
        }
        if (this.hotbars.size() > this.currentHotbar) {
            inventory = this.hotbars.get(this.currentHotbar);
            for (ItemStack itemStack : inventory.getContents()) {
                if (!this.updateIfMatch(itemStack, spell)) continue;
                return;
            }
        }
    }

    public static void updateSpellItem(com.elmakers.mine.bukkit.api.magic.Messages messages, ItemStack itemStack, SpellTemplate spell, String args, Wand wand, String activeMaterial, boolean isItem) {
        Wand.updateSpellItem(messages, itemStack, spell, args, wand == null ? null : wand.getActiveMage(), wand, activeMaterial, isItem);
    }

    public static void updateSpellItem(com.elmakers.mine.bukkit.api.magic.Messages messages, ItemStack itemStack, SpellTemplate spell, String args, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, String activeMaterial, boolean isItem) {
        Wand.updateSpellName(messages, itemStack, spell, wand, activeMaterial);
        ArrayList<String> lore = new ArrayList<String>();
        Wand.addSpellLore(messages, spell, lore, mage, wand);
        if (isItem) {
            ConfigurationUtils.addIfNotEmpty(messages.get("wand.spell_item_description"), lore);
        }
        CompatibilityLib.getCompatibilityUtils().setLore(itemStack, lore);
        Object spellNode = CompatibilityLib.getNBTUtils().createNode(itemStack, "spell");
        CompatibilityLib.getNBTUtils().setMeta(spellNode, "key", spell.getKey());
        CompatibilityLib.getNBTUtils().setMeta(spellNode, "args", args);
        if (SpellGlow || wand != null && wand.spellGlow) {
            CompatibilityLib.getItemUtils().addGlow(itemStack);
        }
    }

    public static void updateSpellName(com.elmakers.mine.bukkit.api.magic.Messages messages, ItemStack itemStack, SpellTemplate spell, Wand wand, String activeMaterial) {
        String displayName = wand != null && !wand.isQuickCast() ? wand.getActiveWandName(spell) : Wand.getSpellDisplayName(messages, spell, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(activeMaterial));
        CompatibilityLib.getCompatibilityUtils().setDisplayName(itemStack, displayName);
    }

    public static void updateBrushName(com.elmakers.mine.bukkit.api.magic.Messages messages, ItemStack itemStack, String materialKey, Wand wand) {
        Wand.updateBrushName(messages, itemStack, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey), wand);
    }

    public static void updateBrushName(com.elmakers.mine.bukkit.api.magic.Messages messages, ItemStack itemStack, com.elmakers.mine.bukkit.block.MaterialBrush brush, Wand wand) {
        Spell activeSpell;
        String displayName = wand != null ? ((activeSpell = wand.getActiveSpell()) != null && activeSpell.usesBrush() ? wand.getActiveWandName(brush) : ChatColor.RED + brush.getName(messages)) : brush.getName(messages);
        CompatibilityLib.getCompatibilityUtils().setDisplayName(itemStack, displayName);
    }

    public static void updateBrushItem(com.elmakers.mine.bukkit.api.magic.Messages messages, ItemStack itemStack, String materialKey, Wand wand) {
        Wand.updateBrushItem(messages, itemStack, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey), wand, true);
    }

    public static void updateBrushItem(com.elmakers.mine.bukkit.api.magic.Messages messages, ItemStack itemStack, com.elmakers.mine.bukkit.block.MaterialBrush brush, Wand wand, boolean useWandName) {
        if (useWandName) {
            Wand.updateBrushName(messages, itemStack, brush, wand);
        }
        Object brushNode = CompatibilityLib.getNBTUtils().createNode(itemStack, "brush");
        CompatibilityLib.getNBTUtils().setMeta(brushNode, "key", brush.getKey());
    }

    public void updateHotbar() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.hasStoredInventory()) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            PlayerInventory inventory = player.getInventory();
            this.updateHotbar(inventory);
            CompatibilityLib.getDeprecatedUtils().updateInventory(player);
        }
    }

    private boolean updateHotbar(PlayerInventory playerInventory) {
        if (this.getMode() != WandMode.INVENTORY) {
            return false;
        }
        WandInventory hotbar = this.getHotbar();
        if (hotbar == null) {
            return false;
        }
        ItemStack currentItem = playerInventory.getItem(this.heldSlot);
        if (currentItem == null || !currentItem.getItemMeta().equals(this.item.getItemMeta())) {
            if (this.mage != null) {
                this.mage.sendDebugMessage("Trying to update hotbar but the wand has gone missing");
            }
            return false;
        }
        int targetOffset = 0;
        for (int hotbarSlot = 0; hotbarSlot < 8; ++hotbarSlot) {
            if (hotbarSlot == this.heldSlot) {
                targetOffset = 1;
            }
            ItemStack hotbarItem = hotbar.getItem(hotbarSlot);
            this.updateInventoryName(hotbarItem, true);
            playerInventory.setItem(hotbarSlot + targetOffset, hotbarItem);
        }
        return true;
    }

    private void updateInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            if (!this.hasStoredInventory()) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            if (!this.updateHotbar(inventory)) {
                for (int i = 0; i < 9; ++i) {
                    if (i == inventory.getHeldItemSlot()) continue;
                    inventory.setItem(i, null);
                }
            }
            this.updateInventory((Inventory)inventory);
            this.updateName();
        } else if (wandMode == WandMode.CHEST || wandMode == WandMode.SKILLS) {
            Inventory inventory = this.getDisplayInventory();
            inventory.clear();
            this.updateInventory(inventory);
        }
    }

    private void updateInventory(Inventory targetInventory) {
        int currentOffset = this.getHotbarSize() > 0 ? 9 : 0;
        List<WandInventory> inventories = this.inventories;
        if (this.openInventoryPage < inventories.size()) {
            WandInventory inventory = inventories.get(this.openInventoryPage);
            ItemStack[] contents = inventory.getContents();
            for (int i = 0; i < contents.length && (currentOffset < 36 || this.getMode() != WandMode.INVENTORY); ++currentOffset, ++i) {
                ItemStack inventoryItem = contents[i];
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset, inventoryItem);
            }
        }
        while (currentOffset < targetInventory.getSize() && currentOffset < 36) {
            targetInventory.setItem(currentOffset, null);
            ++currentOffset;
        }
    }

    protected static void addSpellLore(com.elmakers.mine.bukkit.api.magic.Messages messages, SpellTemplate spell, List<String> lore, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand) {
        if (wand != null && spell instanceof BaseSpell) {
            BaseSpell baseSpell = (BaseSpell)spell;
            Map<String, String> overrides = wand.getOverrides();
            ConfigurationSection parameters = baseSpell.getWorkingParameters();
            if (parameters != null && overrides != null && !overrides.isEmpty()) {
                parameters = ConfigurationUtils.cloneConfiguration(parameters);
                for (Map.Entry<String, String> entry : overrides.entrySet()) {
                    parameters.set(entry.getKey(), (Object)entry.getValue());
                }
                baseSpell.processTemplateParameters(parameters);
            }
        }
        spell.addLore(messages, mage, wand, lore);
    }

    private String getInventoryTitle() {
        return this.getMessage("chest_inventory_title", "$wand").replace("$wand", this.getName());
    }

    protected WandInventory getOpenInventory() {
        while (this.openInventoryPage >= this.inventories.size()) {
            this.inventories.add(new WandInventory(this.getInventorySize()));
        }
        return this.inventories.get(this.openInventoryPage);
    }

    protected Inventory getDisplayInventory() {
        if (this.displayInventory == null || this.displayInventory.getSize() != this.getInventorySize()) {
            this.displayInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, this.getInventorySize(), this.getInventoryTitle());
        }
        return this.displayInventory;
    }

    public void saveChestInventory() {
        if (this.displayInventory == null) {
            return;
        }
        WandInventory openInventory = this.getOpenInventory();
        HashMap<String, Integer> previousSlots = new HashMap<String, Integer>();
        HashSet<String> addedBack = new HashSet<String>();
        for (int i = 0; i < this.displayInventory.getSize(); ++i) {
            ItemStack playerItem = this.displayInventory.getItem(i);
            String itemSpellKey = Wand.getSpell(playerItem);
            if (!this.updateSlot(i + this.openInventoryPage * this.getInventorySize(), playerItem)) {
                playerItem = new ItemStack(Material.AIR);
                this.displayInventory.setItem(i, playerItem);
            } else if (itemSpellKey != null) {
                addedBack.add(itemSpellKey);
            }
            ItemStack current = openInventory.getItem(i);
            String spellKey = Wand.getSpell(current);
            if (spellKey != null) {
                previousSlots.put(spellKey, i);
            }
            openInventory.setItem(i, playerItem);
        }
        for (Map.Entry entry : previousSlots.entrySet()) {
            if (addedBack.contains(entry.getKey())) continue;
            ItemStack current = openInventory.getItem((Integer)entry.getValue());
            ItemStack itemStack = this.createSpellItem((String)entry.getKey(), "", false);
            if (current == null || current.getType() == Material.AIR) {
                openInventory.setItem((Integer)entry.getValue(), itemStack);
                continue;
            }
            openInventory.addItem(itemStack);
        }
    }

    public void saveInventory() {
        if (this.mage == null) {
            return;
        }
        if (this.getMode() == WandMode.SKILLS) {
            this.saveChestInventory();
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.mage.getPlayer() == null) {
            return;
        }
        if (this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (!this.hasStoredInventory()) {
            return;
        }
        if (this.mage.isDead()) {
            return;
        }
        Player player = this.mage.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        WandInventory hotbar = this.getHotbar();
        if (hotbar != null) {
            int saveOffset = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack playerItem = playerInventory.getItem(i);
                if (Wand.isWand(playerItem)) {
                    saveOffset = -1;
                    continue;
                }
                int hotbarOffset = i + saveOffset;
                if (hotbarOffset >= hotbar.getSize()) break;
                if (!this.updateSlot(i + saveOffset + this.currentHotbar * 8, playerItem)) {
                    playerItem = new ItemStack(Material.AIR);
                    playerInventory.setItem(i, playerItem);
                }
                hotbar.setItem(i + saveOffset, playerItem);
            }
        }
        int hotbarOffset = this.getHotbarSize();
        WandInventory openInventory = this.getOpenInventory();
        for (int i = 0; i < openInventory.getSize(); ++i) {
            ItemStack playerItem = playerInventory.getItem(i + 9);
            if (!this.updateSlot(i + hotbarOffset + this.openInventoryPage * this.getInventorySize(), playerItem)) {
                playerItem = new ItemStack(Material.AIR);
                playerInventory.setItem(i + 9, playerItem);
            }
            openInventory.setItem(i, playerItem);
        }
    }

    protected boolean updateSlot(int slot, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        String spellKey = Wand.getSpell(item);
        if (spellKey != null) {
            SpellKey key = new SpellKey(spellKey);
            this.spellInventory.put(key.getBaseKey(), slot);
        } else {
            String brushKey = Wand.getBrush(item);
            if (brushKey != null) {
                this.brushInventory.put(brushKey, slot);
            } else if (this.mage != null) {
                this.mage.sendDebugMessage(ChatColor.RED + "  updating slot with a non-brush/spell item: " + item.getType(), 30);
                if (!item.equals((Object)this.item)) {
                    this.mage.giveItem(item);
                    this.mage.sendDebugMessage(ChatColor.RED + "    Giving to mage: " + item.getType(), 100);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public int enchant(int totalLevels, com.elmakers.mine.bukkit.api.magic.Mage mage, boolean addSpells) {
        return this.randomize(totalLevels, mage, addSpells);
    }

    @Override
    public int enchant(int totalLevels, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        return this.randomize(totalLevels, mage, true);
    }

    @Override
    public int enchant(int totalLevels) {
        return this.randomize(totalLevels, null, true);
    }

    protected int randomize(int totalLevels, com.elmakers.mine.bukkit.api.magic.Mage enchanter, boolean addSpells) {
        Mage activeMage = this.mage;
        if (enchanter instanceof Mage && this.mage == null) {
            this.mage = (Mage)enchanter;
        }
        int levels = this.randomize(totalLevels, addSpells);
        this.mage = activeMage;
        return levels;
    }

    @Override
    public int randomize(int totalLevels, boolean addSpells) {
        if (this.maxEnchantCount > 0 && this.enchantCount >= this.maxEnchantCount) {
            if (this.mage != null && addSpells) {
                this.mage.sendMessage(this.getMessage("max_enchanted").replace("$wand", this.getName()));
            }
            return 0;
        }
        int levels = super.randomize(totalLevels, addSpells);
        if (levels > 0) {
            ++this.enchantCount;
            this.setProperty("enchant_count", this.enchantCount);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
        return levels;
    }

    protected void randomize() {
        if (this.template != null && this.template.length() > 0) {
            WandTemplate wandConfig = this.controller.getWandTemplate(this.template);
            boolean legacyIcons = this.controller.isLegacyIconsEnabled();
            if (wandConfig != null && wandConfig.hasIcon(legacyIcons)) {
                String iconKey = wandConfig.getIcon(legacyIcons);
                if (iconKey.contains(",")) {
                    Random r = new Random();
                    String[] keys = StringUtils.split((String)iconKey, (char)',');
                    iconKey = keys[r.nextInt(keys.length)];
                }
                this.setIcon(ConfigurationUtils.toMaterialAndData(iconKey));
                this.updateIcon();
                this.playEffects("randomize");
            }
        }
    }

    @Nullable
    public static Wand createWand(MagicController controller, String templateName) {
        return Wand.createWand(controller, templateName, null);
    }

    @Nullable
    public static Wand createWand(MagicController controller, String templateName, Mage mage) {
        if (controller == null) {
            return null;
        }
        Wand wand = null;
        try {
            wand = new Wand(controller, templateName, mage);
        }
        catch (UnknownWandException unknownWandException) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return wand;
    }

    @Nonnull
    public static Wand createWand(@Nonnull MagicController controller, @Nonnull ItemStack itemStack) {
        Preconditions.checkNotNull((Object)controller);
        Preconditions.checkNotNull((Object)itemStack);
        Wand wand = null;
        try {
            wand = controller.getWand(CompatibilityLib.getItemUtils().makeReal(itemStack.clone()));
            wand.saveState();
            wand.updateName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            wand = new Wand(controller);
        }
        return wand;
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand other) {
        if (other instanceof Wand) {
            return this.add((Wand)other);
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand other, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (other instanceof Wand) {
            return this.add((Wand)other);
        }
        return false;
    }

    public boolean add(Wand other) {
        if (!(this.isModifiable() || other.isUpgrade() && other.path != null && this.path != null && !other.path.isEmpty() && !this.path.isEmpty() && other.path.equals(this.path))) {
            return false;
        }
        if (this.hasUses || other.hasUses) {
            return false;
        }
        if (this.isHeroes || other.isHeroes) {
            return false;
        }
        ConfigurationSection templateConfig = this.controller.getWandTemplateConfiguration(other.getTemplateKey());
        if (other.isForcedUpgrade()) {
            if (templateConfig == null) {
                return false;
            }
            templateConfig = ConfigurationUtils.cloneConfiguration(templateConfig);
            templateConfig.set("name", (Object)templateConfig.getString("upgrade_name"));
            templateConfig.set("description", (Object)templateConfig.getString("upgrade_description"));
            templateConfig.set("force", null);
            templateConfig.set("upgrade", null);
            templateConfig.set("legacy_icon", (Object)templateConfig.getString("legacy_upgrade_icon"));
            templateConfig.set("icon", (Object)templateConfig.getString("upgrade_icon"));
            templateConfig.set("indestructible", null);
            templateConfig.set("upgrade_icon", null);
            this.configure(templateConfig);
            return true;
        }
        if (!(!other.isUpgrade() || other.path == null || other.path.isEmpty() || this.path != null && this.path.equals(other.path))) {
            return false;
        }
        ConfigurationSection upgradeConfig = ConfigurationUtils.cloneConfiguration(other.getEffectiveConfiguration());
        String upgradeIcon = ConfigurationUtils.getIcon(upgradeConfig, this.controller.isLegacyIconsEnabled(), "upgrade_icon");
        this.cleanUpgradeConfig(upgradeConfig);
        upgradeConfig.set("icon", (Object)upgradeIcon);
        upgradeConfig.set("template", (Object)other.upgradeTemplate);
        Messages messages = this.controller.getMessages();
        if (other.rename && templateConfig != null) {
            String newName = messages.get("wands." + other.template + ".name");
            newName = templateConfig.getString("name", newName);
            upgradeConfig.set("name", (Object)newName);
        }
        if (other.renameDescription && templateConfig != null) {
            String newDescription = messages.get("wands." + other.template + ".description");
            newDescription = templateConfig.getString("description", newDescription);
            upgradeConfig.set("description", (Object)newDescription);
        }
        return this.upgrade(upgradeConfig);
    }

    public boolean isForcedUpgrade() {
        return this.isUpgrade && this.forceUpgrade;
    }

    public boolean keepOnDeath() {
        return this.keep;
    }

    public static WandMode parseWandMode(String modeString, WandMode defaultValue) {
        if (modeString != null && !modeString.isEmpty()) {
            try {
                defaultValue = WandMode.valueOf(modeString.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static WandAction parseWandAction(String actionString, WandAction defaultValue) {
        if (actionString != null && !actionString.isEmpty()) {
            try {
                defaultValue = WandAction.valueOf(actionString.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public WandUseMode parseUseMode(String useString, WandUseMode defaultValue) {
        block3: {
            if (useString != null && !useString.isEmpty()) {
                try {
                    return WandUseMode.valueOf(useString.toUpperCase());
                }
                catch (Exception ex) {
                    if (this.controller == null) break block3;
                    this.controller.getLogger().warning("Invalid use mode: " + useString);
                }
            }
        }
        return defaultValue;
    }

    private void updateActiveMaterial() {
        if (this.mage == null) {
            return;
        }
        if (this.activeBrush == null) {
            this.mage.clearBuildingMaterial();
        } else {
            MaterialBrush brush = this.mage.getBrush();
            brush.update(this.activeBrush);
        }
    }

    public void cycleActive(int direction) {
        Player player;
        Player player2 = player = this.mage != null ? this.mage.getPlayer() : null;
        if (player != null && player.isSneaking()) {
            Spell activeSpell = this.getActiveSpell();
            boolean cycleMaterials = false;
            if (activeSpell != null) {
                cycleMaterials = activeSpell.usesBrushSelection();
            }
            if (cycleMaterials) {
                this.cycleMaterials(direction);
            } else {
                this.cycleSpells(direction);
            }
        } else {
            this.cycleSpells(direction);
        }
    }

    public void toggleInventory() {
        MageSpell brushSelect;
        if (this.mage != null && this.mage.cancelSelection()) {
            this.mage.playSoundEffect(noActionSound);
            return;
        }
        Player player = this.mage == null ? null : this.mage.getPlayer();
        boolean isSneaking = player != null && player.isSneaking();
        Spell currentSpell = this.getActiveSpell();
        if (this.getBrushMode() == WandMode.CHEST && brushSelectSpell != null && !brushSelectSpell.isEmpty() && isSneaking && currentSpell != null && currentSpell.usesBrushSelection() && (brushSelect = this.mage.getSpell(brushSelectSpell)) != null) {
            brushSelect.cast();
            return;
        }
        if (!this.hasInventory) {
            if (this.activeSpell == null || this.activeSpell.length() == 0) {
                this.updateHasInventory();
                if (this.spells.size() > 0) {
                    this.setActiveSpell(this.spells.iterator().next());
                }
            }
            this.updateName();
            return;
        }
        if (!this.isInventoryOpen()) {
            this.openInventory();
        } else {
            this.closeInventory();
        }
    }

    public void updateHasInventory() {
        int inventorySize = this.getSpells().size() + this.getBrushes().size();
        this.hasInventory = inventorySize > 1 || inventorySize == 1 && this.hasSpellProgression || this.autoFill;
    }

    public void cycleInventory() {
        this.cycleInventory(1);
    }

    public void cycleInventory(int direction) {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            int inventoryCount = this.inventories.size();
            this.setOpenInventoryPage(inventoryCount == 0 ? 0 : (this.openInventoryPage + inventoryCount + direction) % inventoryCount);
            this.updateInventory();
            if (this.mage != null && this.inventories.size() > 1) {
                if (!this.playPassiveEffects("cycle") && inventoryCycleSound != null) {
                    this.mage.playSoundEffect(inventoryCycleSound);
                }
                CompatibilityLib.getDeprecatedUtils().updateInventory(this.mage.getPlayer());
            }
        }
    }

    @Override
    public void cycleHotbar() {
        this.cycleHotbar(1);
    }

    public void cycleHotbar(int direction) {
        if (!this.hasInventory || this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (this.isInventoryOpen() && this.mage != null && this.hotbars.size() > 1) {
            this.saveInventory();
            int hotbarCount = this.hotbars.size();
            this.setCurrentHotbar(hotbarCount == 0 ? 0 : (this.currentHotbar + hotbarCount + direction) % hotbarCount);
            this.updateHotbar();
            if (!this.playPassiveEffects("cycle") && inventoryCycleSound != null) {
                this.mage.playSoundEffect(inventoryCycleSound);
            }
            this.sendMessage("hotbar_changed");
            this.updateHotbarStatus();
            CompatibilityLib.getDeprecatedUtils().updateInventory(this.mage.getPlayer());
        }
    }

    public void openInventory() {
        if (this.mage == null) {
            return;
        }
        if (System.currentTimeMillis() < this.mage.getWandDisableTime()) {
            return;
        }
        SpellInventoryEvent event = new SpellInventoryEvent(this.mage, true);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.CHEST || wandMode == WandMode.SKILLS) {
            this.inventoryIsOpen = true;
            if (!this.playPassiveEffects("open") && inventoryOpenSound != null) {
                this.mage.playSoundEffect(inventoryOpenSound);
            }
            this.updateInventory();
            this.mage.getPlayer().openInventory(this.getDisplayInventory());
        } else if (wandMode == WandMode.INVENTORY) {
            if (this.hasStoredInventory()) {
                return;
            }
            if (this.storeInventory()) {
                this.inventoryIsOpen = true;
                this.showActiveIcon(true);
                if (!this.playPassiveEffects("open") && inventoryOpenSound != null) {
                    this.mage.playSoundEffect(inventoryOpenSound);
                }
                this.updateInventory();
                this.updateHotbarStatus();
                if (this.inventoryOpenLore != null && !this.inventoryOpenLore.isEmpty()) {
                    this.updateLore();
                }
            }
        }
    }

    @Override
    public void closeInventory() {
        this.closeInventory(true);
    }

    public void closeInventory(boolean closePlayerInventory) {
        if (!this.isInventoryOpen()) {
            return;
        }
        SpellInventoryEvent event = new SpellInventoryEvent(this.mage, false);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.controller.disableItemSpawn();
        this.inventoryWasOpen = true;
        WandMode mode = this.getMode();
        try {
            this.saveInventory();
            this.updateSpellInventory();
            this.updateBrushInventory();
            this.inventoryIsOpen = false;
            if (this.mage != null) {
                PlayerInventory inventory;
                ItemStack testItem;
                if (!this.playPassiveEffects("close") && inventoryCloseSound != null) {
                    this.mage.playSoundEffect(inventoryCloseSound);
                }
                if (mode == WandMode.INVENTORY) {
                    this.restoreInventory();
                    this.showActiveIcon(false);
                    if (this.inventoryOpenLore != null && !this.inventoryOpenLore.isEmpty()) {
                        this.updateLore();
                    }
                } else if (closePlayerInventory) {
                    this.mage.getPlayer().closeInventory();
                }
                if (Wand.isSpell(testItem = (inventory = this.mage.getPlayer().getInventory()).getHelmet()) || Wand.isBrush(testItem)) {
                    inventory.setHelmet(new ItemStack(Material.AIR));
                    CompatibilityLib.getDeprecatedUtils().updateInventory(this.mage.getPlayer());
                }
                if (Wand.isSpell(testItem = inventory.getBoots()) || Wand.isBrush(testItem)) {
                    inventory.setBoots(new ItemStack(Material.AIR));
                    CompatibilityLib.getDeprecatedUtils().updateInventory(this.mage.getPlayer());
                }
                if (Wand.isSpell(testItem = inventory.getLeggings()) || Wand.isBrush(testItem)) {
                    inventory.setLeggings(new ItemStack(Material.AIR));
                    CompatibilityLib.getDeprecatedUtils().updateInventory(this.mage.getPlayer());
                }
                if (Wand.isSpell(testItem = inventory.getChestplate()) || Wand.isBrush(testItem)) {
                    inventory.setChestplate(new ItemStack(Material.AIR));
                    CompatibilityLib.getDeprecatedUtils().updateInventory(this.mage.getPlayer());
                }
                if (Wand.isSpell(testItem = inventory.getItemInOffHand()) && !Wand.isSkill(testItem) || Wand.isBrush(testItem)) {
                    inventory.setItemInOffHand(new ItemStack(Material.AIR));
                    CompatibilityLib.getDeprecatedUtils().updateInventory(this.mage.getPlayer());
                }
            }
        }
        catch (Throwable ex) {
            this.restoreInventory();
        }
        if (mode == WandMode.INVENTORY && this.mage != null && closePlayerInventory) {
            try {
                this.mage.getPlayer().closeInventory();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        this.controller.enableItemSpawn();
        this.inventoryWasOpen = false;
    }

    @Override
    public boolean fill(Player player) {
        return this.fill(player, 0);
    }

    @Override
    public boolean fill(Player player, int maxLevel) {
        String playerId = player.getUniqueId().toString();
        this.closeInventory();
        if (this.mage != null) {
            this.buildInventory();
        }
        ArrayList currentSpells = new ArrayList(this.getSpells());
        for (String spellKey : currentSpells) {
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            boolean removeSpell = !spell.hasCastPermission((CommandSender)player);
            String creatorId = spell.getCreatorId();
            if (!(removeSpell = removeSpell || FILL_CREATOR && (creatorId == null || !playerId.equals(creatorId)))) continue;
            this.removeSpell(spellKey);
        }
        Collection<SpellTemplate> allSpells = this.controller.getPlugin().getSpellTemplates();
        Mage mage = this.mage;
        this.mage = null;
        for (SpellTemplate spell : allSpells) {
            String key = spell.getKey();
            if (maxLevel > 0 && spell.getSpellKey().getLevel() > maxLevel || key.startsWith("heroes*")) continue;
            String creatorId = spell.getCreatorId();
            if (FILL_CREATOR && (creatorId == null || !playerId.equals(creatorId)) || !spell.hasCastPermission((CommandSender)player) || !spell.hasIcon() || spell.isHidden()) continue;
            this.addSpell(key);
        }
        this.mage = mage;
        this.updateSpellInventory();
        this.updateBrushInventory();
        if (this.mage != null) {
            this.buildInventory();
        }
        if (!FILL_CREATOR) {
            if (this.autoFill) {
                this.setProperty("fill", false);
            }
            this.autoFill = false;
        }
        this.saveState();
        return true;
    }

    protected void checkActiveMaterial() {
        Collection materials;
        if ((this.activeBrush == null || this.activeBrush.length() == 0) && (materials = this.getBrushes()).size() > 0) {
            this.activeBrush = (String)materials.iterator().next();
        }
    }

    @Override
    public boolean addItem(ItemStack item) {
        Wand upgradeWand;
        String slot;
        if (this.isUpgrade) {
            return false;
        }
        if (this.mageClassKeys != null && !this.mageClassKeys.isEmpty() && this.mage == null) {
            return false;
        }
        CurrencyAmount currency = CompatibilityLib.getInventoryUtils().getCurrencyAmount(item);
        boolean isUpgrade = Wand.isUpgrade(item);
        if (!this.isModifiable() && !isUpgrade && currency == null) {
            return false;
        }
        if (isUpgrade && (slot = (upgradeWand = this.controller.createWand(item)).getSlot()) != null && !slot.isEmpty()) {
            return this.addSlotted(upgradeWand);
        }
        return super.addItem(item);
    }

    public boolean addSlotted(Wand upgradeWand) {
        List<String> slots = this.getStringList("slots");
        if (slots == null || slots.isEmpty()) {
            return false;
        }
        slots = new ArrayList<String>(slots);
        if (this.slotted == null) {
            this.slotted = new ArrayList<Wand>();
        }
        for (Wand wand : this.slotted) {
            slots.remove(wand.getSlot());
        }
        String slot = upgradeWand.getSlot();
        for (String remaining : slots) {
            if (!remaining.equals(slot)) continue;
            List<String> slottedKeys = this.getStringList("slotted");
            if (slottedKeys == null) {
                slottedKeys = new ArrayList<String>();
            }
            slottedKeys.add(upgradeWand.getKey());
            this.setProperty("slotted", slottedKeys);
            this.slotted.add(upgradeWand);
            this.updateSlotted(upgradeWand);
            this.updated();
            return true;
        }
        return false;
    }

    protected void updateSlotted(Wand addSlot) {
        if (this.slottedConfiguration == null) {
            this.slottedConfiguration = ConfigurationUtils.newConfigurationSection();
        }
        ConfigurationSection upgradeConfig = ConfigurationUtils.cloneConfiguration(addSlot.getEffectiveConfiguration());
        this.cleanUpgradeConfig(upgradeConfig);
        ConfigurationUtils.addConfigurations(this.slottedConfiguration, upgradeConfig);
    }

    protected void updateEffects() {
        this.updateEffects(this.mage);
    }

    public void updateEffects(Mage mage) {
        double speedSquared;
        Vector velocity;
        double velocitySquared;
        boolean velocityCheck;
        boolean playEffects;
        if (mage == null) {
            return;
        }
        Player player = mage.getPlayer();
        if (player == null) {
            return;
        }
        Color effectColor = this.getEffectColor();
        if (this.effectBubbles && effectColor != null) {
            Location potionEffectLocation = player.getLocation();
            potionEffectLocation.setX(potionEffectLocation.getX() + random.nextDouble() - 0.5);
            potionEffectLocation.setY(potionEffectLocation.getY() + random.nextDouble() * player.getEyeHeight());
            potionEffectLocation.setZ(potionEffectLocation.getZ() + random.nextDouble() - 0.5);
            EffectPlayer.displayParticle(Particle.SPELL_MOB, potionEffectLocation, 0.0f, 0.0f, 0.0f, 0.0f, 0, 1.0f, effectColor, null, (byte)0, 24.0);
        }
        Location location = mage.getLocation();
        long now = System.currentTimeMillis();
        boolean bl = playEffects = !this.activeEffectsOnly || this.inventoryIsOpen || this.isInOffhand;
        if (playEffects && this.effectParticle != null && this.effectParticleInterval > 0 && this.effectParticleCount > 0) {
            velocityCheck = true;
            if (this.effectParticleMinVelocity > 0.0) {
                velocitySquared = this.effectParticleMinVelocity * this.effectParticleMinVelocity;
                velocity = mage.getVelocity().clone();
                velocity.setY(0);
                speedSquared = velocity.lengthSquared();
                boolean bl2 = velocityCheck = speedSquared > velocitySquared;
            }
            if (velocityCheck && (this.lastParticleEffect == 0L || now > this.lastParticleEffect + (long)this.effectParticleInterval)) {
                this.lastParticleEffect = now;
                Location effectLocation = player.getLocation();
                Location eyeLocation = player.getEyeLocation();
                effectLocation.setY(eyeLocation.getY() + this.effectParticleOffset);
                if (this.effectPlayer == null) {
                    this.effectPlayer = new EffectRing((Plugin)this.controller.getPlugin());
                    this.effectPlayer.setParticleCount(1);
                    this.effectPlayer.setIterations(1);
                    this.effectPlayer.setParticleOffset(0.0f, 0.0f, 0.0f);
                }
                this.effectPlayer.setMaterial(location.getBlock().getRelative(BlockFace.DOWN));
                if (this.effectParticleData == 0.0f) {
                    this.effectPlayer.setColor(effectColor);
                } else {
                    this.effectPlayer.setColor(null);
                }
                this.effectPlayer.setParticleType(this.effectParticle);
                this.effectPlayer.setParticleData(this.effectParticleData);
                this.effectPlayer.setSize(this.effectParticleCount);
                this.effectPlayer.setRadius((float)this.effectParticleRadius);
                this.effectPlayer.start(effectLocation, null);
            }
        }
        if (this.castSpell != null && this.castInterval > 0 && (this.lastSpellCast == 0L || now > this.lastSpellCast + (long)this.castInterval)) {
            velocityCheck = true;
            if (this.castMinVelocity > 0.0) {
                velocitySquared = this.castMinVelocity * this.castMinVelocity;
                velocity = mage.getVelocity();
                if (this.castVelocityDirection != null) {
                    velocity = velocity.clone().multiply(this.castVelocityDirection);
                    if (this.castVelocityDirection.getY() < 0.0) {
                        velocityCheck = velocity.getY() < 0.0;
                    } else {
                        boolean bl3 = velocityCheck = velocity.getY() > 0.0;
                    }
                }
                if (velocityCheck) {
                    speedSquared = velocity.lengthSquared();
                    boolean bl4 = velocityCheck = speedSquared > velocitySquared;
                }
            }
            if (velocityCheck) {
                this.lastSpellCast = now;
                MageSpell spell = mage.getSpell(this.castSpell);
                if (spell != null) {
                    boolean costFree = this.getBoolean("cast_interval_cost_free", false);
                    if (this.castParameters == null) {
                        this.castParameters = ConfigurationUtils.newConfigurationSection();
                    }
                    this.castParameters.set("aura", (Object)true);
                    if (costFree) {
                        mage.setCostFree(true);
                    }
                    mage.setQuiet(true);
                    try {
                        this.doCast(spell, this.castParameters);
                    }
                    catch (Exception ex) {
                        this.controller.getLogger().log(Level.WARNING, "Error casting aura spell " + spell.getKey(), ex);
                    }
                    if (costFree) {
                        mage.setCostFree(false);
                    }
                    mage.setQuiet(false);
                }
            }
        }
        if (playEffects && this.effectSound != null && this.controller.soundsEnabled() && this.effectSoundInterval > 0 && (this.lastSoundEffect == 0L || now > this.lastSoundEffect + (long)this.effectSoundInterval)) {
            this.lastSoundEffect = now;
            this.effectSound.play((Plugin)this.controller.getPlugin(), (Logger)this.controller.getLogger(), (Entity)mage.getPlayer());
        }
    }

    protected void updateDurability() {
        short maxDurability = this.item.getType().getMaxDurability();
        if (maxDurability > 0 && this.effectiveManaMax > 0.0f) {
            int durability = (int)(this.getMana() * (float)maxDurability / this.effectiveManaMax);
            if ((durability = maxDurability - durability) >= maxDurability) {
                durability = maxDurability - 1;
            } else if (durability < 0) {
                durability = 0;
            }
            CompatibilityLib.getDeprecatedUtils().setItemDamage(this.item, (short)durability);
        }
    }

    public boolean usesXPBar() {
        return this.xpBarDisplayMode.isEnabled(this);
    }

    public boolean usesXPNumber() {
        return this.levelDisplayMode.isEnabled(this);
    }

    public boolean usesXPDisplay() {
        return this.usesXPBar() || this.usesXPNumber();
    }

    public boolean usesCurrency(String type) {
        if (type.equals("sp") && !this.usesSP()) {
            return false;
        }
        return this.xpBarDisplayMode.usesCurrency(type) || this.levelDisplayMode.usesCurrency(type) || this.bossBarDisplayMode.usesCurrency(type);
    }

    public boolean usesSP() {
        return this.controller.isSPEarnEnabled() && this.hasSpellProgression && this.earnMultiplier > 0.0f;
    }

    public boolean hasSpellProgression() {
        return this.hasSpellProgression;
    }

    @Override
    public void updateMana() {
        Player player;
        if (this.isInOffhand) {
            return;
        }
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player == null) {
            return;
        }
        this.updateXPBar();
        float mana = this.getMana();
        if (this.usesMana()) {
            if (this.actionBarMana) {
                this.updateActionBar();
            }
            if (manaMode.useGlow()) {
                if (mana == this.effectiveManaMax) {
                    CompatibilityLib.getItemUtils().addGlow(this.item);
                } else {
                    CompatibilityLib.getItemUtils().removeGlow(this.item);
                }
            }
            if (manaMode.useDurability()) {
                this.updateDurability();
            }
        }
    }

    protected void updateActionBar() {
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player == null || this.actionBarMessage == null) {
            return;
        }
        if (this.actionBarMana) {
            double manaMax;
            boolean fullMana;
            double mana = this.mage.getMana();
            boolean bl = fullMana = mana == (manaMax = (double)this.mage.getEffectiveManaMax());
            if (fullMana && this.lastActionBarFullMana) {
                return;
            }
            this.lastActionBarFullMana = fullMana;
        }
        String message = this.mage.parameterize(this.actionBarMessage);
        CompatibilityLib.getCompatibilityUtils().sendActionBar(player, message);
    }

    public void updateXPBar() {
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player == null) {
            return;
        }
        boolean usesXPDisplay = this.xpBarDisplayMode.isEnabled(this);
        if (usesXPDisplay && this.xpBarDisplayMode.usesMana() && manaMode == WandManaMode.NONE) {
            usesXPDisplay = false;
        }
        boolean usesLevelDisplay = this.levelDisplayMode.isEnabled(this);
        if (usesXPDisplay || usesLevelDisplay) {
            int playerLevel = player.getLevel();
            float playerProgress = player.getExp();
            if (usesXPDisplay) {
                playerProgress = (float)Math.min(Math.max(0.0, this.xpBarDisplayMode.getProgress(this)), 1.0);
            }
            if (usesLevelDisplay) {
                playerLevel = (int)this.levelDisplayMode.getValue(this);
            }
            this.mage.sendExperience(playerProgress, playerLevel);
        }
    }

    @Override
    public boolean isInventoryOpen() {
        return this.mage != null && this.inventoryIsOpen;
    }

    public boolean wasInventoryOpen() {
        return this.inventoryWasOpen;
    }

    @Override
    public void unbind() {
        Mage owningMage = this.mage;
        this.deactivate();
        if (this.ownerId != null) {
            if (owningMage == null || !owningMage.getId().equals(this.ownerId)) {
                owningMage = this.controller.getRegisteredMage(this.ownerId);
            }
            if (owningMage != null) {
                owningMage.unbind(this);
            }
            this.ownerId = null;
        } else {
            owningMage.unbind(this);
        }
        this.bound = false;
        this.owner = null;
        this.setProperty("bound", false);
        this.setProperty("owner", null);
        this.setProperty("owner_id", null);
        this.saveState();
        this.updateLore();
        this.updateName();
    }

    @Override
    public void bind() {
        if (this.bound) {
            return;
        }
        Mage holdingMage = this.mage;
        this.deactivate();
        this.bound = true;
        this.setProperty("bound", true);
        this.saveState();
        if (holdingMage != null) {
            holdingMage.checkWand();
        }
    }

    @Override
    public void deactivate() {
        this.deactivate(true);
    }

    public void deactivate(boolean closePlayerInventory) {
        if (this.mage == null || !this.isActive) {
            return;
        }
        this.isActive = false;
        this.mage.sendDebugMessage(ChatColor.YELLOW + " Deactivating wand", 50);
        this.removeBossBar();
        this.playPassiveEffects("deactivate");
        List<String> modifiers = this.getStringList("modifiers");
        if (modifiers != null) {
            for (String key : modifiers) {
                this.mage.removeModifier(key);
            }
        }
        if (this.wandContext != null) {
            int cancelDelay = this.getInt("cancel_effects_delay", 0);
            if (cancelDelay == 0) {
                this.wandContext.cancelEffects();
            } else {
                MagicPlugin plugin = this.controller.getPlugin();
                plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, (Runnable)new CancelEffectsContextTask(this.wandContext), (long)(cancelDelay * 20 / 1000));
            }
        }
        Mage mage = this.mage;
        if (this.isInventoryOpen()) {
            this.closeInventory(closePlayerInventory);
        }
        this.storedInventory = null;
        if (this.usesXPNumber() || this.usesXPBar()) {
            mage.resetSentExperience();
        }
        this.saveState();
        this.showActiveIcon(false);
        mage.deactivateWand(this);
        this.mage = null;
        this.updateMaxMana(true);
    }

    @Override
    @Nullable
    public Spell getActiveSpell() {
        if (this.mage == null) {
            return null;
        }
        String activeSpellKey = this.getActiveSpellKey();
        if (activeSpellKey == null || activeSpellKey.length() == 0) {
            return null;
        }
        return this.mage.getSpell(activeSpellKey);
    }

    @Nullable
    public Spell getAlternateSpell(int index) {
        String key = this.alternateSpells[index];
        if (this.mage == null || key == null || key.length() == 0) {
            return null;
        }
        return this.mage.getSpell(key);
    }

    @Override
    @Nullable
    public SpellTemplate getBaseSpell(String spellName) {
        return this.getBaseSpell(new SpellKey(spellName));
    }

    @Nullable
    public SpellTemplate getBaseSpell(SpellKey key) {
        if (!this.spells.contains(key.getBaseKey())) {
            return null;
        }
        SpellKey baseKey = new SpellKey(key.getBaseKey(), this.getSpellLevel(key.getBaseKey()));
        return this.controller.getSpellTemplate(baseKey.getKey());
    }

    @Override
    public String getActiveSpellKey() {
        String activeSpellKey = this.activeSpell;
        Integer level = this.spellLevels.get(activeSpellKey);
        if (level != null) {
            activeSpellKey = new SpellKey(activeSpellKey, level).getKey();
        }
        return activeSpellKey;
    }

    @Override
    public String getActiveBrushKey() {
        return this.activeBrush;
    }

    @Override
    public void damageDealt(double damage, Entity target) {
        if (this.manaPerDamage > 0.0f) {
            int manaMax = this.getEffectiveManaMax();
            float mana = this.getMana();
            if (manaMax > 0 && mana < (float)manaMax) {
                this.setMana(Math.min((float)manaMax, mana + (float)damage * this.manaPerDamage));
                this.updateMana();
            }
        }
    }

    public boolean alternateCast(int index) {
        return this.cast(this.getAlternateSpell(index));
    }

    @Override
    public boolean cast() {
        return this.cast(this.getActiveSpell(), null);
    }

    @Override
    public boolean cast(String[] parameters) {
        return this.cast(this.getActiveSpell(), parameters);
    }

    @Override
    public boolean cast(Spell spell) {
        return this.cast(spell, null);
    }

    public boolean cast(Spell spell, String[] parameterArguments) {
        ConfigurationSection parameters = null;
        if (parameterArguments != null && parameterArguments.length > 0) {
            parameters = ConfigurationUtils.newConfigurationSection();
            ConfigurationUtils.addParameters(parameterArguments, parameters);
        }
        return this.doCast(spell, parameters);
    }

    public boolean doCast(Spell spell, ConfigurationSection parameters) {
        if (spell == null) {
            return false;
        }
        if (spell.isPassive()) {
            if (spell.isToggleable()) {
                spell.setEnabled(!spell.isEnabled());
                this.updateSpellItem(spell);
            }
            return true;
        }
        if (this.useMode == WandUseMode.PRECAST) {
            this.use();
        }
        ConfigurationSection castParameters = null;
        Map<String, String> castOverrides = this.getOverrides();
        if (castOverrides != null && castOverrides.size() > 0) {
            castParameters = ConfigurationUtils.newConfigurationSection();
            for (Map.Entry<String, String> entry : castOverrides.entrySet()) {
                String[] key = StringUtils.split((String)entry.getKey(), (String)".", (int)2);
                if (key.length == 0 || key.length == 2 && !key[0].equals("default") && !key[0].equals(spell.getSpellKey().getBaseKey()) && !key[0].equals(spell.getSpellKey().getKey())) continue;
                castParameters.set(key.length == 2 ? key[1] : key[0], (Object)entry.getValue());
            }
        }
        if (parameters != null) {
            if (castParameters == null) {
                castParameters = ConfigurationUtils.newConfigurationSection();
            }
            ConfigurationUtils.addConfigurations(castParameters, parameters, true);
        }
        if (spell.cast(this, castParameters)) {
            if (this.useMode != WandUseMode.PRECAST) {
                this.use();
            }
            this.onCast(spell);
            this.updateHotbarStatus();
            return true;
        }
        if (this.useMode == WandUseMode.ALWAYS) {
            this.use();
        }
        return false;
    }

    protected boolean use() {
        boolean usesRemaining = true;
        if (this.hasUses) {
            Player player;
            this.findItem();
            ItemStack item = this.getItem();
            if (this.mage != null && (player = this.mage.getPlayer()) != null && player.getGameMode() == GameMode.CREATIVE) {
                return true;
            }
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                if (this.uses > 0) {
                    --this.uses;
                }
                if (this.uses <= 0 && this.mage != null) {
                    player = this.mage.getPlayer();
                    Mage theMage = this.mage;
                    this.playEffects("break");
                    this.deactivate();
                    PlayerInventory playerInventory = player.getInventory();
                    if (item.getAmount() > 1) {
                        item.setAmount(item.getAmount() - 1);
                    } else {
                        if (this.isInOffhand) {
                            playerInventory.setItemInOffHand(new ItemStack(Material.AIR, 1));
                        } else {
                            playerInventory.setItemInMainHand(new ItemStack(Material.AIR, 1));
                        }
                        usesRemaining = false;
                        theMage.sendMessage(this.getMessage("used"));
                    }
                    CompatibilityLib.getDeprecatedUtils().updateInventory(player);
                }
                this.setProperty("uses", this.uses);
                this.saveState();
                this.updateName();
                this.updateLore();
            }
        }
        return usesRemaining;
    }

    public static int getExpToLevel(int expLevel) {
        return expLevel >= 30 ? 112 + (expLevel - 30) * 9 : (expLevel >= 15 ? 37 + (expLevel - 15) * 5 : 7 + expLevel * 2);
    }

    public static int getExperience(int expLevel, float expProgress) {
        int xp = 0;
        for (int level = 0; level < expLevel; ++level) {
            xp += Wand.getExpToLevel(level);
        }
        return xp + (int)(expProgress * (float)Wand.getExpToLevel(expLevel));
    }

    protected void updateHotbarStatus() {
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player != null && LiveHotbar && this.getMode() == WandMode.INVENTORY && this.isInventoryOpen()) {
            this.mage.updateHotbarStatus();
        }
    }

    @Override
    public boolean tickMana() {
        if (this.isHeroes) {
            HeroesManager heroes = this.controller.getHeroes();
            if (heroes != null && this.mage != null && this.mage.isPlayer()) {
                Player player = this.mage.getPlayer();
                this.effectiveManaMax = (float)heroes.getMaxMana(player);
                this.effectiveManaRegeneration = (float)heroes.getManaRegen(player);
                this.setManaMax(this.effectiveManaMax);
                this.setManaRegeneration(this.effectiveManaRegeneration);
                this.setMana((float)heroes.getMana(player));
                return true;
            }
            return false;
        }
        return super.tickMana();
    }

    @Override
    public void tick() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        super.tick();
        this.updateXPBar();
        long now = System.currentTimeMillis();
        if (this.actionBarMessage != null && now > this.lastActionBar + (long)this.actionBarInterval) {
            this.lastActionBar = System.currentTimeMillis();
            this.updateActionBar();
        }
        if (player.isBlocking() && this.blockMageCooldown > 0) {
            this.mage.setRemainingCooldown(this.blockMageCooldown);
        }
        if (!this.isInOffhand) {
            this.updateHotbarStatus();
        }
        if (!this.worn) {
            this.updateEffects();
        }
        this.checkBossBar();
    }

    @Override
    public void passiveEffectsUpdated() {
        this.updateMaxMana(true);
    }

    protected void updateMaxMana(boolean updateLore) {
        if (this.isHeroes) {
            return;
        }
        if (!this.hasOwnMana() && this.mageClass != null) {
            updateLore = this.mageClass.updateMaxMana(this.mage) && updateLore;
            this.effectiveManaMax = this.mageClass.getEffectiveManaMax();
            this.effectiveManaRegeneration = this.mageClass.getEffectiveManaRegeneration();
            if (updateLore) {
                this.updateLore();
            }
        } else if (super.updateMaxMana(this.mage) && updateLore) {
            this.updateLore();
        }
    }

    public void cycleSpells(int direction) {
        ArrayList<String> spells = new ArrayList<String>(this.spells);
        if (spells.size() == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.setActiveSpell(spells.get(0));
            return;
        }
        int spellIndex = 0;
        for (int i = 0; i < spells.size(); ++i) {
            if (!spells.get(i).equals(this.activeSpell)) continue;
            spellIndex = i;
            break;
        }
        spellIndex = (spellIndex + direction + spells.size()) % spells.size();
        this.setActiveSpell(spells.get(spellIndex));
        if (this.showCycleModeLore) {
            this.updateLore();
        }
    }

    public void cycleMaterials(int direction) {
        Collection materialsSet = this.getBrushes();
        ArrayList materials = new ArrayList(materialsSet);
        if (materials.size() == 0) {
            return;
        }
        if (this.activeBrush == null) {
            this.setActiveBrush(StringUtils.split((String)((String)materials.get(0)), (char)'@')[0]);
            return;
        }
        int materialIndex = 0;
        for (int i = 0; i < materials.size(); ++i) {
            if (!StringUtils.split((String)((String)materials.get(i)), (char)'@')[0].equals(this.activeBrush)) continue;
            materialIndex = i;
            break;
        }
        materialIndex = (materialIndex + direction) % materials.size();
        this.setActiveBrush(StringUtils.split((String)((String)materials.get(materialIndex)), (char)'@')[0]);
    }

    @Nullable
    public Mage getActiveMage() {
        return this.mage;
    }

    public void setActiveMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage instanceof Mage) {
            this.mage = (Mage)mage;
            this.passiveEffectsUpdated();
        }
    }

    public Particle getEffectParticle() {
        return this.effectParticle;
    }

    @Override
    @Nullable
    public String getEffectParticleName() {
        return this.effectParticle == null ? null : this.effectParticle.name();
    }

    @Nullable
    public WandInventory getHotbar() {
        if (this.hotbars.size() == 0) {
            return null;
        }
        if (this.currentHotbar < 0 || this.currentHotbar >= this.hotbars.size()) {
            this.setCurrentHotbar(0);
        }
        return this.hotbars.get(this.currentHotbar);
    }

    public int getHotbarCount() {
        if (this.getMode() != WandMode.INVENTORY) {
            return 0;
        }
        return Math.max(1, this.getInt("hotbar_count", 1));
    }

    public List<WandInventory> getHotbars() {
        return this.hotbars;
    }

    @Override
    public boolean isQuickCastDisabled() {
        return this.quickCastDisabled;
    }

    public boolean isManualQuickCastDisabled() {
        return this.manualQuickCastDisabled;
    }

    @Override
    public boolean isQuickCast() {
        return this.quickCast;
    }

    public WandMode getMode() {
        Player player;
        WandMode wandMode = this.mode;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (CREATIVE_CHEST_MODE && wandMode == WandMode.INVENTORY && player != null && player.getGameMode() == GameMode.CREATIVE) {
            wandMode = WandMode.CHEST;
        }
        return wandMode;
    }

    public WandMode getBrushMode() {
        return this.brushMode;
    }

    public void setMode(WandMode mode) {
        this.mode = mode;
    }

    public void setBrushMode(WandMode mode) {
        this.brushMode = mode;
    }

    @Override
    public boolean showCastMessages() {
        return this.quietLevel == 0;
    }

    @Override
    public boolean showMessages() {
        return this.quietLevel < 2;
    }

    public boolean isStealth() {
        return this.quietLevel > 2;
    }

    @Override
    public void setPath(String path) {
        String oldPath = this.path;
        this.path = path;
        this.setProperty("path", path);
        if (!oldPath.equals(path)) {
            this.updated();
        }
    }

    @Override
    public boolean isLost(com.elmakers.mine.bukkit.api.wand.LostWand lostWand) {
        return this.id != null && this.id.equals(lostWand.getId());
    }

    @Override
    public LostWand makeLost(Location location) {
        this.checkId();
        this.saveState();
        return new LostWand(this, location);
    }

    public void applyIcon() {
        if (!this.useActiveIcon()) {
            return;
        }
        this.findItem();
        this.icon.applyToItem(this.item);
    }

    public void showActiveIcon(boolean show) {
        if (this.icon == null || this.inactiveIcon == null || this.inactiveIcon.getMaterial() == Material.AIR || this.inactiveIcon.getMaterial() == null) {
            return;
        }
        if (this.icon.getMaterial() == Material.AIR || this.icon.getMaterial() == null) {
            this.icon.setMaterial(DefaultWandMaterial);
        }
        if (show) {
            if (this.inactiveIconDelay > 0) {
                MagicPlugin plugin = this.controller.getPlugin();
                plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new ApplyWandIconTask(this), (long)(this.inactiveIconDelay * 20 / 1000));
            } else {
                this.findItem();
                this.icon.applyToItem(this.item);
            }
        } else {
            this.findItem();
            this.inactiveIcon.applyToItem(this.item);
        }
    }

    public boolean activateOffhand(Mage mage) {
        return this.activate(mage, true);
    }

    @Override
    @Deprecated
    public void activate(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage instanceof Mage) {
            this.activate((Mage)mage);
        }
    }

    public boolean activate(Mage mage) {
        return this.activate(mage, false);
    }

    public boolean activate(Mage mage, boolean offhand) {
        HeroesManager heroes;
        if (mage == null) {
            return false;
        }
        mage.sendDebugMessage(ChatColor.YELLOW + "   Activating wand", 50);
        Player player = mage.getPlayer();
        if (player == null) {
            return false;
        }
        if (!this.controller.hasWandPermission(player, this)) {
            return false;
        }
        InventoryView openInventory = player.getOpenInventory();
        InventoryType inventoryType = openInventory.getType();
        if (inventoryType == InventoryType.ENCHANTING || inventoryType == InventoryType.ANVIL) {
            return false;
        }
        if (this.hasUses && this.uses <= 0) {
            if (offhand) {
                player.getInventory().setItemInOffHand(new ItemStack(Material.AIR, 1));
            } else {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR, 1));
            }
            return false;
        }
        if (!this.canUse(player)) {
            mage.sendMessage(this.getMessage("bound").replace("$name", this.getOwner()));
            return false;
        }
        if (this.isUpgrade) {
            this.controller.getLogger().warning("Activated an upgrade item- this shouldn't happen");
            return false;
        }
        WandPreActivateEvent preActivateEvent = new WandPreActivateEvent(mage, this);
        Bukkit.getPluginManager().callEvent((Event)preActivateEvent);
        if (preActivateEvent.isCancelled()) {
            return false;
        }
        if (this.getMode() != WandMode.INVENTORY) {
            this.showActiveIcon(true);
        }
        boolean needsSave = false;
        if (this.hasId) {
            needsSave = this.checkId() || needsSave;
        } else {
            this.setProperty("id", null);
        }
        if (!this.setMage(mage, offhand, player)) {
            return false;
        }
        this.isActive = true;
        this.isInOffhand = offhand;
        this.heldSlot = offhand ? 40 : player.getInventory().getHeldItemSlot();
        List<String> modifiers = this.getStringList("modifiers");
        if (modifiers != null) {
            for (String key : modifiers) {
                mage.addModifier(key);
            }
        }
        this.discoverRecipes("discover_recipes");
        CompatibilityLib.getInventoryUtils().applyAttributes(this.item, this.getConfigurationSection("item_attributes"), this.getString("item_attribute_slot", this.getString("attribute_slot")));
        mage.setLastActivatedSlot(player.getInventory().getHeldItemSlot());
        String replacementTemplate = this.getString("replace_on_activate", "");
        if (!replacementTemplate.isEmpty() && !replacementTemplate.equals(this.template)) {
            this.replaceTemplate(replacementTemplate);
            return this.activate(mage, offhand);
        }
        if ((this.getMode() != WandMode.INVENTORY || offhand) && this.controller.isLoaded()) {
            MagicPlugin plugin = this.controller.getPlugin();
            plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new OpenWandTask(this), 1L);
        }
        if (!this.isUpgrade && (this.controller.fillWands() || this.autoFill)) {
            this.fill(mage.getPlayer(), this.controller.getMaxWandFillLevel());
            needsSave = true;
        }
        if (this.isHeroes && (heroes = this.controller.getHeroes()) != null) {
            Set<String> skills = heroes.getSkills(player);
            ArrayList currentSpells = new ArrayList(this.getSpells());
            for (String spellKey : currentSpells) {
                if (!spellKey.startsWith("heroes*") || skills.contains(spellKey.substring(7))) continue;
                this.removeSpell(spellKey);
            }
            this.mage = null;
            for (String skillKey : skills) {
                String heroesKey = "heroes*" + skillKey;
                if (this.spells.contains(heroesKey)) continue;
                this.addSpell(heroesKey);
            }
            this.mage = mage;
        }
        if (this.resetManaOnActivate != null && this.usesMana()) {
            float newMana = (float)this.resetManaOnActivate.doubleValue();
            if (newMana < 1.0f) {
                newMana *= (float)this.getManaMax();
            }
            if (newMana < this.getMana()) {
                this.setMana(newMana);
            }
            this.setProperty("mana_timestamp", System.currentTimeMillis());
        }
        if (this.autoOrganize && !this.isUpgrade) {
            this.organizeInventory(mage);
            needsSave = true;
        }
        if (this.autoAlphabetize && !this.isUpgrade) {
            this.alphabetizeInventory();
            needsSave = true;
        }
        boolean forceUpdate = false;
        if (this.autoAbsorb && this.checkInventoryForUpgrades()) {
            forceUpdate = true;
            needsSave = true;
        }
        if (this.randomizeOnActivate) {
            this.randomize();
            this.randomizeOnActivate = false;
            forceUpdate = true;
            needsSave = true;
        }
        if (offhand) {
            mage.setOffhandWand(this);
        } else {
            mage.setActiveWand(this);
        }
        this.buildInventory();
        this.updateMaxMana(false);
        this.tick();
        if (!this.isInOffhand) {
            this.updateMana();
        }
        this.checkActiveMaterial();
        if (this.bound) {
            boolean ownerRenamed;
            String mageName = ChatColor.stripColor((String)mage.getPlayer().getDisplayName());
            String mageId = mage.getId();
            boolean bl = ownerRenamed = this.owner != null && this.ownerId != null && this.ownerId.equals(mageId) && !this.owner.equals(mageName);
            if (this.ownerId == null || this.ownerId.length() == 0 || this.owner == null || ownerRenamed) {
                this.takeOwnership(mage.getPlayer());
                needsSave = true;
            }
        }
        if (needsSave) {
            this.saveState();
        }
        this.updateActiveMaterial();
        this.updateName();
        this.updateLore();
        this.playPassiveEffects("activate");
        this.lastSoundEffect = 0L;
        this.lastParticleEffect = 0L;
        this.lastSpellCast = 0L;
        if (forceUpdate) {
            CompatibilityLib.getDeprecatedUtils().updateInventory(player);
        }
        return true;
    }

    private boolean setMage(Mage mage, boolean offhand, Player player) {
        this.mage = mage;
        if (this.mageClassKeys != null && !this.mageClassKeys.isEmpty()) {
            String mageClassKey;
            MageClass mageClass = null;
            Iterator<String> iterator = this.mageClassKeys.iterator();
            while (iterator.hasNext() && (mageClass = mage.getClass(mageClassKey = iterator.next())) == null) {
            }
            if (mageClass == null) {
                if (player != null) {
                    Integer lastSlot = mage.getLastActivatedSlot();
                    if (!(offhand || lastSlot != null && lastSlot.intValue() == player.getInventory().getHeldItemSlot())) {
                        mage.setLastActivatedSlot(player.getInventory().getHeldItemSlot());
                        mage.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", this.getName()));
                    }
                }
                return false;
            }
            this.setMageClass(mageClass);
            if (!offhand && player != null) {
                mage.setActiveClass(mageClass.getKey());
            }
        }
        MageParameters wrapped = new MageParameters(mage, "Wand " + this.getTemplateKey());
        wrapped.wrap(this.configuration);
        this.load((ConfigurationSection)wrapped);
        this.loadProperties();
        return true;
    }

    private void replaceTemplate(String newTemplate) {
        this.playEffects("replace");
        this.setTemplate(newTemplate);
        this.clearProperty("icon");
        this.loadProperties();
        this.saveState();
    }

    public boolean checkInventoryForUpgrades() {
        Player player;
        boolean updated = false;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player == null || this.mage.hasStoredInventory()) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack[] items = inventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (!this.addItem(item)) continue;
            inventory.setItem(i, null);
            updated = true;
        }
        return updated;
    }

    private void setOpenInventoryPage(int page) {
        this.openInventoryPage = page;
        this.setProperty("page", page);
    }

    @Override
    public boolean organizeInventory() {
        if (this.mage != null) {
            return this.organizeInventory(this.mage);
        }
        return false;
    }

    @Override
    public boolean organizeInventory(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        WandOrganizer organizer = new WandOrganizer(this, mage);
        this.closeInventory();
        organizer.organize();
        this.setOpenInventoryPage(0);
        this.setCurrentHotbar(this.currentHotbar);
        if (this.autoOrganize) {
            this.setProperty("organize", false);
        }
        this.autoOrganize = false;
        this.updateSpellInventory();
        this.updateBrushInventory();
        if (this.mage != null) {
            this.buildInventory();
        }
        return true;
    }

    @Override
    public boolean alphabetizeInventory() {
        WandOrganizer organizer = new WandOrganizer(this);
        this.closeInventory();
        organizer.alphabetize();
        this.setOpenInventoryPage(0);
        this.setCurrentHotbar(0);
        if (this.autoAlphabetize) {
            this.setProperty("alphabetize", false);
        }
        this.autoAlphabetize = false;
        this.updateSpellInventory();
        this.updateBrushInventory();
        if (this.mage != null) {
            this.buildInventory();
        }
        return true;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand duplicate() {
        ItemStack newItem = CompatibilityLib.getItemUtils().getCopy(this.item);
        Wand newWand = this.controller.getWand(newItem);
        newWand.saveState();
        return newWand;
    }

    @Override
    @Deprecated
    public boolean configure(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        this.configure(ConfigurationUtils.convertConfigurationSection(convertedProperties));
        return true;
    }

    @Override
    public void preUpdate() {
        this.updateSpellInventory();
        this.updateBrushInventory();
    }

    @Override
    public void updated() {
        if (this.wandContext != null) {
            this.wandContext.cancelEffects();
            this.wandContext = null;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            this.updateSpellInventory();
        }
        this.saveState();
        super.updated();
        if (this.mage != null) {
            this.buildInventory();
            if (this.isInventoryOpen()) {
                this.updateInventory();
            }
        }
        this.updateMaxMana(false);
        this.updateName();
        this.updateLore();
        if (this.mage != null) {
            this.playPassiveEffects("activate");
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean upgradesAllowed() {
        return !this.locked || this.lockedAllowUpgrades;
    }

    @Override
    public void unlock() {
        this.locked = false;
        this.setProperty("locked", false);
    }

    public boolean isWorn() {
        return this.worn;
    }

    @Override
    public boolean canUse(Player player) {
        if (!this.bound || this.ownerId == null || this.ownerId.length() == 0) {
            return true;
        }
        if (this.controller.hasPermission(player, "Magic.wand.override_bind")) {
            return true;
        }
        String playerId = this.controller.getMageIdentifier().fromEntity((Entity)player);
        if (this.ownerId.equalsIgnoreCase(playerId)) {
            return true;
        }
        return this.ownerId.equals(player.getUniqueId().toString());
    }

    @Override
    public boolean addSpell(String spellName) {
        if (!this.isModifiable()) {
            return false;
        }
        return super.addSpell(spellName);
    }

    @Override
    public boolean forceAddSpell(String spellName) {
        WandUpgradePath path;
        SpellTemplate template = this.controller.getSpellTemplate(spellName);
        if (template == null) {
            return false;
        }
        SpellKey spellKey = template.getSpellKey();
        if (this.limitSpellsToPath && (path = this.getPath()) != null && !path.containsSpell(spellKey.getBaseKey())) {
            return false;
        }
        this.checkSpellLevelsAndInventory();
        if (!super.forceAddSpell(spellName)) {
            return false;
        }
        this.saveInventory();
        ItemStack spellItem = this.createSpellItem(spellKey.getKey());
        if (spellItem == null) {
            return false;
        }
        int level = spellKey.getLevel();
        int inventoryCount = this.inventories.size();
        int spellCount = this.spells.size();
        Integer inventorySlot = this.spellInventory.get(spellKey.getBaseKey());
        this.clearSlot(inventorySlot);
        this.setSpellLevel(spellKey.getBaseKey(), level);
        this.spells.add(spellKey.getBaseKey());
        if (this.activeSpell == null || this.activeSpell.isEmpty()) {
            this.setActiveSpell(spellKey.getBaseKey());
        }
        this.addToInventory(spellItem, inventorySlot);
        this.checkSpellLevelsAndInventory();
        this.updateInventory();
        this.updateHasInventory();
        this.saveState();
        this.updateLore();
        if (this.mage != null && this.spells.size() != spellCount) {
            boolean sendInstructions;
            boolean bl = sendInstructions = spellCount == 0 && this.leftClickAction == WandAction.CAST || spellCount == 1 || inventoryCount == 1 && this.inventories.size() > 1;
            if (sendInstructions) {
                this.startWandInstructions();
                this.showSpellInstructions();
                this.showPageInstructions();
                this.endWandInstructions();
            }
        }
        return true;
    }

    @Nonnull
    public String getInventoryKey(String def) {
        String key = this.getInventoryKey();
        return key == null ? def : key;
    }

    @Nullable
    private String getInventoryKey() {
        switch (this.getMode()) {
            case CYCLE: {
                return this.getControlKey(WandAction.CYCLE);
            }
        }
        return this.getControlKey(WandAction.TOGGLE);
    }

    @Nullable
    private String getControlMessage() {
        String inventoryMessage = null;
        switch (this.getMode()) {
            case INVENTORY: {
                inventoryMessage = "inventory_instructions";
                break;
            }
            case CHEST: {
                inventoryMessage = "chest_instructions";
                break;
            }
            case SKILLS: {
                inventoryMessage = "skills_instructions";
                break;
            }
            case CYCLE: {
                inventoryMessage = "cycle_instructions";
                break;
            }
        }
        return inventoryMessage;
    }

    private void checkSpellLevelsAndInventory() {
        BaseMagicConfigurable storage;
        if (!(this.spellLevels.isEmpty() || (storage = this.getStorage("spell_levels")) != null && storage != this || this.configuration.contains("spell_levels"))) {
            this.configuration.set("spell_levels", this.spellLevels);
        }
        if (!(this.spellInventory.isEmpty() || (storage = this.getStorage("spell_inventory")) != null && storage != this || this.configuration.contains("spell_inventory"))) {
            this.configuration.set("spell_inventory", this.spellInventory);
        }
    }

    private void clearSlot(Integer slot) {
        if (slot != null) {
            WandInventory inventory = this.getInventory(slot);
            slot = this.getInventorySlot(slot);
            inventory.setItem(slot, null);
        }
    }

    @Override
    public String getMessage(String messageKey, String defaultValue) {
        String message = super.getMessage(messageKey, defaultValue);
        if (messageKey.equals("hotbar_count_usage")) {
            String controlKey = this.getControlKey(WandAction.CYCLE_HOTBAR);
            if (controlKey != null) {
                controlKey = this.controller.getMessages().get("controls." + controlKey);
                message = message.replace("$cycle_hotbar", controlKey);
            } else {
                return "";
            }
        }
        return message;
    }

    @Override
    protected String getMessageKey(String key) {
        String templateKey;
        WandTemplate template = this.getTemplate();
        String string = templateKey = template == null ? null : template.getMessageKey(key, this.controller);
        if (templateKey != null) {
            return templateKey;
        }
        template = template == null ? null : template.getParent();
        String string2 = templateKey = template == null ? null : template.getMessageKey(key, this.controller);
        if (templateKey != null) {
            return templateKey;
        }
        return "wand." + key;
    }

    @Override
    protected String parameterizeMessage(String message) {
        return message.replace("$wand", this.getName());
    }

    @Override
    public boolean hasBrush(String materialKey) {
        WandUpgradePath path;
        if (this.limitBrushesToPath && (path = this.getPath()) != null && !path.containsBrush(materialKey)) {
            return false;
        }
        return this.getBrushes().contains(materialKey);
    }

    @Override
    public boolean hasSpell(String spellName) {
        return this.hasSpell(new SpellKey(spellName));
    }

    @Override
    public boolean hasSpell(SpellKey spellKey) {
        WandUpgradePath path;
        if (!this.spells.contains(spellKey.getBaseKey())) {
            return false;
        }
        if (this.limitSpellsToPath && (path = this.getPath()) != null && !path.containsSpell(spellKey.getBaseKey())) {
            return false;
        }
        int level = this.getSpellLevel(spellKey.getBaseKey());
        return level >= spellKey.getLevel();
    }

    @Override
    public boolean addBrush(String materialKey) {
        WandUpgradePath path;
        if (!this.isModifiable()) {
            return false;
        }
        if (this.limitBrushesToPath && (path = this.getPath()) != null && !path.containsBrush(materialKey)) {
            return false;
        }
        if (!super.addBrush(materialKey)) {
            return false;
        }
        this.saveInventory();
        ItemStack itemStack = this.createBrushIcon(materialKey);
        if (itemStack == null) {
            return false;
        }
        int inventoryCount = this.inventories.size();
        int brushCount = this.brushes.size();
        this.brushInventory.put(materialKey, null);
        this.brushes.add(materialKey);
        this.addToInventory(itemStack);
        if (this.activeBrush == null || this.activeBrush.length() == 0) {
            this.activateBrush(materialKey);
        } else {
            this.updateInventory();
        }
        this.updateHasInventory();
        this.saveState();
        this.updateLore();
        if (this.mage != null) {
            boolean sendInstructions;
            boolean bl = sendInstructions = brushCount == 0 || inventoryCount == 1 && this.inventories.size() > 1;
            if (sendInstructions) {
                this.startWandInstructions();
                this.showBrushInstructions();
                this.showPageInstructions();
                this.endWandInstructions();
            }
        }
        return true;
    }

    @Override
    public void setActiveBrush(String materialKey) {
        this.activateBrush(materialKey);
        if (materialKey == null || this.mage == null) {
            return;
        }
        MaterialBrush brush = this.mage.getBrush();
        if (brush == null) {
            return;
        }
        boolean eraseWasActive = brush.isEraseModifierActive();
        brush.activate(this.mage.getLocation(), materialKey);
        BrushMode mode = brush.getMode();
        if (mode == BrushMode.CLONE) {
            this.mage.sendMessage(this.getMessage("clone_material_activated"));
        } else if (mode == BrushMode.REPLICATE) {
            this.mage.sendMessage(this.getMessage("replicate_material_activated"));
        }
        if (!eraseWasActive && brush.isEraseModifierActive()) {
            this.mage.sendMessage(this.getMessage("erase_modifier_activated"));
        }
    }

    public void setActiveBrush(ItemStack itemStack) {
        if (!Wand.isBrush(itemStack)) {
            return;
        }
        this.setActiveBrush(Wand.getBrush(itemStack));
    }

    public void activateBrush(String materialKey) {
        this.activeBrush = materialKey;
        this.setProperty("active_brush", this.activeBrush);
        this.saveState();
        this.updateActiveMaterial();
        this.updateName();
        this.updateHotbar();
    }

    @Override
    public void setActiveSpell(String activeSpell) {
        if (activeSpell != null) {
            SpellKey spellKey = new SpellKey(activeSpell);
            this.activeSpell = spellKey.getBaseKey();
        } else {
            this.activeSpell = null;
        }
        this.checkActiveSpell();
        this.setProperty("active_spell", this.activeSpell);
        this.saveState();
        this.updateName();
    }

    protected void checkActiveSpell() {
        if (this.activeSpell != null && !this.spells.isEmpty() && !this.spells.contains(this.activeSpell)) {
            this.activeSpell = null;
        }
    }

    @Override
    public boolean removeBrush(String materialKey) {
        WandUpgradePath path;
        if (!this.isModifiable() || materialKey == null) {
            return false;
        }
        if (this.limitBrushesToPath && (path = this.getPath()) != null && !path.containsBrush(materialKey)) {
            return false;
        }
        if (!super.removeBrush(materialKey)) {
            return false;
        }
        this.saveInventory();
        if (materialKey.equals(this.activeBrush)) {
            this.activeBrush = null;
        }
        this.clearSlot(this.brushInventory.get(materialKey));
        this.brushInventory.remove(materialKey);
        boolean found = this.brushes.remove(materialKey);
        if (this.activeBrush == null && this.brushes.size() > 0) {
            this.activeBrush = this.brushes.iterator().next();
        }
        this.updateActiveMaterial();
        this.updateInventory();
        this.updateBrushInventory();
        this.saveState();
        this.updateName();
        this.updateLore();
        return found;
    }

    @Override
    public boolean removeSpell(String spellName) {
        WandUpgradePath path;
        if (!this.isModifiable()) {
            return false;
        }
        SpellKey spellKey = new SpellKey(spellName);
        if (this.limitSpellsToPath && (path = this.getPath()) != null && !path.containsSpell(spellKey.getBaseKey())) {
            return false;
        }
        if (!super.removeSpell(spellName)) {
            return false;
        }
        this.saveInventory();
        if (this.activeSpell != null) {
            SpellKey activeKey = new SpellKey(this.activeSpell);
            if (spellKey.getBaseKey().equals(activeKey.getBaseKey())) {
                this.setActiveSpell(null);
            }
        }
        this.clearSlot(this.spellInventory.get(spellKey.getBaseKey()));
        this.spells.remove(spellKey.getBaseKey());
        this.spellLevels.remove(spellKey.getBaseKey());
        this.spellInventory.remove(spellKey.getBaseKey());
        if (this.activeSpell == null && this.spells.size() > 0) {
            this.setActiveSpell(this.spells.iterator().next());
        }
        this.checkSpellLevelsAndInventory();
        this.updateInventory();
        this.updateHasInventory();
        this.updateSpellInventory();
        this.saveState();
        this.updateName();
        this.updateLore();
        return true;
    }

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        return remainder.size() == 0;
    }

    public boolean storeInventory() {
        if (this.storedInventory != null) {
            if (this.mage != null) {
                this.mage.sendMessage("Your wand contains a previously stored inventory and will not activate, let go of it to clear.");
            }
            this.controller.getLogger().warning("Tried to store an inventory with one already present: " + (this.mage == null ? "?" : this.mage.getName()));
            return false;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        this.storedInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, 36, "Stored Inventory");
        for (int i = 0; i < 36; ++i) {
            ItemStack item = inventory.getItem(i);
            this.storedInventory.setItem(i, item);
            if (i == this.heldSlot) continue;
            inventory.setItem(i, null);
        }
        return true;
    }

    public boolean restoreInventory() {
        if (this.storedInventory == null) {
            return false;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < this.storedInventory.getSize(); ++i) {
            ItemStack storedItem = this.storedInventory.getItem(i);
            if (i == this.heldSlot && !Wand.isSpell(inventory.getItem(i))) continue;
            inventory.setItem(i, storedItem);
        }
        this.storedInventory = null;
        inventory.setHeldItemSlot(this.heldSlot);
        return true;
    }

    @Override
    @Deprecated
    public boolean isSoul() {
        return false;
    }

    public static boolean isBound(ItemStack item) {
        Object wandSection = CompatibilityLib.getNBTUtils().getNode(item, WAND_KEY);
        if (wandSection == null) {
            return false;
        }
        String boundValue = CompatibilityLib.getNBTUtils().getMetaString(wandSection, "owner_id");
        return boundValue != null;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    @Nullable
    public SpellTemplate getSpellTemplate(String spellKey) {
        SpellKey key = new SpellKey(spellKey);
        if (!this.spells.contains(spellKey = key.getBaseKey())) {
            return null;
        }
        Integer level = this.spellLevels.get(spellKey);
        if (level != null) {
            spellKey = new SpellKey(spellKey, level).getKey();
        }
        return this.controller.getSpellTemplate(spellKey);
    }

    @Override
    public boolean setSpellLevel(String spellKey, int level) {
        boolean modified;
        if (level <= 1) {
            modified = this.spellLevels.containsKey(spellKey);
            this.spellLevels.remove(spellKey);
        } else {
            modified = !this.spellLevels.containsKey(spellKey) || this.spellLevels.get(spellKey) != level;
            this.spellLevels.put(spellKey, level);
        }
        return modified;
    }

    @Override
    public int getSpellLevel(String spellKey) {
        Integer level = this.spellLevels.get(spellKey);
        return level == null ? 1 : level;
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public Map<String, Integer> getSpellInventory() {
        return new HashMap<String, Integer>(this.spellInventory);
    }

    @Override
    public Map<String, Integer> getBrushInventory() {
        return new HashMap<String, Integer>(this.brushInventory);
    }

    @Override
    public float getHealthRegeneration() {
        Integer level = this.getPotionEffects().get(PotionEffectType.REGENERATION);
        return level != null && level > 0 ? (float)level.intValue() : 0.0f;
    }

    @Override
    public float getHungerRegeneration() {
        Integer level = this.getPotionEffects().get(PotionEffectType.SATURATION);
        return level != null && level > 0 ? (float)level.intValue() : 0.0f;
    }

    @Override
    @Nullable
    public WandTemplate getTemplate() {
        if (this.template == null || this.template.isEmpty()) {
            return null;
        }
        return this.controller.getWandTemplate(this.template);
    }

    public boolean playPassiveEffects(String effects) {
        WandTemplate wandTemplate = this.getTemplate();
        if (wandTemplate != null && this.mage != null) {
            boolean offhandActive = this.mage.setOffhandActive(this.isInOffhand);
            boolean result = false;
            try {
                result = wandTemplate.playEffects(this, effects);
            }
            catch (Exception ex) {
                result = false;
                this.controller.getLogger().log(Level.WARNING, "Error playing effects " + effects + " from wand " + this.template, ex);
            }
            this.mage.setOffhandActive(offhandActive);
            return result;
        }
        return false;
    }

    @Override
    public boolean playEffects(String effects) {
        if (this.activeEffectsOnly && !this.inventoryIsOpen) {
            return false;
        }
        return this.playPassiveEffects(effects);
    }

    @Override
    public WandAction getDropAction() {
        return this.dropSneakAction != WandAction.NONE && this.mage != null && this.mage.isSneaking() ? this.dropSneakAction : this.dropAction;
    }

    @Override
    public WandAction getRightClickAction() {
        return this.rightClickSneakAction != WandAction.NONE && this.mage != null && this.mage.isSneaking() ? this.rightClickSneakAction : this.rightClickAction;
    }

    @Override
    public WandAction getLeftClickAction() {
        return this.leftClickSneakAction != WandAction.NONE && this.mage != null && this.mage.isSneaking() ? this.leftClickSneakAction : this.leftClickAction;
    }

    @Override
    public WandAction getSwapAction() {
        return this.swapSneakAction != WandAction.NONE && this.mage != null && this.mage.isSneaking() ? this.swapSneakAction : this.swapAction;
    }

    @Override
    public boolean performAction(WandAction action) {
        WandMode mode = this.getMode();
        switch (action) {
            case CAST: {
                this.cast();
                break;
            }
            case ALT_CAST: {
                this.alternateCast(0);
                break;
            }
            case ALT_CAST2: {
                this.alternateCast(1);
                break;
            }
            case ALT_CAST3: {
                this.alternateCast(2);
                break;
            }
            case ALT_CAST4: {
                this.alternateCast(3);
                break;
            }
            case ALT_CAST5: {
                this.alternateCast(4);
                break;
            }
            case ALT_CAST6: {
                this.alternateCast(5);
                break;
            }
            case ALT_CAST7: {
                this.alternateCast(6);
                break;
            }
            case TOGGLE: {
                if (mode == WandMode.CYCLE) {
                    this.cycleActive(1);
                    return true;
                }
                if (mode != WandMode.CHEST && mode != WandMode.INVENTORY && mode != WandMode.SKILLS) {
                    return false;
                }
                this.toggleInventory();
                break;
            }
            case CYCLE: {
                this.cycleActive(1);
                break;
            }
            case CYCLE_REVERSE: {
                this.cycleActive(-1);
                break;
            }
            case CYCLE_HOTBAR: {
                if (mode != WandMode.INVENTORY || !this.isInventoryOpen()) {
                    return false;
                }
                if (this.getHotbarCount() > 1) {
                    this.cycleHotbar(1);
                    break;
                }
                this.closeInventory();
                break;
            }
            case CYCLE_HOTBAR_REVERSE: {
                if (mode != WandMode.INVENTORY) {
                    return false;
                }
                if (this.getHotbarCount() > 1) {
                    this.cycleHotbar(-1);
                    break;
                }
                if (this.isInventoryOpen()) {
                    this.closeInventory();
                    break;
                }
                return false;
            }
            case REPLACE: {
                String replacementTemplate = this.getString("replacement", "");
                if (replacementTemplate.isEmpty() || replacementTemplate.equals(this.template)) {
                    return false;
                }
                this.replaceTemplate(replacementTemplate);
                if (this.mage == null) break;
                Mage mage = this.mage;
                this.deactivate();
                mage.checkWandNextTick();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasUpgrade() {
        WandUpgradePath path = this.getPath();
        return path != null && path.hasUpgrade();
    }

    @Override
    public boolean checkUpgrade(boolean quiet) {
        WandUpgradePath path = this.getPath();
        return path == null || !path.hasUpgrade() ? false : path.checkUpgradeRequirements(this, quiet ? null : this.mage);
    }

    @Override
    @Deprecated
    public boolean upgrade(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        return this.upgrade(ConfigurationUtils.convertConfigurationSection(convertedProperties));
    }

    @Override
    public boolean upgrade(boolean quiet) {
        WandUpgradePath path = this.getPath();
        if (path == null) {
            return false;
        }
        path.upgrade((com.elmakers.mine.bukkit.api.wand.Wand)this, quiet ? null : this.mage);
        return true;
    }

    @Override
    public boolean isBlocked(double angle) {
        boolean isBlocked;
        if (this.mage == null) {
            return false;
        }
        if (this.blockChance == 0.0f) {
            return false;
        }
        if (this.blockFOV > 0.0f && angle > (double)this.blockFOV) {
            return false;
        }
        long lastBlock = this.mage.getLastBlockTime();
        if (this.blockCooldown > 0 && lastBlock > 0L && lastBlock + (long)this.blockCooldown > System.currentTimeMillis()) {
            return false;
        }
        boolean bl = isBlocked = Math.random() <= (double)this.blockChance;
        if (isBlocked) {
            this.playEffects("spell_blocked");
            this.mage.setLastBlockTime(System.currentTimeMillis());
        }
        return isBlocked;
    }

    @Override
    public boolean isReflected(double angle) {
        boolean isReflected;
        if (this.mage == null) {
            return false;
        }
        if (this.blockReflectChance == 0.0f) {
            return false;
        }
        if (this.blockFOV > 0.0f && angle > (double)this.blockFOV) {
            return false;
        }
        long lastBlock = this.mage.getLastBlockTime();
        if (this.blockCooldown > 0 && lastBlock > 0L && lastBlock + (long)this.blockCooldown > System.currentTimeMillis()) {
            return false;
        }
        boolean bl = isReflected = Math.random() <= (double)this.blockReflectChance;
        if (isReflected) {
            this.playEffects("spell_reflected");
            if (this.mage != null) {
                this.mage.setLastBlockTime(System.currentTimeMillis());
            }
        }
        return isReflected;
    }

    @Override
    @Nullable
    public Location getLocation() {
        if (this.mage == null) {
            return null;
        }
        Location wandLocation = this.mage.getEyeLocation();
        wandLocation = this.mage.getOffsetLocation(wandLocation, this.isInOffhand, this.castLocation == null ? DEFAULT_CAST_OFFSET : this.castLocation);
        return wandLocation;
    }

    @Override
    @Nullable
    public Mage getMage() {
        return this.mage;
    }

    @Override
    @Nullable
    public MageClass getMageClass() {
        return this.mageClass;
    }

    @Override
    @Nullable
    public String getMageClassKey() {
        if (this.mageClass != null) {
            return this.mageClass.getKey();
        }
        return this.mageClassKeys == null || this.mageClassKeys.isEmpty() ? null : this.mageClassKeys.get(0);
    }

    @Override
    public void setCurrentHotbar(int hotbar) {
        this.currentHotbar = hotbar;
        this.setProperty("hotbar", this.currentHotbar);
    }

    @Override
    public int getCurrentHotbar() {
        return this.currentHotbar;
    }

    public int getInventorySize() {
        WandMode mode = this.getMode();
        if (mode == WandMode.CHEST || mode == WandMode.SKILLS) {
            return 9 * this.inventoryRows;
        }
        return 27;
    }

    @Override
    public int getHeldSlot() {
        return this.heldSlot;
    }

    @Override
    public void setHeldSlot(int slot) {
        this.heldSlot = slot;
    }

    @Override
    @Nullable
    public BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        switch (propertyType) {
            case WAND: {
                return this;
            }
            case SUBCLASS: {
                return this.mageClass;
            }
            case CLASS: {
                return this.mageClass == null ? null : this.mageClass.getRoot();
            }
            case MAGE: {
                return this.mage == null ? null : this.mage.getProperties();
            }
        }
        return null;
    }

    @Override
    public boolean isPlayer() {
        return this.mage == null ? false : this.mage.isPlayer();
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.mage == null ? null : this.mage.getPlayer();
    }

    @Override
    @Nonnull
    public MageContext getContext() {
        Preconditions.checkState((this.mage != null ? 1 : 0) != 0, (Object)"Mage is not available");
        if (this.wandContext == null || this.wandContext.getMage() != this.mage) {
            this.wandContext = new WandContext((com.elmakers.mine.bukkit.api.magic.Mage)Verify.verifyNotNull((Object)this.mage), this);
        }
        return (MageContext)Verify.verifyNotNull((Object)this.wandContext);
    }

    @Override
    public Wand getWand() {
        return this;
    }

    @Override
    public boolean isInOffhand() {
        return this.isInOffhand;
    }

    public boolean hasWearable() {
        return this.hasProperty("wearable");
    }

    public boolean isWearableInSlot(int slotNumber) {
        if (this.isBoolean("wearable") && this.getBoolean("wearable")) {
            return true;
        }
        List<String> slots = this.getStringList("wearable");
        if (slots != null) {
            for (String slotKey : slots) {
                InventorySlot slot = InventorySlot.parse(slotKey);
                if (slot != null) {
                    if (slot.getSlot() != slotNumber) continue;
                    return true;
                }
                this.controller.getLogger().warning("Invalid wearable slot: " + slotKey);
            }
        }
        return false;
    }

    @Nullable
    public Collection<Integer> getWearableSlots() {
        ArrayList<Integer> slots = null;
        if (this.isBoolean("wearable") && this.getBoolean("wearable")) {
            slots = new ArrayList<Integer>();
            for (InventorySlot slot : InventorySlot.values()) {
                if (slot.getSlot() < 0) continue;
                slots.add(slot.getSlot());
            }
            return slots;
        }
        List<String> slotList = this.getStringList("wearable");
        if (slotList != null) {
            slots = new ArrayList();
            for (String slotKey : slotList) {
                InventorySlot slot = InventorySlot.parse(slotKey);
                if (slot != null) {
                    slots.add(slot.getSlot());
                    continue;
                }
                this.controller.getLogger().warning("Invalid wearable slot: " + slotKey);
            }
        }
        return slots;
    }

    public boolean tryToWear(Mage mage) {
        Player player = mage.getPlayer();
        if (player == null) {
            return false;
        }
        Collection<Integer> slots = this.getWearableSlots();
        if (slots != null) {
            for (int slot : slots) {
                ItemStack existing = player.getInventory().getItem(slot);
                if (!CompatibilityLib.getItemUtils().isEmpty(existing)) continue;
                this.deactivate();
                player.getInventory().setItem(slot, this.getItem());
                this.controller.onArmorUpdated(mage);
                return true;
            }
        }
        return false;
    }

    public static void addParameterKeys(MageController controller, Collection<String> options) {
        for (String key : PROPERTY_KEYS) {
            options.add(key);
        }
        for (String damageType : controller.getDamageTypes()) {
            options.add("protection." + damageType);
            options.add("strength." + damageType);
            options.add("weakness." + damageType);
        }
    }

    public static void addParameterValues(MageController controller, String key, Collection<String> options) {
        if (key.equals("effect_sound")) {
            Sound[] sounds;
            for (Sound sound : sounds = Sound.values()) {
                options.add(sound.name().toLowerCase());
            }
        } else if (key.equals("effect_particle")) {
            for (Particle particleType : Particle.values()) {
                options.add(particleType.name().toLowerCase());
            }
        } else if (key.equals("mode")) {
            for (WandMode mode : WandMode.values()) {
                options.add(mode.name().toLowerCase());
            }
        } else if (key.equals("left_click") || key.equals("right_click") || key.equals("drop") || key.equals("swap") || key.equals("left_click_sneak") || key.equals("right_click_sneak") || key.equals("drop_sneak") || key.equals("swap_sneak")) {
            for (WandAction action : WandAction.values()) {
                options.add(action.name().toLowerCase());
            }
        } else if (key.equals("item_flags")) {
            for (ItemFlag flag : ItemFlag.values()) {
                options.add(flag.name().toLowerCase());
            }
        } else if (key.equals("boss_bar") || key.equals("xp_display") || key.equals("level_display")) {
            WandDisplayMode.addOptions(options);
        } else if (key.equals("action_bar")) {
            options.add("&cHP&7: &c@health&7/&c@health_max &f &f &f &f &f &f &bMP&7: &b@mana&7/&b@mana_max");
        }
    }

    public int getOrganizeBuffer() {
        return this.getInt("page_free_space", 4);
    }

    @Override
    public boolean isEnchantable() {
        return this.getBoolean("enchantable");
    }

    @Override
    public void setEnchantments(Map<Enchantment, Integer> enchants) {
        if (enchants == null) {
            ItemMeta meta;
            this.setProperty("enchantments", null);
            if (this.item != null && (meta = this.item.getItemMeta()) != null) {
                meta.getEnchants().clear();
                this.item.setItemMeta(meta);
            }
        } else {
            CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
            ConfigurationSection enchantments = ConfigurationUtils.newConfigurationSection();
            for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                enchantments.set(compatibilityUtils.getEnchantmentKey(entry.getKey()), (Object)entry.getValue());
            }
            this.setProperty("enchantments", enchantments);
            if (this.item != null) {
                CompatibilityLib.getInventoryUtils().applyEnchantments(this.item, enchantments);
            }
            this.saveState();
            this.updateLore();
        }
    }

    @Override
    public boolean addEnchantments(Map<Enchantment, Integer> enchants) {
        if (enchants == null || this.item == null) {
            return false;
        }
        CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
        ConfigurationSection enchantments = ConfigurationUtils.newConfigurationSection();
        for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
            enchantments.set(compatibilityUtils.getEnchantmentKey(entry.getKey()), (Object)entry.getValue());
        }
        if (CompatibilityLib.getInventoryUtils().addEnchantments(this.item, enchantments)) {
            enchantments = ConfigurationUtils.newConfigurationSection();
            Map newEnchants = this.item.getItemMeta().getEnchants();
            for (Map.Entry entry : newEnchants.entrySet()) {
                enchantments.set(compatibilityUtils.getEnchantmentKey((Enchantment)entry.getKey()), entry.getValue());
            }
            this.setProperty("enchantments", enchantments);
            this.saveState();
            this.updateLore();
        }
        return true;
    }

    @Override
    @Nonnull
    public Map<Enchantment, Integer> getEnchantments() {
        HashMap<Enchantment, Integer> enchantMap = new HashMap<Enchantment, Integer>();
        ConfigurationSection enchantConfig = this.getConfigurationSection("enchantments");
        if (enchantConfig != null) {
            CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
            Set enchantKeys = enchantConfig.getKeys(false);
            for (String enchantKey : enchantKeys) {
                try {
                    Enchantment enchantment = compatibilityUtils.getEnchantmentByKey(enchantKey);
                    if (enchantment == null) {
                        this.controller.getLogger().warning("Invalid enchantment in wand " + this.getTemplateKey() + ": " + enchantKey);
                        continue;
                    }
                    enchantMap.put(enchantment, enchantConfig.getInt(enchantKey));
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.SEVERE, "Could not add enchantment: " + enchantKey + " to wand " + this.getTemplateKey(), ex);
                }
            }
        }
        return enchantMap;
    }

    @Override
    public boolean hasProperty(String key) {
        if (this.slottedConfiguration != null && this.slottedConfiguration.contains(key)) {
            return true;
        }
        return this.hasOwnProperty(key);
    }

    @Override
    @Nullable
    public Object getProperty(String key) {
        Object slottedOverride;
        if (this.slottedConfiguration != null && (slottedOverride = this.slottedConfiguration.get(key)) != null) {
            return slottedOverride;
        }
        return this.getPropertyConfiguration(key).get(key);
    }

    public boolean isInteractible(Block block) {
        if (block == null) {
            return false;
        }
        if (this.interactibleMaterials != null) {
            return this.interactibleMaterials.testBlock(block);
        }
        return this.controller != null ? this.controller.isInteractible(block) : false;
    }

    public boolean isPlaceable() {
        return this.getBoolean("placeable");
    }
}

