/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_17_0.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.base.entity.EntityAnimalData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;

public class EntityAxolotlData
extends EntityAnimalData {
    public Axolotl.Variant variant;

    public EntityAxolotlData() {
    }

    public EntityAxolotlData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        Logger log = controller.getLogger();
        String typeString = parameters.getString("axolotl_type");
        if (typeString != null && !typeString.isEmpty()) {
            try {
                this.variant = Axolotl.Variant.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid axolotl_type: " + typeString, ex);
            }
        }
    }

    public EntityAxolotlData(Entity entity) {
        super(entity);
        if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            this.variant = axolotl.getVariant();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            if (this.variant != null) {
                axolotl.setVariant(this.variant);
            }
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Axolotl axolotl = (Axolotl)entity;
        Axolotl.Variant type = axolotl.getVariant();
        Axolotl.Variant[] typeValues = Axolotl.Variant.values();
        int typeOrdinal = (type.ordinal() + 1) % typeValues.length;
        type = typeValues[typeOrdinal];
        axolotl.setVariant(type);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Axolotl;
    }
}

