/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_17_0;

import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.SchematicUtilsBase;
import com.elmakers.mine.bukkit.utility.schematic.LoadableSchematic;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import org.bukkit.Bukkit;
import org.bukkit.util.Vector;

public class SchematicUtils
extends SchematicUtilsBase {
    public SchematicUtils(Platform platform) {
        super(platform);
    }

    @Override
    public boolean loadSchematic(InputStream input, LoadableSchematic schematic, Logger log) {
        if (input == null || schematic == null) {
            return false;
        }
        try {
            int i;
            int size;
            NBTTagCompound nbtData = NBTCompressedStreamTools.a((InputStream)input);
            if (nbtData == null) {
                return false;
            }
            short width = nbtData.getShort("Width");
            short height = nbtData.getShort("Height");
            short length = nbtData.getShort("Length");
            NBTTagCompound palette = nbtData.getCompound("Palette");
            byte[] blockData = nbtData.getByteArray("BlockData");
            int[] blockMap = null;
            HashMap<Integer, String> paletteMap = null;
            if (palette != null) {
                paletteMap = new HashMap<Integer, String>();
                Set keys = palette.getKeys();
                for (String key : keys) {
                    int index = palette.getInt(key);
                    paletteMap.put(index, key);
                }
            }
            if (blockData != null) {
                int varInt = 0;
                int varIntLength = 0;
                int index = 0;
                blockMap = new int[width * height * length];
                for (int i2 = 0; i2 < blockData.length; ++i2) {
                    varInt |= (blockData[i2] & 0x7F) << varIntLength++ * 7;
                    if ((blockData[i2] & 0x80) == 128) continue;
                    blockMap[index++] = varInt;
                    varIntLength = 0;
                    varInt = 0;
                }
                if (index != blockMap.length) {
                    log.warning("Block data array length does not match dimensions in schematic");
                }
            }
            ArrayList<Object> tileEntityData = new ArrayList<Object>();
            ArrayList<Object> entityData = new ArrayList<Object>();
            NBTTagList entityList = nbtData.getList("Entities", 10);
            NBTTagList tileEntityList = null;
            tileEntityList = nbtData.hasKey("BlockEntities") ? nbtData.getList("BlockEntities", 10) : nbtData.getList("TileEntities", 10);
            if (entityList != null) {
                size = entityList.size();
                for (i = 0; i < size; ++i) {
                    NBTBase entity = entityList.k(i);
                    entityData.add(entity);
                }
            }
            if (tileEntityList != null) {
                size = tileEntityList.size();
                for (i = 0; i < size; ++i) {
                    NBTBase tileEntity = tileEntityList.k(i);
                    tileEntityData.add(tileEntity);
                }
            }
            Vector origin = new Vector(0, 0, 0);
            int[] offset = nbtData.getIntArray("Offset");
            if (offset != null && offset.length == 3) {
                origin.setX(offset[0]);
                origin.setY(offset[1]);
                origin.setZ(offset[2]);
            }
            schematic.load(width, height, length, blockMap, null, paletteMap, tileEntityData, entityData, origin);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean saveSchematic(OutputStream output, String[][][] blockData) {
        if (output == null || blockData == null || blockData.length == 0 || blockData[0].length == 0 || blockData[0][0].length == 0) {
            return false;
        }
        NBTTagCompound nbtData = new NBTTagCompound();
        int width = blockData.length;
        int height = blockData[0].length;
        int length = blockData[0][0].length;
        nbtData.setShort("Width", (short)width);
        nbtData.setShort("Height", (short)height);
        nbtData.setShort("Length", (short)length);
        HashMap<String, Integer> paletteLookup = new HashMap<String, Integer>();
        ArrayList<Byte> blockList = new ArrayList<Byte>();
        int currentId = 0;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width; ++x) {
                    String block = blockData[x][y][z];
                    Integer paletteIndex = (Integer)paletteLookup.get(block);
                    if (paletteIndex == null) {
                        paletteIndex = currentId++;
                        paletteLookup.put(block, paletteIndex);
                    }
                    while (paletteIndex > 128) {
                        blockList.add((byte)(paletteIndex & 0x7F | 0x80));
                        paletteIndex = paletteIndex >> 7;
                    }
                    blockList.add((byte)paletteIndex.intValue());
                }
            }
        }
        NBTTagCompound palette = new NBTTagCompound();
        for (Map.Entry entry : paletteLookup.entrySet()) {
            palette.setInt((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        nbtData.set("Palette", (NBTBase)palette);
        byte[] blockArray = Bytes.toArray(blockList);
        nbtData.set("BlockData", (NBTBase)new NBTTagByteArray(blockArray));
        nbtData.set("Entities", (NBTBase)new NBTTagList());
        nbtData.set("BlockEntities", (NBTBase)new NBTTagList());
        int[] offset = new int[]{0, 0, 0};
        nbtData.set("Offset", (NBTBase)new NBTTagIntArray(offset));
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)nbtData, (OutputStream)output);
        }
        catch (IOException ex) {
            this.platform.getLogger().log(Level.WARNING, "Error writing schematic", ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean loadLegacySchematic(InputStream input, LoadableSchematic schematic) {
        if (input == null || schematic == null) {
            return false;
        }
        try {
            int i;
            int size;
            NBTTagCompound nbtData = NBTCompressedStreamTools.a((InputStream)input);
            if (nbtData == null) {
                return false;
            }
            String materials = nbtData.getString("Materials");
            if (!materials.equals("Alpha")) {
                Bukkit.getLogger().warning("Schematic is not in Alpha format");
                return false;
            }
            short width = nbtData.getShort("Width");
            short height = nbtData.getShort("Height");
            short length = nbtData.getShort("Length");
            byte[] blockIds = nbtData.getByteArray("Blocks");
            int[] blocks = new int[blockIds.length];
            byte[] addBlocks = new byte[]{};
            if (nbtData.hasKey("AddBlocks")) {
                addBlocks = nbtData.getByteArray("AddBlocks");
            }
            for (int index = 0; index < blocks.length; ++index) {
                blocks[index] = index >> 1 >= addBlocks.length ? (int)((short)(blockIds[index] & 0xFF)) : ((index & 1) == 0 ? (int)((short)(((addBlocks[index >> 1] & 0xF) << 8) + (blockIds[index] & 0xFF))) : (int)((short)(((addBlocks[index >> 1] & 0xF0) << 4) + (blockIds[index] & 0xFF))));
            }
            byte[] data = nbtData.getByteArray("Data");
            ArrayList<Object> tileEntityData = new ArrayList<Object>();
            ArrayList<Object> entityData = new ArrayList<Object>();
            NBTTagList entityList = nbtData.getList("Entities", 10);
            NBTTagList tileEntityList = nbtData.getList("TileEntities", 10);
            if (entityList != null) {
                size = entityList.size();
                for (i = 0; i < size; ++i) {
                    NBTBase entity = entityList.k(i);
                    entityData.add(entity);
                }
            }
            if (tileEntityList != null) {
                size = tileEntityList.size();
                for (i = 0; i < size; ++i) {
                    NBTBase tileEntity = tileEntityList.k(i);
                    tileEntityData.add(tileEntity);
                }
            }
            int originX = nbtData.getInt("WEOriginX");
            int originY = nbtData.getInt("WEOriginY");
            int originZ = nbtData.getInt("WEOriginZ");
            schematic.load(width, height, length, blocks, data, null, tileEntityData, entityData, new Vector(originX, originY, originZ));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

