/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.progression;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.item.Cost;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class ProgressionLevel
implements com.elmakers.mine.bukkit.api.magic.ProgressionLevel {
    private final int level;
    private final Map<String, Cost> costs = new HashMap<String, Cost>();

    public ProgressionLevel(MageController controller, int level, ConfigurationSection configuration) {
        String costKey;
        Cost cost2;
        this.level = level;
        List<Cost> costs = Cost.parseCosts(configuration.getConfigurationSection("costs"), controller);
        if (costs != null) {
            for (Cost cost2 : costs) {
                this.costs.put(cost2.getType(), cost2);
            }
        }
        if ((costKey = configuration.getString("cost")) != null && !costKey.isEmpty() && (cost2 = Cost.parseCost(controller, costKey, "xp")) != null) {
            Cost duplicate = this.costs.get(cost2.getType());
            if (duplicate != null) {
                duplicate.setAmount(duplicate.getAmount() + cost2.getAmount());
            } else {
                this.costs.put(cost2.getType(), cost2);
            }
        }
    }

    public ProgressionLevel(int level, ProgressionLevel first, ProgressionLevel last) {
        this.level = level;
        this.costs.putAll(first.costs);
        for (Map.Entry<String, Cost> entry : last.costs.entrySet()) {
            Cost cost = this.costs.get(entry.getKey());
            if (cost == null) {
                this.costs.put(entry.getKey(), entry.getValue());
                continue;
            }
            float distance = (float)(level - first.getLevel()) / (float)(last.getLevel() - first.getLevel());
            cost.setAmount(RandomUtils.lerp(cost.getAmount(), entry.getValue().getAmount(), distance));
        }
    }

    @Nullable
    public Collection<Cost> getCosts() {
        return this.costs.values();
    }

    @Override
    public int getLevel() {
        return this.level;
    }
}

