/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block.magic;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.magic.MagicBlockTemplate;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.SpellUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class InteractCaster {
    private final MagicBlockTemplate template;
    @Nonnull
    private final String spellKey;
    protected final ConfigurationSection spellParameters;
    protected EntityData.SourceType spellSource;
    protected EntityData.TargetType spellTarget;

    public InteractCaster(MagicBlockTemplate template, MageController controller, ConfigurationSection configuration) {
        this.template = template;
        String spellKeyAndParameters = configuration.getString("spell");
        ConfigurationSection parameters = configuration.getConfigurationSection("parameters");
        ConfigurationSection configurationSection = this.spellParameters = parameters == null ? configuration.createSection("parameters") : parameters;
        if (spellKeyAndParameters.contains(" ")) {
            String[] split = StringUtils.split((String)spellKeyAndParameters, (char)' ');
            this.spellKey = split[0];
            String[] parameterPieces = Arrays.copyOfRange(split, 1, split.length);
            ConfigurationUtils.addParameters(parameterPieces, this.spellParameters);
        } else {
            this.spellKey = spellKeyAndParameters;
        }
        String sourceType = configuration.getString("interact_spell_source", "PLAYER");
        if (sourceType.equalsIgnoreCase("OPPED_PLAYER")) {
            controller.getLogger().warning("Invalid spell source type: " + sourceType);
            sourceType = "PLAYER";
        }
        try {
            this.spellSource = EntityData.SourceType.valueOf(sourceType.toUpperCase());
        }
        catch (Exception ex) {
            controller.getLogger().warning("Invalid block interact source type: " + sourceType);
            this.spellSource = EntityData.SourceType.PLAYER;
        }
        String targetType = configuration.getString("interact_spell_target", "BLOCK");
        try {
            this.spellTarget = EntityData.TargetType.valueOf(targetType.toUpperCase());
        }
        catch (Exception ex) {
            controller.getLogger().warning("Invalid block interact target type: " + targetType);
            this.spellTarget = EntityData.TargetType.BLOCK;
        }
    }

    private String getName() {
        return this.template == null ? "anonymous" : this.template.getKey();
    }

    public boolean onInteract(Mage magicBlock, Location location, Player player) {
        int level;
        MageController controller = magicBlock.getController();
        magicBlock.setLocation(location);
        ConfigurationSection parameters = this.spellParameters;
        Mage mage = SpellUtils.getCastSource(this.spellSource, (Entity)player, null, magicBlock, controller, " magic block " + this.getName());
        SpellUtils.prepareParameters(this.spellTarget, parameters, (Entity)player, null, magicBlock, controller, " magic block " + this.getName());
        String interactSpell = this.spellKey;
        if (!interactSpell.contains("|") && (level = mage.getActiveProperties().getSpellLevel(interactSpell)) > 1) {
            interactSpell = interactSpell + "|" + level;
        }
        return controller.cast(mage, interactSpell, parameters, (CommandSender)player);
    }
}

