/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.arena.Arena;
import com.elmakers.mine.bukkit.arena.ArenaMobSpawner;
import com.elmakers.mine.bukkit.arena.ArenaPlayer;
import com.elmakers.mine.bukkit.arena.EditingStage;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ArenaStage
implements EditingStage {
    private static Random random = new Random();
    private final Arena arena;
    private int index;
    private List<ArenaMobSpawner> mobs = new ArrayList<ArenaMobSpawner>();
    private List<Location> mobSpawns = new ArrayList<Location>();
    private Set<Entity> spawned = new HashSet<Entity>();
    private String startSpell;
    private String endSpell;
    private String name;
    private Vector randomizeMobSpawn;
    private int winXP = 0;
    private int winSP = 0;
    private int winMoney = 0;
    private int duration = 0;
    private int respawnDuration = 0;
    private boolean defaultDrops = false;
    private boolean forceTarget = true;
    private long started;
    private long lastTick;

    public ArenaStage(Arena arena, int index) {
        this.arena = arena;
        this.index = index;
    }

    public ArenaStage(Arena arena, int index, MageController controller, ConfigurationSection configuration) {
        this.arena = arena;
        this.index = index;
        if (configuration.contains("mobs")) {
            Collection<ConfigurationSection> mobConfigurations = ConfigurationUtils.getNodeList(configuration, "mobs");
            for (ConfigurationSection mobConfiguration : mobConfigurations) {
                ArenaMobSpawner mob = new ArenaMobSpawner(controller, mobConfiguration);
                if (!mob.isValid()) continue;
                this.mobs.add(mob);
            }
        }
        this.startSpell = configuration.getString("spell_start");
        this.endSpell = configuration.getString("spell_end");
        for (String s : configuration.getStringList("mob_spawns")) {
            this.mobSpawns.add(ConfigurationUtils.toLocation(s, arena.getCenter()));
        }
        this.name = configuration.getString("name");
        this.winXP = configuration.getInt("win_xp");
        this.winSP = configuration.getInt("win_sp");
        this.winMoney = configuration.getInt("win_money");
        this.defaultDrops = configuration.getBoolean("drops");
        this.forceTarget = configuration.getBoolean("aggro", true);
        this.duration = configuration.getInt("duration", 0);
        this.respawnDuration = configuration.getInt("respawn_duration", 0);
        if (configuration.contains("randomize_mob_spawn")) {
            this.randomizeMobSpawn = ConfigurationUtils.toVector(configuration.getString("randomize_mob_spawn"));
        }
    }

    public void save(ConfigurationSection configuration) {
        ArrayList<MemoryConfiguration> mobsConfigurations = new ArrayList<MemoryConfiguration>();
        for (ArenaMobSpawner mob : this.mobs) {
            if (!mob.isValid()) continue;
            MemoryConfiguration section = new MemoryConfiguration();
            mob.save((ConfigurationSection)section);
            mobsConfigurations.add(section);
        }
        configuration.set("mobs", mobsConfigurations);
        configuration.set("spell_start", (Object)this.startSpell);
        configuration.set("spell_end", (Object)this.endSpell);
        ArrayList<String> mobSpawnList = new ArrayList<String>();
        for (Location spawn : this.mobSpawns) {
            mobSpawnList.add(ConfigurationUtils.fromLocation(spawn, this.arena.getCenter()));
        }
        configuration.set("mob_spawns", mobSpawnList);
        if (this.name != null && !this.name.isEmpty()) {
            configuration.set("name", (Object)this.name);
        }
        if (this.winXP != 0) {
            configuration.set("win_xp", (Object)this.winXP);
        }
        if (this.winSP != 0) {
            configuration.set("win_sp", (Object)this.winSP);
        }
        if (this.winMoney != 0) {
            configuration.set("win_money", (Object)this.winMoney);
        }
        configuration.set("drops", (Object)this.defaultDrops);
        configuration.set("aggro", (Object)this.forceTarget);
        if (this.duration != 0) {
            configuration.set("duration", (Object)this.duration);
        }
        if (this.respawnDuration != 0) {
            configuration.set("respawn_duration", (Object)this.respawnDuration);
        }
        if (this.randomizeMobSpawn != null) {
            configuration.set("randomize_mob_spawn", (Object)ConfigurationUtils.fromVector(this.randomizeMobSpawn));
        }
    }

    @Override
    public void addMob(EntityData entityType, int count) {
        this.mobs.add(new ArenaMobSpawner(entityType, count));
    }

    @Override
    public void removeMob(EntityData entityType) {
        Iterator<ArenaMobSpawner> it = this.mobs.iterator();
        while (it.hasNext()) {
            ArenaMobSpawner spawner = it.next();
            if (!spawner.getEntity().getKey().equalsIgnoreCase(entityType.getKey())) continue;
            it.remove();
        }
    }

    @Override
    public void describe(CommandSender sender) {
        sender.sendMessage(ChatColor.AQUA + this.getName() + ChatColor.GRAY + " (" + ChatColor.DARK_AQUA + this.getNumber() + ChatColor.GRAY + ")");
        int mobSpawnSize = this.mobSpawns.size();
        if (mobSpawnSize == 1) {
            sender.sendMessage(ChatColor.BLUE + "Spawn Mobs: " + this.arena.printLocation(this.mobSpawns.get(0)));
        } else if (mobSpawnSize > 1) {
            sender.sendMessage(ChatColor.BLUE + "Spawns Mobs: " + ChatColor.GRAY + mobSpawnSize);
            for (Location spawn : this.mobSpawns) {
                sender.sendMessage(this.arena.printLocation(spawn));
            }
        }
        int numMobs = this.mobs.size();
        if (numMobs == 0) {
            sender.sendMessage(ChatColor.GRAY + "(No Mobs)");
        } else {
            sender.sendMessage(ChatColor.DARK_GREEN + "Mobs: " + ChatColor.BLUE + numMobs);
            for (ArenaMobSpawner mob : this.mobs) {
                sender.sendMessage(" " + this.describeMob(mob));
            }
        }
        if (this.randomizeMobSpawn != null) {
            sender.sendMessage(ChatColor.DARK_GREEN + " Randomize Spawning: " + ChatColor.BLUE + this.randomizeMobSpawn);
        }
        if (this.duration > 0) {
            int minutes = (int)Math.ceil((double)this.duration / 60.0 / 1000.0);
            sender.sendMessage(ChatColor.AQUA + "Duration: " + ChatColor.DARK_AQUA + minutes + ChatColor.WHITE + " minutes");
        }
        if (this.respawnDuration > 0) {
            int seconds = (int)Math.ceil((double)this.respawnDuration / 1000.0);
            sender.sendMessage(ChatColor.AQUA + "Respawn: " + ChatColor.DARK_AQUA + seconds + ChatColor.WHITE + " seconds");
        }
        if (this.startSpell != null) {
            sender.sendMessage(ChatColor.DARK_AQUA + "Cast at Start: " + ChatColor.AQUA + this.startSpell);
        }
        if (this.endSpell != null) {
            sender.sendMessage(ChatColor.DARK_AQUA + "Cast at End: " + ChatColor.AQUA + this.endSpell);
        }
        if (this.winXP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: " + ChatColor.LIGHT_PURPLE + this.winXP + ChatColor.AQUA + " xp");
        }
        if (this.winSP > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: " + ChatColor.LIGHT_PURPLE + this.winSP + ChatColor.AQUA + " sp");
        }
        if (this.winMoney > 0) {
            sender.sendMessage(ChatColor.AQUA + "Winning Reward: $" + ChatColor.LIGHT_PURPLE + this.winMoney);
        }
    }

    protected String describeMob(ArenaMobSpawner mob) {
        if (mob == null) {
            return ChatColor.RED + "(Invalid Mob)";
        }
        if (mob.getEntity() == null) {
            return ChatColor.RED + "(Invalid Mob)" + ChatColor.YELLOW + " x" + mob.getCount();
        }
        return ChatColor.DARK_GREEN + " " + mob.getEntity().describe() + ChatColor.YELLOW + " x" + mob.getCount();
    }

    public String getStartSpell() {
        return this.startSpell;
    }

    @Override
    public void setStartSpell(String startSpell) {
        this.startSpell = startSpell;
    }

    public String getEndSpell() {
        return this.endSpell;
    }

    @Override
    public void setEndSpell(String endSpell) {
        this.endSpell = endSpell;
    }

    @Override
    public void addMobSpawn(Location location) {
        this.mobSpawns.add(location.clone());
    }

    @Override
    public Location removeMobSpawn(Location location) {
        int rangeSquared = 9;
        for (Location spawn : this.mobSpawns) {
            if (!(spawn.distanceSquared(location) < (double)rangeSquared)) continue;
            this.mobSpawns.remove(spawn);
            return spawn;
        }
        return null;
    }

    public List<Location> getMobSpawns() {
        if (this.mobSpawns.size() == 0) {
            ArrayList<Location> centerList = new ArrayList<Location>();
            centerList.add(this.arena.getCenter());
            return centerList;
        }
        return this.mobSpawns;
    }

    public void start() {
        this.lastTick = this.started = System.currentTimeMillis();
        if (!this.mobs.isEmpty()) {
            this.arena.messageInGamePlayers("t:" + this.getName());
            MageController magic = this.arena.getController().getMagic();
            magic.setForceSpawn(true);
            ArrayList<ArenaPlayer> players = new ArrayList<ArenaPlayer>(this.arena.getLivingParticipants());
            if (players.isEmpty()) {
                this.arena.getController().getMagic().getLogger().warning("Arena stage " + this.getNumber() + " of " + this.arena.getKey() + " starting without any living players");
                return;
            }
            try {
                List<Location> spawns = this.getMobSpawns();
                int num = 0;
                for (ArenaMobSpawner mobSpawner : this.mobs) {
                    EntityData mobType = mobSpawner.getEntity();
                    if (mobType == null) continue;
                    for (int i = 0; i < mobSpawner.getCount(); ++i) {
                        Location spawn = spawns.get(num);
                        if (this.randomizeMobSpawn != null) {
                            spawn = spawn.clone();
                            spawn.add((2.0 * random.nextDouble() - 1.0) * this.randomizeMobSpawn.getX(), (2.0 * random.nextDouble() - 1.0) * this.randomizeMobSpawn.getY(), (2.0 * random.nextDouble() - 1.0) * this.randomizeMobSpawn.getZ());
                        }
                        num = (num + 1) % spawns.size();
                        Entity spawnedEntity = mobType.spawn(spawn);
                        if (spawnedEntity == null) continue;
                        this.arena.getController().register(spawnedEntity, this.arena);
                        this.spawned.add(spawnedEntity);
                        if (!this.defaultDrops) {
                            magic.disableDrops(spawnedEntity);
                        }
                        if (!this.forceTarget || !(spawnedEntity instanceof Creature)) continue;
                        ArenaPlayer player = RandomUtils.getRandom(players);
                        ((Creature)spawnedEntity).setTarget((LivingEntity)player.getPlayer());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            magic.setForceSpawn(false);
        }
        if (this.startSpell != null && !this.startSpell.isEmpty()) {
            Mage arenaMage = this.arena.getMage();
            arenaMage.setLocation(this.arena.getCenter());
            MageSpell spell = arenaMage.getSpell(this.startSpell);
            if (spell != null) {
                spell.cast();
            }
        }
    }

    public void checkAggro(Entity mob) {
        if (mob instanceof Creature) {
            Creature creature = (Creature)mob;
            LivingEntity target = creature.getTarget();
            Set<ArenaPlayer> currentPlayers = this.arena.getLivingParticipants();
            if (target != null) {
                if (target instanceof Player) {
                    ArenaPlayer targetPlayer = new ArenaPlayer(this.arena, target.getUniqueId());
                    if (!currentPlayers.contains(targetPlayer)) {
                        target = null;
                    }
                } else {
                    target = null;
                }
            }
            if (target == null) {
                ArenaPlayer player = RandomUtils.getRandom(new ArrayList<ArenaPlayer>(currentPlayers));
                creature.setTarget((LivingEntity)player.getPlayer());
            }
        }
    }

    public void mobDied(Entity entity) {
        this.arena.getController().unregister(entity);
        this.spawned.remove(entity);
    }

    public void completed() {
        this.arena.messageInGamePlayers(ChatColor.GREEN + "Congratulations!" + ChatColor.AQUA + "  You have passed " + ChatColor.DARK_AQUA + this.getName());
        Collection<ArenaPlayer> players = this.arena.getParticipants();
        for (ArenaPlayer player : players) {
            Mage mage = player.getMage();
            if (this.winXP > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(this.winXP) + ChatColor.AQUA + " experience!");
                mage.giveExperience(this.winXP);
            }
            if (this.winSP > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(this.winSP) + ChatColor.AQUA + " spell points!");
                mage.addSkillPoints(this.winSP);
            }
            if (this.winMoney <= 0) continue;
            mage.sendMessage(ChatColor.AQUA + "You have been awarded $" + ChatColor.DARK_AQUA + Integer.toString(this.winMoney) + ChatColor.AQUA + "!");
            mage.addVaultCurrency(this.winMoney);
        }
        this.finish();
    }

    public void finish() {
        if (this.endSpell != null && !this.endSpell.isEmpty()) {
            Mage arenaMage = this.arena.getMage();
            arenaMage.setLocation(this.arena.getCenter());
            MageSpell spell = arenaMage.getSpell(this.endSpell);
            if (spell != null) {
                spell.cast();
            }
        }
        this.reset();
    }

    public boolean hasMobs() {
        return !this.mobs.isEmpty();
    }

    public boolean isFinished() {
        this.checkSpawns();
        return this.spawned.isEmpty();
    }

    public void checkSpawnsAndArena() {
        this.checkSpawns(true, true);
    }

    public void checkSpawns() {
        this.checkSpawns(false, false);
    }

    public void checkSpawns(boolean checkAggro, boolean checkArena) {
        Iterator<Entity> it = this.spawned.iterator();
        boolean mobsDied = false;
        while (it.hasNext()) {
            Entity entity = it.next();
            if (entity.isDead() || !entity.isValid()) {
                mobsDied = true;
                this.arena.getController().unregister(entity);
                it.remove();
                continue;
            }
            if (!checkAggro || !this.forceTarget) continue;
            this.checkAggro(entity);
        }
        if (checkArena && (mobsDied || this.spawned.isEmpty()) && this.arena.isStarted()) {
            this.arena.check();
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)this.name);
        }
        return "Stage " + this.getNumber();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Arena getArena() {
        return this.arena;
    }

    public int getNumber() {
        return this.index + 1;
    }

    public void reset() {
        for (Entity entity : this.spawned) {
            if (!entity.isValid()) continue;
            this.arena.getController().unregister(entity);
            entity.remove();
        }
        this.spawned.clear();
    }

    @Override
    public void setRandomizeMobSpawn(Vector vector) {
        this.randomizeMobSpawn = vector;
    }

    @Override
    public void setWinXP(int xp) {
        this.winXP = Math.max(xp, 0);
    }

    @Override
    public void setWinSP(int sp) {
        this.winSP = Math.max(sp, 0);
    }

    @Override
    public void setWinMoney(int money) {
        this.winMoney = Math.max(money, 0);
    }

    public List<ArenaMobSpawner> getMobSpawners() {
        return this.mobs;
    }

    public int getActiveMobs() {
        this.checkSpawns();
        return this.spawned.size();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Collection<EntityData> getSpawns() {
        ArrayList<EntityData> spawns = new ArrayList<EntityData>();
        List<ArenaMobSpawner> spawners = this.getMobSpawners();
        for (ArenaMobSpawner spawner : spawners) {
            if (!spawner.isValid()) continue;
            spawns.add(spawner.getEntity());
        }
        return spawns;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void setRespawnDuration(int duration) {
        this.respawnDuration = duration;
    }

    public long getRespawnDuration() {
        return this.respawnDuration;
    }

    public boolean isRespawning() {
        return this.arena.hasDeadPlayers() && this.respawnDuration > 0;
    }

    public boolean isRespawnEnabled() {
        return this.respawnDuration > 0;
    }

    public void tick() {
        this.checkSpawnsAndArena();
        if (this.duration <= 0 && this.respawnDuration <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        long previousTick = this.lastTick;
        this.lastTick = now;
        long previousTime = previousTick - this.started;
        long currentTime = now - this.started;
        if (this.duration > 0) {
            long previousSecondsRemaining = ((long)this.duration - previousTime) / 1000L;
            long secondsRemaining = ((long)this.duration - currentTime) / 1000L;
            if (secondsRemaining > 0L && secondsRemaining < previousSecondsRemaining) {
                if (secondsRemaining == 10L || secondsRemaining == 30L) {
                    this.arena.messageInGamePlayers("t:" + ChatColor.RED + secondsRemaining + " Seconds!");
                } else if (secondsRemaining <= 5L) {
                    this.arena.messageInGamePlayers("t:" + ChatColor.RED + secondsRemaining);
                }
            }
            if (currentTime > (long)this.duration) {
                this.arena.draw();
                return;
            }
        }
        if (this.respawnDuration > 0 && this.arena.hasDeadPlayers()) {
            long secondsRemaining;
            long lastDeathTime = this.arena.getLastDeathTime();
            long deathTime = now - lastDeathTime;
            long respawnSecondsRemaining = ((long)this.respawnDuration - deathTime) / 1000L;
            if (this.duration > 0 && (secondsRemaining = ((long)this.duration - currentTime) / 1000L) <= respawnSecondsRemaining) {
                return;
            }
            long previousDeathTime = previousTick - lastDeathTime;
            long previousRespawnSecondsRemaining = ((long)this.respawnDuration - previousDeathTime) / 1000L;
            if (respawnSecondsRemaining > 0L && respawnSecondsRemaining < previousRespawnSecondsRemaining) {
                if (respawnSecondsRemaining == 10L) {
                    this.arena.messageDeadPlayers("t:" + ChatColor.GREEN + "Respawning\n" + ChatColor.GRAY + "in 10 Seconds!");
                } else if (respawnSecondsRemaining <= 5L) {
                    this.arena.messageDeadPlayers("t:" + ChatColor.GREEN + respawnSecondsRemaining);
                }
            }
            if (deathTime > (long)this.respawnDuration) {
                this.arena.respawn();
                return;
            }
            this.arena.showRespawnBossBar((double)deathTime / (double)this.respawnDuration);
        }
    }
}

