/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.arena.Arena;
import com.elmakers.mine.bukkit.arena.ArenaController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;

public class ArenaPlayer
implements Comparable<ArenaPlayer> {
    private Mage mage;
    private ProgressionPath path;
    private final Arena arena;
    private final UUID uuid;
    private String name;
    private String displayName;
    private int wins;
    private int losses;
    private int quits;
    private int joins;
    private int draws;

    public ArenaPlayer(Arena arena, ConfigurationSection config) {
        this.mage = null;
        this.arena = arena;
        this.uuid = UUID.fromString(config.getString("uuid"));
        this.name = config.getString("name");
        this.displayName = config.getString("display_name");
        this.wins = config.getInt("wins");
        this.losses = config.getInt("losses");
        this.quits = config.getInt("quits");
        this.joins = config.getInt("joins");
        this.draws = config.getInt("draws");
    }

    public ArenaPlayer(Arena arena, Player player) {
        this.uuid = player.getUniqueId();
        this.arena = arena;
        this.update(player);
    }

    public ArenaPlayer(Arena arena, UUID uuid) {
        this.uuid = uuid;
        this.arena = arena;
    }

    public void update(Player player) {
        if (player == null) {
            return;
        }
        ArenaController controller = this.arena.getController();
        this.name = player.getName();
        this.mage = controller.getMagic().getMage(player);
        this.displayName = player.getDisplayName();
        this.path = null;
        CasterProperties mageClass = this.mage.getActiveProperties();
        if (mageClass != null) {
            this.path = mageClass.getPath();
        }
        this.wins = this.get("won");
        this.losses = this.get("lost");
        this.quits = this.get("quit");
        this.joins = this.get("joined");
        this.draws = this.get("draw");
    }

    public void save(ConfigurationSection config) {
        config.set("uuid", (Object)this.uuid.toString());
        config.set("name", (Object)this.name);
        config.set("display_name", (Object)this.displayName);
        config.set("wins", (Object)this.wins);
        config.set("losses", (Object)this.losses);
        config.set("quits", (Object)this.quits);
        config.set("joins", (Object)this.joins);
        config.set("draws", (Object)this.draws);
    }

    public boolean isValid() {
        return this.mage == null ? false : this.mage.isValid();
    }

    public boolean isDead() {
        return this.mage == null ? false : this.mage.isDead();
    }

    public Player getPlayer() {
        return this.mage == null ? null : this.mage.getPlayer();
    }

    public String getDisplayName() {
        String display = this.displayName;
        if (this.displayName == null) {
            display = this.displayName = this.mage.getDisplayName();
        }
        if (this.path != null) {
            display = display + " " + ChatColor.GRAY + "(" + ChatColor.GOLD + this.path.getName() + ChatColor.GRAY + ")";
        }
        return display;
    }

    public void won() {
        Player player = this.getPlayer();
        if (player != null) {
            int money;
            int sp;
            int xp = this.arena.getWinXP();
            if (xp > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(xp) + ChatColor.AQUA + " experience!");
                this.mage.giveExperience(xp);
            }
            if ((sp = this.arena.getWinSP()) > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(sp) + ChatColor.AQUA + " spell points!");
                this.mage.addSkillPoints(sp);
            }
            if ((money = this.arena.getWinMoney()) > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded $" + ChatColor.DARK_AQUA + Integer.toString(money) + ChatColor.AQUA + "!");
                this.mage.addVaultCurrency(money);
            }
            this.wins = this.increment("won");
        }
    }

    public void lost() {
        Player player = this.getPlayer();
        if (player != null) {
            int money;
            int sp;
            int xp = this.arena.getLoseXP();
            if (xp > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(xp) + ChatColor.AQUA + " experience!");
                this.mage.giveExperience(xp);
            }
            if ((sp = this.arena.getLoseSP()) > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(sp) + ChatColor.AQUA + " spell points!");
                this.mage.addSkillPoints(sp);
            }
            if ((money = this.arena.getLoseMoney()) > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded $" + ChatColor.DARK_AQUA + Integer.toString(money) + ChatColor.AQUA + "!");
                this.mage.addVaultCurrency(money);
            }
            this.losses = this.increment("lost");
        }
    }

    public void quit() {
        Player player = this.getPlayer();
        if (player != null) {
            this.quits = this.increment("quit");
        }
    }

    public void joined() {
        Player player = this.getPlayer();
        if (player != null) {
            this.joins = this.increment("joined");
        }
    }

    public void draw() {
        this.heal();
        this.teleport(this.arena.getLoseLocation());
        Player player = this.getPlayer();
        if (player != null) {
            int money;
            int sp;
            int xp = this.arena.getDrawXP();
            if (xp > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(xp) + ChatColor.AQUA + " experience!");
                this.mage.giveExperience(xp);
            }
            if ((sp = this.arena.getDrawSP()) > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(sp) + ChatColor.AQUA + " spell points!");
                this.mage.addSkillPoints(sp);
            }
            if ((money = this.arena.getDrawMoney()) > 0) {
                this.mage.sendMessage(ChatColor.AQUA + "You have been awarded $" + ChatColor.DARK_AQUA + Integer.toString(money) + ChatColor.AQUA + "!");
                this.mage.addVaultCurrency(money);
            }
            this.draws = this.increment("draw");
        }
    }

    public int getWins() {
        return this.wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getQuits() {
        return this.quits;
    }

    public int getJoins() {
        return this.joins;
    }

    public int getDraws() {
        return this.draws;
    }

    public int getValidMatches() {
        return this.wins + this.losses;
    }

    public Arena getArena() {
        return this.arena;
    }

    protected int increment(String statName) {
        if (this.mage == null) {
            this.arena.getController().getPlugin().getLogger().warning("Cannot increment statistic " + statName + ", no mage present.");
            return 0;
        }
        String arenaKey = "arena." + this.arena.getKey() + "." + statName;
        ConfigurationSection data = this.mage.getData();
        int currentValue = data.getInt(arenaKey, 0);
        int newValue = currentValue + 1;
        data.set(arenaKey, (Object)newValue);
        return newValue;
    }

    protected int get(String statName) {
        if (this.mage == null) {
            this.arena.getController().getPlugin().getLogger().warning("Cannot get statistic " + statName + ", no mage present.");
            return 0;
        }
        String arenaKey = "arena." + this.arena.getKey() + "." + statName;
        ConfigurationSection data = this.mage.getData();
        return data.getInt(arenaKey, 0);
    }

    public float getWinRatio() {
        if (this.losses == 0 && this.wins == 0) {
            return 0.0f;
        }
        return (float)this.wins / (float)(this.losses + this.wins);
    }

    public double getWinConfidence() {
        int nGames = this.wins + this.losses;
        if (nGames <= 0) {
            return 0.0;
        }
        double z = 1.96;
        double winRate = (double)this.wins / (double)nGames;
        double b = (winRate * (1.0 - winRate) + z * z / (double)(4 * nGames)) / (double)nGames;
        double a = winRate + z * z / (double)(2 * nGames) - z * Math.sqrt(b);
        return a / (1.0 + z * z / (double)nGames);
    }

    @Override
    public int compareTo(ArenaPlayer other) {
        return this.uuid.compareTo(other.getUUID());
    }

    public boolean equals(Object other) {
        if (other instanceof Player) {
            return this.equals((Player)other);
        }
        if (other instanceof UUID) {
            return this.equals((UUID)other);
        }
        if (!(other instanceof ArenaPlayer)) {
            return false;
        }
        return this.uuid.equals(((ArenaPlayer)other).uuid);
    }

    public boolean equals(Player player) {
        return player != null && player.getUniqueId().equals(this.uuid);
    }

    public boolean equals(UUID id) {
        return id != null && id.equals(this.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void teleport(Location location) {
        Player player = this.getPlayer();
        if (player != null && location != null) {
            if (player.isDead()) {
                player.setMetadata("respawnLocation", (MetadataValue)new FixedMetadataValue(this.arena.getController().getPlugin(), (Object)location));
            } else {
                player.setMetadata("allow_teleport", (MetadataValue)new FixedMetadataValue(this.arena.getController().getPlugin(), (Object)true));
                player.teleport(location);
            }
        }
    }

    public void sendMessage(String message) {
        Mage mage = this.getMage();
        if (mage != null) {
            mage.sendMessage(message);
        }
    }

    public double getHealth() {
        Player player = this.getPlayer();
        return player == null ? 0.0 : player.getHealth();
    }

    public void heal() {
        Player player = this.getPlayer();
        if (player != null) {
            double maxHealth = CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)player);
            player.setHealth(maxHealth);
            player.setFoodLevel(20);
            player.setSaturation(20.0f);
            player.setExhaustion(0.0f);
            player.setFireTicks(0);
            for (PotionEffect pt : player.getActivePotionEffects()) {
                if (pt.getDuration() >= 0x1FFFFFFF) continue;
                player.removePotionEffect(pt.getType());
            }
            this.mage.deactivateAllSpells(true, true);
        }
    }

    public void reset() {
        this.wins = 0;
        this.losses = 0;
        this.quits = 0;
        this.joins = 0;
        this.draws = 0;
        if (this.mage != null) {
            String arenaKey = "arena." + this.arena.getKey();
            ConfigurationSection data = this.mage.getData();
            data.set(arenaKey, null);
        }
    }

    public Mage getMage() {
        return this.mage;
    }

    public boolean isBattling() {
        return this.arena != null && this.arena.isBattling(this);
    }
}

