/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.arena.Arena;
import com.elmakers.mine.bukkit.arena.ArenaStage;
import com.elmakers.mine.bukkit.arena.EditingStage;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.util.Vector;

public class AllStages
implements EditingStage {
    private final Arena arena;

    public AllStages(Arena arena) {
        this.arena = arena;
    }

    @Override
    public Arena getArena() {
        return this.arena;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return "(All Stages)";
    }

    @Override
    public void setRandomizeMobSpawn(Vector vector) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.setRandomizeMobSpawn(vector);
        }
    }

    @Override
    public void setWinXP(int xp) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.setWinXP(xp);
        }
    }

    @Override
    public void setWinSP(int sp) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.setWinSP(sp);
        }
    }

    @Override
    public void setWinMoney(int money) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.setWinMoney(money);
        }
    }

    @Override
    public void setStartSpell(String startSpell) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.setStartSpell(startSpell);
        }
    }

    @Override
    public void setEndSpell(String endSpell) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.setEndSpell(endSpell);
        }
    }

    @Override
    public void addMobSpawn(Location location) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.addMobSpawn(location);
        }
    }

    @Override
    public Location removeMobSpawn(Location location) {
        Location removed = null;
        for (ArenaStage stage : this.arena.getStages()) {
            Location stageRemoved = stage.removeMobSpawn(location);
            if (stageRemoved == null) continue;
            removed = stageRemoved;
        }
        return removed;
    }

    @Override
    public void addMob(EntityData entityType, int count) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.addMob(entityType, count);
        }
    }

    @Override
    public void removeMob(EntityData entityType) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.removeMob(entityType);
        }
    }

    @Override
    public void describe(CommandSender sender) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.describe(sender);
        }
    }

    @Override
    public Collection<EntityData> getSpawns() {
        ArrayList<EntityData> spawns = new ArrayList<EntityData>();
        for (ArenaStage stage : this.arena.getStages()) {
            spawns.addAll(stage.getSpawns());
        }
        return spawns;
    }

    @Override
    public void setDuration(int duration) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.setDuration(duration);
        }
    }

    @Override
    public void setRespawnDuration(int duration) {
        for (ArenaStage stage : this.arena.getStages()) {
            stage.setRespawnDuration(duration);
        }
    }
}

