/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.item.InventorySlot;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EquipAction
extends BaseSpellAction {
    private MaterialAndData material;
    private ItemStack item;
    private boolean useItem;
    private Map<Enchantment, Integer> enchantments;
    private InventorySlot slot;
    private boolean unbreakable = true;
    private boolean returnOnFinish = false;
    private boolean makeTemporary = true;
    private boolean replaceItem = false;
    private WearUndoAction undoAction;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.contains("enchantments")) {
            this.enchantments = new HashMap<Enchantment, Integer>();
            ConfigurationSection enchantConfig = ConfigurationUtils.getConfigurationSection(parameters, "enchantments");
            CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
            Set enchantKeys = enchantConfig.getKeys(false);
            for (String enchantKey : enchantKeys) {
                Enchantment enchantment = compatibilityUtils.getEnchantmentByKey(enchantKey);
                if (enchantment == null) {
                    spell.getController().getLogger().warning("Invalid enchantment in equip action: " + enchantKey);
                    continue;
                }
                this.enchantments.put(enchantment, enchantConfig.getInt(enchantKey));
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Wand activeWand;
        if (this.slot == null) {
            return SpellResult.FAIL;
        }
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            if (!context.getTargetsCaster()) {
                return SpellResult.NO_TARGET;
            }
            entity = context.getEntity();
        }
        if (entity == null) {
            return SpellResult.NO_TARGET;
        }
        if (!(entity instanceof LivingEntity)) {
            return SpellResult.LIVING_ENTITY_REQUIRED;
        }
        EntityEquipment equipment = ((LivingEntity)entity).getEquipment();
        MaterialAndData material = this.material;
        MageController controller = context.getController();
        com.elmakers.mine.bukkit.api.magic.Mage mage = controller.getMage(entity);
        ItemStack equipItem = null;
        if (this.useItem) {
            ItemStack itemInHand;
            Wand activeWand2 = mage.getActiveWand();
            if (activeWand2 != context.getWand()) {
                return SpellResult.NO_TARGET;
            }
            if (activeWand2 != null) {
                activeWand2.deactivate();
            }
            if ((itemInHand = equipment.getItemInMainHand()) == null || itemInHand.getType() == Material.AIR) {
                return SpellResult.FAIL;
            }
            equipItem = itemInHand;
        } else {
            String materialName = null;
            if (this.item != null) {
                equipItem = CompatibilityLib.getItemUtils().getCopy(this.item);
                materialName = context.getController().describeItem(equipItem);
            } else {
                Block targetBlock;
                if (material == null && (context.getSpell().usesBrush() || context.getSpell().hasBrushOverride())) {
                    material = context.getBrush();
                }
                if (material == null && (targetBlock = context.getTargetBlock()) != null) {
                    material = new com.elmakers.mine.bukkit.block.MaterialAndData(targetBlock);
                    material.setMaterial(DefaultMaterials.blockToItem(material.getMaterial()));
                }
                if (material == null || DefaultMaterials.isAir(material.getMaterial()) || !material.isValid()) {
                    return SpellResult.NO_TARGET;
                }
                ItemStack itemStack = material.getItemStack(1);
                itemStack = CompatibilityLib.getItemUtils().makeReal(itemStack);
                if (CompatibilityLib.getItemUtils().isEmpty(itemStack)) {
                    return SpellResult.NO_TARGET;
                }
                equipItem = itemStack;
                materialName = material.getName(context.getController().getMessages());
            }
            if (DefaultMaterials.isAir(equipItem.getType())) {
                return SpellResult.NO_TARGET;
            }
            ItemMeta meta = equipItem.getItemMeta();
            String displayName = context.getMessage("hat_name", "");
            displayName = context.getMessage("wear_name", displayName);
            if (materialName == null || materialName.isEmpty()) {
                materialName = "?";
            }
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(displayName.replace("$hat", materialName).replace("$item", materialName));
            }
            ArrayList<String> lore = new ArrayList<String>();
            String loreLine = context.getMessage("hat_lore");
            loreLine = context.getMessage("wear_lore", loreLine);
            lore.add(loreLine);
            meta.setLore(lore);
            equipItem.setItemMeta(meta);
            equipItem = CompatibilityLib.getItemUtils().makeReal(equipItem);
            if (this.makeTemporary) {
                CompatibilityLib.getItemUtils().makeTemporary(equipItem, context.getMessage("removed").replace("$hat", materialName).replace("$item", materialName));
            }
            if (this.enchantments != null) {
                equipItem.addUnsafeEnchantments(this.enchantments);
            }
            if (this.unbreakable) {
                CompatibilityLib.getItemUtils().makeUnbreakable(equipItem);
            }
        }
        ItemStack existingItem = null;
        int slotNumber = -1;
        if (this.slot == InventorySlot.MAIN_HAND && (activeWand = mage.getActiveWand()) != null) {
            activeWand.deactivate();
        }
        if ((slotNumber = this.slot.getSlot(mage)) == -1) {
            context.getLogger().warning("Invalid slot for Wear action: " + (Object)((Object)this.slot));
            return SpellResult.FAIL;
        }
        existingItem = mage.getItem(slotNumber);
        if (!CompatibilityLib.getItemUtils().isEmpty(existingItem) && !this.replaceItem) {
            if (CompatibilityLib.getItemUtils().isTemporary(existingItem)) {
                ItemStack replacement;
                existingItem = replacement = CompatibilityLib.getItemUtils().getReplacement(existingItem);
            }
            if (this.useItem) {
                equipment.setItemInMainHand(existingItem);
            } else if (existingItem != null) {
                CompatibilityLib.getItemUtils().setReplacement(equipItem, existingItem);
                if (this.returnOnFinish) {
                    CompatibilityLib.getNBTUtils().setMetaBoolean(equipItem, "return_on_death", true);
                }
            }
        } else if (this.useItem) {
            equipment.setItemInMainHand(new ItemStack(Material.AIR));
        }
        mage.setItem(slotNumber, equipItem);
        this.undoAction = new WearUndoAction(mage, slotNumber);
        context.registerForUndo(this.undoAction);
        if (mage instanceof Mage) {
            Mage implMage = (Mage)mage;
            implMage.armorUpdated();
            implMage.checkWandNextTick();
        }
        return SpellResult.CAST;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.material = ConfigurationUtils.getMaterialAndData(parameters, "material");
        this.item = context.getController().createItem(parameters.getString("item"));
        String slotName = parameters.getString("slot");
        if (slotName != null && !slotName.isEmpty()) {
            this.slot = InventorySlot.parse(slotName);
            if (this.slot == null) {
                context.getLogger().warning("Invalid slot in Wear action: " + slotName);
            }
        } else {
            this.slot = InventorySlot.getArmorSlot(parameters.getInt("armor_slot", 3));
        }
        this.useItem = parameters.getBoolean("use_item", false);
        this.unbreakable = parameters.getBoolean("unbreakable", true);
        this.returnOnFinish = parameters.getBoolean("return_on_finish", false);
        this.makeTemporary = parameters.getBoolean("temporary", true);
        this.replaceItem = parameters.getBoolean("replace_item", false);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        if (this.returnOnFinish && this.undoAction != null) {
            this.undoAction.returnItem();
        }
        this.undoAction = null;
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        if (this.returnOnFinish && this.undoAction != null) {
            this.undoAction.returnItem();
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("material");
        parameters.add("item");
        parameters.add("use_item");
        parameters.add("armor_slot");
        parameters.add("slot");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("material")) {
            examples.addAll(MagicPlugin.getAPI().getBrushes());
        } else if (parameterKey.equals("item")) {
            for (Material material : Material.values()) {
                examples.add(material.name().toLowerCase());
            }
            Set<String> allItems = spell.getController().getItemKeys();
            for (String itemKey : allItems) {
                examples.add(itemKey);
            }
        } else if (parameterKey.equals("armor_slot")) {
            examples.add("0");
            examples.add("1");
            examples.add("2");
            examples.add("3");
        } else if (parameterKey.equals("slot")) {
            for (InventorySlot slot : InventorySlot.values()) {
                examples.add(slot.name().toLowerCase());
            }
        } else if (parameterKey.equals("use_item")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private static class WearUndoAction
    implements Runnable {
        private final WeakReference<com.elmakers.mine.bukkit.api.magic.Mage> mage;
        private final int slotNumber;
        private boolean returned = false;

        public WearUndoAction(com.elmakers.mine.bukkit.api.magic.Mage mage, int slotNumber) {
            this.mage = new WeakReference<com.elmakers.mine.bukkit.api.magic.Mage>(mage);
            this.slotNumber = slotNumber;
        }

        private void returnItem() {
            if (this.returned) {
                return;
            }
            this.returned = true;
            com.elmakers.mine.bukkit.api.magic.Mage mage = (com.elmakers.mine.bukkit.api.magic.Mage)this.mage.get();
            if (mage == null || mage.isDead()) {
                return;
            }
            ItemStack currentItem = mage.getItem(this.slotNumber);
            if (CompatibilityLib.getItemUtils().isTemporary(currentItem)) {
                ItemStack replacement = CompatibilityLib.getItemUtils().getReplacement(currentItem);
                mage.setItem(this.slotNumber, replacement);
            }
            if (mage instanceof Mage) {
                Mage implMage = (Mage)mage;
                implMage.armorUpdated();
                implMage.checkWandNextTick();
            }
        }

        @Override
        public void run() {
            this.returnItem();
        }
    }
}

