/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.spawn.builtin;

import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import com.elmakers.mine.bukkit.world.CastSpell;
import com.elmakers.mine.bukkit.world.CastSpellParser;
import com.elmakers.mine.bukkit.world.spawn.SpawnResult;
import com.elmakers.mine.bukkit.world.spawn.SpawnRule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class CastRule
extends SpawnRule {
    protected List<CastSpell> spells;
    protected Deque<WeightedPair<CastSpell>> spellProbability;
    protected int yOffset;

    @Override
    public void finalizeLoad(String worldName) {
        this.yOffset = this.parameters.getInt("y_offset", 0);
        List spells = this.parameters.getStringList("spells");
        if (spells == null || spells.size() == 0) {
            ConfigurationSection spellMap = this.parameters.getConfigurationSection("spells");
            this.spellProbability = new ArrayDeque<WeightedPair<CastSpell>>();
            RandomUtils.populateProbabilityMap(CastSpellParser.getInstance(), this.spellProbability, spellMap);
            if (this.spellProbability.isEmpty()) {
                return;
            }
            this.logSpawnRule("Casting one of " + StringUtils.join(this.spellProbability, (String)",") + " on " + this.getTargetEntityTypeName() + " in " + worldName);
        } else {
            this.spells = new ArrayList<CastSpell>();
            for (String spellName : spells) {
                this.spells.add(new CastSpell(spellName));
            }
            this.logSpawnRule("Casting " + StringUtils.join(this.spells, (String)",") + " on " + this.getTargetEntityTypeName() + " in " + worldName);
        }
    }

    @Override
    @Nonnull
    public SpawnResult onProcess(Plugin plugin, LivingEntity entity) {
        int y = entity.getLocation().getBlockY() + this.yOffset;
        if (y > 250) {
            y = 250;
        }
        if (entity.getWorld().getEnvironment() == World.Environment.NETHER && y > 118) {
            y = 118;
        }
        String[] standardParameters = new String[]{"pworld", entity.getLocation().getWorld().getName(), "px", Integer.toString(entity.getLocation().getBlockX()), "py", Integer.toString(y), "pz", Integer.toString(entity.getLocation().getBlockZ()), "quiet", "true"};
        if (this.spells == null) {
            this.spells = new ArrayList<CastSpell>();
        }
        if (this.spellProbability != null) {
            CastSpell spell = (CastSpell)RandomUtils.weightedRandom(this.spellProbability);
            this.spells.clear();
            this.spells.add(spell);
        }
        boolean casted = false;
        for (CastSpell spell : this.spells) {
            int index;
            if (spell.isEmpty()) {
                SpawnResult result = spell.getSpawnResult();
                if (result == SpawnResult.SKIP) continue;
                return result;
            }
            Object[] fullParameters = new String[spell.getParameters().length + standardParameters.length];
            for (index = 0; index < standardParameters.length; ++index) {
                fullParameters[index] = standardParameters[index];
            }
            for (index = 0; index < spell.getParameters().length; ++index) {
                fullParameters[index + standardParameters.length] = spell.getParameters()[index];
            }
            casted = this.controller.cast(spell.getName(), (String[])fullParameters) || casted;
            this.controller.info("Spawn rule casting: " + spell.getName() + " " + StringUtils.join((Object[])fullParameters, (char)' ') + " at " + entity.getLocation().toVector());
        }
        return casted ? SpawnResult.REPLACE : SpawnResult.REMOVE;
    }
}

