/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_14.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.base.entity.EntityAnimalData;
import java.util.logging.Logger;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;

public class EntityCatData
extends EntityAnimalData {
    private Cat.Type type;
    private DyeColor collarColor;

    public EntityCatData() {
    }

    public EntityCatData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        String colorString;
        Logger log = controller.getLogger();
        String typeName = parameters.getString("cat_type");
        if (typeName != null && !typeName.isEmpty()) {
            try {
                this.type = Cat.Type.valueOf((String)typeName.toUpperCase());
            }
            catch (Exception ex) {
                log.warning("Invalid cat type: " + typeName);
            }
        }
        if ((colorString = parameters.getString("color")) != null && !colorString.isEmpty()) {
            try {
                this.collarColor = DyeColor.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                log.warning("Invalid collar color: " + colorString);
                this.collarColor = null;
            }
        }
    }

    public EntityCatData(Entity entity) {
        super(entity);
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            this.type = cat.getCatType();
            this.collarColor = cat.getCollarColor();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            if (this.type != null) {
                cat.setCatType(this.type);
            }
            if (this.collarColor != null) {
                cat.setCollarColor(this.collarColor);
            }
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Cat cat = (Cat)entity;
        Cat.Type catType = cat.getCatType();
        Cat.Type[] typeValues = Cat.Type.values();
        catType = typeValues[(catType.ordinal() + 1) % typeValues.length];
        cat.setCatType(catType);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Cat;
    }
}

