/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.base.entity.EntityAnimalData;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;

public class EntitySheepData
extends EntityAnimalData {
    private DyeColor color;
    private boolean sheared;

    public EntitySheepData() {
    }

    public EntitySheepData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        String colorString = parameters.getString("color");
        if (colorString != null) {
            try {
                this.color = DyeColor.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                this.color = null;
            }
        }
        this.sheared = parameters.getBoolean("sheared");
    }

    public EntitySheepData(Entity entity) {
        super(entity);
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            this.color = sheep.getColor();
            this.sheared = sheep.isSheared();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            if (this.color != null) {
                sheep.setColor(this.color);
            }
            sheep.setSheared(this.sheared);
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Sheep sheep = (Sheep)entity;
        DyeColor dyeColor = sheep.getColor();
        DyeColor[] dyeColorValues = DyeColor.values();
        dyeColor = dyeColorValues[(dyeColor.ordinal() + 1) % dyeColorValues.length];
        sheep.setColor(dyeColor);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Sheep;
    }
}

