/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;

public class LogMessage {
    @Nullable
    private final String context;
    private final String message;

    public LogMessage(String context, String message) {
        this.context = context;
        this.message = message;
    }

    public String getMessage() {
        if (this.context == null) {
            return this.message;
        }
        return ChatColor.AQUA + this.context + ChatColor.GRAY + ": " + ChatColor.WHITE + this.message;
    }

    public int hashCode() {
        int contextHash = this.context == null ? 0 : this.context.hashCode();
        int messageHash = this.message == null ? 0 : this.message.hashCode();
        return contextHash & 0xFFFFFF | (messageHash & 0xFFFFFF) << 16;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogMessage)) {
            return false;
        }
        LogMessage other = (LogMessage)o;
        return Objects.equals(this.context, other.context) && Objects.equals(this.message, other.message);
    }
}

