/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.kit;

import com.elmakers.mine.bukkit.configuration.MagicConfiguration;
import com.elmakers.mine.bukkit.kit.MagicKit;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.tasks.ProcessKitsTask;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;

public class KitController
implements Listener {
    private final MagicController controller;
    private final Map<String, MagicKit> kits = new HashMap<String, MagicKit>();
    private final List<MagicKit> joinKits = new ArrayList<MagicKit>();

    public KitController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        this.kits.clear();
        this.joinKits.clear();
        Set keys = configuration.getKeys(false);
        for (String key : keys) {
            Object kitConfiguration = configuration.getConfigurationSection(key);
            if (!ConfigurationUtils.isEnabled(kitConfiguration)) continue;
            kitConfiguration = MagicConfiguration.getKeyed(this.controller, kitConfiguration, "kit", key);
            MagicKit kit = new MagicKit(this.controller, key, (ConfigurationSection)kitConfiguration);
            this.kits.put(key, kit);
            if (!kit.isKeep() && !kit.isRemove() && !kit.isStarter()) continue;
            this.joinKits.add(kit);
        }
        Collections.sort(this.joinKits);
    }

    public int getCount() {
        return this.kits.size();
    }

    public MagicKit getKit(String key) {
        return this.kits.get(key);
    }

    public Set<String> getKitKeys() {
        return this.kits.keySet();
    }

    public void onJoin(Mage mage) {
        Location location = mage.getLocation();
        World world = location == null ? null : location.getWorld();
        for (MagicKit joinKit : this.joinKits) {
            if (joinKit.isWorldSpecific() && !joinKit.isWorld(world)) continue;
            if (joinKit.isStarter()) {
                joinKit.checkGive(mage);
            }
            if (joinKit.isRemove()) {
                joinKit.checkRemoveFrom(mage);
            }
            if (!joinKit.isKeep()) continue;
            joinKit.giveMissing(mage);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getMage(player);
        World fromWorld = event.getFrom();
        World toWorld = player.getWorld();
        ProcessKitsTask task = new ProcessKitsTask(mage, fromWorld, toWorld);
        for (MagicKit joinKit : this.joinKits) {
            if (!joinKit.isWorld(toWorld)) continue;
            task.addKit(joinKit);
        }
        if (!task.isEmpty()) {
            MagicPlugin plugin = this.controller.getPlugin();
            plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, (Runnable)task, 1L);
        }
    }
}

