/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Knows Spell")
@Description(value={"Checks whether a player knows a specific spell, or has it on their wand."})
@Examples(value={"player knows \"missile\"", "player has spell \"blink\"", "player has \"meteor\""})
public class CondHasSpell
extends Condition {
    private Expression<Entity> entities;
    private Expression<String> spells;

    public static void register() {
        Skript.registerCondition(CondHasSpell.class, (String[])new String[]{"%entities% (has|have|know|knows) [spell[s]] %strings%", "%entities% (ha(s|ve) not|do[es]n't have|do[es]n't know|do[es] not know) [spell[s]] %strings%"});
    }

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = vars[0];
        this.spells = vars[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(final Event e) {
        return this.entities.check(e, (Checker)new Checker<Entity>(){

            public boolean check(Entity entity) {
                final Mage mage = MagicPlugin.getAPI().getController().getRegisteredMage(entity);
                if (mage == null) {
                    return false;
                }
                return CondHasSpell.this.spells.check(e, (Checker)new Checker<String>(){

                    public boolean check(String spellKey) {
                        Wand wand = mage.getActiveWand();
                        if (wand != null && wand.hasSpell(spellKey)) {
                            return true;
                        }
                        MageClass activeClass = mage.getActiveClass();
                        return activeClass != null && activeClass.hasSpell(spellKey);
                    }
                }, CondHasSpell.this.isNegated());
            }
        });
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.entities.toString(e, debug) + (this.entities.isSingle() ? " knows" : " know") + (this.isNegated() ? " not" : "") + " spell " + this.spells;
    }
}

