/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.configuration.TranslatingConfigurationSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ConfigUtils {
    public static Collection<ConfigurationSection> getNodeList(ConfigurationSection node, String path) {
        ArrayList<ConfigurationSection> results = new ArrayList<ConfigurationSection>();
        List mapList = node.getMapList(path);
        for (Map map : mapList) {
            results.add(ConfigUtils.toConfigurationSection(node, map));
        }
        return results;
    }

    public static ConfigurationSection newSection(ConfigurationSection parent, String path) {
        if (parent instanceof TranslatingConfigurationSection) {
            return ((TranslatingConfigurationSection)parent).newSection(path);
        }
        return new TranslatingConfigurationSection(parent, path);
    }

    public static ConfigurationSection toConfigurationSection(ConfigurationSection parent, Map<?, ?> nodeMap) {
        return ConfigUtils.toConfigurationSection(parent, "", nodeMap);
    }

    public static ConfigurationSection toConfigurationSection(ConfigurationSection parent, String path, Map<?, ?> nodeMap) {
        ConfigurationSection newSection = ConfigUtils.newSection(parent, path);
        for (Map.Entry<?, ?> entry : nodeMap.entrySet()) {
            newSection.set(entry.getKey().toString(), entry.getValue());
        }
        return newSection;
    }

    public static ConfigurationSection convertConfigurationSection(Map<?, ?> nodeMap) {
        MemoryConfiguration newSection = new MemoryConfiguration();
        for (Map.Entry<?, ?> entry : nodeMap.entrySet()) {
            ConfigUtils.set((ConfigurationSection)newSection, entry.getKey().toString(), entry.getValue());
        }
        return newSection;
    }

    public static ConfigurationSection toStringConfiguration(Map<String, String> stringMap) {
        if (stringMap == null) {
            return null;
        }
        MemoryConfiguration configMap = new MemoryConfiguration();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            configMap.set(entry.getKey(), (Object)entry.getValue());
        }
        return configMap;
    }

    public static void set(ConfigurationSection node, String path, Object value) {
        if (value == null) {
            node.set(path, null);
            return;
        }
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            node.set(path, (Object)isTrue);
            return;
        }
        try {
            Integer i = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
            node.set(path, (Object)i);
        }
        catch (Exception ex) {
            try {
                double d = value instanceof Double ? (Double)value : (value instanceof Float ? (double)((Float)value).floatValue() : Double.parseDouble(value.toString()));
                node.set(path, (Object)d);
            }
            catch (Exception ex2) {
                node.set(path, value);
            }
        }
    }

    public static ConfigurationSection getConfigurationSection(ConfigurationSection base, String key) {
        ConfigurationSection section = base.getConfigurationSection(key);
        if (section != null) {
            return section;
        }
        Object value = base.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof ConfigurationSection) {
            return (ConfigurationSection)value;
        }
        if (value instanceof Map) {
            ConfigurationSection newChild = base.createSection(key);
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                newChild.set((String)entry.getKey(), entry.getValue());
            }
            base.set(key, (Object)newChild);
            return newChild;
        }
        return null;
    }

    public static boolean isMaxValue(String stringValue) {
        return stringValue.equalsIgnoreCase("infinite") || stringValue.equalsIgnoreCase("forever") || stringValue.equalsIgnoreCase("infinity") || stringValue.equalsIgnoreCase("max");
    }

    @Nullable
    public static List<Object> getList(ConfigurationSection section, String path) {
        List list = section.getList(path);
        if (list != null) {
            return list;
        }
        Object o = section.get(path);
        return ConfigUtils.getList(o);
    }

    @Nullable
    public static List<Object> getList(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            return new ArrayList<Object>(Arrays.asList(StringUtils.split((String)((String)o), (char)',')));
        }
        ArrayList<Object> single = new ArrayList<Object>();
        single.add(o);
        return single;
    }

    public static List<String> getStringList(ConfigurationSection section, String path, List<String> def) {
        ArrayList list = ConfigUtils.getStringList(section, path);
        return list == null ? (def == null ? new ArrayList() : def) : list;
    }

    @Nullable
    public static List<String> getStringList(ConfigurationSection section, String path) {
        List<Object> raw = ConfigUtils.getList(section, path);
        return ConfigUtils.getStringList(raw);
    }

    @Nullable
    public static List<String> getStringList(ConfigurationSection section, String path, String delimiter) {
        if (section.isList(path)) {
            List<Object> raw = ConfigUtils.getList(section, path);
            return ConfigUtils.getStringList(raw);
        }
        String value = section.getString(path);
        if (value == null) {
            return null;
        }
        String[] pieces = StringUtils.split((String)value, (String)delimiter);
        return Arrays.asList(pieces);
    }

    @Nullable
    public static List<String> getStringList(Object o) {
        List<Object> raw = ConfigUtils.getList(o);
        return ConfigUtils.getStringList(raw);
    }

    @Nullable
    public static List<String> getStringList(List<Object> rawList) {
        if (rawList == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : rawList) {
            if (o == null || o instanceof ConfigurationSection || o instanceof List || o instanceof Map) continue;
            list.add(o.toString());
        }
        return list;
    }

    @Nullable
    public static List<PotionEffect> getPotionEffectObjects(ConfigurationSection baseConfig, String key, Logger log) {
        return ConfigUtils.getPotionEffectObjects(baseConfig, key, log, Integer.MAX_VALUE, 0, true, true);
    }

    @Nullable
    public static List<PotionEffect> getPotionEffectObjects(ConfigurationSection baseConfig, String key, Logger log, int defaultDuration) {
        return ConfigUtils.getPotionEffectObjects(baseConfig, key, log, defaultDuration, 0, true, true);
    }

    @Nullable
    public static List<PotionEffect> getPotionEffectObjects(ConfigurationSection baseConfig, String key, Logger log, int defaultDuration, int defaultAmplifier, boolean defaultAmbient, boolean defaultParticles) {
        ArrayList<PotionEffect> potionEffects = null;
        List<Object> genericList = ConfigUtils.getList(baseConfig, key);
        if (genericList != null && !genericList.isEmpty()) {
            potionEffects = new ArrayList<PotionEffect>();
            for (Object genericEntry : genericList) {
                ConfigurationSection potionEffectSection;
                PotionEffectType effectType;
                if (genericEntry instanceof String) {
                    String typeString = (String)genericEntry;
                    effectType = PotionEffectType.getByName((String)typeString.toUpperCase());
                    if (effectType == null) {
                        log.log(Level.WARNING, "Invalid potion effect type: " + typeString);
                        continue;
                    }
                    int ticks = defaultDuration / 50;
                    potionEffects.add(new PotionEffect(effectType, effectType.isInstant() ? 1 : ticks, defaultAmplifier, defaultAmbient, defaultParticles));
                    continue;
                }
                ConfigurationSection configurationSection = potionEffectSection = genericEntry instanceof ConfigurationSection ? (ConfigurationSection)genericEntry : null;
                if (potionEffectSection == null && genericEntry instanceof Map) {
                    potionEffectSection = ConfigUtils.toConfigurationSection(baseConfig, (Map)genericEntry);
                }
                if (potionEffectSection == null) continue;
                if (potionEffectSection.contains("type")) {
                    effectType = PotionEffectType.getByName((String)potionEffectSection.getString("type").toUpperCase());
                    if (effectType == null) {
                        log.log(Level.WARNING, "Invalid potion effect type: " + potionEffectSection.getString("type", "(null)"));
                        continue;
                    }
                    int ticks = Integer.MAX_VALUE;
                    String duration = potionEffectSection.getString("duration");
                    if (duration == null || !duration.equals("forever") && !duration.equals("infinite") && !duration.equals("infinity")) {
                        ticks = (int)(potionEffectSection.getLong("duration", (long)defaultDuration) / 50L);
                        ticks = potionEffectSection.getInt("ticks", ticks);
                    }
                    int amplifier = potionEffectSection.getInt("amplifier", defaultAmplifier);
                    boolean ambient = potionEffectSection.getBoolean("ambient", defaultAmbient);
                    boolean particles = potionEffectSection.getBoolean("particles", defaultParticles);
                    potionEffects.add(new PotionEffect(effectType, effectType.isInstant() ? 1 : ticks, amplifier, ambient, particles));
                    continue;
                }
                Set types = potionEffectSection.getKeys(false);
                for (String type : types) {
                    PotionEffectType effectType2 = PotionEffectType.getByName((String)type.toUpperCase());
                    if (effectType2 == null) {
                        log.log(Level.WARNING, "Invalid potion effect type: " + type);
                        continue;
                    }
                    int amplifier = potionEffectSection.getInt(type, defaultAmplifier);
                    int ticks = defaultDuration / 50;
                    potionEffects.add(new PotionEffect(effectType2, effectType2.isInstant() ? 1 : ticks, amplifier, defaultAmbient, defaultParticles));
                }
            }
        }
        return potionEffects;
    }
}

