/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@Deprecated
public class PotionEffectSpell
extends UndoableSpell {
    private static final PotionEffectType[] _negativeEffects = new PotionEffectType[]{PotionEffectType.BLINDNESS, PotionEffectType.CONFUSION, PotionEffectType.HARM, PotionEffectType.HUNGER, PotionEffectType.POISON, PotionEffectType.SLOW, PotionEffectType.SLOW_DIGGING, PotionEffectType.WEAKNESS, PotionEffectType.WITHER};
    protected static final Set<PotionEffectType> negativeEffects = new HashSet<PotionEffectType>(Arrays.asList(_negativeEffects));

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        ArrayList<LivingEntity> targetEntities = new ArrayList<LivingEntity>();
        Entity targetedEntity = target.getEntity();
        if (target.hasEntity() && targetedEntity instanceof LivingEntity) {
            targetEntities.add((LivingEntity)targetedEntity);
        }
        int radius = parameters.getInt("radius", 0);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        if (radius > 0) {
            Collection<Entity> entities = CompatibilityLib.getCompatibilityUtils().getNearbyEntities(target.getLocation(), radius, radius, radius);
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity) || entity == targetedEntity || entity == this.mage.getEntity()) continue;
                targetEntities.add((LivingEntity)entity);
            }
        }
        if (targetEntities.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        int fallProtection = parameters.getInt("fall_protection", 0);
        Integer duration = null;
        if (parameters.contains("duration")) {
            duration = parameters.getInt("duration");
        }
        Collection<PotionEffect> effects = PotionEffectSpell.getPotionEffects(parameters, duration);
        for (LivingEntity targetEntity : targetEntities) {
            Mage targetMage;
            Mage mage = targetMage = this.controller.isMage((Entity)targetEntity) ? this.controller.getMage((Entity)targetEntity) : null;
            if (targetMage != null && fallProtection > 0) {
                targetMage.enableFallProtection(fallProtection);
            }
            if (targetEntity != this.mage.getEntity() && this.isSuperProtected((Entity)targetEntity)) continue;
            if (targetMage != null && parameters.getBoolean("deactivate_target_mage")) {
                targetMage.deactivateAllSpells(true, false);
            }
            if (targetEntity instanceof Player && parameters.getBoolean("feed", false)) {
                Player p = (Player)targetEntity;
                p.setExhaustion(0.0f);
                p.setFoodLevel(20);
            }
            if (parameters.getBoolean("cure", false)) {
                Collection currentEffects = targetEntity.getActivePotionEffects();
                for (PotionEffect effect : currentEffects) {
                    if (!negativeEffects.contains(effect.getType())) continue;
                    targetEntity.removePotionEffect(effect.getType());
                }
            }
            if (parameters.contains("heal")) {
                this.registerModified((Entity)targetEntity);
                double health = targetEntity.getHealth() + parameters.getDouble("heal");
                targetEntity.setHealth(Math.min(health, CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)targetEntity)));
            } else if (parameters.contains("heal_percentage")) {
                this.registerModified((Entity)targetEntity);
                double health = targetEntity.getHealth() + CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)targetEntity) * parameters.getDouble("heal_percentage");
                targetEntity.setHealth(Math.min(health, CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)targetEntity)));
            } else if (parameters.contains("damage")) {
                this.registerModified((Entity)targetEntity);
                CompatibilityLib.getCompatibilityUtils().magicDamage((Damageable)targetEntity, parameters.getDouble("damage") * (double)this.mage.getDamageMultiplier(), this.mage.getEntity());
            } else {
                this.registerPotionEffects((Entity)targetEntity);
            }
            if (parameters.contains("fire")) {
                this.registerModified((Entity)targetEntity);
                targetEntity.setFireTicks(parameters.getInt("fire"));
            }
            CompatibilityLib.getCompatibilityUtils().applyPotionEffects(targetEntity, effects);
            if (!parameters.contains("remove_effects")) continue;
            List removeKeys = parameters.getStringList("remove_effects");
            for (String removeKey : removeKeys) {
                PotionEffectType removeType = PotionEffectType.getByName((String)removeKey);
                targetEntity.removePotionEffect(removeType);
            }
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

