/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.batch.UndoBatch;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.listener.ChunkLoadListener;
import com.elmakers.mine.bukkit.tasks.CheckChunkTask;
import com.elmakers.mine.bukkit.tasks.UndoBlockTask;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.world.MagicWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class BlockController
implements Listener,
ChunkLoadListener {
    private final MagicController controller;
    private boolean undoOnWorldSave = false;
    private int creativeBreakFrequency = 0;
    private boolean dropOriginalBlock = true;
    private boolean applySpawnerData = true;
    private boolean disableSpawnerData = false;
    static final List<BlockFace> blockBurnDirections = Arrays.asList(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN);

    public BlockController(MagicController controller) {
        this.controller = controller;
    }

    public void loadProperties(ConfigurationSection properties) {
        this.undoOnWorldSave = properties.getBoolean("undo_on_world_save", false);
        this.creativeBreakFrequency = properties.getInt("prevent_creative_breaking", 0);
        this.dropOriginalBlock = properties.getBoolean("drop_original_block", true);
        this.applySpawnerData = properties.getBoolean("apply_spawner_data", true);
        if (this.disableSpawnerData) {
            this.applySpawnerData = false;
        }
    }

    public void finalizeIntegration() {
        PluginManager pluginManager = this.controller.getPlugin().getServer().getPluginManager();
        if (pluginManager.isPluginEnabled("SilkSpawners")) {
            this.applySpawnerData = false;
            this.disableSpawnerData = true;
            this.controller.getLogger().info("SilkSpawners detected, forcing apply_spawner_data to false");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList;
        String lockKey;
        Mage mage;
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (this.creativeBreakFrequency > 0 && player.getGameMode() == GameMode.CREATIVE && (mage = this.controller.getMage(event.getPlayer())).checkLastClick(this.creativeBreakFrequency)) {
            event.setCancelled(true);
            return;
        }
        if (this.controller.areLocksProtected() && this.controller.isContainer(block) && !this.controller.hasBypassPermission((CommandSender)event.getPlayer()) && (lockKey = CompatibilityLib.getCompatibilityUtils().getLock(block)) != null && !lockKey.isEmpty()) {
            PlayerInventory inventory = player.getInventory();
            Mage mage2 = this.controller.getRegisteredMage((Entity)event.getPlayer());
            if (mage2 != null) {
                inventory = mage2.getInventory();
            }
            if (!CompatibilityLib.getInventoryUtils().hasItem((Inventory)inventory, lockKey)) {
                String message = this.controller.getMessages().get("general.locked_chest");
                if (mage2 != null) {
                    mage2.sendMessage(message);
                } else {
                    player.sendMessage(message);
                }
                event.setCancelled(true);
                return;
            }
        }
        if (this.controller.checkAutomatonBreak(block)) {
            event.setCancelled(true);
            return;
        }
        BlockData modifiedBlock = UndoList.getModified(block.getLocation());
        if (modifiedBlock != null && (undoList = modifiedBlock.getUndoList()) != null) {
            if (undoList.isUnbreakable()) {
                event.setCancelled(true);
                return;
            }
            if (!undoList.isConsumed()) {
                event.setCancelled(true);
                Collection items = null;
                if (this.dropOriginalBlock) {
                    BlockData originalBlock = modifiedBlock;
                    while (originalBlock.getPriorState() != null) {
                        originalBlock = originalBlock.getPriorState();
                    }
                    originalBlock.modify(block);
                    items = block.getDrops();
                }
                if (items != null) {
                    Location location = block.getLocation();
                    for (ItemStack item : items) {
                        if (CompatibilityLib.getItemUtils().isEmpty(item)) continue;
                        location.getWorld().dropItemNaturally(location, item);
                    }
                }
                block.setType(Material.AIR);
            }
            modifiedBlock.commit();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack itemStack = event.getItemInHand();
        if (CompatibilityLib.getItemUtils().isTemporary(itemStack)) {
            event.setCancelled(true);
            player.getInventory().setItemInMainHand(null);
            return;
        }
        if (CompatibilityLib.getItemUtils().isUnplaceable(itemStack) || Wand.isSpecial(itemStack)) {
            event.setCancelled(true);
            return;
        }
        Mage mage = this.controller.getMage(player);
        if (mage.getBlockPlaceTimeout() > System.currentTimeMillis()) {
            event.setCancelled(true);
        }
        if (Wand.isSpecial(itemStack)) {
            event.setCancelled(true);
        }
        if (!event.isCancelled()) {
            Block block = event.getBlock();
            BlockData modifiedBlock = UndoList.getModified(block.getLocation());
            if (modifiedBlock != null) {
                com.elmakers.mine.bukkit.api.block.UndoList undoList = modifiedBlock.getUndoList();
                if (undoList != null && undoList.isScheduled()) {
                    if (modifiedBlock.isDifferent(event.getBlockReplacedState().getType())) {
                        event.setCancelled(true);
                        MagicPlugin plugin = this.controller.getPlugin();
                        plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, (Runnable)new UndoBlockTask(modifiedBlock), 1L);
                    } else {
                        modifiedBlock.commit();
                    }
                } else {
                    modifiedBlock.commit();
                    if (event.getBlockReplacedState().getType() == Material.WATER) {
                        CompatibilityLib.getCompatibilityUtils().setWaterlogged(block, false);
                    }
                }
            }
            if (!event.isCancelled() && this.applySpawnerData && DefaultMaterials.isMobSpawner(block.getType()) && event.getItemInHand() != null && DefaultMaterials.isMobSpawner(event.getItemInHand().getType()) && player.hasPermission("Magic.spawners")) {
                CompatibilityLib.getCompatibilityUtils().applyItemData(event.getItemInHand(), block);
            }
        }
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent event) {
        Block block = event.getBlock();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.controller.getPendingUndo(block.getLocation());
        if (undoList != null) {
            undoList.add(block);
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        Block piston = event.getBlock();
        Block block = piston.getRelative(event.getDirection());
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.controller.getPendingUndo(block.getLocation());
        if (undoList != null) {
            undoList.add(block);
            undoList.add(piston);
            block = piston.getRelative(event.getDirection());
            if (!DefaultMaterials.isAir(block.getType())) {
                undoList.add(block);
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Block piston = event.getBlock();
        Block block = piston.getRelative(event.getDirection());
        PistonMoveReaction reaction = block.getPistonMoveReaction();
        if (reaction == PistonMoveReaction.BLOCK) {
            return;
        }
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.controller.getPendingUndo(block.getLocation());
        if (undoList == null) {
            undoList = this.controller.getPendingUndo(piston.getLocation());
        }
        if (undoList != null) {
            undoList.add(piston);
            if (reaction == PistonMoveReaction.BREAK) {
                undoList.add(block);
                CompatibilityLib.getCompatibilityUtils().clearItems(block.getLocation());
                CompatibilityLib.getDeprecatedUtils().setTypeAndData(block, Material.AIR, (byte)0, false);
            } else {
                undoList.add(block);
                block = block.getRelative(event.getDirection());
                undoList.add(block);
                int maxBlocks = 14;
                while (maxBlocks-- > 0 && !DefaultMaterials.isAir(block.getType())) {
                    block = block.getRelative(event.getDirection());
                    undoList.add(block);
                }
            }
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Block targetBlock = event.getToBlock();
        Block sourceBlock = event.getBlock();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.controller.getPendingUndo(sourceBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock);
        } else {
            undoList = this.controller.getPendingUndo(targetBlock.getLocation());
            if (undoList != null) {
                undoList.add(targetBlock);
            }
        }
        if (undoList != null && undoList.isScheduled()) {
            MaterialSet doubles = UndoList.attachablesDouble;
            if (doubles.testBlock(targetBlock)) {
                Block upBlock = targetBlock.getRelative(BlockFace.UP);
                while (doubles.testBlock(upBlock)) {
                    undoList.add(upBlock);
                    CompatibilityLib.getDeprecatedUtils().setTypeAndData(upBlock, Material.AIR, (byte)0, false);
                    upBlock = upBlock.getRelative(BlockFace.UP);
                }
                Block downBlock = targetBlock.getRelative(BlockFace.DOWN);
                while (doubles.testBlock(downBlock)) {
                    undoList.add(downBlock);
                    CompatibilityLib.getDeprecatedUtils().setTypeAndData(downBlock, Material.AIR, (byte)0, false);
                    downBlock = downBlock.getRelative(BlockFace.DOWN);
                }
            }
            if (!CompatibilityLib.getCompatibilityUtils().isWaterLoggable(targetBlock)) {
                CompatibilityLib.getCompatibilityUtils().clearItems(targetBlock.getLocation());
                CompatibilityLib.getDeprecatedUtils().setTypeAndData(targetBlock, Material.AIR, (byte)0, false);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        Block targetBlock = event.getBlock();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.controller.getPendingUndo(targetBlock.getLocation());
        if (undoList == null) {
            BlockFace face;
            Block sourceBlock;
            Iterator<BlockFace> iterator = blockBurnDirections.iterator();
            while (iterator.hasNext() && ((sourceBlock = targetBlock.getRelative(face = iterator.next())).getType() != Material.FIRE || (undoList = this.controller.getPendingUndo(sourceBlock.getLocation())) == null)) {
            }
        }
        if (undoList != null) {
            undoList.add(targetBlock);
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList;
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        if (cause == BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL || cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
            return;
        }
        Entity entity = event.getIgnitingEntity();
        com.elmakers.mine.bukkit.api.block.UndoList entityList = this.controller.getEntityUndo(entity);
        if (entityList != null) {
            entityList.add(event.getBlock());
            return;
        }
        Block ignitingBlock = event.getIgnitingBlock();
        Block targetBlock = event.getBlock();
        if (ignitingBlock != null && (undoList = this.controller.getPendingUndo(ignitingBlock.getLocation())) != null) {
            undoList.add(event.getBlock());
            return;
        }
        undoList = this.controller.getPendingUndo(targetBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock);
        }
    }

    @EventHandler
    public void onBlockDamage(BlockDamageEvent event) {
        com.elmakers.mine.bukkit.api.wand.Wand activeWand;
        Player damager = event.getPlayer();
        Mage damagerMage = this.controller.getRegisteredMage((Entity)damager);
        if (damagerMage != null && (activeWand = damagerMage.getActiveWand()) != null) {
            activeWand.playEffects("hit_block");
        }
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            if (event.getTo() == Material.AIR) {
                this.controller.registerFallingBlock(entity, event.getBlock());
            } else {
                com.elmakers.mine.bukkit.api.block.UndoList blockList = UndoList.getUndoList(entity);
                if (blockList != null) {
                    CastContext context = blockList.getContext();
                    if (context != null && !context.hasBuildPermission(entity.getLocation().getBlock())) {
                        event.setCancelled(true);
                    } else {
                        Block block = event.getBlock();
                        blockList.convert(entity, block);
                        if (!blockList.getApplyPhysics()) {
                            FallingBlock falling = (FallingBlock)entity;
                            CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
                            Material material = compatibilityUtils.getMaterial(falling);
                            String blockData = compatibilityUtils.getBlockData(falling);
                            if (blockData != null) {
                                compatibilityUtils.setBlockData(block, blockData);
                            } else {
                                byte data = CompatibilityLib.getCompatibilityUtils().getLegacyBlockData(falling);
                                CompatibilityLib.getDeprecatedUtils().setTypeAndData(block, material, data, false);
                            }
                            entity.remove();
                            event.setCancelled(true);
                        }
                    }
                }
            }
        }
    }

    private void undoPending(World world, String logType) {
        Collection<com.elmakers.mine.bukkit.api.magic.Mage> mages = this.controller.getMages();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : mages) {
            ArrayList<Batch> pending = new ArrayList<Batch>(mage.getPendingBatches());
            int cancelled = 0;
            int fastForwarded = 0;
            for (Batch batch : pending) {
                UndoBatch undoBatch;
                com.elmakers.mine.bukkit.api.block.UndoList undoList;
                if (batch instanceof SpellBatch) {
                    SpellBatch spellBatch = (SpellBatch)batch;
                    undoList = spellBatch.getUndoList();
                    if (undoList == null || !undoList.isScheduled() || !undoList.affectsWorld(world)) continue;
                    spellBatch.cancel();
                    ++cancelled;
                    continue;
                }
                if (!(batch instanceof UndoBatch) || (undoList = (undoBatch = (UndoBatch)batch).getUndoList()) == null || !undoList.affectsWorld(world)) continue;
                undoBatch.complete();
                ++fastForwarded;
            }
            if (cancelled > 0) {
                this.controller.info("Cancelled " + cancelled + " pending spells for " + mage.getName() + " prior to " + logType + " of world " + world.getName());
            }
            if (fastForwarded <= 0) continue;
            this.controller.info("Fast-forwarded " + fastForwarded + " pending undo tasks for " + mage.getName() + " prior to " + logType + " of world " + world.getName());
        }
        ArrayList<com.elmakers.mine.bukkit.api.block.UndoList> pending = new ArrayList<com.elmakers.mine.bukkit.api.block.UndoList>(this.controller.getPendingUndo());
        int undone = 0;
        for (com.elmakers.mine.bukkit.api.block.UndoList list : pending) {
            if (!list.isScheduled() || !list.affectsWorld(world)) continue;
            list.undoScheduled(true);
            ++undone;
        }
        if (undone > 0) {
            this.controller.info("Undid " + undone + " spells prior to " + logType + " of world " + world.getName());
        }
    }

    @EventHandler
    public void onWorldSaveEvent(WorldSaveEvent event) {
        World world = event.getWorld();
        MagicWorld magicWorld = this.controller.getMagicWorld(world.getName());
        boolean undo = this.undoOnWorldSave;
        if (undo && magicWorld != null && !magicWorld.isCancelSpellsOnSave()) {
            undo = false;
        }
        if (undo) {
            this.undoPending(world, "save");
        }
        List players = world.getPlayers();
        for (Player player : players) {
            Mage mage = this.controller.getRegisteredMage((Entity)player);
            if (mage == null) continue;
            this.controller.saveMage(mage, true);
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        World world = event.getWorld();
        this.undoPending(world, "unload");
    }

    @Override
    public void onChunkLoad(Chunk chunk) {
        this.controller.resumeAutomata(chunk);
        this.controller.restoreNPCs(chunk);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        CheckChunkTask.process(this.controller, this, event.getChunk());
    }

    @EventHandler
    public void onWorldInit(WorldInitEvent e) {
        this.controller.checkAutomata(e.getWorld());
        this.controller.checkNPCs(e.getWorld());
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent e) {
        this.controller.pauseAutomata(e.getChunk());
    }
}

