/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.materials;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.materials.NegatedMaterialSet;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

final class SimpleMaterialSet
implements MaterialSet {
    @Nonnull
    protected final ImmutableList<MaterialSet> parents;
    @Nonnull
    protected final ImmutableSet<Material> materials;
    @Nonnull
    protected final ImmutableList<MaterialAndData> materialAndDatas;
    private transient MaterialSet inverse;

    public SimpleMaterialSet(@Nonnull ImmutableList<MaterialSet> parents, @Nonnull ImmutableSet<Material> materials, @Nonnull ImmutableList<MaterialAndData> materialAndDatas) {
        this.materialAndDatas = materialAndDatas;
        this.parents = parents;
        this.materials = (ImmutableSet)Preconditions.checkNotNull(materials);
    }

    @Override
    public MaterialSet not() {
        if (this.inverse != null) {
            return this.inverse;
        }
        this.inverse = new NegatedMaterialSet(this);
        return this.inverse;
    }

    @Override
    public Collection<Material> getMaterials() {
        return this.materials;
    }

    @Override
    public boolean testMaterial(Material material) {
        if (this.materials.contains((Object)material)) {
            return true;
        }
        for (MaterialSet parent : this.parents) {
            if (!parent.testMaterial(material)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testBlock(Block block) {
        if (this.materials.contains((Object)block.getType())) {
            return true;
        }
        for (MaterialSet parent : this.parents) {
            if (!parent.testBlock(block)) continue;
            return true;
        }
        for (MaterialAndData materialAndData : this.materialAndDatas) {
            if (!materialAndData.is(block)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testItem(ItemStack item) {
        if (this.materials.contains((Object)item.getType())) {
            return true;
        }
        for (MaterialSet parent : this.parents) {
            if (!parent.testItem(item)) continue;
            return true;
        }
        DeprecatedUtils deprecatedUtils = CompatibilityLib.getDeprecatedUtils();
        for (MaterialAndData materialAndData : this.materialAndDatas) {
            if (materialAndData.getMaterial() != item.getType() || materialAndData.getData().shortValue() != deprecatedUtils.getItemDamage(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testMaterialAndData(MaterialAndData targetMaterial) {
        if (this.materials.contains((Object)targetMaterial.getMaterial())) {
            return true;
        }
        for (MaterialSet parent : this.parents) {
            if (!parent.testMaterialAndData(targetMaterial)) continue;
            return true;
        }
        for (MaterialAndData materialAndData : this.materialAndDatas) {
            if (!materialAndData.equals(targetMaterial)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        boolean first = true;
        StringBuilder sb = new StringBuilder().append('(');
        for (MaterialSet parent : this.parents) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(parent);
        }
        for (Object material : this.materials) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(material.name().toLowerCase());
        }
        for (Object material : this.materialAndDatas) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(material.getKey());
        }
        return sb.append(')').toString();
    }
}

