/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.materials;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

final class NegatedMaterialSet
implements MaterialSet {
    @Nonnull
    private final MaterialSet delegate;

    public NegatedMaterialSet(MaterialSet delegate) {
        this.delegate = (MaterialSet)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    @Override
    public MaterialSet not() {
        return this.delegate;
    }

    @Override
    public Collection<Material> getMaterials() {
        return ImmutableList.of();
    }

    @Override
    public boolean testMaterial(Material material) {
        return !this.delegate.testMaterial(material);
    }

    @Override
    public boolean testBlock(Block testBlock) {
        return !this.delegate.testBlock(testBlock);
    }

    @Override
    public boolean testItem(ItemStack item) {
        return !this.delegate.testItem(item);
    }

    @Override
    public boolean testMaterialAndData(MaterialAndData targetMaterial) {
        return !this.delegate.testMaterialAndData(targetMaterial);
    }

    public String toString() {
        return "!(" + this.delegate + ")";
    }
}

