/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.maps;

import com.elmakers.mine.bukkit.maps.MapController;
import com.elmakers.mine.bukkit.maps.URLMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

class SaveMapsRunnable
implements Runnable {
    private final MapController mapController;
    final List<URLMap> saveMaps;

    public SaveMapsRunnable(MapController mapController, Collection<URLMap> maps) {
        this.mapController = mapController;
        this.saveMaps = new ArrayList<URLMap>(maps);
    }

    @Override
    public void run() {
        try {
            YamlConfiguration configuration = new YamlConfiguration();
            for (URLMap map : this.saveMaps) {
                ConfigurationSection mapConfig = configuration.createSection(Integer.toString(map.id));
                mapConfig.set("world", (Object)map.world);
                mapConfig.set("url", (Object)map.url);
                mapConfig.set("x", (Object)map.x);
                mapConfig.set("y", (Object)map.y);
                mapConfig.set("width", (Object)map.width);
                mapConfig.set("height", (Object)map.height);
                mapConfig.set("enabled", (Object)map.isEnabled());
                mapConfig.set("name", (Object)map.name);
                mapConfig.set("player", (Object)map.playerName);
                if (map.priority != null) {
                    mapConfig.set("priority", (Object)map.priority);
                }
                if (map.xOverlay != null) {
                    mapConfig.set("x_overlay", (Object)map.xOverlay);
                }
                if (map.yOverlay == null) continue;
                mapConfig.set("y_overlay", (Object)map.yOverlay);
            }
            File tempFile = new File(this.mapController.configurationFile.getAbsolutePath() + ".tmp");
            configuration.save(tempFile);
            if (this.mapController.configurationFile.exists()) {
                File backupFile = new File(this.mapController.configurationFile.getAbsolutePath() + ".bak");
                if (!backupFile.exists() || this.mapController.configurationFile.length() >= backupFile.length()) {
                    if (backupFile.exists() && !backupFile.delete()) {
                        this.mapController.warning("Failed to delete backup file in order to replace it: " + backupFile.getAbsolutePath());
                    }
                    this.mapController.configurationFile.renameTo(backupFile);
                } else {
                    this.mapController.info("Backup file is larger than current map file, you may want to restore or delete it? " + backupFile.getAbsolutePath());
                    if (!this.mapController.configurationFile.delete()) {
                        this.mapController.warning("Failed to delete file in order to replace it: " + this.mapController.configurationFile.getAbsolutePath());
                    }
                }
            }
            if (!tempFile.renameTo(this.mapController.configurationFile)) {
                this.mapController.warning("Failed to rename file from " + tempFile.getAbsolutePath() + " to " + this.mapController.configurationFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            this.mapController.warning("Failed to save file " + this.mapController.configurationFile.getAbsolutePath());
        }
        this.mapController.saveTask = null;
    }
}

