/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.crafting;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.crafting.MagicBlastingRecipe;
import com.elmakers.mine.bukkit.crafting.MagicCampfireRecipe;
import com.elmakers.mine.bukkit.crafting.MagicFurnaceRecipe;
import com.elmakers.mine.bukkit.crafting.MagicShapedRecipe;
import com.elmakers.mine.bukkit.crafting.MagicSmithingRecipe;
import com.elmakers.mine.bukkit.crafting.MagicSmokingRecipe;
import com.elmakers.mine.bukkit.crafting.MagicStonecuttnigRecipe;
import com.elmakers.mine.bukkit.crafting.RecipeMatchType;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public abstract class MagicRecipe {
    public static boolean FIRST_REGISTER = true;
    protected final MagicController controller;
    protected final String key;
    protected boolean locked = false;
    protected boolean disableDefaultRecipe;
    protected boolean ignoreDamage;
    private String outputKey;
    private Material outputType;
    private String outputItemType;
    private boolean autoDiscover = false;
    private List<String> discover = null;

    protected MagicRecipe(String key, MagicController controller) {
        this.key = key;
        this.controller = controller;
    }

    public ItemStack load(ConfigurationSection configuration) {
        this.locked = configuration.getBoolean("locked", false);
        this.disableDefaultRecipe = configuration.getBoolean("disable_default", false);
        this.ignoreDamage = configuration.getBoolean("ignore_damage", false);
        this.autoDiscover = configuration.getBoolean("auto_discover", false);
        this.discover = ConfigurationUtils.getStringList(configuration, "discover");
        this.outputKey = configuration.getString("output");
        if (this.outputKey == null || this.outputKey.isEmpty()) {
            this.outputKey = this.key;
        }
        this.outputItemType = configuration.getString("output_type", "item");
        ItemStack item = this.craft();
        if (item == null) {
            this.controller.getLogger().warning("Unknown output for recipe " + this.key + ": " + this.outputKey);
            return null;
        }
        this.outputType = item.getType();
        return item;
    }

    public abstract Recipe getRecipe();

    public Material getOutputType() {
        return this.outputType;
    }

    public String getOutputKey() {
        return this.outputKey;
    }

    public Material getSubstitute() {
        return null;
    }

    @Nullable
    public ItemStack craft() {
        if (this.outputKey == null) {
            return null;
        }
        Object item = this.outputItemType.equalsIgnoreCase("wand") ? (this.outputKey != null && !this.outputKey.isEmpty() ? this.controller.createWand(this.outputKey).getItem() : null) : (this.outputItemType.equalsIgnoreCase("spell") ? this.controller.createSpellItem(this.outputKey) : (this.outputItemType.equalsIgnoreCase("brush") ? this.controller.createBrushItem(this.outputKey) : (this.outputItemType.equalsIgnoreCase("item") ? this.controller.createItem(this.outputKey) : null)));
        return item;
    }

    public void crafted(HumanEntity entity, MageController controller) {
        if (this.discover == null) {
            return;
        }
        for (String key : this.discover) {
            if (!controller.hasPermission((Entity)entity, "Magic.craft." + key)) continue;
            CompatibilityLib.getCompatibilityUtils().discoverRecipe(entity, key);
        }
    }

    public boolean isAutoDiscover() {
        return this.autoDiscover;
    }

    public void unregister(Plugin plugin) {
        Recipe recipe = this.getRecipe();
        boolean canRemoveRecipes = CompatibilityLib.getCompatibilityUtils().canRemoveRecipes();
        if (recipe != null && !FIRST_REGISTER && canRemoveRecipes) {
            CompatibilityLib.getCompatibilityUtils().removeRecipe(this.key);
        }
    }

    public void preregister(Plugin plugin) {
        boolean canRemoveRecipes = CompatibilityLib.getCompatibilityUtils().canRemoveRecipes();
        if (this.disableDefaultRecipe && canRemoveRecipes) {
            int disabled = 0;
            List existing = plugin.getServer().getRecipesFor(new ItemStack(this.getOutputType()));
            for (Recipe recipe : existing) {
                CompatibilityLib.getCompatibilityUtils().removeRecipe(recipe);
                ++disabled;
            }
            if (disabled > 0) {
                plugin.getLogger().info("Disabled " + disabled + " default crafting recipe(s) for " + this.getOutputType());
            }
        }
    }

    public void register(MagicController controller, Plugin plugin) {
        boolean canRemoveRecipes = CompatibilityLib.getCompatibilityUtils().canRemoveRecipes();
        Recipe recipe = this.getRecipe();
        if (recipe != null) {
            List existing;
            if (!FIRST_REGISTER && !canRemoveRecipes && (existing = plugin.getServer().getRecipesFor(this.craft())).size() > 0) {
                return;
            }
            controller.info("Adding " + this.getType() + " recipe for " + this.getOutputKey());
            try {
                plugin.getServer().addRecipe(recipe);
            }
            catch (Exception ex) {
                plugin.getLogger().log(Level.WARNING, "Failed to add recipe", ex);
            }
        }
    }

    public boolean isSameRecipe(Recipe matchRecipe) {
        return CompatibilityLib.getCompatibilityUtils().isSameKey((Plugin)this.controller.getPlugin(), this.getKey(), matchRecipe);
    }

    public String getKey() {
        return this.key;
    }

    protected abstract String getType();

    public boolean isLocked() {
        return this.locked;
    }

    public static MagicRecipe loadRecipe(MagicController controller, String key, ConfigurationSection configuration) {
        MagicRecipe recipe = null;
        String recipeType = configuration.getString("type", "shaped").toLowerCase();
        try {
            switch (recipeType) {
                case "shaped": {
                    recipe = new MagicShapedRecipe(key, controller);
                    break;
                }
                case "furnace": {
                    recipe = new MagicFurnaceRecipe(key, controller);
                    break;
                }
                case "blasting": {
                    recipe = new MagicBlastingRecipe(key, controller);
                    break;
                }
                case "campfire": {
                    recipe = new MagicCampfireRecipe(key, controller);
                    break;
                }
                case "smoking": {
                    recipe = new MagicSmokingRecipe(key, controller);
                    break;
                }
                case "stonecutting": {
                    recipe = new MagicStonecuttnigRecipe(key, controller);
                    break;
                }
                case "smithing": {
                    recipe = new MagicSmithingRecipe(key, controller);
                    break;
                }
                default: {
                    controller.getLogger().warning("Unknown recipe type: " + recipeType);
                }
            }
            if (recipe != null && recipe.load(configuration) == null) {
                recipe = null;
            }
        }
        catch (Exception ex) {
            controller.getLogger().log(Level.WARNING, "An error occurred creating crafting recipe: " + key, ex);
            recipe = null;
        }
        return recipe;
    }

    public RecipeMatchType getMatchType(Recipe matchRecipe, ItemStack[] matrix) {
        if (!CompatibilityLib.getCompatibilityUtils().isLegacyRecipes()) {
            return this.isSameRecipe(matchRecipe) ? RecipeMatchType.MATCH : RecipeMatchType.NONE;
        }
        return RecipeMatchType.NONE;
    }
}

