/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.automata;

import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.automata.AutomatonTemplate;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;

public class Caster {
    @Nonnull
    private final Deque<WeightedPair<String>> spells = new ArrayDeque<WeightedPair<String>>();
    private final boolean recast;
    private final boolean undoAll;
    private final boolean allowOverlapping;

    public Caster(@Nonnull AutomatonTemplate automaton, ConfigurationSection configuration) {
        RandomUtils.populateStringProbabilityMap(this.spells, configuration, "spells");
        this.recast = configuration.getBoolean("recast", true);
        this.undoAll = configuration.getBoolean("undo_all", false);
        this.allowOverlapping = configuration.getBoolean("allow_overlap", false);
    }

    public void cast(Mage mage) {
        if (!this.allowOverlapping && !mage.getPendingBatches().isEmpty()) {
            return;
        }
        String castSpell = (String)RandomUtils.weightedRandom(this.spells);
        if (castSpell.length() > 0) {
            String[] parameters = null;
            Spell spell = null;
            if (!castSpell.equalsIgnoreCase("none")) {
                if (castSpell.contains(" ")) {
                    parameters = StringUtils.split((String)castSpell, (char)' ');
                    castSpell = parameters[0];
                    parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
                }
                spell = mage.getSpell(castSpell);
            }
            if (spell != null) {
                spell.cast(parameters);
            }
        }
    }

    public boolean isRecast() {
        return this.recast;
    }

    public boolean isUndoAll() {
        return this.undoAll;
    }
}

